/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.gui;

import com.ibm.eNetwork.onDemand.config.gui.NodeCellRenderer;
import com.ibm.eNetwork.onDemand.config.gui.NodeMenuItemAction;
import com.ibm.eNetwork.onDemand.config.gui.NodeMouseListener;
import com.ibm.eNetwork.onDemand.config.gui.NodeTreeModel;
import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptor;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptorList;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import com.sun.java.swing.Action;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.JRootPane;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTree;
import com.sun.java.swing.event.TreeSelectionEvent;
import com.sun.java.swing.event.TreeSelectionListener;
import com.sun.java.swing.tree.TreeCellRenderer;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreeSelectionModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;

public class NodeTree
extends JComponent
implements PropertyChangeListener {
    private static final String DEFAULT_NODEMGR = "com.ibm.eNetwork.onDemand.config.agents.AgentsNodeMgr";
    private Debug debug = new Debug("NodeTree", true);
    private String serverName;
    private int serverPort = 80;
    NodeMgr nodeMgr;
    Node rootNode;
    JRootPane rootPane;
    JTree tree;
    JMenu selectMenu;

    public NodeTree(NodeMgr nodeMgr, Node node) {
        this.nodeMgr = nodeMgr;
        this.rootNode = node;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.rootPane = new JRootPane();
        JScrollPane jScrollPane = new JScrollPane();
        this.rootPane.getContentPane().add((Component)jScrollPane);
        try {
            this.tree = new JTree((TreeModel)new NodeTreeModel(node));
            this.tree.setCellRenderer((TreeCellRenderer)new NodeCellRenderer());
            TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
            treeSelectionModel.setSelectionMode(1);
        }
        catch (Exception exception) {
            this.debug.print("Could not create tree.  Exception: " + exception);
        }
        this.tree.setLargeModel(true);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addMouseListener(new NodeMouseListener());
        this.tree.addTreeSelectionListener((TreeSelectionListener)new 1());
        jScrollPane.getViewport().add((Component)this.tree);
        this.constructMenuBar(node.getMenuItemDescriptors(), node);
        this.tree.expandRow(0);
        ((Container)((Object)this)).add((Component)this.rootPane, "Center");
    }

    private void constructMenuBar(NodeMenuItemDescriptorList nodeMenuItemDescriptorList, Node node) {
        if (nodeMenuItemDescriptorList == null || nodeMenuItemDescriptorList.size() <= 0) {
            this.rootPane.setMenuBar(null);
            return;
        }
        JMenu jMenu = null;
        JMenuBar jMenuBar = new JMenuBar();
        Enumeration enumeration = nodeMenuItemDescriptorList.elements();
        while (enumeration.hasMoreElements()) {
            NodeMenuItemDescriptor nodeMenuItemDescriptor = (NodeMenuItemDescriptor)enumeration.nextElement();
            if (nodeMenuItemDescriptor.isSeparator()) {
                System.err.println("Error: Found separator");
                continue;
            }
            if (nodeMenuItemDescriptor.isLeaf()) {
                System.err.println("Error: Found separator");
                continue;
            }
            if (nodeMenuItemDescriptor.isHelpMenu()) {
                jMenu = this.constructCascade(nodeMenuItemDescriptor, node);
                continue;
            }
            jMenuBar.add(this.constructCascade(nodeMenuItemDescriptor, node));
        }
        jMenuBar.add(this.getSelectMenu());
        if (jMenu != null) {
            jMenuBar.add(jMenu);
        }
        this.rootPane.setMenuBar(jMenuBar);
    }

    private JMenu constructCascade(NodeMenuItemDescriptor nodeMenuItemDescriptor, Node node) {
        JMenu jMenu = new JMenu(nodeMenuItemDescriptor.getLabel());
        NodeMenuItemDescriptorList nodeMenuItemDescriptorList = nodeMenuItemDescriptor.getNmidl();
        Enumeration enumeration = nodeMenuItemDescriptorList.elements();
        while (enumeration.hasMoreElements()) {
            NodeMenuItemDescriptor nodeMenuItemDescriptor2 = (NodeMenuItemDescriptor)enumeration.nextElement();
            if (nodeMenuItemDescriptor2.isSeparator()) {
                jMenu.addSeparator();
                continue;
            }
            if (nodeMenuItemDescriptor2.isLeaf()) {
                jMenu.add((Action)new NodeMenuItemAction(nodeMenuItemDescriptor2, node));
                continue;
            }
            jMenu.add((JMenuItem)this.constructCascade(nodeMenuItemDescriptor2, node));
        }
        return jMenu;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.debug.print("propertyChanged(" + propertyChangeEvent + ")");
        String string = propertyChangeEvent.getPropertyName();
        if ("menuItem".equals(string)) {
            Node node = (Node)propertyChangeEvent.getSource();
            this.constructMenuBar(node.getMenuItemDescriptors(), node);
        }
    }

    public JMenu getSelectMenu() {
        if (this.selectMenu == null) {
            this.selectMenu = new JMenu(this.nodeMgr.getMsgTranslator().get("Selected", "SELECTED_MENU"));
        }
        return this.selectMenu;
    }

    public void updateSelectMenu(TreeSelectionEvent treeSelectionEvent) {
        JMenu jMenu = this.getSelectMenu();
        jMenu.removeAll();
        Node node = (Node)treeSelectionEvent.getPath().getLastPathComponent();
        NodeMenuItemDescriptorList nodeMenuItemDescriptorList = node.getMenuItemDescriptors();
        Enumeration enumeration = nodeMenuItemDescriptorList.elements();
        while (enumeration.hasMoreElements()) {
            NodeMenuItemDescriptor nodeMenuItemDescriptor = (NodeMenuItemDescriptor)enumeration.nextElement();
            if (nodeMenuItemDescriptor.isSeparator()) {
                jMenu.addSeparator();
                continue;
            }
            if (nodeMenuItemDescriptor.isLeaf()) {
                jMenu.add((Action)new NodeMenuItemAction(nodeMenuItemDescriptor, node));
                continue;
            }
            jMenu.add((JMenuItem)this.constructCascade(nodeMenuItemDescriptor, node));
        }
    }

    private final class 1
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            NodeTree.this.updateSelectMenu(treeSelectionEvent);
        }

        /* synthetic */ 1() {
        }
    }
}

