/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.gui;

import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import com.sun.java.swing.event.EventListenerList;
import com.sun.java.swing.event.TreeModelEvent;
import com.sun.java.swing.event.TreeModelListener;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreePath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.Vector;

public class NodeTreeModel
implements TreeModel,
PropertyChangeListener {
    Node root;
    EventListenerList listenerList = new EventListenerList();
    Debug debug = new Debug("NodeTreeModel", false);
    static /* synthetic */ Class class$com$sun$java$swing$event$TreeModelListener;

    private void checkNode(Object object) {
        if (object == null || !(object instanceof Node)) {
            throw new IllegalArgumentException("node: " + object + " not instance of Node");
        }
    }

    public NodeTreeModel(Node node) {
        this.debug.print("NodeTreeModel(" + node + ")");
        this.root = node;
        this.root.addPropertyChangeListener(this);
    }

    public Object getRoot() {
        this.debug.print("getRoot()");
        this.debug.print("\t=> " + this.root);
        return this.root;
    }

    public Object getChild(Object object, int n) {
        this.debug.print("getChild(" + object + ", " + n + ")");
        this.checkNode(object);
        Node node = ((Node)object).getChildAt(n);
        node.removePropertyChangeListener(this);
        node.addPropertyChangeListener(this);
        this.debug.print("\t=> " + node);
        return node;
    }

    public int getChildCount(Object object) {
        this.debug.print("getChildCount(" + object + ")");
        this.checkNode(object);
        int n = ((Node)object).getNumChildren();
        this.debug.print("\t=> " + n);
        return n;
    }

    public boolean isLeaf(Object object) {
        this.checkNode(object);
        boolean bl = ((Node)object).isLeaf();
        return bl;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        this.debug.print("valueForPathChanged(" + treePath + ", " + object);
    }

    public int getIndexOfChild(Object object, Object object2) {
        this.debug.print("getIndexOfChild(" + object + ", " + object2 + ")");
        this.checkNode(object);
        int n = ((Node)object).getIndex((Node)object2);
        this.debug.print("\t=> " + n);
        return n;
    }

    public TreePath getPathOfNode(Node node) {
        Vector<Node> vector = new Vector<Node>();
        Node node2 = node;
        while (node2 != null) {
            vector.addElement(node2);
            node2 = node2.getParent();
        }
        int n = vector.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = vector.elementAt(n - 1 - n2);
            ++n2;
        }
        return new TreePath(objectArray);
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.debug.print("addTreeModelListener(" + treeModelListener + ")");
        this.listenerList.add(class$com$sun$java$swing$event$TreeModelListener != null ? class$com$sun$java$swing$event$TreeModelListener : (class$com$sun$java$swing$event$TreeModelListener = NodeTreeModel.class$("com.sun.java.swing.event.TreeModelListener")), (EventListener)treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.debug.print("removeTreeModelListener(" + treeModelListener + ")");
        this.listenerList.remove(class$com$sun$java$swing$event$TreeModelListener != null ? class$com$sun$java$swing$event$TreeModelListener : (class$com$sun$java$swing$event$TreeModelListener = NodeTreeModel.class$("com.sun.java.swing.event.TreeModelListener")), (EventListener)treeModelListener);
    }

    void fireTreeNodesChanged(Node node) {
        Object[] objectArray = this.listenerList.getListenerList();
        Node node2 = node.getParent();
        int[] nArray = new int[]{node2.getIndex(node)};
        Object[] objectArray2 = new Object[]{node};
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, this.getPathOfNode(node2), nArray, objectArray2);
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TreeModelListener != null ? class$com$sun$java$swing$event$TreeModelListener : NodeTreeModel.class$("com.sun.java.swing.event.TreeModelListener"))) {
                ((TreeModelListener)objectArray[n + 1]).treeNodesChanged(treeModelEvent);
            }
            n += 2;
        }
    }

    void fireTreeNodesInserted() {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new TreePath(this.getRoot()));
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TreeModelListener != null ? class$com$sun$java$swing$event$TreeModelListener : NodeTreeModel.class$("com.sun.java.swing.event.TreeModelListener"))) {
                ((TreeModelListener)objectArray[n + 1]).treeNodesInserted(treeModelEvent);
            }
            n += 2;
        }
    }

    void fireTreeNodesRemoved() {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new TreePath(this.getRoot()));
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TreeModelListener != null ? class$com$sun$java$swing$event$TreeModelListener : NodeTreeModel.class$("com.sun.java.swing.event.TreeModelListener"))) {
                ((TreeModelListener)objectArray[n + 1]).treeNodesRemoved(treeModelEvent);
            }
            n += 2;
        }
    }

    void fireTreeStructureChanged(Node node) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, this.getPathOfNode(node));
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == (class$com$sun$java$swing$event$TreeModelListener != null ? class$com$sun$java$swing$event$TreeModelListener : NodeTreeModel.class$("com.sun.java.swing.event.TreeModelListener"))) {
                ((TreeModelListener)objectArray[n + 1]).treeStructureChanged(treeModelEvent);
            }
            n += 2;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.debug.print("propertyChanged(" + propertyChangeEvent + ")");
        String string = propertyChangeEvent.getPropertyName();
        if ("label".equals(string)) {
            this.debug.print("PROP_LABEL changed");
            this.fireTreeNodesChanged((Node)propertyChangeEvent.getSource());
            return;
        }
        if ("child".equals(string)) {
            this.debug.print("PROP_CHILD changed");
            this.fireTreeStructureChanged((Node)propertyChangeEvent.getSource());
            return;
        }
        if ("menuItem".equals(string)) {
            this.debug.print("PROP_MENU_ITEMS changed");
            return;
        }
        if ("icon".equals(string)) {
            this.debug.print("PROP_ICON changed");
            this.fireTreeNodesChanged((Node)propertyChangeEvent.getSource());
            return;
        }
        this.debug.print("Other changed: " + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

