/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.node;

import com.ibm.eNetwork.onDemand.common.dataStructures.Comparator;
import com.ibm.eNetwork.onDemand.common.dataStructures.DefaultComparator;
import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.node.NodeList;
import com.ibm.eNetwork.onDemand.config.node.NodeMenuItemDescriptorList;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.Debug;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class BaseNode
implements Node {
    NodeList nodelist = new NodeList();
    Node parent;
    private NodeMgr nodeMgr;
    Hashtable menu_items = new Hashtable();
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    Debug debug = new Debug("BaseNode", false);
    String icon = "";
    String label = this.getClass().getName();
    NodeMenuItemDescriptorList menus;
    Comparator comparator = new DefaultComparator();

    public BaseNode() {
    }

    public BaseNode(Node node) {
        this.parent = node;
    }

    public Node getParent() {
        return this.parent;
    }

    public void setParent(Node node) {
        this.parent = node;
    }

    public boolean isLeaf() {
        return this.getNumChildren() == 0;
    }

    public NodeList getChildren() {
        this.debug.print(String.valueOf(this.getLabel()) + "getChildren:size = " + this.nodelist.size());
        return this.nodelist;
    }

    public void setChildren(NodeList nodeList) {
        this.debug.print(String.valueOf(this.getLabel()) + "setChildren:size = " + nodeList.size());
        this.nodelist = nodeList;
        this.reSortChildren();
        this.firePropertyChange("child", new Integer(-1), new Integer(-2));
    }

    private void reSortChildren() {
        if (this.comparator == null) {
            return;
        }
        Object[] objectArray = new Node[this.nodelist.size()];
        this.nodelist.copyInto(objectArray);
        this.nodelist = new NodeList();
        int n = 0;
        while (n < objectArray.length) {
            int n2 = this.getInsertionIndex(this.nodelist, (Node)objectArray[n]);
            if (n2 != -1) {
                this.nodelist.insertElementAt(objectArray[n], n2);
            }
            ++n;
        }
    }

    public NodeList getChildren(int n, int n2) {
        NodeList nodeList = new NodeList();
        if (n < this.nodelist.size()) {
            int n3 = n;
            while (n3 < n + n2) {
                if (n3 < this.nodelist.size()) {
                    nodeList.addElement(this.nodelist.elementAt(n3));
                }
                ++n3;
            }
        }
        this.debug.print(String.valueOf(this.getLabel()) + "getChildren " + n + " for " + n2 + ", result is " + nodeList.size());
        return nodeList;
    }

    public int getNumChildren() {
        this.debug.print(String.valueOf(this.getLabel()) + "getNumChildren " + this.nodelist);
        return this.nodelist.size();
    }

    public Node getChildAt(int n) {
        Node node = (Node)this.nodelist.elementAt(n);
        this.debug.print(String.valueOf(this.getLabel()) + "getChildAt " + n + " is " + node);
        return node;
    }

    public int getIndex(Node node) {
        return this.nodelist.indexOf(node);
    }

    public void insert(Node node, int n) {
        if (this.comparator == null) {
            this.nodelist.insertElementAt(node, n);
            this.firePropertyChange("child", null, new Integer(n));
            return;
        }
        this.add(node);
    }

    public void add(Node node) {
        int n = this.getInsertionIndex(this.nodelist, node);
        if (n != -1) {
            this.nodelist.insertElementAt(node, n);
            this.firePropertyChange("child", null, new Integer(n));
        }
    }

    private int getInsertionIndex(Vector vector, Node node) {
        if (this.comparator == null) {
            return vector.size();
        }
        int n = 0;
        int n2 = vector.size();
        while (n != n2) {
            int n3 = n + (n2 - n) / 2;
            int n4 = this.comparator.compare(node, vector.elementAt(n3));
            if (n4 >= 0) {
                if (n == n3) {
                    return n + 1;
                }
                n = n3;
                continue;
            }
            if (n2 == n3) {
                return n2;
            }
            n2 = n3;
        }
        return n;
    }

    public void remove(int n) {
        this.nodelist.removeElementAt(n);
        this.firePropertyChange("child", new Integer(n), null);
    }

    public void remove(Node node) {
        this.remove(this.getIndex(node));
    }

    public void setNodeMgr(NodeMgr nodeMgr) {
        this.nodeMgr = nodeMgr;
    }

    public NodeMgr getNodeMgr() {
        return this.nodeMgr;
    }

    public String toString() {
        return this.getLabel();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.debug.print("addPropertyChangeListener " + propertyChangeListener);
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.debug.print("removePropertyChangeListener " + propertyChangeListener);
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.debug.print("firePropertyChange " + string + object + object2);
        this.pcs.firePropertyChange(string, object, object2);
    }

    public String getUniqueName() {
        if (this.getParent() != null) {
            return String.valueOf(this.getParent().getUniqueName()) + "/" + this.getLabel();
        }
        return this.getLabel();
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String string) {
        String string2 = this.icon;
        this.icon = string;
        this.firePropertyChange("icon", string2, string);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        String string2 = this.label;
        this.label = string;
        this.firePropertyChange("label", string2, string);
    }

    public NodeMenuItemDescriptorList getMenuItemDescriptors() {
        return this.menus;
    }

    public void setMenuItemDescriptors(NodeMenuItemDescriptorList nodeMenuItemDescriptorList) {
        NodeMenuItemDescriptorList nodeMenuItemDescriptorList2 = this.menus;
        this.menus = nodeMenuItemDescriptorList;
        this.firePropertyChange("menuItem", nodeMenuItemDescriptorList2, nodeMenuItemDescriptorList);
    }

    public Object performOperation(int n, Object object) {
        return null;
    }

    public Node getNodeByUniqueName(String string) {
        Node node = null;
        this.debug.print("getNodeByUniqueName " + string + " for " + this);
        if (string == null || this.getUniqueName().equals(string)) {
            node = this;
        } else {
            Enumeration enumeration = this.getChildren().elements();
            while (node == null && enumeration.hasMoreElements()) {
                Node node2 = (Node)enumeration.nextElement();
                node = node2.getNodeByUniqueName(string);
            }
        }
        return node;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
        this.reSortChildren();
        this.firePropertyChange("child", new Integer(-1), new Integer(-2));
    }
}

