/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.config.util;

import com.ibm.eNetwork.onDemand.common.Copyright;
import com.ibm.eNetwork.onDemand.config.gui.ClntGuiContext;
import com.ibm.eNetwork.onDemand.config.gui.NodeTreeModel;
import com.ibm.eNetwork.onDemand.config.node.Node;
import com.ibm.eNetwork.onDemand.config.node.NodeMgr;
import com.ibm.eNetwork.onDemand.config.util.FileBrowserListener;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JFrame;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.JTree;
import com.sun.java.swing.ToolTipManager;
import com.sun.java.swing.event.TreeSelectionEvent;
import com.sun.java.swing.event.TreeSelectionListener;
import com.sun.java.swing.tree.TreeModel;
import com.sun.java.swing.tree.TreePath;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class FileBrowser
extends JFrame {
    private static final String copyright = Copyright.COPYRIGHT_98;
    protected JTree tree;
    protected TreeModel treeModel;
    protected JTextField filename;
    protected JButton button_OK;
    protected JButton button_CANCEL;
    private boolean isApplication = false;
    private String resultFile;
    private boolean resultIsDirectory;
    private Vector listeners = new Vector();

    public FileBrowser(String string) {
        NodeMgr nodeMgr = NodeMgr.getNodeMgr("com.ibm.eNetwork.onDemand.config.filesys.LocalNodeMgr");
        nodeMgr.setGuiContext(new ClntGuiContext());
        URL uRL = null;
        try {
            uRL = new URL("file", "", -1, "/FileSys.WKN");
        }
        catch (Exception exception) {}
        String string2 = String.valueOf(uRL);
        Node node = nodeMgr.getRoot(string2);
        if (node != null) {
            node.getNodeByUniqueName(string);
        }
        NodeTreeModel nodeTreeModel = new NodeTreeModel(node);
        this.initUI(nodeTreeModel);
    }

    public FileBrowser(Applet applet, String string) {
        NodeMgr nodeMgr = NodeMgr.getNodeMgr("com.ibm.eNetwork.onDemand.config.comm.client.ClntNodeMgr");
        URL uRL = null;
        try {
            uRL = new URL(applet.getDocumentBase(), "/FileSys.WKN");
        }
        catch (Exception exception) {}
        String string2 = String.valueOf(uRL);
        nodeMgr.setGuiContext(new ClntGuiContext());
        Node node = nodeMgr.getRoot(string2);
        if (node != null) {
            Node node2 = node.getNodeByUniqueName(string);
            NodeTreeModel nodeTreeModel = new NodeTreeModel(node);
            this.initUI(nodeTreeModel);
            this.showSpecificNode(node2);
        }
    }

    public void showSpecificNode(Node node) {
        if (node == null) {
            return;
        }
        NodeTreeModel nodeTreeModel = (NodeTreeModel)this.tree.getModel();
        TreePath treePath = nodeTreeModel.getPathOfNode(node);
        this.tree.expandPath(treePath);
        Object[] objectArray = treePath.getPath();
        while (!this.tree.isVisible(treePath)) {
            if (objectArray.length == 0) {
                return;
            }
            Object[] objectArray2 = new Object[objectArray.length - 1];
            int n = 0;
            while (n < objectArray2.length) {
                objectArray2[n] = objectArray[n];
                ++n;
            }
            treePath = new TreePath(objectArray2);
            this.tree.expandPath(treePath);
            objectArray = objectArray2;
        }
    }

    private void initUI(NodeTreeModel nodeTreeModel) {
        JPanel jPanel = new JPanel(true);
        this.getContentPane().add("Center", (Component)jPanel);
        ((Component)((Object)this)).setBackground(Color.lightGray);
        this.tree = new JTree((TreeModel)nodeTreeModel);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.tree);
        this.tree.addTreeSelectionListener((TreeSelectionListener)new 1());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setPreferredSize(new Dimension(300, 300));
        jScrollPane.getViewport().add((Component)this.tree);
        jPanel.setLayout(new BorderLayout());
        jPanel.add("Center", (Component)jScrollPane);
        JPanel jPanel2 = new JPanel((LayoutManager)new FlowLayout());
        this.filename = new JTextField(50);
        jPanel2.add((Component)this.filename);
        this.button_OK = new JButton("OK");
        this.button_OK.addActionListener((ActionListener)new 2());
        jPanel2.add((Component)this.button_OK);
        this.button_CANCEL = new JButton("CANCEL");
        this.button_CANCEL.addActionListener((ActionListener)new 3());
        jPanel2.add((Component)this.button_CANCEL);
        this.getContentPane().add((Component)jPanel2, "South");
        ((Window)((Object)this)).addWindowListener(new 4());
        ((Window)((Object)this)).pack();
        ((Window)((Object)this)).show();
    }

    public FileBrowser(Node node) {
        this.treeModel = new NodeTreeModel(node);
    }

    private String makePath(TreePath treePath) {
        Object[] objectArray = treePath.getPath();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n < objectArray.length) {
            String string;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.separator);
            }
            if ((string = objectArray[n].toString()).endsWith(File.separator)) {
                stringBuffer.append(string.substring(0, string.length() - 1));
            } else {
                stringBuffer.append(string);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getFilename() {
        return this.resultFile;
    }

    private void setApplication(boolean bl) {
        this.isApplication = bl;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            FileBrowser fileBrowser = new FileBrowser(stringArray[0]);
            fileBrowser.setApplication(true);
            return;
        }
        System.out.println("usage: FileBrowser <path>");
        System.exit(0);
    }

    public void addFileBrowserListener(FileBrowserListener fileBrowserListener) {
        this.listeners.addElement(fileBrowserListener);
    }

    public void removeFileBrowserListener(FileBrowserListener fileBrowserListener) {
        this.listeners.removeElement(fileBrowserListener);
    }

    private void notifyListeners(String string, boolean bl) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            FileBrowserListener fileBrowserListener = (FileBrowserListener)enumeration.nextElement();
            fileBrowserListener.itemSelected(string, bl);
        }
    }

    private final class 1
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (treeSelectionEvent.getPath() != null) {
                FileBrowser.this.filename.setText(FileBrowser.this.makePath(treeSelectionEvent.getPath()));
                if (FileBrowser.this.tree.getModel().isLeaf(treeSelectionEvent.getPath().getLastPathComponent())) {
                    FileBrowser.this.resultIsDirectory = false;
                    return;
                }
                FileBrowser.this.resultIsDirectory = true;
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            FileBrowser.this.resultFile = FileBrowser.this.filename.getText();
            FileBrowser.this.notifyListeners(FileBrowser.this.resultFile, FileBrowser.this.resultIsDirectory);
            ((Component)((Object)FileBrowser.this)).setVisible(false);
            if (FileBrowser.this.isApplication) {
                System.exit(0);
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)((Object)FileBrowser.this)).setVisible(false);
            if (FileBrowser.this.isApplication) {
                System.exit(0);
            }
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            ((Component)((Object)FileBrowser.this)).setVisible(false);
            if (FileBrowser.this.isApplication) {
                System.exit(0);
            }
        }

        /* synthetic */ 4() {
        }
    }
}

