/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Address;
import COM.ibm.raleigh.dhcpsgui.biz.IPAddress;
import COM.ibm.raleigh.dhcpsgui.biz.IPSubnetAddress;
import COM.ibm.raleigh.dhcpsgui.biz.IPSubnetMask;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class AddressRange
implements Cloneable {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_MISSING_ADDRESS_RANGE = DHCPServerGUI.getResourceString("ERROR_MISSING_ADDRESS_RANGE");
    private static final String ERROR_MISSING_ADDRESS_IN_RANGE = DHCPServerGUI.getResourceString("ERROR_MISSING_ADDRESS_IN_RANGE");
    private static final String ERROR_STARTING_ADDRESS = DHCPServerGUI.getResourceString("ERROR_STARTING_ADDRESS");
    private static final String ERROR_ENDING_ADDRESS = DHCPServerGUI.getResourceString("ERROR_ENDING_ADDRESS");
    private static final String ERROR_MISSING_SUBNET_DEFINITION = DHCPServerGUI.getResourceString("ERROR_MISSING_SUBNET_DEFINITION");
    private static final String ERROR_ADDRESS_NOT_IN_RANGE = DHCPServerGUI.getResourceString("ERROR_ADDRESS_NOT_IN_RANGE");
    private static final String ERROR_ADDRESS_NOT_IN_SUBNET = DHCPServerGUI.getResourceString("ERROR_ADDRESS_NOT_IN_SUBNET");
    private static final String ERROR_INVALID_RANGE = DHCPServerGUI.getResourceString("ERROR_INVALID_RANGE");
    private static final String ERROR_INVALID_PARENT_RANGE = DHCPServerGUI.getResourceString("ERROR_INVALID_PARENT_RANGE");
    private static final String ERROR_INVALID_SUBRANGE = DHCPServerGUI.getResourceString("ERROR_INVALID_SUBRANGE");
    private static final String ERROR_STARTING_ADDRESS_NOT_IN_SUBNET = DHCPServerGUI.getResourceString("ERROR_STARTING_ADDRESS_NOT_IN_SUBNET");
    private static final String ERROR_ENDING_ADDRESS_NOT_IN_SUBNET = DHCPServerGUI.getResourceString("ERROR_ENDING_ADDRESS_NOT_IN_SUBNET");
    private static final String ERROR_HOSTBITS_ALL_ZEROS = DHCPServerGUI.getResourceString("ERROR_HOSTBITS_ALL_ZEROS");
    private static final String ERROR_HOSTBITS_ALL_ONES = DHCPServerGUI.getResourceString("ERROR_HOSTBITS_ALL_ONES");
    private static final String ERROR_START_GREATER_THAN_END_ADDRESS = DHCPServerGUI.getResourceString("ERROR_START_GREATER_THAN_END_ADDRESS");
    private IPAddress start = new IPAddress();
    private IPAddress end = new IPAddress();
    private int snmask;
    private int snaddr;
    private int size;
    private boolean validrange;
    private boolean validsubnet;

    public AddressRange() {
        this.initRange();
    }

    public Message setAddressRange(String string) {
        String string2;
        String string3;
        if (string == null) {
            return new Message(ERROR_MISSING_ADDRESS_RANGE);
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "-");
            string3 = stringTokenizer.nextToken().trim();
            string2 = stringTokenizer.nextToken().trim();
        }
        catch (NoSuchElementException noSuchElementException) {
            return new Message(ERROR_MISSING_ADDRESS_IN_RANGE);
        }
        Message message = this.start.setAddress(string3);
        if (message != null) {
            return new Message(String.valueOf(ERROR_STARTING_ADDRESS) + string3 + "   " + message.getText());
        }
        message = this.end.setAddress(string2);
        if (message != null) {
            return new Message(String.valueOf(ERROR_ENDING_ADDRESS) + string2 + "   " + message.getText());
        }
        int n = this.start.getIntegerAddress();
        int n2 = this.end.getIntegerAddress();
        if (this.validsubnet) {
            message = AddressRange.checkRange(n, n2, this.snaddr, this.snmask);
            if (message == null) {
                this.size = n2 - n + 1;
                this.validrange = true;
            } else {
                this.validrange = false;
            }
            return message;
        }
        return null;
    }

    public Message setAddressRangeStart(String string) {
        return this.start.setAddress(string.trim());
    }

    public Message setAddressRangeEnd(String string) {
        return this.end.setAddress(string.trim());
    }

    public void setSubnetDefinition(IPSubnetAddress iPSubnetAddress, IPSubnetMask iPSubnetMask) {
        this.snaddr = iPSubnetAddress.getIntegerAddress();
        this.snmask = iPSubnetMask.getIntegerAddress();
        this.validsubnet = true;
    }

    public final void invalidateSubnetDefinition() {
        this.validsubnet = false;
    }

    public void setSubnetDefinition(String string, String string2) {
        this.snaddr = Address.dottedTo32BitAddress(string.trim());
        this.snmask = Address.dottedTo32BitAddress(string2.trim());
        this.validsubnet = true;
    }

    public Message validateAddressRange() {
        int n;
        if (!this.validsubnet) {
            return new Message(ERROR_MISSING_SUBNET_DEFINITION);
        }
        int n2 = this.start.getIntegerAddress();
        Message message = AddressRange.checkRange(n2, n = this.end.getIntegerAddress(), this.snaddr, this.snmask);
        if (message == null) {
            this.size = n - n2 + 1;
            this.validrange = true;
        } else {
            this.validrange = false;
        }
        return message;
    }

    public static Message validateAddressRange(String string, String string2, String string3, String string4) {
        int n = Address.dottedTo32BitAddress(string.trim());
        int n2 = Address.dottedTo32BitAddress(string2.trim());
        int n3 = Address.dottedTo32BitAddress(string3.trim());
        int n4 = Address.dottedTo32BitAddress(string4.trim());
        return AddressRange.checkRange(n3, n4, n, n2);
    }

    public final boolean isValidRange() {
        return this.validrange;
    }

    public final boolean isValidSubnet() {
        return this.validsubnet;
    }

    public static String lowestAddressInSubnet(String string, String string2) {
        int n = Address.dottedTo32BitAddress(string.trim());
        int n2 = Address.dottedTo32BitAddress(string2.trim());
        if (n2 != 0 && n != 0) {
            int n3 = 1;
            return Address.integerToDottedDecimal(n3 += n2);
        }
        return "0";
    }

    public static String highestAddressInSubnet(String string, String string2) {
        int n = Address.dottedTo32BitAddress(string.trim());
        int n2 = Address.dottedTo32BitAddress(string2.trim());
        if (n2 != 0 && n != 0) {
            int n3 = (0xFFFFFFFF & ~n2) - 1;
            return Address.integerToDottedDecimal(n3 += n2);
        }
        return "0";
    }

    public Message isInTheRange(IPAddress iPAddress) {
        int n = iPAddress.getIntegerAddress();
        if (this.validrange) {
            if ((n & this.snmask) == this.snaddr) {
                if (n <= this.end.getIntegerAddress() && n >= this.start.getIntegerAddress()) {
                    return null;
                }
                return new Message(ERROR_ADDRESS_NOT_IN_RANGE);
            }
            return new Message(ERROR_ADDRESS_NOT_IN_SUBNET);
        }
        return new Message(ERROR_INVALID_RANGE);
    }

    public Message isSubRange(AddressRange addressRange) {
        if (!addressRange.isValidRange()) {
            return new Message(ERROR_INVALID_PARENT_RANGE);
        }
        this.start.getIntegerAddress();
        this.end.getIntegerAddress();
        if (addressRange.end.getIntegerAddress() >= this.end.getIntegerAddress() && addressRange.start.getIntegerAddress() <= this.start.getIntegerAddress()) {
            return null;
        }
        return new Message(ERROR_INVALID_SUBRANGE);
    }

    public Enumeration getAllAddresses() {
        if (this.validrange) {
            Vector<String> vector = new Vector<String>(this.size);
            int n = this.start.getIntegerAddress();
            int n2 = 0;
            while (n2 < this.size) {
                vector.addElement(Address.integerToDottedDecimal(n));
                ++n;
                ++n2;
            }
            return vector.elements();
        }
        return null;
    }

    public final int getSize() {
        if (this.validrange) {
            return this.size;
        }
        return 0;
    }

    public String getAddressRange() {
        if (this.validrange) {
            return String.valueOf(this.start.toString()) + '-' + this.end.toString();
        }
        return null;
    }

    public String getAddressRangeStart() {
        if (this.validrange) {
            return this.start.toString();
        }
        return null;
    }

    public String getAddressRangeEnd() {
        if (this.validrange) {
            return this.end.toString();
        }
        return null;
    }

    public String toString() {
        return this.getAddressRange();
    }

    public final void initRange() {
        this.snmask = 0;
        this.snaddr = 0;
        this.size = 0;
        this.validsubnet = false;
        this.validrange = false;
        this.start.initAddress();
        this.end.initAddress();
    }

    public Object clone() {
        AddressRange addressRange = new AddressRange();
        if (this.start == null) {
            return null;
        }
        addressRange.start = (IPAddress)this.start.clone();
        addressRange.end = (IPAddress)this.end.clone();
        addressRange.snmask = this.snmask;
        addressRange.snaddr = this.snaddr;
        addressRange.size = this.size;
        addressRange.validsubnet = this.validsubnet;
        addressRange.validrange = this.validrange;
        return addressRange;
    }

    private final int highestAddressInSubnet() {
        if (this.snmask != 0 && this.snaddr != 0) {
            int n = (0xFFFFFFFF & ~this.snmask) - 1;
            return n += this.snmask;
        }
        return 0;
    }

    private final int lowestAddressInSubnet() {
        if (this.snmask != 0 && this.snaddr != 0) {
            int n = 1;
            return n += this.snmask;
        }
        return 0;
    }

    private static Message checkRange(int n, int n2, int n3, int n4) {
        if ((n & n4) != n3) {
            return new Message(ERROR_STARTING_ADDRESS_NOT_IN_SUBNET);
        }
        if ((n2 & n4) != n3) {
            return new Message(ERROR_ENDING_ADDRESS_NOT_IN_SUBNET);
        }
        if ((n & ~n4) == 0 || (n2 & ~n4) == 0) {
            return new Message(ERROR_HOSTBITS_ALL_ZEROS);
        }
        if ((n & ~n4) == ~n4 || (n2 & ~n4) == ~n4) {
            return new Message(ERROR_HOSTBITS_ALL_ONES);
        }
        if (n >= n2) {
            return new Message(ERROR_START_GREATER_THAN_END_ADDRESS);
        }
        return null;
    }
}

