/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.LogFile;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParametersKeyword;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class BINLServerParameters
extends ConfigItem {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_KEYWORD_NOT_VALID = DHCPServerGUI.getResourceString("ERROR_KEYWORD_NOT_VALID");
    private static final String TEXT_SERVER_PARAMETERS = DHCPServerGUI.getResourceString("TEXT_SERVER_PARAMETERS");
    private static final String WARNING_KEYWORD_NO_VALUE = DHCPServerGUI.getResourceString("WARNING_KEYWORD_NO_VALUE");
    private String backupString;
    private LogFile logFile;
    private Hashtable keywordTable = new Hashtable();

    BINLServerParameters(ConfigItem configItem) {
        this.logFile = new LogFile();
        this.initialize();
        this.commit(configItem);
    }

    private void initialize() {
    }

    public Message setParameter(String string) {
        String string2;
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreElements()) {
            string3 = (String)stringTokenizer.nextElement();
            string2 = stringTokenizer.hasMoreElements() ? string.substring(string3.length() + 1).trim() : "";
        } else {
            throw new IllegalArgumentException();
        }
        Message message = this.isKeyword(string3);
        if (message != null) {
            return message;
        }
        if (string2 == "") {
            Message message2 = new Message();
            message2.addWarning(WARNING_KEYWORD_NO_VALUE);
            return message2;
        }
        if (string3.equalsIgnoreCase("updateDNS")) {
            string3 = "updateDNSP";
        }
        if (string3.equalsIgnoreCase("numLogFiles") || string3.equalsIgnoreCase("logFileSize") || string3.equalsIgnoreCase("logFileName") || string3.equalsIgnoreCase("logItem")) {
            return this.getLogFile().setParameter(string3, string2);
        }
        if (this.keywordTable.containsKey(string3.toUpperCase())) {
            return ((ServerParametersKeyword)this.keywordTable.get(string3.toUpperCase())).process(string2);
        }
        throw new ShouldNotOccurException();
    }

    public Message isKeyword(String string) {
        if (string.equalsIgnoreCase("numLogFiles") || string.equalsIgnoreCase("logFileSize") || string.equalsIgnoreCase("logFileName") || string.equalsIgnoreCase("logItem")) {
            return null;
        }
        Object[] objectArray = new Object[]{string};
        return new Message(MessageFormat.format(ERROR_KEYWORD_NOT_VALID, objectArray));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLogFile().toString());
        Enumeration enumeration = this.keywordTable.elements();
        while (enumeration.hasMoreElements()) {
            String string = ((ServerParametersKeyword)enumeration.nextElement()).toString();
            if (string == null) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public String getName() {
        return this.getItemType();
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem instanceof Configuration;
    }

    String getTypeSpecificScheme() {
        return "DHCP No Icon";
    }

    public Enumeration getOneLineDescription() {
        return new Vector().elements();
    }

    public String getItemType() {
        return TEXT_SERVER_PARAMETERS;
    }

    public void backup() {
        this.backupString = this.toString();
    }

    public void restore() {
        this.logFile.initialize();
        this.initialize();
        StringTokenizer stringTokenizer = new StringTokenizer(this.backupString, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            Message message;
            String string = stringTokenizer.nextToken();
            if (string.substring(0, 1).equals("#") || (message = this.setParameter(string)) == null) continue;
            throw new ShouldNotOccurException("ServerParameters restore():  error found in <" + string + ">: " + message.getText());
        }
    }

    void addKeyword(String string, ServerParametersKeyword serverParametersKeyword) {
        this.keywordTable.put(string, serverParametersKeyword);
    }
}

