/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.CommonClient;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.IPAddress;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.biz.SupportsLeaseDuration;
import COM.ibm.raleigh.dhcpsgui.biz.SupportsScopedKeywords;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.util.Enumeration;
import java.util.Vector;

public class Client
extends CommonClient
implements SupportsScopedKeywords,
SupportsLeaseDuration {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_INVALID_SCOPE = DHCPServerGUI.getResourceString("ERROR_INVALID_SCOPE");
    private static final String ERROR_MISSING_ADDRESS = DHCPServerGUI.getResourceString("ERROR_MISSING_ADDRESS");
    private static final String TEXT_NAME_CLIENT = DHCPServerGUI.getResourceString("TEXT_NAME_CLIENT");
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    public static final String KEYWORD_CLIENT = "client";
    public static final String ANY = "ANY";
    private IPAddress address = new IPAddress();
    private boolean any = false;

    public String getAddress() {
        if (this.any) {
            return ANY;
        }
        return this.address.getIPAddress();
    }

    public Message setAddress(String string) {
        if (string == null) {
            return new Message(ERROR_MISSING_ADDRESS);
        }
        if (string.trim().toUpperCase().equals(ANY)) {
            this.any = true;
            return null;
        }
        this.any = false;
        return this.address.setIPAddress(string);
    }

    public Message validateAddress(ConfigItem configItem) {
        Message message = null;
        if (!this.any && configItem instanceof Subnetwork) {
            message = ((Subnetwork)configItem).validateAddressIsInSubnet(this.address);
        }
        return message;
    }

    public String getName() {
        String string = this.getAlias();
        if (string.equals("")) {
            String string2 = this.getAddress();
            if (string2 != null && !string2.equals(ANY)) {
                return String.valueOf(this.getItemType()) + " " + string2;
            }
            return String.valueOf(this.getItemType()) + " ";
        }
        return String.valueOf(this.getItemType()) + " " + string;
    }

    public String getItemType() {
        return TEXT_NAME_CLIENT;
    }

    String getTypeSpecificScheme() {
        return "DHCP Client";
    }

    public Enumeration getOneLineDescription() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(String.valueOf(this.getItemType()) + " " + this.getAlias());
        vector.addElement(String.valueOf(CommonClient.TEXT_ID) + this.getIdValue());
        vector.addElement(String.valueOf(CommonClient.TEXT_TYPE) + " " + this.getTypeDescription());
        if (!Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            vector.addElement(String.valueOf(CommonClient.TEXT_IP_ADDRESS) + this.getAddress());
        }
        return vector.elements();
    }

    public Object itemClone() {
        Client client = (Client)super.itemClone();
        client.address = (IPAddress)this.address.clone();
        return client;
    }
}

