/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.SubnetGroup;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.util.Enumeration;
import java.util.Vector;

public class Comment
extends ConfigItem {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    public static final String commentTitleMark = "#$";
    private static int FILE_LINE_LENGTH = 80;
    private static int KEYWORD_COMMENT_LENGTH = 40;
    private String localTitle = "";
    private String text = "";
    private String name;

    public Comment() {
    }

    public Comment(String string) {
        if (string.indexOf(commentTitleMark) == 0) {
            int n = string.indexOf("\n");
            if (n < 0) {
                this.localTitle = string.substring(2);
                this.text = "";
                return;
            }
            this.localTitle = string.substring(2, n);
            this.text = string.substring(n);
            return;
        }
        int n = string.indexOf(35);
        this.text = string.substring(n + 1);
        this.localTitle = "";
    }

    public void addLine(String string) {
        int n = string.indexOf("#");
        String string2 = string;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        if (this.text == null || this.text.length() == 0) {
            this.text = string2;
            return;
        }
        this.text = String.valueOf(this.text) + "\n" + string2;
    }

    public String getCommentText() {
        return this.text;
    }

    public Message setCommentText(String string) {
        this.text = string;
        return null;
    }

    public String getItemType() {
        return DHCPServerGUI.getResourceString("TEXT_COMMENT_NOTEBOOK_TITLE");
    }

    public String getName() {
        String string;
        if (this.localTitle.length() > 0) {
            string = String.valueOf(this.getItemType()) + " " + this.localTitle;
        } else {
            string = DHCPServerGUI.getResourceString("TEXT_COMMENT_FOR");
            ConfigItem configItem = this.getParent();
            if (configItem != null) {
                string = String.valueOf(string) + configItem.getItemType();
            }
        }
        return string;
    }

    public String getTitle() {
        return this.localTitle;
    }

    public void setTitle(String string) {
        this.localTitle = string;
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem instanceof Global || configItem instanceof BINLGlobal || configItem instanceof SubnetGroup;
    }

    protected String getTypeSpecificScheme() {
        return "DHCP Comment";
    }

    public String toString() {
        String string = this.text;
        String string2 = this.localTitle.length() > 0 ? commentTitleMark + this.localTitle + "\n" + "# " : "# ";
        int n = string.length();
        String string3 = "";
        int n2 = -1;
        boolean bl = false;
        while (n > FILE_LINE_LENGTH || string.indexOf("\n") != -1) {
            if (n > FILE_LINE_LENGTH) {
                string3 = string.substring(0, FILE_LINE_LENGTH);
                bl = true;
            } else {
                string3 = string;
                bl = false;
            }
            n2 = string3.indexOf("\n");
            if (n2 < 0) {
                if (!bl) break;
                n2 = string3.lastIndexOf(" ");
            }
            if (n2 >= 0) {
                string2 = String.valueOf(string2) + string.substring(0, n2);
                string = string.substring(n2 + 1);
            } else {
                string2 = String.valueOf(string2) + string3;
                string = string.substring(FILE_LINE_LENGTH + 1);
            }
            string2 = String.valueOf(string2) + "\n# ";
            n = string.length();
        }
        if (n > 0) {
            string2 = String.valueOf(string2) + string;
        }
        if (this.getParent() instanceof Global || this.getParent() instanceof SubnetGroup || this.getParent() instanceof BINLGlobal) {
            string2 = String.valueOf(string2) + "\n";
        }
        return string2;
    }

    public Enumeration getOneLineDescription() {
        Vector<String> vector = new Vector<String>();
        String string = this.getCommentText();
        if (string.length() > 100) {
            string = string.substring(0, 100);
            string.replace('\n', ' ');
            int n = string.lastIndexOf(" ");
            if (n > 0) {
                string = string.substring(0, n);
            }
        }
        vector.addElement(String.valueOf(this.getItemType()) + ":  " + string);
        return vector.elements();
    }

    public Object itemClone() {
        Comment comment = (Comment)super.itemClone();
        comment.text = this.text;
        comment.localTitle = this.localTitle;
        return comment;
    }
}

