/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.HexString;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Option;
import COM.ibm.raleigh.dhcpsgui.biz.OptionValidator;
import COM.ibm.raleigh.dhcpsgui.biz.VendorOption;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.BoundedInteger;
import java.util.StringTokenizer;

public abstract class CommonOption
extends ConfigItem {
    private static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    public static final String KEYWORD_OPTION = "option";
    public static final String KEYWORD_OPTION_BINL = "pxeoption";
    public static final String KEYWORD_OPTION_BINL_PREFIX = "pxevendor";
    private static final String ERROR_INVALID_OPTION_SYNTAX = DHCPServerGUI.getResourceString("ERROR_INVALID_OPTION_SYNTAX");
    private static final String ERROR_DUPLICATE = DHCPServerGUI.getResourceString("ERROR_DUPLICATE");
    private static final String ERROR_MISSING_HEX_PREFIX_OR_QUOTES = DHCPServerGUI.getResourceString("ERROR_MISSING_HEX_PREFIX_OR_QUOTES");
    protected String tag;
    protected String value;
    protected boolean hexformat = false;
    protected HexString hexstring = new HexString();
    protected boolean RFCArchitected = true;
    protected boolean fromNotebook = true;

    public boolean commit(ConfigItem configItem, boolean bl) {
        boolean bl2 = true;
        bl2 = bl ? super.commit(configItem) : this.setParent(configItem);
        return bl2;
    }

    static Object commonParse(CommonOption commonOption, ConfigItem configItem, String string) {
        commonOption.fromNotebook = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.hasMoreElements()) {
            return new Message(ERROR_INVALID_OPTION_SYNTAX);
        }
        String string2 = stringTokenizer.nextToken();
        if (configItem.getExplicitOption(string2) != null) {
            return new Message(ERROR_DUPLICATE);
        }
        Message message = commonOption.setTag(string2, configItem);
        if (message != null) {
            return message;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            return new Message(ERROR_INVALID_OPTION_SYNTAX);
        }
        String string3 = string.trim().substring(string2.length()).trim();
        if (string3.length() == 0) {
            return new Message(ERROR_INVALID_OPTION_SYNTAX);
        }
        message = commonOption.setValue(string3, configItem);
        if (message != null) {
            return message;
        }
        if (!commonOption.commit(configItem)) {
            return new Message(ConfigItem.ERROR_WRONG_SCOPE);
        }
        return commonOption;
    }

    public String getTag() {
        return this.tag;
    }

    public String getValue() {
        if (this.hexformat) {
            return this.hexstring.getDisplayValue();
        }
        return this.value;
    }

    public static Message isValidTag(String string) {
        return BoundedInteger.isIntegerWithinSpecifiedRange(string, 1, 254);
    }

    public boolean isHexFormat() {
        return this.hexformat;
    }

    public Message setValue(String string, boolean bl, ConfigItem configItem) {
        Message message;
        if (string == null || string.trim().length() == 0) {
            return new Message(ERROR_INVALID_OPTION_SYNTAX);
        }
        String string2 = string.trim();
        if (string2.length() > 255) {
            return new Message(ERROR_INVALID_OPTION_SYNTAX);
        }
        if (bl) {
            message = this.hexstring.setHexStringAndValidate(string2, false);
            if (this instanceof VendorOption) {
                this.hexstring.setDisplayValue(this.hexstring.getHexString());
            }
        } else {
            message = this.setTextValue(string2);
        }
        this.hexformat = bl;
        if (message == null && this instanceof Option) {
            return this.validateValue(configItem);
        }
        return message;
    }

    public Message setValue(String string, ConfigItem configItem) {
        String string2 = string.trim();
        Message message = this.hexstring.setHexStringAndValidate(string2, true);
        if (message == null) {
            this.hexformat = true;
            if (this instanceof VendorOption) {
                this.hexstring.setDisplayValue(this.hexstring.getHexString());
            }
        } else {
            if (!message.getText().equals(ERROR_MISSING_HEX_PREFIX_OR_QUOTES)) {
                return message;
            }
            message = this.fromNotebook ? this.setTextValue(string2) : this.setTextValueAndValidate(string2);
            if (message == null) {
                this.hexformat = false;
            }
        }
        if (message == null && this instanceof Option) {
            return this.validateValue(configItem);
        }
        return message;
    }

    private Message setTextValueAndValidate(String string) {
        int n;
        int n2;
        if (string.charAt(0) == '\"') {
            n2 = 1;
            int n3 = string.indexOf(34, 1);
            n = n3 == -1 ? string.length() : n3;
        } else {
            n2 = 0;
            n = string.length();
        }
        if (n2 == n) {
            return new Message(ERROR_INVALID_OPTION_SYNTAX);
        }
        this.value = string.substring(n2, n);
        return null;
    }

    private Message setTextValue(String string) {
        int n = 0;
        int n2 = string.length();
        if (string.charAt(0) == '\"') {
            ++n;
            if (string.charAt(n2 - 1) == '\"') {
                --n2;
            }
        }
        this.value = string.substring(n, n2);
        return null;
    }

    private Message validateValue(ConfigItem configItem) {
        Object object = this.hexformat ? OptionValidator.validateOption(this.tag, this.hexstring, configItem) : OptionValidator.validateOption(this.tag, this.value, configItem);
        if (object instanceof Message) {
            return (Message)object;
        }
        return null;
    }

    public Object clone() {
        CommonOption commonOption = (CommonOption)super.clone();
        commonOption.hexstring = (HexString)this.hexstring.clone();
        return commonOption;
    }

    public abstract Message setTag(String var1, ConfigItem var2);
}

