/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.BINLServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.BooleanKeyword;
import COM.ibm.raleigh.dhcpsgui.biz.BootImage;
import COM.ibm.raleigh.dhcpsgui.biz.BootstrapServer;
import COM.ibm.raleigh.dhcpsgui.biz.Comment;
import COM.ibm.raleigh.dhcpsgui.biz.ComputerDomain;
import COM.ibm.raleigh.dhcpsgui.biz.ComputerName;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.Keyword;
import COM.ibm.raleigh.dhcpsgui.biz.Lease;
import COM.ibm.raleigh.dhcpsgui.biz.ListCriteria;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Option;
import COM.ibm.raleigh.dhcpsgui.biz.ProxyARec;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.ServerType;
import COM.ibm.raleigh.dhcpsgui.biz.SubnetGroup;
import COM.ibm.raleigh.dhcpsgui.biz.SupportsLeaseDuration;
import COM.ibm.raleigh.dhcpsgui.biz.SupportsScopedKeywords;
import COM.ibm.raleigh.dhcpsgui.biz.TFTPServer;
import COM.ibm.raleigh.dhcpsgui.biz.Vendor;
import COM.ibm.raleigh.dhcpsgui.biz.VendorOption;
import COM.ibm.raleigh.dhcpsgui.io.DHCPFile;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.dhcpsgui.view.ViewSchemes;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import COM.ibm.raleigh.utilExt.SortedHashtable;
import com.ibm.eNetwork.onDemand.common.gui.common.Scheme;
import com.ibm.eNetwork.onDemand.common.gui.common.Text;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewScheme;
import com.ibm.eNetwork.onDemand.common.gui.treeView.addableToTreeView;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class ConfigItem
extends Observable
implements addableToTreeView,
Cloneable {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_NO_LEASE = DHCPServerGUI.getResourceString("ERROR_NO_LEASE");
    public static final String ERROR_WRONG_SCOPE = DHCPServerGUI.getResourceString("ERROR_WRONG_SCOPE");
    public static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    public static final String LEASE_TIME_OPTION_TAG = "51";
    public static final String cannedCommentMark = "##";
    public static final String KEYWORD_ALIAS = "alias=";
    public static final String KEYWORD_CANONICAL = "canonical";
    public static final String KEYWORD_APPEND_DOMAIN_NAME = "appendDomainName";
    public static final String NO_ALIAS_DEFINED = "";
    private ConfigItem parent;
    protected Vector children = new Vector();
    public Object oState;
    private Hashtable keywordTable = new Hashtable();
    private Hashtable pxeKeywordTable = new Hashtable();
    private String alias = "";
    private boolean isValid = true;
    private Vector commentVector = new Vector();
    private static final String CUT = " Cut";
    static final String NEWLINE = "\n";
    private TreeViewScheme tvScheme;
    private TreeViewScheme tvSchemeCut;
    private TreeViewScheme currentScheme;
    private Text theText;
    protected Vector messages;

    public ConfigItem() {
        this.updateScheme();
    }

    public static String breakOutAlias(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        if (!string2.substring(0, 1).equals("(")) {
            return null;
        }
        int n = string2.toLowerCase().indexOf(KEYWORD_ALIAS);
        if (n < 0) {
            return null;
        }
        if ((string2 = string2.substring(n + KEYWORD_ALIAS.length()).trim()).length() > 0) {
            if (!string2.substring(0, 1).equals("\"")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
                if (stringTokenizer.countTokens() > 0) {
                    return stringTokenizer.nextToken();
                }
                return NO_ALIAS_DEFINED;
            }
        } else {
            return NO_ALIAS_DEFINED;
        }
        if ((string2 = string2.substring(1).trim()).indexOf("\"") > 0) {
            string2 = string2.substring(0, string2.indexOf("\""));
            return string2;
        }
        return NO_ALIAS_DEFINED;
    }

    public Keyword getKeyword(String string) {
        return (Keyword)this.keywordTable.get(string);
    }

    public Keyword getKeywordPXE(String string) {
        Keyword keyword = (Keyword)this.pxeKeywordTable.get(string);
        return keyword;
    }

    public Message addKeyword(String string, Keyword keyword) {
        if (this instanceof SupportsScopedKeywords) {
            this.keywordTable.put(string, keyword);
            return null;
        }
        return new Message(ERROR_WRONG_SCOPE);
    }

    public void addKeywordPXE(String string, Keyword keyword) {
        this.pxeKeywordTable.put(string, keyword);
    }

    public void removeKeyword(String string) {
        this.keywordTable.remove(string);
    }

    public void removeKeywordPXE(String string) {
        this.pxeKeywordTable.remove(string);
    }

    public Keyword getApplicableKeyword(String string) {
        ConfigItem configItem = this;
        while (configItem != null) {
            Keyword keyword = configItem.getKeyword(string);
            if (keyword != null) {
                return keyword;
            }
            configItem = configItem.getParent();
        }
        return null;
    }

    public Message setBooleanKeyword(String string, String string2) {
        BooleanKeyword booleanKeyword = new BooleanKeyword(string, this);
        Message message = booleanKeyword.setValue(string2);
        if (message == null) {
            message = this.addKeyword(string, booleanKeyword);
        }
        return message;
    }

    public Message setARecordSupport(String string) {
        ProxyARec proxyARec = new ProxyARec(this);
        Message message = proxyARec.setValue(string);
        if (message == null) {
            message = this.addKeyword(proxyARec.getKeyword(), proxyARec);
        }
        return message;
    }

    public Message setServerType(String string) {
        ServerType serverType = new ServerType(this);
        Message message = serverType.setValue(string);
        if (message == null) {
            this.removeKeywordPXE(serverType.getKeyword());
            this.addKeywordPXE(serverType.getKeyword(), serverType);
        }
        return message;
    }

    public Message setBooleanKeyword(String string, boolean bl) {
        BooleanKeyword booleanKeyword = (BooleanKeyword)this.getKeyword(string);
        if (booleanKeyword != null) {
            return booleanKeyword.setValue(bl);
        }
        return this.addKeyword(string, new BooleanKeyword(string, this, bl));
    }

    public Message setBootstrapServer(String string) {
        if (string == null || string.trim().length() == 0) {
            this.removeKeyword("bootstrapServer");
            return null;
        }
        BootstrapServer bootstrapServer = new BootstrapServer(this);
        Message message = bootstrapServer.setValue(string);
        if (message == null) {
            message = this.addKeyword(bootstrapServer.getKeyword(), bootstrapServer);
        }
        return message;
    }

    public Message setTFTPServer(String string) {
        if (string == null || string.trim().length() == 0) {
            this.removeKeyword("tftp");
            return null;
        }
        TFTPServer tFTPServer = new TFTPServer(this);
        Message message = tFTPServer.setValue(string);
        if (message == null) {
            message = this.addKeyword(tFTPServer.getKeyword(), tFTPServer);
        }
        return message;
    }

    public Message setBootImage(String string) {
        if (string == null || string.trim().length() == 0) {
            this.removeKeyword("bpname");
            return null;
        }
        BootImage bootImage = new BootImage(this);
        Message message = bootImage.setValue(string);
        if (message == null) {
            message = this.addKeyword(bootImage.getKeyword(), bootImage);
        }
        return message;
    }

    public Message setComputerName(String string) {
        if (string == null || string.trim().length() == 0) {
            this.removeKeyword("servername");
            return null;
        }
        ComputerName computerName = new ComputerName(this);
        Message message = computerName.setValue(string);
        if (message == null) {
            message = this.addKeyword(computerName.getKeyword(), computerName);
        }
        return message;
    }

    public Message setComputerDomain(String string) {
        if (string == null || string.trim().length() == 0 || string.equalsIgnoreCase(" domain") || string.equalsIgnoreCase(" workgroup")) {
            this.removeKeyword("serverdomainname");
            return null;
        }
        ComputerDomain computerDomain = new ComputerDomain(this);
        Message message = computerDomain.setValue(string);
        if (message == null) {
            message = this.addKeyword(computerDomain.getKeyword(), computerDomain);
        }
        return message;
    }

    public Message setLeaseInterval(String string) {
        if (!(this instanceof SupportsLeaseDuration)) {
            return new Message(ERROR_NO_LEASE);
        }
        Option option = this.getExplicitOption(LEASE_TIME_OPTION_TAG);
        if (string == null) {
            if (option != null) {
                this.deleteChild(option);
            }
            return null;
        }
        if (option == null) {
            option = new Option();
            Message message = option.setTag(LEASE_TIME_OPTION_TAG, this.parent);
            if (message != null) {
                return message;
            }
            message = Lease.validateLeaseValue(string);
            if (message != null) {
                return message;
            }
            message = option.setValue(string, this.parent);
            if (message != null) {
                return message;
            }
            boolean bl = option.commit(this);
            if (!bl) {
                return new Message(ERROR_WRONG_SCOPE);
            }
            return null;
        }
        Message message = option.setTag(LEASE_TIME_OPTION_TAG, this.parent);
        if (message != null) {
            return message;
        }
        message = Lease.validateLeaseValue(string);
        if (message != null) {
            return message;
        }
        message = option.setValue(string, this.parent);
        return message;
    }

    public String getComment() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = NO_ALIAS_DEFINED;
        if (this.commentVector.size() > 0) {
            stringBuffer.append(NO_ALIAS_DEFINED);
            Enumeration enumeration = this.commentVector.elements();
            while (enumeration.hasMoreElements()) {
                Comment comment = (Comment)enumeration.nextElement();
                stringBuffer.append(String.valueOf(string) + comment.getCommentText());
                string = NEWLINE;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public boolean setComment(String string) {
        if (string == null || string.equals(NO_ALIAS_DEFINED)) {
            return true;
        }
        Comment comment = new Comment(string);
        this.commentVector.removeAllElements();
        this.commentVector.addElement(comment);
        return true;
    }

    public boolean setComment(Comment comment) {
        this.commentVector.addElement(comment);
        return true;
    }

    public Message setAlias(String string) {
        if (string != null && string.trim().length() > 0) {
            String string2 = string.trim();
            int n = 0;
            int n2 = string2.length();
            if (string2.charAt(0) == '\"') {
                ++n;
            }
            if (string2.charAt(n2 - 1) == '\"') {
                --n2;
            }
            this.alias = string2.substring(n, n2);
        } else {
            this.alias = NO_ALIAS_DEFINED;
        }
        return null;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getAliasWithQuotes() {
        if (this.alias.equals(NO_ALIAS_DEFINED)) {
            return NO_ALIAS_DEFINED;
        }
        if (this.alias.indexOf(" ") != -1) {
            return "\"" + this.alias + "\"";
        }
        return this.alias;
    }

    public void saveToConfigFile(DHCPFile dHCPFile) {
        dHCPFile.writeLine(this.toStringWithScopedItems());
    }

    public String toStringWithScopedItems() {
        Stack<String> stack = new Stack<String>();
        stack.push(NO_ALIAS_DEFINED);
        StringBuffer stringBuffer = new StringBuffer();
        return this.toStringWithScopedItems(stack, stringBuffer).toString();
    }

    private StringBuffer toStringWithScopedItems(Stack stack, StringBuffer stringBuffer) {
        boolean bl;
        Cloneable cloneable;
        String string = NO_ALIAS_DEFINED;
        Comment comment = null;
        if (this.commentVector.size() > 0) {
            comment = (Comment)this.commentVector.elementAt(0);
            if (this.commentVector.size() == 1 && comment.toString().indexOf(NEWLINE) == -1 && (String.valueOf(this.toString()) + comment.toString()).length() < 80) {
                string = ((Comment)this.commentVector.elementAt(0)).toString();
            } else {
                Enumeration enumeration = this.commentVector.elements();
                while (enumeration.hasMoreElements()) {
                    cloneable = (Comment)enumeration.nextElement();
                    stringBuffer.append(NEWLINE + stack.peek());
                    stringBuffer.append(((Comment)cloneable).toString());
                }
                stringBuffer.append(NEWLINE);
                if (this instanceof Global || this instanceof BINLGlobal) {
                    stringBuffer.append(NEWLINE);
                }
            }
        }
        if (this instanceof Comment) {
            stringBuffer.append(NEWLINE);
        }
        stringBuffer.append(String.valueOf(stack.peek()) + this.toString());
        stringBuffer.append(" " + string);
        if (this instanceof Comment) {
            stringBuffer.append(NEWLINE);
        }
        if (bl = !(this instanceof Configuration) && !(this instanceof ServerParameters) && !(this instanceof BINLServerParameters) && !(this instanceof Global) && !(this instanceof BINLGlobal) && !(this instanceof SubnetGroup)) {
            if (this instanceof Vendor) {
                if (((Vendor)this).getVendorName().equalsIgnoreCase("PXEClient")) {
                    cloneable = Configuration.currentConfiguration.getServerParameters();
                    if (((ServerParameters)cloneable).getServerType().getValue().equalsIgnoreCase("dhcp")) {
                        stringBuffer.append(NEWLINE + '#' + stack.peek() + "{");
                    } else {
                        stringBuffer.append(NEWLINE + stack.peek() + "{");
                    }
                } else {
                    stringBuffer.append(NEWLINE + stack.peek() + "{");
                }
            } else {
                stringBuffer.append(NEWLINE + stack.peek() + "{");
            }
            stack.push(String.valueOf(stack.peek()) + "  ");
        }
        Enumeration enumeration = this.keywordTable.elements();
        while (enumeration.hasMoreElements()) {
            cloneable = (Keyword)enumeration.nextElement();
            stringBuffer.append(NEWLINE + stack.peek() + ((Keyword)cloneable).toString());
        }
        this.writeScopedItems(stack, stringBuffer);
        if (bl) {
            stack.pop();
            if (stringBuffer.charAt(stringBuffer.length() - 1) == '{') {
                stringBuffer.setLength(stringBuffer.length() - 2 - ((String)stack.peek()).length());
            } else if (this instanceof Vendor) {
                if (((Vendor)this).getVendorName().equalsIgnoreCase("PXEClient")) {
                    ServerParameters serverParameters = Configuration.currentConfiguration.getServerParameters();
                    if (serverParameters.getServerType().getValue().equalsIgnoreCase("dhcp")) {
                        stringBuffer.append(NEWLINE + '#' + stack.peek() + "}");
                    } else {
                        stringBuffer.append(NEWLINE + stack.peek() + "}");
                    }
                } else {
                    stringBuffer.append(NEWLINE + stack.peek() + "}");
                }
            } else {
                stringBuffer.append(NEWLINE + stack.peek() + "}");
            }
        }
        return stringBuffer;
    }

    void writeScopedItems(Stack stack, StringBuffer stringBuffer) {
        boolean bl = false;
        boolean bl2 = false;
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(NEWLINE);
            ConfigItem configItem = (ConfigItem)enumeration.nextElement();
            if (configItem instanceof Option) {
                ConfigItem configItem2 = configItem.getParent();
                if (!bl && configItem2 != null && Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
                    stringBuffer.append(String.valueOf(stack.peek()) + "pxevendor" + NEWLINE);
                    stringBuffer.append(String.valueOf(stack.peek()) + "{" + NEWLINE);
                    stack.push(String.valueOf(stack.peek()) + "  ");
                    bl = true;
                }
                if (bl2) {
                    if (!Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) continue;
                    String string = "pxevendor\n{\n";
                    int n = stringBuffer.toString().indexOf(string);
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stack.push(String.valueOf(stack.peek()) + "  ");
                    configItem.toStringWithScopedItems(stack, stringBuffer2);
                    stack.pop();
                    stringBuffer.insert(n + string.length(), String.valueOf(stringBuffer2.toString()) + NEWLINE);
                    continue;
                }
                configItem.toStringWithScopedItems(stack, stringBuffer);
                continue;
            }
            if (bl && !bl2) {
                stack.pop();
                stringBuffer.append(String.valueOf(stack.peek()) + "}" + NEWLINE);
                bl2 = true;
            }
            configItem.toStringWithScopedItems(stack, stringBuffer);
        }
        if (bl && !bl2) {
            stack.pop();
            stringBuffer.append(NEWLINE + stack.peek() + "}" + NEWLINE);
            bl2 = true;
        }
    }

    public ConfigItem getParent() {
        return this.parent;
    }

    public void markCutState(boolean bl) {
        this.currentScheme = bl ? this.tvSchemeCut : this.tvScheme;
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            ConfigItem configItem = (ConfigItem)enumeration.nextElement();
            configItem.markCutState(bl);
        }
    }

    public boolean getCutState() {
        return this.currentScheme == this.tvSchemeCut;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Enumeration getChildren() {
        return this.children.elements();
    }

    public boolean commit(ConfigItem configItem) {
        if (configItem == null) {
            this.setParent(null);
            this.notifyWatchers(null);
            return false;
        }
        if (configItem == this.getParent()) {
            this.notifyWatchers(null);
            return true;
        }
        if (configItem.addChild(this)) {
            this.setParent(configItem);
            this.parent.notifyWatchers(this);
            return true;
        }
        return false;
    }

    public boolean commitAt(ConfigItem configItem, ConfigItem configItem2) {
        if (configItem2 == null ? !configItem.insertChildAt(this, 0) : !configItem.addChildAfter(this, configItem2) && this.parent == null) {
            return false;
        }
        if (!this.setParent(configItem)) {
            return false;
        }
        this.parent.notifyWatchers(this);
        return true;
    }

    public boolean validateScope(ConfigItem configItem) {
        return this.parentTypeIsValid(configItem);
    }

    public abstract boolean parentTypeIsValid(ConfigItem var1);

    protected boolean setParent(ConfigItem configItem) {
        if (configItem != null) {
            this.parent = configItem;
            return true;
        }
        return false;
    }

    public void deleteChild(ConfigItem configItem) {
        this.children.removeElement(configItem);
        configItem.setParent(null);
    }

    public void replaceItem(ConfigItem configItem) {
        configItem.commitAt(this.parent, this);
        this.parent.deleteChild(this);
    }

    private boolean addChild(ConfigItem configItem) {
        return this.insertChildAt(configItem, this.children.size());
    }

    private boolean addChildAfter(ConfigItem configItem, ConfigItem configItem2) {
        int n = this.children.indexOf(configItem2);
        if (n == -1) {
            return false;
        }
        return this.insertChildAt(configItem, n + 1);
    }

    private boolean insertChildAt(ConfigItem configItem, int n) {
        if (this.children.indexOf(configItem) != -1) {
            return true;
        }
        if (configItem.validateScope(this)) {
            this.children.insertElementAt(configItem, n);
            return true;
        }
        return false;
    }

    public void removeAllObservers() {
        this.deleteObservers();
        Enumeration enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            ((ConfigItem)enumeration.nextElement()).removeAllObservers();
        }
    }

    public Enumeration getConfigItems(String string, boolean bl) {
        Vector vector = new Vector(10, 10);
        if (!string.equals("all")) {
            try {
                Class.forName(string);
            }
            catch (Exception exception) {
                throw new ShouldNotOccurException(exception.toString());
            }
        }
        this.addDescendantsMeetingCriteria(vector, string, bl);
        return vector.elements();
    }

    private void addDescendantsMeetingCriteria(Vector vector, String string, boolean bl) {
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            ConfigItem configItem = (ConfigItem)enumeration.nextElement();
            if (string.equals("all") || configItem.getClass().getName().equals(string)) {
                vector.addElement(configItem);
            }
            if (!bl) continue;
            configItem.addDescendantsMeetingCriteria(vector, string, bl);
        }
    }

    public Vector getConfigItems(ListCriteria listCriteria, boolean bl) {
        Vector vector = new Vector(10, 10);
        this.addDescendantsMeetingCriteria(vector, listCriteria, bl);
        return vector;
    }

    private void addDescendantsMeetingCriteria(Vector vector, ListCriteria listCriteria, boolean bl) {
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            ConfigItem configItem = (ConfigItem)enumeration.nextElement();
            Object object = listCriteria.meetsCriteria(configItem);
            if (object != null) {
                if (configItem instanceof Vendor) {
                    if (!((Vendor)configItem).getVendorName().equalsIgnoreCase("PXEClient") || !(configItem.getParent() instanceof Global)) {
                        vector.addElement(configItem);
                    }
                } else {
                    vector.addElement(object);
                }
            }
            if (!bl) continue;
            configItem.addDescendantsMeetingCriteria(vector, listCriteria, bl);
        }
    }

    public Option getOption(String string) {
        Enumeration enumeration = this.getInheritedOptions();
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            if (!option.getTag().equals(string.trim())) continue;
            return option;
        }
        return null;
    }

    public Option getExplicitOption(String string) {
        Enumeration enumeration = this.getExplicitOptions();
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            if (!option.getTag().equals(string.trim())) continue;
            return option;
        }
        return null;
    }

    public Enumeration getExplicitOptions() {
        SortedHashtable sortedHashtable = new SortedHashtable();
        this.getExplicitOptions(sortedHashtable);
        return sortedHashtable.elements();
    }

    private void getExplicitOptions(SortedHashtable sortedHashtable) {
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            Option option;
            String string;
            ConfigItem configItem = (ConfigItem)enumeration.nextElement();
            if (!(configItem instanceof Option) || sortedHashtable.containsKey(string = (option = (Option)configItem).getTag())) continue;
            sortedHashtable.put(string, option);
        }
    }

    public Enumeration getInheritedOptions() {
        SortedHashtable sortedHashtable = new SortedHashtable();
        this.getExplicitOptions(sortedHashtable);
        if (this instanceof Vendor && ((Vendor)this).getVendorName().equalsIgnoreCase("PXEClient")) {
            return sortedHashtable.elements();
        }
        ConfigItem configItem = this.getParent();
        while (configItem != null) {
            configItem.getExplicitOptions(sortedHashtable);
            configItem = configItem.getParent();
        }
        return sortedHashtable.elements();
    }

    public Scheme getScheme() {
        return this.currentScheme;
    }

    public Text getText() {
        if (this.theText == null) {
            this.theText = new Text();
            this.theText.addText(this.getName(), 0);
        } else {
            this.theText.addText(this.getName(), 0);
        }
        return this.theText;
    }

    public void setState(Object object) {
        this.oState = object;
    }

    public Object getState() {
        return this.oState;
    }

    public addableToTreeView getParentNode() {
        return this.getParent();
    }

    public addableToTreeView getNextNode() {
        if (this.parent == null) {
            return null;
        }
        int n = this.parent.children.indexOf(this);
        return this.parent.nextCandidateChild(n + 1);
    }

    public addableToTreeView getChildNode() {
        if (this.hasChildren()) {
            return this.nextCandidateChild(0);
        }
        return null;
    }

    abstract String getTypeSpecificScheme();

    private addableToTreeView nextCandidateChild(int n) {
        try {
            int n2 = n;
            while (true) {
                Object e = this.children.elementAt(n2);
                ConfigItem configItem = ((ConfigItem)e).getParent();
                if (e instanceof Vendor ? !(((ConfigItem)e).getParent() instanceof Global) || !((Vendor)e).getVendorName().equalsIgnoreCase("PXEClient") : !(e instanceof Option) && !(e instanceof VendorOption) && !(e instanceof ServerParameters) && !(e instanceof BINLServerParameters) && (!(e instanceof Comment) || configItem instanceof Global || configItem instanceof BINLGlobal)) {
                    return (addableToTreeView)e;
                }
                ++n2;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public Object clone() {
        ConfigItem configItem = (ConfigItem)this.itemClone();
        Enumeration enumeration = ConfigItem.cloneVector(this.children).elements();
        while (enumeration.hasMoreElements()) {
            ConfigItem configItem2 = (ConfigItem)enumeration.nextElement();
            configItem2.commit(configItem);
        }
        configItem.oState = null;
        return configItem;
    }

    public Object itemClone() {
        ConfigItem configItem;
        try {
            configItem = (ConfigItem)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        configItem.parent = null;
        configItem.children = new Vector();
        configItem.keywordTable = (Hashtable)this.keywordTable.clone();
        Enumeration enumeration = this.keywordTable.keys();
        Enumeration enumeration2 = this.keywordTable.elements();
        while (enumeration2.hasMoreElements()) {
            configItem.keywordTable.put(enumeration.nextElement(), ((Keyword)enumeration2.nextElement()).clone());
        }
        configItem.alias = String.valueOf(configItem.alias) + "-1";
        configItem.isValid = this.isValid;
        configItem.commentVector = ConfigItem.cloneVector(this.commentVector);
        configItem.oState = null;
        return configItem;
    }

    public Object replacementClone() {
        ConfigItem configItem = (ConfigItem)this.clone();
        configItem.children = (Vector)this.children.clone();
        Enumeration enumeration = configItem.children.elements();
        while (enumeration.hasMoreElements()) {
            ConfigItem configItem2 = (ConfigItem)enumeration.nextElement();
            if (!(configItem2 instanceof VendorOption) && !(configItem2 instanceof Option)) continue;
            ConfigItem configItem3 = (ConfigItem)configItem2.clone();
            configItem3.commitAt(configItem, configItem2);
            configItem.deleteChild(configItem2);
        }
        configItem.parent = null;
        configItem.alias = this.alias;
        configItem.isValid = this.isValid;
        configItem.commentVector = (Vector)this.commentVector.clone();
        return configItem;
    }

    protected static Vector cloneVector(Vector vector) {
        Vector vector2 = new Vector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object object = e instanceof ConfigItem ? ((ConfigItem)e).clone() : e;
            vector2.addElement(object);
        }
        return vector2;
    }

    public abstract String getItemType();

    public abstract Enumeration getOneLineDescription();

    public final void notifyWatchers(ConfigItem configItem) {
        this.setChanged();
        this.notifyObservers(configItem);
    }

    public abstract String getName();

    void updateScheme() {
        ViewSchemes viewSchemes = ViewSchemes.getViewSchemes();
        String string = this.getTypeSpecificScheme();
        if (viewSchemes != null) {
            this.tvScheme = viewSchemes.getSchemeByName(string);
            this.tvSchemeCut = viewSchemes.getSchemeByName(String.valueOf(string) + CUT);
            this.currentScheme = this.tvScheme;
            return;
        }
        this.currentScheme = null;
    }

    public boolean hasMessages() {
        return this.messages != null;
    }

    public Enumeration getMessages() {
        return new 1();
    }

    public void clearMessages() {
        if (this.messages != null) {
            this.messages.removeAllElements();
        }
    }

    public void addMessage(Message message) {
        if (this.messages == null) {
            this.messages = new Vector();
        }
        this.messages.addElement(message);
    }

    private final class 1
    implements Enumeration {
        private int i;

        public boolean hasMoreElements() {
            return ConfigItem.this.messages != null && this.i < ConfigItem.this.messages.size();
        }

        public Object nextElement() {
            if (this.i < ConfigItem.this.messages.size()) {
                return ConfigItem.this.messages.elementAt(this.i++);
            }
            throw new NoSuchElementException("getMessagesEnumerator");
        }

        /* synthetic */ 1() {
        }
    }
}

