/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.AddressRange;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.IPSubnetAddress;
import COM.ibm.raleigh.dhcpsgui.biz.IPSubnetMask;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.biz.SupportsLeaseDuration;
import COM.ibm.raleigh.dhcpsgui.biz.SupportsScopedKeywords;
import COM.ibm.raleigh.dhcpsgui.biz.UnlistedClient;
import COM.ibm.raleigh.dhcpsgui.notebook.ClientSupportPanelUser;
import COM.ibm.raleigh.dhcpsgui.notebook.InheritedUnlistedClientPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.Parsing;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class DHCPClass
extends ConfigItem
implements SupportsScopedKeywords,
SupportsLeaseDuration,
ClientSupportPanelUser {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    static final String ERROR_ADDRESS_RANGE_NOT_ALLOWED = DHCPServerGUI.getResourceString("ERROR_ADDRESS_RANGE_NOT_ALLOWED");
    static final String ERROR_SUBNET_INVALID_ADDR_MASK = DHCPServerGUI.getResourceString("ERROR_SUBNET_INVALID_ADDR_MASK");
    static final String ERROR_MISSING_CLASS_NAME = DHCPServerGUI.getResourceString("ERROR_MISSING_CLASS_NAME");
    static final String TEXT_NAME_CLASS = DHCPServerGUI.getResourceString("TEXT_NAME_CLASS");
    static final String TEXT_RANGE = DHCPServerGUI.getResourceString("TEXT_RANGE");
    static final String WARN_DUPLICATE_CLASS_NAME = DHCPServerGUI.getResourceString("WARN_DUPLICATE_CLASS_NAME");
    static final String ERROR_INVALID_CLASS_NAME = DHCPServerGUI.getResourceString("ERROR_INVALID_CLASS_NAME");
    public static final String KEYWORD_CLASS = "class";
    private String className;
    private AddressRange range = new AddressRange();
    private boolean validsubnet;
    private boolean wildCardSupported = true;
    private UnlistedClient unlistedClient = new UnlistedClient();

    public static Object parse(ConfigItem configItem, String string, boolean bl) {
        String string2;
        String string3;
        DHCPClass dHCPClass = new DHCPClass();
        StringTokenizer stringTokenizer = new StringTokenizer(string = String.valueOf(string.trim()) + " ", " ");
        if (stringTokenizer.countTokens() == 0) {
            return new Message(ERROR_MISSING_CLASS_NAME);
        }
        if (string.charAt(0) == '\"') {
            string3 = Parsing.getAllBetween(string, "\"", "\"");
            string2 = Parsing.getAllAfter(string, String.valueOf(string3) + "\"");
        } else {
            string3 = stringTokenizer.nextToken();
            string2 = Parsing.getAllAfter(string, string3);
        }
        dHCPClass.setWildCardSupported(bl);
        if (dHCPClass.getWildCardSupported() && (string3 = dHCPClass.convertToNormal(string3)) == null) {
            return new Message(ERROR_INVALID_CLASS_NAME);
        }
        Message message = dHCPClass.setClassName(string3, bl);
        if (message != null) {
            return message;
        }
        if (string2 != null && string2.trim().length() != 0 && (message = dHCPClass.setRange(string2, configItem)) != null) {
            return message;
        }
        if (dHCPClass.isThisDuplicate(configItem)) {
            if (message == null) {
                message = new Message();
            }
            message.addWarning(WARN_DUPLICATE_CLASS_NAME);
            return message;
        }
        if (dHCPClass.commit(configItem)) {
            return dHCPClass;
        }
        return new Message(ConfigItem.ERROR_WRONG_SCOPE);
    }

    public Message setClassName(String string, boolean bl) {
        if (string == null || string.trim().length() == 0) {
            return new Message(ERROR_MISSING_CLASS_NAME);
        }
        String string2 = string.trim();
        int n = 0;
        int n2 = string2.length();
        if (string2.charAt(0) == '\"') {
            ++n;
        }
        if (string2.charAt(n2 - 1) == '\"') {
            --n2;
        }
        string2 = string2.substring(n, n2);
        if (bl && (string2 = this.checkForSyntax(string2)) == null) {
            return new Message("Class name is not valid");
        }
        this.className = string2;
        this.setAlias(this.className);
        this.wildCardSupported = bl;
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassNameWithQuotes() {
        String string = this.className;
        if (this.wildCardSupported && string != null) {
            string = this.convertToWildCard(string);
        }
        if (string.indexOf(" ") != -1) {
            return "\"" + string + "\"";
        }
        return string;
    }

    public Message setSubnetDefinition(Subnetwork subnetwork) {
        if (subnetwork.isValidSubnet()) {
            IPSubnetAddress iPSubnetAddress = subnetwork.getAddressObject();
            IPSubnetMask iPSubnetMask = subnetwork.getMaskObject();
            this.range.setSubnetDefinition(iPSubnetAddress, iPSubnetMask);
            this.validsubnet = true;
            return null;
        }
        this.validsubnet = false;
        return new Message(ERROR_SUBNET_INVALID_ADDR_MASK);
    }

    public Message setRange(String string, ConfigItem configItem) {
        if (!(configItem instanceof Subnetwork)) {
            return new Message(ERROR_ADDRESS_RANGE_NOT_ALLOWED);
        }
        Subnetwork subnetwork = (Subnetwork)configItem;
        if (string == null) {
            this.range = new AddressRange();
            return null;
        }
        string = string.trim();
        if (subnetwork.isValidSubnet()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
            if (stringTokenizer.countTokens() == 0) {
                return null;
            }
            AddressRange addressRange = subnetwork.getPoolRangeObject();
            this.setSubnetDefinition(subnetwork);
            Message message = this.range.setAddressRange(string);
            if (message != null) {
                return message;
            }
            message = this.range.isSubRange(addressRange);
            if (message != null) {
                return message;
            }
        } else {
            this.validsubnet = false;
            return new Message(ERROR_SUBNET_INVALID_ADDR_MASK);
        }
        return null;
    }

    public String getRange() {
        if (this.range.isValidRange()) {
            return this.range.getAddressRange();
        }
        return null;
    }

    public String getRangeStart() {
        if (this.range.isValidRange()) {
            return this.range.getAddressRangeStart();
        }
        return null;
    }

    public String getRangeEnd() {
        if (this.range.isValidRange()) {
            return this.range.getAddressRangeEnd();
        }
        return null;
    }

    public boolean isRangeValid() {
        if (this.range.isValidRange()) {
            return this.range.isValidRange();
        }
        return false;
    }

    public String getName() {
        return String.valueOf(this.getItemType()) + " " + this.getClassName();
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem instanceof Global || configItem instanceof Subnetwork;
    }

    String getTypeSpecificScheme() {
        return "DHCP Class";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("class " + this.getClassNameWithQuotes());
        String string = this.getRange();
        if (string != null) {
            stringBuffer.append(" " + string);
        }
        if (this.getWildCardSupported()) {
            stringBuffer.insert(0, "#@@@WILD@@@" + '\n');
        }
        return stringBuffer.toString();
    }

    public Enumeration getOneLineDescription() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(String.valueOf(this.getItemType()) + " " + this.getAlias());
        if (this.getRange() != null) {
            vector.addElement(String.valueOf(TEXT_RANGE) + this.getRange());
        }
        return vector.elements();
    }

    public String getItemType() {
        return TEXT_NAME_CLASS;
    }

    public Object clone() {
        DHCPClass dHCPClass = (DHCPClass)super.clone();
        dHCPClass.range = (AddressRange)this.range.clone();
        return dHCPClass;
    }

    public Message validate() {
        Message message = null;
        message = this.setRange(this.getRange(), this.getParent());
        if (message != null) {
            message = new Message(String.valueOf(this.toString()) + "\n" + "   " + message.getText());
        }
        return message;
    }

    private String convertToNormal(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        string2 = string2.trim();
        int n3 = string2.length();
        while (n < n3) {
            char c = string2.charAt(n);
            switch (c) {
                case '(': {
                    if (n3 <= n + 3) {
                        stringBuffer.append(c);
                        return null;
                    }
                    if (string2.charAt(n + 1) != '.' || string2.charAt(n + 2) != '*' || string2.charAt(n + 3) != ')') break;
                    stringBuffer.append('*');
                    n += 3;
                    break;
                }
                case '.': {
                    stringBuffer.append('?');
                    break;
                }
                case '[': {
                    stringBuffer.append('[');
                    n2 = n;
                    while (n < n3 - 1 && (c = string2.charAt(++n)) != ']') {
                        stringBuffer.append(c);
                    }
                    if (c != ']') {
                        return null;
                    }
                    if (n2 > n - 2) {
                        stringBuffer.append(c);
                        return null;
                    }
                    if (string2.charAt(n - 2) == '-') {
                        if (n != n2 + 4) {
                            return null;
                        }
                        if (Character.isDigit(string2.charAt(n2 + 1)) && !Character.isDigit(string2.charAt(n2 + 3)) || string2.charAt(n2 + 1) >= string2.charAt(n2 + 3)) {
                            return null;
                        }
                        if (Character.isLetter(string2.charAt(n2 + 1)) && !Character.isLetter(string2.charAt(n2 + 3)) || string2.charAt(n2 + 1) >= string2.charAt(n2 + 3)) {
                            return null;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                case ']': {
                    return null;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    private String convertToWildCard(String var1_1) {
        var2_2 = new StringBuffer();
        var3_3 = 0;
        var4_4 = 0;
        var2_2.ensureCapacity(100);
        var1_1 = var1_1.trim();
        var5_5 = var1_1.length();
        if (var5_5 != 0) ** GOTO lbl55
        return null;
lbl-1000:
        // 1 sources

        {
            var6_6 = var1_1.charAt(var3_3);
            switch (var6_6) {
                case '*': {
                    var2_2.append('(');
                    var2_2.append('.');
                    var2_2.append('*');
                    var2_2.append(')');
                    break;
                }
                case '?': {
                    var2_2.append('.');
                    break;
                }
                case '[': {
                    var2_2.append('[');
                    var4_4 = var3_3;
                    while (var3_3 < var5_5 - 1 && (var6_6 = var1_1.charAt(++var3_3)) != ']') {
                        var2_2.append(var6_6);
                    }
                    if (var6_6 != ']') {
                        return null;
                    }
                    if (var4_4 > var3_3 - 2) {
                        var2_2.append(var6_6);
                        return null;
                    }
                    if (var1_1.charAt(var3_3 - 2) == '-') {
                        if (var3_3 != var4_4 + 4) {
                            return null;
                        }
                        if (Character.isDigit(var1_1.charAt(var4_4 + 1)) && !Character.isDigit(var1_1.charAt(var4_4 + 3)) || var1_1.charAt(var4_4 + 1) >= var1_1.charAt(var4_4 + 3)) {
                            return null;
                        }
                        if (Character.isLetter(var1_1.charAt(var4_4 + 1)) && !Character.isLetter(var1_1.charAt(var4_4 + 3)) || var1_1.charAt(var4_4 + 1) >= var1_1.charAt(var4_4 + 3)) {
                            return null;
                        }
                    }
                    var2_2.append(var6_6);
                    break;
                }
                case ']': {
                    return null;
                }
                default: {
                    var2_2.append(var6_6);
                }
            }
            ++var3_3;
lbl55:
            // 2 sources

            ** while (var3_3 < var5_5)
        }
lbl56:
        // 1 sources

        return var2_2.toString();
    }

    public boolean getWildCardSupported() {
        return this.wildCardSupported;
    }

    public void setWildCardSupported(boolean bl) {
        this.wildCardSupported = bl;
    }

    public String checkForSyntax(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        string2 = string2.trim();
        int n3 = string2.length();
        while (n < n3) {
            char c = string2.charAt(n);
            switch (c) {
                case '[': {
                    stringBuffer.append('[');
                    n2 = n;
                    while (n < n3 - 1 && (c = string2.charAt(++n)) != ']') {
                        stringBuffer.append(c);
                    }
                    if (c != ']') {
                        return null;
                    }
                    if (n2 > n - 2) {
                        stringBuffer.append(c);
                        return null;
                    }
                    if (string2.charAt(n - 2) == '-') {
                        if (n != n2 + 4) {
                            return null;
                        }
                        if (Character.isDigit(string2.charAt(n2 + 1)) && !Character.isDigit(string2.charAt(n2 + 3)) || string2.charAt(n2 + 1) >= string2.charAt(n2 + 3)) {
                            return null;
                        }
                        if (Character.isLetter(string2.charAt(n2 + 1)) && !Character.isLetter(string2.charAt(n2 + 3)) || string2.charAt(n2 + 1) >= string2.charAt(n2 + 3)) {
                            return null;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                case ']': {
                    return null;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean isThisDuplicate(ConfigItem configItem) {
        int n = 0;
        while (n < configItem.children.size()) {
            if (configItem.children.elementAt(n) instanceof DHCPClass && !this.equals(configItem.children.elementAt(n)) && this.className.equalsIgnoreCase(((DHCPClass)configItem.children.elementAt(n)).getClassName())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void parseUnlistedClientSupport(String string, String string2) {
        this.unlistedClient.parseValue(string, string2);
    }

    public int getUnlistedClientSupportType() {
        return this.unlistedClient.getUnlistedClientSupportType();
    }

    public void setUnlistedClientSupportType(int n) {
        this.unlistedClient.setUnlistedClientSupportType(n);
    }

    public boolean isUnlistedInherited() {
        return this.unlistedClient.isInherited();
    }

    public void setUnlistedInherited(boolean bl) {
        this.unlistedClient.setInherited(bl);
    }

    public int getInheritedClientSupportType(ConfigItem configItem) {
        int n = this.getUnlistedClientSupportType();
        ConfigItem configItem2 = this.getParent();
        if (configItem2 == null && configItem != null) {
            configItem2 = configItem;
        }
        if (configItem2 == null || configItem2 instanceof Global) {
            n = this.getServerParameters(configItem).getUnlistedClientSupportType();
        } else if (configItem2 instanceof Subnetwork) {
            n = !((Subnetwork)configItem2).isUnlistedInherited() ? ((Subnetwork)configItem2).getUnlistedClientSupportType() : this.getServerParameters(configItem).getUnlistedClientSupportType();
        }
        return n;
    }

    public String getInheritedClientSupportLocation(ConfigItem configItem) {
        StringBuffer stringBuffer = new StringBuffer();
        ConfigItem configItem2 = this.getParent();
        if (configItem2 == null && configItem != null) {
            configItem2 = configItem;
        }
        if (configItem2 == null || configItem2 instanceof Global) {
            stringBuffer.append(InheritedUnlistedClientPanel.TEXT_DHCP_SERVER);
        } else if (configItem2 instanceof Subnetwork) {
            if (!((Subnetwork)configItem2).isUnlistedInherited()) {
                stringBuffer.append(((Subnetwork)configItem2).getName());
            } else {
                stringBuffer.append(InheritedUnlistedClientPanel.TEXT_DHCP_SERVER);
            }
        }
        return stringBuffer.toString();
    }

    public ServerParameters getServerParameters(ConfigItem configItem) {
        ConfigItem configItem2 = null;
        ServerParameters serverParameters = null;
        configItem2 = configItem != null ? configItem : this.getParent();
        while (configItem2 != null) {
            if (configItem2 instanceof Configuration) {
                serverParameters = ((Configuration)configItem2).getServerParameters();
                break;
            }
            configItem2 = configItem2.getParent();
        }
        return serverParameters;
    }

    protected void writeScopedItems(Stack stack, StringBuffer stringBuffer) {
        if (!this.isUnlistedInherited()) {
            stringBuffer.append("\n" + stack.peek() + this.unlistedClient.toString());
        }
        super.writeScopedItems(stack, stringBuffer);
    }
}

