/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.AvailableSubnetsCriteria;
import COM.ibm.raleigh.dhcpsgui.biz.Client;
import COM.ibm.raleigh.dhcpsgui.biz.Comment;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItemWithExcludedAddresses;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.DHCPClass;
import COM.ibm.raleigh.dhcpsgui.biz.IPAddress;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Option;
import COM.ibm.raleigh.dhcpsgui.biz.ProxyARec;
import COM.ibm.raleigh.dhcpsgui.biz.SubnetGroup;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.biz.SupportsScopedKeywords;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Global
extends ConfigItemWithExcludedAddresses
implements SupportsScopedKeywords {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_GLOBAL = DHCPServerGUI.getResourceString("TEXT_GLOBAL");
    private static final String TEXT_GLOBAL_ONE_LINE_DESCRIPTION = DHCPServerGUI.getResourceString("TEXT_GLOBAL_ONE_LINE_DESCRIPTION");

    public Global(ConfigItem configItem) {
        this.commit(configItem);
        this.setBooleanKeyword("canonical", false);
        this.setBooleanKeyword("appendDomainName", true);
        ProxyARec proxyARec = new ProxyARec(this);
        proxyARec.setValue("no");
        this.addKeyword("proxyARec", proxyARec);
    }

    public boolean setComment(String string) {
        if (string == null) {
            return false;
        }
        Comment comment = new Comment(string);
        return comment.commit(this);
    }

    public boolean setComment(Comment comment) {
        return comment.commit(this);
    }

    public Message validateExcludedAddress(IPAddress iPAddress) {
        return null;
    }

    public String toString() {
        return String.valueOf(this.getGroupList("inOrder:")) + this.getGroupList("balance:");
    }

    public String getName() {
        return this.getItemType();
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem instanceof Configuration;
    }

    String getTypeSpecificScheme() {
        return "DHCP Global";
    }

    public Enumeration getOneLineDescription() {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            if (objectArray instanceof Subnetwork) {
                ++n;
                continue;
            }
            if (objectArray instanceof DHCPClass) {
                ++n2;
                continue;
            }
            if (objectArray instanceof Client) {
                ++n3;
                continue;
            }
            if (objectArray instanceof Option) {
                ++n4;
                continue;
            }
            if (!(objectArray instanceof SubnetGroup)) continue;
            ++n5;
        }
        objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n5), new Integer(n4)};
        vector.addElement(MessageFormat.format(TEXT_GLOBAL_ONE_LINE_DESCRIPTION, objectArray));
        return vector.elements();
    }

    public boolean checkAnAddressIsDefined() {
        boolean bl = false;
        Enumeration enumeration = this.getChildren();
        while (enumeration.hasMoreElements()) {
            ConfigItem configItem = (ConfigItem)enumeration.nextElement();
            if (!(configItem instanceof Subnetwork) && !(configItem instanceof Client)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String getItemType() {
        return TEXT_GLOBAL;
    }

    public Message addSubnetGroups(String string, String string2) {
        if ((string = string.trim()).equalsIgnoreCase("inOrder:")) {
            string = "inOrder:";
        } else if (string.equalsIgnoreCase("balance:")) {
            string = "balance:";
        } else {
            throw new IllegalArgumentException();
        }
        Message message = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
        while (stringTokenizer.hasMoreElements()) {
            Object object = this.addSubnetGroup((String)stringTokenizer.nextElement());
            if (object instanceof SubnetGroup) {
                ((SubnetGroup)object).setEnabledState(true);
                ((SubnetGroup)object).setOrder(string);
                continue;
            }
            message = (Message)object;
            break;
        }
        return message;
    }

    private Object addSubnetGroup(String string) {
        Object object;
        SubnetGroup subnetGroup = null;
        string = string.trim();
        Enumeration enumeration = this.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.SubnetGroup", false);
        while (enumeration.hasMoreElements()) {
            object = (SubnetGroup)enumeration.nextElement();
            if (!((SubnetGroup)object).getGroupName().equalsIgnoreCase(string)) continue;
            subnetGroup = object;
            break;
        }
        if (subnetGroup == null) {
            object = null;
            subnetGroup = new SubnetGroup();
            object = subnetGroup.setGroupName(string);
            if (object == null) {
                subnetGroup.commit(this);
            } else {
                return object;
            }
        }
        return subnetGroup;
    }

    protected Message addSubnetToGroup(String string, Subnetwork subnetwork, int n) {
        Object object = this.addSubnetGroup(string);
        if (object instanceof SubnetGroup) {
            ((SubnetGroup)object).addSubnet(subnetwork, n);
            return null;
        }
        return (Message)object;
    }

    private String getGroupList(String string) {
        StringBuffer stringBuffer = new StringBuffer(50);
        Enumeration enumeration = this.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.SubnetGroup", false);
        while (enumeration.hasMoreElements()) {
            SubnetGroup subnetGroup = (SubnetGroup)enumeration.nextElement();
            if (!subnetGroup.getOrder().equals(string) || !subnetGroup.getEnabledState()) continue;
            stringBuffer.append(" " + subnetGroup.getGroupName());
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.insert(0, "\n" + string);
        }
        return stringBuffer.toString();
    }

    public Vector getAvailableSubnets() {
        return this.getConfigItems(new AvailableSubnetsCriteria(), false);
    }
}

