/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;

public class HardwareType
implements Cloneable {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_CLIENT_HARDWARE_TYPE_NOT_SUPPORTED = DHCPServerGUI.getResourceString("ERROR_CLIENT_HARDWARE_TYPE_NOT_SUPPORTED");
    private static final String TEXT_HARDWARE_TYPE_0_UNASSIGNED = DHCPServerGUI.getResourceString("TEXT_HARDWARE_TYPE_0_UNASSIGNED");
    private static final String TEXT_HARDWARE_TYPE_1_ETHERNET = DHCPServerGUI.getResourceString("TEXT_HARDWARE_TYPE_1_ETHERNET");
    private static final String TEXT_HARDWARE_TYPE_6_IEEE_802 = DHCPServerGUI.getResourceString("TEXT_HARDWARE_TYPE_6_IEEE_802");
    private static int[] hwType;
    private static String[] name;
    private static String[] strHWTypes;
    private int index;

    public Message setIdTypeFromIndex(int n) {
        try {
            this.index = n;
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return new Message(ERROR_CLIENT_HARDWARE_TYPE_NOT_SUPPORTED);
        }
    }

    public Message setIdTypeFromInteger(int n) {
        int n2 = 0;
        while (n2 < hwType.length) {
            if (n == hwType[n2]) {
                this.index = n2;
                return null;
            }
            ++n2;
        }
        return new Message(ERROR_CLIENT_HARDWARE_TYPE_NOT_SUPPORTED);
    }

    public static String[] getHWTypeStrings() {
        return strHWTypes;
    }

    public final String getDescription() {
        return name[this.index];
    }

    public final int getIdTypeAsIndex() {
        return this.index;
    }

    public final int getIdTypeAsInteger() {
        return hwType[this.index];
    }

    public String getIdTypeAsString() {
        return String.valueOf(hwType[this.index]);
    }

    public String getIdTypeDescription() {
        return strHWTypes[this.index];
    }

    public Object clone() {
        HardwareType hardwareType;
        try {
            hardwareType = (HardwareType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ShouldNotOccurException("HardwareType caught " + cloneNotSupportedException + " when trying to clone " + this.getDescription());
        }
        return hardwareType;
    }

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 6;
        hwType = nArray;
        name = new String[]{TEXT_HARDWARE_TYPE_0_UNASSIGNED, TEXT_HARDWARE_TYPE_1_ETHERNET, TEXT_HARDWARE_TYPE_6_IEEE_802};
        strHWTypes = new String[]{String.valueOf(hwType[0]) + " " + TEXT_HARDWARE_TYPE_0_UNASSIGNED, String.valueOf(hwType[1]) + " " + TEXT_HARDWARE_TYPE_1_ETHERNET, String.valueOf(hwType[2]) + " " + TEXT_HARDWARE_TYPE_6_IEEE_802};
    }
}

