/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Address;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;

public class IPAddress
extends Address {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_MISSING_ADDRESS = DHCPServerGUI.getResourceString("ERROR_MISSING_ADDRESS");
    private static final String ERROR_FIRST_OCTET_VALUE = DHCPServerGUI.getResourceString("ERROR_FIRST_OCTET_VALUE");

    public static Message validateAddress(String string) {
        if (string == null) {
            return new Message(ERROR_MISSING_ADDRESS);
        }
        String string2 = string.trim();
        Message message = Address.validateAddressFormat(string2);
        if (message == null) {
            return IPAddress.checkFirstOctet(string2);
        }
        return message;
    }

    public Message setIPAddress(String string) {
        if (string == null) {
            return new Message(ERROR_MISSING_ADDRESS);
        }
        return this.setAddress(string.trim());
    }

    public String getIPAddress() {
        return this.getAddress();
    }

    public Message setAddress(String string) {
        if (string == null) {
            return new Message(ERROR_MISSING_ADDRESS);
        }
        Message message = super.setAddress(string.trim());
        if (message == null && (message = IPAddress.checkFirstOctet(this.address)) != null) {
            super.initAddress();
        }
        return message;
    }

    public Object clone() {
        return (IPAddress)super.clone();
    }

    private static Message checkFirstOctet(String string) {
        int n;
        if (string == null) {
            return new Message(ERROR_MISSING_ADDRESS);
        }
        String string2 = string.trim();
        if (Integer.parseInt(string2.substring(0, n = string2.indexOf(46))) > 223) {
            return new Message(ERROR_FIRST_OCTET_VALUE);
        }
        return null;
    }
}

