/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Address;
import COM.ibm.raleigh.dhcpsgui.biz.IPAddress;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;

public class IPSubnetAddress
extends IPAddress {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_MISSING_SUBNET_ADDRESS = DHCPServerGUI.getResourceString("ERROR_MISSING_SUBNET_ADDRESS");
    private static final String ERROR_SUBNET_ADDRESS_ENDS_IN_ONES = DHCPServerGUI.getResourceString("ERROR_SUBNET_ADDRESS_ENDS_IN_ONES");

    public static Message validateAddress(String string) {
        if (string == null) {
            return new Message(ERROR_MISSING_SUBNET_ADDRESS);
        }
        String string2 = string.trim();
        Message message = IPAddress.validateAddress(string2);
        if (message == null) {
            int n = Address.dottedTo32BitAddress(string2);
            message = IPSubnetAddress.validateSubnetAddressFormat(n);
            if (message != null) {
                return message;
            }
            return null;
        }
        return message;
    }

    public static String truncateAddressToMaskLength(String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            return null;
        }
        int n2 = Address.lsbFromDottedDecimal(string);
        if (n2 > (n = Address.lsbFromDottedDecimal(string2))) {
            int n3 = Address.dottedTo32BitAddress(string);
            int n4 = Address.dottedTo32BitAddress(string2);
            return Address.integerToDottedDecimal(n3 &= n4);
        }
        return string;
    }

    public Message setAddress(String string) {
        if (string == null) {
            return new Message(ERROR_MISSING_SUBNET_ADDRESS);
        }
        String string2 = string.trim();
        Message message = super.setAddress(string2);
        if (message == null) {
            this.intAddress = Address.dottedTo32BitAddress(string2);
            message = IPSubnetAddress.validateSubnetAddressFormat(this.intAddress);
            if (message == null) {
                this.address = string2;
                this.address.trim();
                this.valid = true;
                return null;
            }
        }
        this.initAddress();
        return message;
    }

    public Object clone() {
        return (IPSubnetAddress)super.clone();
    }

    private static Message validateSubnetAddressFormat(int n) {
        if ((n & 0xFFFFFFFE) != n) {
            return new Message(ERROR_SUBNET_ADDRESS_ENDS_IN_ONES);
        }
        return null;
    }
}

