/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Address;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.util.StringTokenizer;

public class IPSubnetMask
extends Address {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_INTEGER_MASK_VALUE = DHCPServerGUI.getResourceString("ERROR_INTEGER_MASK_VALUE");
    private static final String ERROR_MISSING_SUBNET_MASK = DHCPServerGUI.getResourceString("ERROR_MISSING_SUBNET_MASK");
    private static final String ERROR_MISSING_SUBNET_ADDRESS = DHCPServerGUI.getResourceString("ERROR_MISSING_SUBNET_ADDRESS");
    private static final String ERROR_MASK_FIRST_OCTET_NOT_255 = DHCPServerGUI.getResourceString("ERROR_MASK_FIRST_OCTET_NOT_255");
    private static final String ERROR_SUBNET_MASK_ALL_ONES = DHCPServerGUI.getResourceString("ERROR_SUBNET_MASK_ALL_ONES");
    private static final String ERROR_SUBNET_MASK_NONCONTIGUOUS_ONES = DHCPServerGUI.getResourceString("ERROR_SUBNET_MASK_NONCONTIGUOUS_ONES");
    private static final String ERROR_SUBNET_MASK_TOO_SHORT = DHCPServerGUI.getResourceString("ERROR_SUBNET_MASK_TOO_SHORT");
    private int numberOfOnes;

    public static Message validateAddress(String string) {
        if (string == null) {
            return new Message(ERROR_MISSING_SUBNET_MASK);
        }
        String string2 = string.trim();
        try {
            int n = Integer.parseInt(string2);
            if (n < 8 || n > 31) {
                return new Message(ERROR_INTEGER_MASK_VALUE);
            }
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            return IPSubnetMask.validateDottedMask(string2);
        }
    }

    public static String convertToDottedDecimalFromOnes(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        int n = Integer.parseInt(string2);
        if (n > 0) {
            int n2 = IPSubnetMask.onesTo32BitAddress(n);
            return Address.integerToDottedDecimal(n2);
        }
        return "0.0.0.0";
    }

    public static String generateClassMask(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.trim().substring(0, string.indexOf(46));
        if (string2 == null) {
            return null;
        }
        int n = Integer.parseInt(string2);
        if (n > 0 && n < 128) {
            return "255.0.0.0";
        }
        if (n > 127 && n < 192) {
            return "255.255.0.0";
        }
        if (n > 191 && n < 224) {
            return "255.255.255.0";
        }
        return null;
    }

    public static String generateDottedMask(String string) {
        int n = Address.dottedTo32BitAddress(string.trim());
        int n2 = 0;
        while (n2 < 32) {
            if ((1 << n2 & n) != 0) break;
            ++n2;
        }
        int n3 = 1;
        n3 <<= 31;
        return Address.integerToDottedDecimal(n3 >>= 31 - n2);
    }

    public static Message isValidMaskForAddress(String string, String string2) {
        int n;
        if (string == null) {
            return new Message(ERROR_MISSING_SUBNET_ADDRESS);
        }
        if (string2 == null) {
            return new Message(ERROR_MISSING_SUBNET_MASK);
        }
        int n2 = Address.dottedTo32BitAddress(string.trim());
        String string3 = string2.trim();
        try {
            int n3 = Integer.parseInt(string3);
            n = IPSubnetMask.onesTo32BitAddress(n3);
        }
        catch (NumberFormatException numberFormatException) {
            n = Address.dottedTo32BitAddress(string3);
        }
        if ((n2 & n) != n2) {
            return new Message(ERROR_SUBNET_MASK_TOO_SHORT);
        }
        return null;
    }

    public Message setMask(String string) {
        return this.setAddress(string);
    }

    public String getMask() {
        return this.getStringAddress();
    }

    public String getStringAddress() {
        if (!this.valid) {
            return null;
        }
        if (this.numberOfOnes != 0) {
            return String.valueOf(this.numberOfOnes);
        }
        return this.address;
    }

    public final String getDottedAddress() {
        if (!this.valid) {
            return null;
        }
        return this.address;
    }

    public Message setAddress(String string) {
        if (string == null) {
            return new Message(ERROR_MISSING_SUBNET_MASK);
        }
        String string2 = string.trim();
        try {
            this.numberOfOnes = Integer.parseInt(string2);
            if (this.numberOfOnes < 8 || this.numberOfOnes > 31) {
                this.numberOfOnes = 0;
                return new Message(ERROR_INTEGER_MASK_VALUE);
            }
            this.intAddress = IPSubnetMask.onesTo32BitAddress(this.numberOfOnes);
            this.address = Address.integerToDottedDecimal(this.intAddress);
            this.valid = true;
            return null;
        }
        catch (NumberFormatException numberFormatException) {
            Message message = IPSubnetMask.validateDottedMask(string2);
            if (message == null) {
                this.address = string;
                this.intAddress = Address.dottedTo32BitAddress(this.address);
                this.numberOfOnes = 0;
                this.valid = true;
            } else {
                this.numberOfOnes = 0;
                super.initAddress();
                this.valid = false;
            }
            return message;
        }
    }

    public Object clone() {
        IPSubnetMask iPSubnetMask = (IPSubnetMask)super.clone();
        iPSubnetMask.numberOfOnes = this.numberOfOnes;
        return iPSubnetMask;
    }

    private static Message validateDottedMask(String string) {
        if (string == null) {
            return new Message(Address.ERROR_MISSING_ADDRESS);
        }
        String string2 = string.trim();
        Message message = Address.validateAddressFormat(string2);
        if (message != null) {
            return message;
        }
        int[] nArray = new int[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        int n = 0;
        while (n < 4) {
            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        if (nArray[0] != 255) {
            return new Message(ERROR_MASK_FIRST_OCTET_NOT_255);
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 1;
        while (n2 < 4) {
            if (nArray[n2] == 255) {
                if (bl || bl2) {
                    return new Message(ERROR_SUBNET_MASK_NONCONTIGUOUS_ONES);
                }
            } else {
                switch (nArray[n2]) {
                    case 128: 
                    case 192: 
                    case 224: 
                    case 240: 
                    case 248: 
                    case 252: 
                    case 254: {
                        if (bl || bl2) {
                            return new Message(ERROR_SUBNET_MASK_NONCONTIGUOUS_ONES);
                        }
                        bl2 = true;
                        break;
                    }
                    case 0: {
                        bl = true;
                        break;
                    }
                    default: {
                        return new Message(ERROR_SUBNET_MASK_NONCONTIGUOUS_ONES);
                    }
                }
            }
            ++n2;
        }
        if (!bl && !bl2) {
            return new Message(ERROR_SUBNET_MASK_ALL_ONES);
        }
        return null;
    }

    private static int onesTo32BitAddress(int n) {
        int n2 = 1;
        n2 <<= 31;
        return n2 >>= n - 1;
    }
}

