/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.BINLServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItemWithExcludedAddresses;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.IPAddress;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.SupportsScopedKeywords;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.Parsing;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class LSA1Group
extends ConfigItemWithExcludedAddresses
implements SupportsScopedKeywords {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    public static final String TEXT_ILLEGAL_CHARS = DHCPServerGUI.getResourceString("TEXT_ILLEGAL_CHARS");
    public static final String ERROR_WRONG_SCOPE = DHCPServerGUI.getResourceString("ERROR_WRONG_SCOPE");
    public static final String ERROR_TOKENS_MISSING = DHCPServerGUI.getResourceString("ERROR_TOKENS_MISSING");
    public static final String TEXT_LSA1GROUP_NAME = DHCPServerGUI.getResourceString("TEXT_LSA1GROUP_NAME");
    public static final String TEXT_DUPLICATE_LSA1GROUP = DHCPServerGUI.getResourceString("TEXT_DUPLICATE_LSA1GROUP");
    public static final String TEXT_NETWORK_INTERFACE_LABEL = DHCPServerGUI.getResourceString("TEXT_NETWORK_INTERFACE_LABEL");
    public static final String KEYWORD_LSA1GROUP = "lsa1nic";
    private String nic = String.valueOf(1);
    private boolean validLSA1Group = false;

    public static Object parse(ConfigItem configItem, String string) {
        String string2 = null;
        LSA1Group lSA1Group = new LSA1Group();
        if (!lSA1Group.parentTypeIsValid(configItem)) {
            return new Message(ConfigItem.ERROR_WRONG_SCOPE);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() < 1) {
            return new Message(ERROR_TOKENS_MISSING);
        }
        string2 = stringTokenizer.nextToken();
        Message message = lSA1Group.setNic(string2);
        if (message != null) {
            return message;
        }
        String string3 = Parsing.getAllAfter(string, string2);
        if (string3 != null && (string3 = string3.trim()).length() > 0) {
            lSA1Group.setAlias(ConfigItem.breakOutAlias(string3));
            if (lSA1Group.getAlias() == null) {
                return new Message(TEXT_ILLEGAL_CHARS);
            }
        }
        lSA1Group.commit(configItem);
        return lSA1Group;
    }

    public String toString() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer("lsa1nic ");
        stringBuffer.append(this.getNic());
        boolean bl2 = bl = !this.getAlias().equals("");
        if (bl) {
            stringBuffer.append(" (");
            if (bl) {
                stringBuffer.append("alias=" + this.getAliasWithQuotes());
            }
        }
        return stringBuffer.toString();
    }

    public Message setNic(String string) {
        this.nic = string;
        return null;
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem instanceof BINLGlobal;
    }

    public String getNic() {
        return this.nic;
    }

    public int getNicAsInt() {
        Integer n = Integer.valueOf(this.nic);
        return n;
    }

    public Message validate() {
        return null;
    }

    public Message validateExcludedAddress(IPAddress iPAddress) {
        return null;
    }

    String getTypeSpecificScheme() {
        return "DHCP Pool";
    }

    public String getName() {
        String string = this.getAlias();
        if (!string.equals("")) {
            return String.valueOf(this.getItemType()) + " " + string;
        }
        return "lsa1nic " + this.getNic();
    }

    public Enumeration getOneLineDescription() {
        Vector<String> vector = new Vector<String>();
        String string = this.getItemType();
        if (!this.getAlias().equals("")) {
            string = String.valueOf(string) + " " + this.getAlias();
        }
        string = String.valueOf(string) + "   ";
        string = String.valueOf(string) + TEXT_NETWORK_INTERFACE_LABEL + " " + this.getNic();
        vector.addElement(string);
        return vector.elements();
    }

    public String getItemType() {
        return TEXT_LSA1GROUP_NAME;
    }

    public LSA1Group getADuplicateLSA1Group(ConfigItem configItem, String string) {
        Enumeration enumeration = configItem.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.LSA1Group", false);
        while (enumeration.hasMoreElements()) {
            LSA1Group lSA1Group = (LSA1Group)enumeration.nextElement();
            if (lSA1Group == this || !string.equalsIgnoreCase(lSA1Group.getNic())) continue;
            return lSA1Group;
        }
        return null;
    }

    public Object itemClone() {
        LSA1Group lSA1Group = (LSA1Group)super.itemClone();
        return lSA1Group;
    }

    public BINLServerParameters getBINLServerParameters(ConfigItem configItem) {
        ConfigItem configItem2 = null;
        BINLServerParameters bINLServerParameters = null;
        configItem2 = configItem != null ? configItem : this.getParent();
        while (configItem2 != null) {
            if (configItem2 instanceof Configuration) {
                bINLServerParameters = ((Configuration)configItem2).getBINLServerParameters();
                break;
            }
            configItem2 = configItem2.getParent();
        }
        return bINLServerParameters;
    }
}

