/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.BINLServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItemWithExcludedAddresses;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.IPAddress;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.SupportsScopedKeywords;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.Parsing;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class LSA2Group
extends ConfigItemWithExcludedAddresses
implements SupportsScopedKeywords {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    public static final String TEXT_ILLEGAL_CHARS = DHCPServerGUI.getResourceString("TEXT_ILLEGAL_CHARS");
    public static final String ERROR_WRONG_SCOPE = DHCPServerGUI.getResourceString("ERROR_WRONG_SCOPE");
    public static final String ERROR_TOKENS_MISSING = DHCPServerGUI.getResourceString("ERROR_TOKENS_MISSING");
    public static final String TEXT_LSA2GROUP_NAME = DHCPServerGUI.getResourceString("TEXT_LSA2GROUP_NAME");
    public static final String TEXT_NETWORK_INTERFACE_LABEL = DHCPServerGUI.getResourceString("TEXT_NETWORK_INTERFACE_LABEL");
    public static final String TEXT_SYSTEM_ARCHITECTURE_LABEL = DHCPServerGUI.getResourceString("TEXT_SYSTEM_ARCHITECTURE_LABEL");
    public static final String KEYWORD_LSA2GROUP_SA = "sa";
    public static final String KEYWORD_LSA2GROUP_NIT = "nit";
    private String nit = String.valueOf(-1);
    private String sa = String.valueOf(-1);
    private boolean validLSA2Group = false;

    public static Object parse(ConfigItem configItem, String string) {
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        String string4 = null;
        LSA2Group lSA2Group = new LSA2Group();
        if (!lSA2Group.parentTypeIsValid(configItem)) {
            return new Message(ConfigItem.ERROR_WRONG_SCOPE);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() < 1) {
            return new Message(ERROR_TOKENS_MISSING);
        }
        if (string.startsWith(KEYWORD_LSA2GROUP_SA)) {
            string4 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            Message message = lSA2Group.setSa(string3);
            if (message != null) {
                return message;
            }
            if (stringTokenizer.nextToken().equalsIgnoreCase(KEYWORD_LSA2GROUP_NIT)) {
                bl = true;
                string2 = stringTokenizer.nextToken();
                message = lSA2Group.setNit(string2);
                if (message != null) {
                    return message;
                }
            }
        } else if (string.startsWith(KEYWORD_LSA2GROUP_NIT)) {
            bl = true;
            string4 = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            Message message = lSA2Group.setNit(string2);
            if (message != null) {
                return message;
            }
        }
        String string5 = bl ? Parsing.getAllAfter(string, "nit " + string2) : Parsing.getAllAfter(string, "sa " + string3);
        if (string5 != null && (string5 = string5.trim()).length() > 0) {
            lSA2Group.setAlias(ConfigItem.breakOutAlias(string5));
            if (lSA2Group.getAlias() == null) {
                return new Message(TEXT_ILLEGAL_CHARS);
            }
        }
        lSA2Group.commit(configItem);
        return lSA2Group;
    }

    public String toString() {
        boolean bl;
        String string = null;
        String string2 = null;
        string = this.getSa();
        string2 = this.getNit();
        StringBuffer stringBuffer = new StringBuffer("");
        if (!string.equals("-1")) {
            stringBuffer.append("sa " + string + " ");
        }
        if (!string2.equals("-1")) {
            stringBuffer.append("nit " + string2);
        }
        boolean bl2 = bl = !this.getAlias().equals("");
        if (bl) {
            stringBuffer.append(" (");
            if (bl) {
                stringBuffer.append("alias=" + this.getAliasWithQuotes());
            }
        }
        return stringBuffer.toString();
    }

    public Message setNit(String string) {
        this.nit = string;
        return null;
    }

    public Message setSa(String string) {
        this.sa = string;
        return null;
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem instanceof BINLGlobal;
    }

    public String getNit() {
        return this.nit;
    }

    public int getNitAsInt() {
        Integer n = Integer.valueOf(this.nit);
        return n;
    }

    public String getSa() {
        return this.sa;
    }

    public int getSaAsInt() {
        Integer n = Integer.valueOf(this.sa);
        return n;
    }

    public Message validate() {
        return null;
    }

    public Message validateExcludedAddress(IPAddress iPAddress) {
        return null;
    }

    public LSA2Group getADuplicateLSA2Group(ConfigItem configItem, String string, String string2) {
        Enumeration enumeration = configItem.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.LSA2Group", false);
        while (enumeration.hasMoreElements()) {
            LSA2Group lSA2Group = (LSA2Group)enumeration.nextElement();
            if (lSA2Group == this || !string.equalsIgnoreCase(lSA2Group.getNit()) || !string2.equalsIgnoreCase(lSA2Group.getSa())) continue;
            return lSA2Group;
        }
        return null;
    }

    String getTypeSpecificScheme() {
        return "DHCP Pool";
    }

    public String getName() {
        String string = this.getAlias();
        if (!string.equals("")) {
            return String.valueOf(this.getItemType()) + " " + string;
        }
        if (!this.getSa().equals("-1")) {
            if (!this.getNit().equals("-1")) {
                return "sa " + this.getSa() + " " + KEYWORD_LSA2GROUP_NIT + " " + this.getNit();
            }
            return "sa " + this.getSa();
        }
        if (!this.getNit().equals("-1")) {
            return "nit " + this.getNit();
        }
        return null;
    }

    public Enumeration getOneLineDescription() {
        Vector<String> vector = new Vector<String>();
        String string = this.getItemType();
        if (!this.getAlias().equals("")) {
            string = String.valueOf(string) + " " + this.getAlias();
        }
        string = String.valueOf(string) + "   ";
        if (this.getSaAsInt() != -1) {
            string = String.valueOf(string) + TEXT_SYSTEM_ARCHITECTURE_LABEL + " " + this.getSa();
            string = String.valueOf(string) + "   ";
        }
        if (this.getNitAsInt() != -1) {
            string = String.valueOf(string) + TEXT_NETWORK_INTERFACE_LABEL + " " + this.getNit();
        }
        vector.addElement(string);
        return vector.elements();
    }

    public String getItemType() {
        return TEXT_LSA2GROUP_NAME;
    }

    public Object itemClone() {
        LSA2Group lSA2Group = (LSA2Group)super.itemClone();
        return lSA2Group;
    }

    public BINLServerParameters getBINLServerParameters(ConfigItem configItem) {
        ConfigItem configItem2 = null;
        BINLServerParameters bINLServerParameters = null;
        configItem2 = configItem != null ? configItem : this.getParent();
        while (configItem2 != null) {
            if (configItem2 instanceof Configuration) {
                bINLServerParameters = ((Configuration)configItem2).getBINLServerParameters();
                break;
            }
            configItem2 = configItem2.getParent();
        }
        return bINLServerParameters;
    }
}

