/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.TimeInterval;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.BoundedInteger;
import java.text.MessageFormat;
import java.util.StringTokenizer;

public class Lease {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_INVALID_UNIT_TYPE = DHCPServerGUI.getResourceString("ERROR_INVALID_UNIT_TYPE");
    private static final String ERROR_LEASE_INVALID = DHCPServerGUI.getResourceString("ERROR_LEASE_INVALID");
    private static final String ERROR_LEASE_VALUE_REQUIRED = DHCPServerGUI.getResourceString("ERROR_LEASE_VALUE_REQUIRED");
    private TimeInterval leaseExpireInterval;
    private TimeInterval leaseTimeDefault;
    private TimeInterval pingTime;
    private TimeInterval reservedTime;
    private TimeInterval usedIpAddressExpireInterval;
    private BoundedInteger statisticSnapshotInterval;
    static final String KEYWORD_LEASE_EXPIRE_INTERVAL = "leaseExpireInterval";
    static final String KEYWORD_LEASE_TIME_DEFAULT = "leaseTimeDefault";
    static final String KEYWORD_PING_TIME = "pingTime";
    static final String KEYWORD_RESERVED_TIME = "reservedTime";
    static final String KEYWORD_USED_IP_ADDRESS_EXPIRE_INTERVAL = "usedIPAddressExpireInterval";
    static final String KEYWORD_STATISTIC_SNAPSHOT_INTERVAL = "statisticSnapshot";
    static final int LEASE_MIN_VALUE = 180;
    static final String LEASE_MIN_UNIT = TimeInterval.SECONDS;
    static final int LEASE_MAX_VALUE = -1;
    static final String LEASE_MAX_UNIT = null;
    public static final int PING_TIME_MIN_VALUE = 1;
    public static final int PING_TIME_MAX_VALUE = 30;

    public Lease() {
        this.initialize();
    }

    void initialize() {
        this.leaseExpireInterval = new TimeInterval(15, TimeInterval.SECONDS, 12, TimeInterval.HOURS);
        this.leaseExpireInterval.setDefault(1, TimeInterval.MINUTES);
        this.leaseTimeDefault = new TimeInterval(180, LEASE_MIN_UNIT, -1, null);
        this.leaseTimeDefault.setDefault(24, TimeInterval.HOURS);
        this.pingTime = new TimeInterval(1, TimeInterval.SECONDS, 30, TimeInterval.SECONDS);
        this.pingTime.setDefault(1, TimeInterval.SECONDS);
        this.reservedTime = new TimeInterval(30, TimeInterval.SECONDS, -1, null);
        this.reservedTime.setDefault(5, TimeInterval.MINUTES);
        this.usedIpAddressExpireInterval = new TimeInterval(30, TimeInterval.SECONDS, -1, null);
        this.usedIpAddressExpireInterval.setDefault(1000, TimeInterval.SECONDS);
        this.statisticSnapshotInterval = new BoundedInteger();
        this.statisticSnapshotInterval.setRange(1, Integer.MAX_VALUE);
        this.statisticSnapshotInterval.setDefault(1);
    }

    public static Message validateLeaseValue(String string) {
        Message message = TimeInterval.isValidInteger(string);
        if (message != null) {
            return message;
        }
        int n = Integer.parseInt(string);
        if (n >= 180 || n == -1) {
            return null;
        }
        Object[] objectArray = new Object[]{new String(string)};
        return new Message(MessageFormat.format(ERROR_LEASE_INVALID, objectArray));
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.getLeaseExpireInterval();
        if (string2 != null) {
            string = TimeInterval.unitsToEnglish(this.getLeaseExpireIntervalUnits());
            if (string == null) {
                string = new String("");
            }
            stringBuffer.append("\nleaseExpireInterval " + string2 + " " + string);
        }
        if ((string2 = this.getLeaseTimeDefault()) != null) {
            string = TimeInterval.unitsToEnglish(this.getLeaseTimeDefaultUnits());
            if (string == null) {
                string = new String("");
            }
            stringBuffer.append("\nleaseTimeDefault " + string2 + " " + string);
        }
        if ((string2 = this.getPingTime()) != null) {
            string = TimeInterval.unitsToEnglish(this.getPingTimeUnits());
            if (string == null) {
                string = new String("");
            }
            stringBuffer.append("\npingTime " + string2 + " " + string);
        }
        if ((string2 = this.getReservedTime()) != null) {
            string = TimeInterval.unitsToEnglish(this.getReservedTimeUnits());
            if (string == null) {
                string = new String("");
            }
            stringBuffer.append("\nreservedTime " + string2 + " " + string);
        }
        if ((string2 = this.getUsedIpAddressExpireInterval()) != null) {
            string = TimeInterval.unitsToEnglish(this.getUsedIpAddressExpireIntervalUnits());
            if (string == null) {
                string = new String("");
            }
            stringBuffer.append("\nusedIPAddressExpireInterval " + string2 + " " + string);
        }
        if (!(string2 = this.getStatisticSnapshotInterval()).equals("")) {
            stringBuffer.append("\nstatisticSnapshot " + string2);
        }
        return stringBuffer.toString();
    }

    public Message setLeaseExpireInterval(String string, String string2) {
        return this.leaseExpireInterval.setTimeIntervalNonNormalized(string, string2);
    }

    public String getLeaseExpireInterval() {
        return this.leaseExpireInterval.getNonNormalizedValue();
    }

    public String getLeaseExpireIntervalUnits() {
        return this.leaseExpireInterval.getNonNormalizedUnits();
    }

    public Message setStatisticSnapshotInterval(String string) {
        return this.statisticSnapshotInterval.setValue(string);
    }

    public String getStatisticSnapshotInterval() {
        return this.statisticSnapshotInterval.getValue();
    }

    public Message setLeaseTimeDefault(String string, String string2) {
        return this.leaseTimeDefault.setTimeIntervalNonNormalized(string, string2);
    }

    public String getLeaseTimeDefault() {
        return this.leaseTimeDefault.getNonNormalizedValue();
    }

    public String getLeaseTimeDefaultUnits() {
        return this.leaseTimeDefault.getNonNormalizedUnits();
    }

    public Message setPingTime(String string, String string2) {
        return this.pingTime.setTimeIntervalNonNormalized(string, string2);
    }

    public String getPingTime() {
        return this.pingTime.getNonNormalizedValue();
    }

    public String getPingTimeUnits() {
        return this.pingTime.getNonNormalizedUnits();
    }

    public Message setReservedTime(String string, String string2) {
        return this.reservedTime.setTimeIntervalNonNormalized(string, string2);
    }

    public String getReservedTime() {
        return this.reservedTime.getNonNormalizedValue();
    }

    public String getReservedTimeUnits() {
        return this.reservedTime.getNonNormalizedUnits();
    }

    public Message setUsedIpAddressExpireInterval(String string, String string2) {
        return this.usedIpAddressExpireInterval.setTimeIntervalNonNormalized(string, string2);
    }

    public String getUsedIpAddressExpireInterval() {
        return this.usedIpAddressExpireInterval.getNonNormalizedValue();
    }

    public String getUsedIpAddressExpireIntervalUnits() {
        return this.usedIpAddressExpireInterval.getNonNormalizedUnits();
    }

    public Message setParameter(String string, String string2) {
        String string3;
        String string4;
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        if (stringTokenizer.hasMoreElements()) {
            string4 = (String)stringTokenizer.nextElement();
            string3 = stringTokenizer.hasMoreElements() ? TimeInterval.englishToNlsUnits((String)stringTokenizer.nextElement()) : TimeInterval.MINUTES;
        } else {
            Object[] objectArray = new Object[]{new String(string)};
            return new Message(MessageFormat.format(ERROR_LEASE_VALUE_REQUIRED, objectArray));
        }
        if (string3 == null) {
            Object[] objectArray = new Object[]{string2};
            return new Message(MessageFormat.format(ERROR_INVALID_UNIT_TYPE, objectArray));
        }
        if (stringTokenizer.hasMoreElements()) {
            return new Message("Illegal characters at the end of the line");
        }
        if ((string = string.trim()).equalsIgnoreCase(KEYWORD_RESERVED_TIME)) {
            return this.setReservedTime(string4, string3);
        }
        if (string.equalsIgnoreCase(KEYWORD_LEASE_TIME_DEFAULT)) {
            return this.setLeaseTimeDefault(string4, string3);
        }
        if (string.equalsIgnoreCase(KEYWORD_LEASE_EXPIRE_INTERVAL)) {
            return this.setLeaseExpireInterval(string4, string3);
        }
        if (string.equalsIgnoreCase(KEYWORD_USED_IP_ADDRESS_EXPIRE_INTERVAL)) {
            return this.setUsedIpAddressExpireInterval(string4, string3);
        }
        if (string.equalsIgnoreCase(KEYWORD_PING_TIME)) {
            return this.setPingTime(string4, string3);
        }
        if (string.equalsIgnoreCase(KEYWORD_STATISTIC_SNAPSHOT_INTERVAL)) {
            return this.setStatisticSnapshotInterval(string4);
        }
        throw new IllegalArgumentException();
    }
}

