/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.DisplayableNamesEnumeration;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.util.Enumeration;
import java.util.Observable;
import java.util.StringTokenizer;
import java.util.Vector;

public class OptionSkeleton
extends Observable
implements Cloneable {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    public static final int maxOptionTagValue = 255;
    public static final String FORMAT_BOOLEAN = "Boolean";
    public static final String FORMAT_TIME = "Time";
    public static final String FORMAT_TIME_SHORT = "Time short";
    public static final String FORMAT_INTEGER_LIST = "Integer list";
    public static final String FORMAT_INTEGER = "Integer";
    public static final String FORMAT_IP_ADDRESS = "IP address";
    public static final String FORMAT_IP_ADDRESS_LIST = "IP addresses";
    public static final String FORMAT_IP_PAIR_ADDRESS_LIST = "IP address pairs";
    public static final String FORMAT_STRING = "String";
    public static final String FORMAT_DISABLED_FIELD = "Disabled field";
    public static final String FORMAT_CHOICE = "Choice";
    public static final String FORMAT_MASK = "Mask in either Integer or IP address format";
    public static final String FORMAT_BROADCAST = "Broadcast IP address";
    public static final String FORMAT_IP_PAIR_WITH_MASK = "IP address pairs with mask";
    public static final String FORMAT_MULTICAST_IP_ADDRESS = "Multicast IP address";
    static final String TEXT_STRING = "String";
    public static final String FORMAT_DISCOVERY_CONTROL = "Discovery Control";
    public static final String FORMAT_BOOTSERVERS = "Boot Servers";
    public static final String FORMAT_BOOTMENU = "Boot Menu";
    public static final String FORMAT_MENUPROMPT = "Menu Prompt";
    private static final String MINIMUM = "Minimum";
    private static final String MAXIMUM = "Maximum";
    private String tag;
    private String briefDescription;
    private String longDescription;
    private String datatype;
    private String userType;
    private String displayLabel;
    private boolean RFC_architected;
    private Integer dataMinimum = new Integer(0);
    private Integer dataMaximum = new Integer(Integer.MAX_VALUE);
    private Vector choiceNames;
    private Vector choiceValues;

    protected OptionSkeleton(String string, String string2, String string3, String string4, String string5, String string6) {
        this.create(string, string2, string3, string4, string5);
        this.userType = string6;
        this.RFC_architected = true;
    }

    protected OptionSkeleton(String string, String string2, String string3, String string4, String string5) {
        this.create(string, string2, string3, string4, string5);
        this.userType = string4;
        this.RFC_architected = false;
    }

    private void create(String string, String string2, String string3, String string4, String string5) {
        this.tag = string;
        this.briefDescription = string2;
        this.longDescription = string3;
        this.setDatatype(string4);
        this.setDataLabel(string5);
    }

    private void parseIntegerConstraints() {
        String string = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this.datatype, "$");
        this.datatype = stringTokenizer.nextToken().trim();
        while (stringTokenizer.hasMoreTokens()) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "=");
            string = stringTokenizer2.nextToken().trim();
            String string2 = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken().trim() : null;
            if (string == null) break;
            try {
                if (string.equals(MINIMUM)) {
                    this.dataMinimum = Integer.valueOf(string2);
                    continue;
                }
                if (!string.equals(MAXIMUM)) continue;
                this.dataMaximum = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ShouldNotOccurException("The data " + string + " in the .pii file is not an integer");
            }
        }
    }

    private Vector initVector(Vector vector) {
        if (vector == null) {
            vector = new Vector();
        } else {
            vector.removeAllElements();
        }
        return vector;
    }

    public String getTag() {
        return this.tag;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public String getDisplayableDatatype() {
        if (this.isRFC_architected()) {
            return this.userType;
        }
        return this.getDatatype();
    }

    public String getBriefDescription() {
        return this.briefDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public Vector getChoiceValues() {
        return (Vector)this.choiceValues.clone();
    }

    public Enumeration getLabelSet() {
        return this.choiceNames.elements();
    }

    public Enumeration getDisplayableValues() {
        return new DisplayableNamesEnumeration(this.choiceNames, this.choiceValues, this);
    }

    public Integer getDataMinimum() {
        return this.dataMinimum;
    }

    public Integer getDataMaximum() {
        return this.dataMaximum;
    }

    public String getDataLabel() {
        return this.displayLabel;
    }

    public String getFileValue(String string) {
        int n = 0;
        Enumeration enumeration = this.getDisplayableValues();
        while (enumeration.hasMoreElements()) {
            if (string.equals((String)enumeration.nextElement())) {
                if (this.choiceValues == null) {
                    throw new ShouldNotOccurException("OptionSkeleton getFileValue():   No file value for selected panel value.");
                }
                if (this.choiceValues.size() <= n) {
                    return string;
                }
                return (String)this.choiceValues.elementAt(n);
            }
            ++n;
        }
        return string;
    }

    public String getDisplayableValue(String string) {
        if (this.choiceValues == null) {
            return string;
        }
        int n = this.choiceValues.indexOf(string);
        if (n == -1) {
            return string;
        }
        if (this.choiceNames == null) {
            throw new ShouldNotOccurException("OptionSkeleton getDisplayableValue():   No displayable value for selected file value.");
        }
        if (this.choiceNames.size() <= n) {
            return string;
        }
        if (this.isRFC_architected() && this.getDatatype().equals(FORMAT_CHOICE)) {
            return (String)this.choiceNames.elementAt(n);
        }
        return String.valueOf((String)this.choiceNames.elementAt(n)) + " (" + this.choiceValues.elementAt(n) + ")";
    }

    public boolean isRFC_architected() {
        return this.RFC_architected;
    }

    private void setTag(String string) {
        this.tag = string;
    }

    public void setLongDescription(String string) {
        this.longDescription = string;
        this.setChanged();
    }

    public void setBriefDescription(String string) {
        this.briefDescription = string;
        this.setChanged();
    }

    public void setDatatype(String string) {
        this.datatype = string;
        if (string != null && string.indexOf("$") >= 0) {
            this.parseType();
        } else {
            this.choiceValues = null;
        }
        this.setChanged();
    }

    protected String getDatatypeWithValues() {
        StringBuffer stringBuffer = new StringBuffer(this.getDatatype());
        if (this.choiceValues != null) {
            Enumeration enumeration = this.choiceValues.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(" $ " + (String)enumeration.nextElement());
            }
        }
        return stringBuffer.toString();
    }

    private void parseType() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.datatype, "$");
        if (this.datatype.indexOf(FORMAT_INTEGER) >= 0) {
            this.parseIntegerConstraints();
            return;
        }
        this.datatype = stringTokenizer.nextToken().trim();
        this.choiceValues = this.initVector(this.choiceValues);
        while (stringTokenizer.hasMoreTokens()) {
            this.choiceValues.addElement(stringTokenizer.nextToken().trim());
        }
    }

    public void setDataLabel(String string) {
        this.displayLabel = string;
        if (this.displayLabel != null && this.displayLabel.indexOf("$") >= 0) {
            this.parseLabel();
        } else {
            this.choiceNames = null;
        }
        this.setChanged();
    }

    private void parseLabel() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.displayLabel, "$");
        this.choiceNames = this.initVector(this.choiceNames);
        while (stringTokenizer.hasMoreTokens()) {
            this.choiceNames.addElement(stringTokenizer.nextToken().trim());
        }
    }

    public String toString() {
        return this.briefDescription;
    }

    public Object clone() {
        try {
            OptionSkeleton optionSkeleton = (OptionSkeleton)super.clone();
            if (this.choiceNames != null) {
                optionSkeleton.choiceNames = (Vector)this.choiceNames.clone();
            }
            if (this.choiceValues != null) {
                optionSkeleton.choiceValues = (Vector)this.choiceValues.clone();
            }
            return optionSkeleton;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ShouldNotOccurException();
        }
    }
}

