/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.ddnssgui.common.TcpipLocale;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.OptionSkeleton;
import COM.ibm.raleigh.dhcpsgui.biz.UserDefinedOptionsSkeletonFile;
import COM.ibm.raleigh.dhcpsgui.io.DHCPFile;
import COM.ibm.raleigh.dhcpsgui.io.NetworkHandler;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.EnumerationSorter;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import COM.ibm.raleigh.utilExt.SortedHashtable;
import java.util.Enumeration;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.Vector;

public class OptionSkeletonManager {
    private static String etcDir;
    private static SortedHashtable tableOfOptionSkeletons;
    private static UserDefinedOptionsSkeletonFile userDefinedOptionSkeletonsFile;
    private static Observer observer;
    private static TcpipLocale thisLocale;
    private static ResourceBundle thisBundle;
    private static final String bundleName = "COM.ibm.raleigh.dhcpsgui.resource.DHCPOptionResources";
    private static final String ERROR_DUPLICATE;
    private static int[] reservedTags;
    private static SortedHashtable unusedOptions;
    private static SortedHashtable usedOptions;
    private static EnumerationSorter alphaSet;
    private static boolean initialized;
    private static Vector backupTable;
    private static Vector deleteList;

    public static void initialize(NetworkHandler networkHandler, String string, boolean bl) {
        if (!initialized) {
            OptionSkeletonManager.createTable();
            userDefinedOptionSkeletonsFile = new UserDefinedOptionsSkeletonFile(String.valueOf(string) + DHCPServerGUI.theFileSeparator + "dhcpext.cfg", bl, networkHandler);
            OptionSkeletonManager.loadUserDefinedOptions();
            initialized = true;
        }
    }

    public static void initialize(NetworkHandler networkHandler, String string, DHCPFile dHCPFile) {
        if (!initialized) {
            OptionSkeletonManager.createTable();
            userDefinedOptionSkeletonsFile = new UserDefinedOptionsSkeletonFile(String.valueOf(string) + DHCPServerGUI.theFileSeparator + "dhcpext.cfg", dHCPFile, networkHandler);
            OptionSkeletonManager.loadUserDefinedOptions();
            initialized = true;
        }
    }

    public static void terminate() {
        OptionSkeletonManager.saveUserDefinedSkeletons();
    }

    private static void createTable() {
        tableOfOptionSkeletons = new SortedHashtable(300);
        int n = 1;
        while (n < 255) {
            String string = OptionSkeletonManager.getResourceString("OPT" + n + "T");
            if (string.trim().length() > 0) {
                String string2 = OptionSkeletonManager.getResourceString("OPT" + n + "F");
                if (string2.equals("Boolean")) {
                    string2 = "Boolean $ 1 $ 0";
                }
                OptionSkeletonManager.createSkeleton(string, OptionSkeletonManager.getResourceString("OPT" + n + "S"), OptionSkeletonManager.getResourceString("OPT" + n + "D"), string2, OptionSkeletonManager.getResourceString("OPT" + n + "L"), OptionSkeletonManager.getResourceString("OPT" + n + "U"));
                ++n;
                continue;
            }
            try {
                n = Integer.parseInt(OptionSkeletonManager.getResourceString("OPT" + n + "N"));
            }
            catch (NumberFormatException numberFormatException) {
                throw new ShouldNotOccurException("The value of OPT" + n + "N" + " is invalid.  It must be an integer");
            }
        }
    }

    private static void loadUserDefinedOptions() {
        if (userDefinedOptionSkeletonsFile.openForRead()) {
            String string;
            while ((string = userDefinedOptionSkeletonsFile.readAttribute()) != null) {
                OptionSkeletonManager.createSkeleton(string, userDefinedOptionSkeletonsFile.readAttribute(), userDefinedOptionSkeletonsFile.readAttribute(), userDefinedOptionSkeletonsFile.readAttribute(), userDefinedOptionSkeletonsFile.readAttribute());
            }
            userDefinedOptionSkeletonsFile.close();
        }
    }

    private static Message createSkeleton(String string, String string2, String string3, String string4, String string5, String string6) {
        OptionSkeleton optionSkeleton = new OptionSkeleton(string, string2, string3, string4, string5, string6);
        return OptionSkeletonManager.addOptionSkeleton(optionSkeleton);
    }

    public static Message createSkeleton(String string, String string2, String string3, String string4, String string5) {
        OptionSkeleton optionSkeleton = new OptionSkeleton(string, string2, string3, string4, string5);
        Message message = OptionSkeletonManager.addOptionSkeleton(optionSkeleton);
        if (message == null && observer != null) {
            optionSkeleton.addObserver(observer);
            optionSkeleton.notifyObservers();
        }
        return message;
    }

    public static void addObserver(OptionSkeleton optionSkeleton) {
        optionSkeleton.addObserver(observer);
    }

    private static void saveUserDefinedSkeletons() {
        if (userDefinedOptionSkeletonsFile.openForWrite()) {
            Enumeration enumeration = OptionSkeletonManager.getSkeletons();
            while (enumeration.hasMoreElements()) {
                OptionSkeleton optionSkeleton = (OptionSkeleton)enumeration.nextElement();
                if (optionSkeleton.isRFC_architected()) continue;
                String string = optionSkeleton.getTag();
                userDefinedOptionSkeletonsFile.writeAttribute(String.valueOf(string) + "T", optionSkeleton.getTag());
                userDefinedOptionSkeletonsFile.writeAttribute(String.valueOf(string) + "S", optionSkeleton.getBriefDescription());
                userDefinedOptionSkeletonsFile.writeAttribute(String.valueOf(string) + "D", optionSkeleton.getLongDescription());
                userDefinedOptionSkeletonsFile.writeAttribute(String.valueOf(string) + "F", optionSkeleton.getDatatypeWithValues());
                userDefinedOptionSkeletonsFile.writeAttribute(String.valueOf(string) + "L", optionSkeleton.getDataLabel());
            }
            userDefinedOptionSkeletonsFile.close();
        }
    }

    private static String getResourceString(String string) {
        if (thisBundle == null && (thisBundle = ResourceBundle.getBundle(bundleName, TcpipLocale.getLocale())) == null) {
            throw new ShouldNotOccurException("The resource bundle for this locale cannot be found");
        }
        try {
            return thisBundle.getString(string);
        }
        catch (Exception exception) {
            System.err.println("OpSkel - getResourceString() for string " + string + " -- exception is <" + exception + ">");
            throw new ShouldNotOccurException();
        }
    }

    private static Message addOptionSkeleton(OptionSkeleton optionSkeleton) {
        String string = optionSkeleton.getTag();
        if (OptionSkeletonManager.isDefined(string)) {
            return new Message(ERROR_DUPLICATE);
        }
        tableOfOptionSkeletons.put(string, optionSkeleton);
        OptionSkeletonManager.sortUsed();
        alphaSet = null;
        return null;
    }

    public static void deleteOptionSkeleton(OptionSkeleton optionSkeleton) {
        String string = optionSkeleton.getTag();
        OptionSkeleton optionSkeleton2 = (OptionSkeleton)tableOfOptionSkeletons.remove(string);
        optionSkeleton2.notifyObservers();
        OptionSkeletonManager.sortUsed();
        alphaSet = null;
    }

    public static Enumeration getOptionSkeletonsByTag() {
        return tableOfOptionSkeletons.elements();
    }

    public static Enumeration getOptionSkeletonsByAlphabet() {
        if (alphaSet == null) {
            alphaSet = new EnumerationSorter(tableOfOptionSkeletons.elements());
        }
        return alphaSet.elements();
    }

    public static Enumeration getUsedOptionSkeletons() {
        OptionSkeletonManager.sortUsed();
        return usedOptions.elements();
    }

    public static Enumeration getUnusedOptionSkeletons() {
        OptionSkeletonManager.sortUsed();
        return unusedOptions.elements();
    }

    public static void setOptionSkeletonUsed(String string) {
        OptionSkeleton optionSkeleton = OptionSkeletonManager.getOptionSkeleton(string);
        unusedOptions.remove(string);
        usedOptions.put(string, optionSkeleton);
        optionSkeleton.notifyObservers();
    }

    public static void sortUsed() {
        usedOptions = new SortedHashtable();
        unusedOptions = new SortedHashtable();
        Enumeration enumeration = tableOfOptionSkeletons.keys();
        SortedHashtable sortedHashtable = Configuration.currentConfiguration.getUsedOptions();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            OptionSkeleton optionSkeleton = (OptionSkeleton)tableOfOptionSkeletons.get(string);
            if (sortedHashtable.containsKey(string)) {
                usedOptions.put(string, optionSkeleton);
                continue;
            }
            unusedOptions.put(string, optionSkeleton);
        }
    }

    public static void setObserver(Observer observer) {
        OptionSkeletonManager.observer = observer;
    }

    public static OptionSkeleton getOptionSkeleton(String string) {
        return (OptionSkeleton)tableOfOptionSkeletons.get(string);
    }

    private static boolean isDefined(String string) {
        int n = Integer.parseInt(string);
        int n2 = 0;
        while (n2 < reservedTags.length) {
            if (reservedTags[n2] == n) {
                return true;
            }
            ++n2;
        }
        return tableOfOptionSkeletons.containsKey(string);
    }

    public static String getBriefDescription(String string) {
        OptionSkeleton optionSkeleton = OptionSkeletonManager.getOptionSkeleton(string);
        if (optionSkeleton == null) {
            return null;
        }
        return optionSkeleton.getBriefDescription();
    }

    public static String getLongDescription(String string) {
        OptionSkeleton optionSkeleton = OptionSkeletonManager.getOptionSkeleton(string);
        if (optionSkeleton == null) {
            return null;
        }
        return optionSkeleton.getLongDescription();
    }

    public static Vector getChoiceValues(String string) {
        OptionSkeleton optionSkeleton = OptionSkeletonManager.getOptionSkeleton(string);
        if (optionSkeleton == null) {
            return null;
        }
        return optionSkeleton.getChoiceValues();
    }

    public static String getDisplayableDatatype(String string) {
        OptionSkeleton optionSkeleton = OptionSkeletonManager.getOptionSkeleton(string);
        if (optionSkeleton == null) {
            return null;
        }
        return optionSkeleton.getDisplayableDatatype();
    }

    public static Integer getDataMinimum(String string) {
        OptionSkeleton optionSkeleton = OptionSkeletonManager.getOptionSkeleton(string);
        if (optionSkeleton == null) {
            return null;
        }
        return optionSkeleton.getDataMinimum();
    }

    public static Integer getDataMaximum(String string) {
        OptionSkeleton optionSkeleton = OptionSkeletonManager.getOptionSkeleton(string);
        if (optionSkeleton == null) {
            return null;
        }
        return optionSkeleton.getDataMaximum();
    }

    public static Enumeration getSkeletons() {
        return tableOfOptionSkeletons.elements();
    }

    public static void backupSkeletons() {
        backupTable.removeAllElements();
        Enumeration enumeration = OptionSkeletonManager.getSkeletons();
        while (enumeration.hasMoreElements()) {
            OptionSkeleton optionSkeleton = (OptionSkeleton)enumeration.nextElement();
            if (optionSkeleton.isRFC_architected()) continue;
            backupTable.addElement(optionSkeleton.clone());
        }
    }

    public static void restoreSkeletons() {
        OptionSkeleton optionSkeleton;
        deleteList.removeAllElements();
        Enumeration enumeration = OptionSkeletonManager.getSkeletons();
        while (enumeration.hasMoreElements()) {
            optionSkeleton = (OptionSkeleton)enumeration.nextElement();
            if (optionSkeleton.isRFC_architected()) continue;
            deleteList.addElement(optionSkeleton);
        }
        Enumeration enumeration2 = deleteList.elements();
        while (enumeration2.hasMoreElements()) {
            tableOfOptionSkeletons.remove(((OptionSkeleton)enumeration2.nextElement()).getTag());
        }
        Enumeration enumeration3 = backupTable.elements();
        while (enumeration3.hasMoreElements()) {
            optionSkeleton = (OptionSkeleton)enumeration3.nextElement();
            tableOfOptionSkeletons.put(optionSkeleton.getTag(), optionSkeleton);
        }
        OptionSkeletonManager.sortUsed();
        alphaSet = null;
    }

    static {
        observer = null;
        thisLocale = DHCPServerGUI.getDHCPLocale();
        ERROR_DUPLICATE = DHCPServerGUI.getResourceString("ERROR_DUPLICATE");
        int[] nArray = new int[10];
        nArray[1] = 52;
        nArray[2] = 53;
        nArray[3] = 54;
        nArray[4] = 55;
        nArray[5] = 56;
        nArray[6] = 57;
        nArray[7] = 60;
        nArray[8] = 81;
        nArray[9] = 255;
        reservedTags = nArray;
        backupTable = new Vector(20);
        deleteList = new Vector(20);
    }
}

