/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.AddressRange;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItemWithExcludedAddresses;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.DHCPClass;
import COM.ibm.raleigh.dhcpsgui.biz.DomainOrAddress;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.IPAddress;
import COM.ibm.raleigh.dhcpsgui.biz.IPSubnetAddress;
import COM.ibm.raleigh.dhcpsgui.biz.IPSubnetMask;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.SubnetGroup;
import COM.ibm.raleigh.dhcpsgui.biz.SupportsLeaseDuration;
import COM.ibm.raleigh.dhcpsgui.biz.SupportsScopedKeywords;
import COM.ibm.raleigh.dhcpsgui.biz.UnlistedClient;
import COM.ibm.raleigh.dhcpsgui.biz.Validatable;
import COM.ibm.raleigh.dhcpsgui.notebook.ClientSupportPanelUser;
import COM.ibm.raleigh.dhcpsgui.notebook.InheritedUnlistedClientPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.Parsing;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class Subnetwork
extends ConfigItemWithExcludedAddresses
implements SupportsScopedKeywords,
SupportsLeaseDuration,
ClientSupportPanelUser,
Validatable {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_SUBNET_ADDRESS_NOT_IN_VALID_CLASS = DHCPServerGUI.getResourceString("ERROR_SUBNET_ADDRESS_NOT_IN_VALID_CLASS");
    private static final String ERROR_SUBNET_ADDRESS_REQUIRED_TO_GENERATE_MASK = DHCPServerGUI.getResourceString("ERROR_SUBNET_ADDRESS_REQUIRED_TO_GENERATE_MASK");
    private static final String ERROR_GENERATED_SUBNET_MASK = DHCPServerGUI.getResourceString("ERROR_GENERATED_SUBNET_MASK");
    private static final String ERROR_TOKENS_MISSING = DHCPServerGUI.getResourceString("ERROR_TOKENS_MISSING");
    private static final String ERROR_RANGE_MISSING = DHCPServerGUI.getResourceString("ERROR_RANGE_MISSING");
    private static final String ERROR_RANGE_NOT_DEFINED = DHCPServerGUI.getResourceString("ERROR_RANGE_NOT_DEFINED");
    private static final String ERROR_NO_SUBNET_DEFINITION = DHCPServerGUI.getResourceString("ERROR_NO_SUBNET_DEFINITION");
    private static final String ERROR_SUBNET_NOT_VALID = DHCPServerGUI.getResourceString("ERROR_SUBNET_NOT_VALID");
    private static final String ERROR_ADDRESS_NOT_IN_SUBNET = DHCPServerGUI.getResourceString("ERROR_ADDRESS_NOT_IN_SUBNET");
    private static final String TEXT_SUBNET_ADDR = DHCPServerGUI.getResourceString("TEXT_SUBNET_ADDR");
    private static final String TEXT_SUBNET_MASK = DHCPServerGUI.getResourceString("TEXT_SUBNET_MASK");
    private static final String TEXT_RANGE = DHCPServerGUI.getResourceString("TEXT_RANGE");
    private static final String TEXT_ADDRESSES = DHCPServerGUI.getResourceString("TEXT_ADDRESSES");
    private static final String TEXT_NAME_SUBNET = DHCPServerGUI.getResourceString("TEXT_NAME_SUBNET");
    private static final String DDNS_PTR_KEYWORD = "DDNSServer=";
    public static final String KEYWORD_SUBNET = "subnet";
    private AddressRange pool;
    private DomainOrAddress primaryDDNSServer;
    protected int priority;
    private UnlistedClient unlistedClient;

    public Subnetwork() {
        this.address = new IPSubnetAddress();
        this.mask = new IPSubnetMask();
        this.validsubnet = false;
        this.pool = new AddressRange();
        this.primaryDDNSServer = new DomainOrAddress();
        this.unlistedClient = new UnlistedClient();
    }

    public static Object parse(ConfigItem configItem, String string) {
        String string2 = null;
        String string3 = null;
        Subnetwork subnetwork = new Subnetwork();
        if (!subnetwork.parentTypeIsValid(configItem)) {
            return new Message(ConfigItem.ERROR_WRONG_SCOPE);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() < 2) {
            return new Message(ERROR_TOKENS_MISSING);
        }
        Message message = subnetwork.setAddress(stringTokenizer.nextToken());
        if (message != null) {
            return message;
        }
        string3 = stringTokenizer.nextToken();
        if (string3.indexOf("-") < 0) {
            message = subnetwork.setSubnetMask(string3);
            if (message != null && !message.getText().equals(ERROR_GENERATED_SUBNET_MASK)) {
                return message;
            }
            if (message != null) {
                subnetwork.addMessage(message);
            }
            string2 = null;
        } else {
            message = subnetwork.setSubnetMask(null);
            if (message != null && !message.getText().equals(ERROR_GENERATED_SUBNET_MASK)) {
                return message;
            }
            if (message != null) {
                subnetwork.addMessage(message);
            }
            string2 = string3;
        }
        message = subnetwork.validateSubnet();
        if (message != null) {
            return message;
        }
        if (string2 == null) {
            string2 = stringTokenizer.nextToken();
        }
        if (string2.length() > 0 && string2.indexOf("-") > 0) {
            message = subnetwork.setPoolRange(string2);
            if (message != null) {
                return message;
            }
        } else {
            return new Message(ERROR_RANGE_MISSING);
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = string2;
            if (string.indexOf("(") == -1) {
                String string4 = Parsing.getAllAfter(string, string3);
                if (string4 != null && (message = SubnetGroup.parse(string4, subnetwork, configItem)) != null) {
                    return message;
                }
            } else {
                String string5 = Parsing.getAllBetween(string, string3, "(");
                if (string5 != null && (message = SubnetGroup.parse(string5, subnetwork, configItem)) != null) {
                    return message;
                }
                string3 = Parsing.getAllAfter(string, "(");
                if (string3 != null && string3.trim().length() > 0) {
                    String string6;
                    String string7 = Parsing.getAllBetween(string3, "alias=", DDNS_PTR_KEYWORD);
                    if (string7 == null) {
                        string7 = Parsing.getAllAfter(string3, "alias=");
                    }
                    if (string7 != null && string7.trim().length() > 0) {
                        message = subnetwork.setAlias(string7);
                    }
                    if ((string6 = Parsing.getAllAfter(string3, DDNS_PTR_KEYWORD)) != null && string6.trim().length() > 0 && (message = subnetwork.setDDNSServer(string6)) != null) {
                        return message;
                    }
                }
            }
        }
        if (subnetwork.getParent() == null) {
            if (subnetwork.commit(configItem)) {
                return subnetwork;
            }
            return new Message(ConfigItem.ERROR_WRONG_SCOPE);
        }
        return subnetwork;
    }

    public String toString() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer("subnet ");
        stringBuffer.append(this.getAddress());
        if (this.getSubnetMask() != null) {
            stringBuffer.append(" " + this.getSubnetMask());
        }
        stringBuffer.append(" " + this.getPoolRange());
        if (this.getParent() instanceof SubnetGroup) {
            stringBuffer.append(((SubnetGroup)this.getParent()).toString(this));
        }
        boolean bl2 = !this.getAlias().equals("");
        boolean bl3 = bl = this.primaryDDNSServer.get() != null;
        if (bl || bl2) {
            stringBuffer.append(" (");
            if (bl2) {
                stringBuffer.append("alias=" + this.getAliasWithQuotes());
            }
            if (bl) {
                stringBuffer.append(" DDNSServer=" + this.primaryDDNSServer.get());
            }
        }
        return stringBuffer.toString();
    }

    public Message setAddress(String string) {
        return this.address.setAddress(string);
    }

    public String getAddress() {
        return this.address.getIPAddress();
    }

    public final IPSubnetAddress getAddressObject() {
        return this.address;
    }

    public Message setSubnetMask(String string) {
        if (string == null || string.trim().length() == 0) {
            if (this.address != null && this.address.isValid()) {
                String string2 = IPSubnetMask.generateClassMask(this.getAddress());
                this.mask.setMask(string2);
                if (string2 != null) {
                    String string3 = IPSubnetAddress.truncateAddressToMaskLength(this.getAddress(), string2);
                    this.setAddress(string3);
                    return new Message(ERROR_GENERATED_SUBNET_MASK);
                }
                return new Message(ERROR_SUBNET_ADDRESS_NOT_IN_VALID_CLASS);
            }
            return new Message(ERROR_SUBNET_ADDRESS_REQUIRED_TO_GENERATE_MASK);
        }
        return this.mask.setMask(string.trim());
    }

    public Message validateSubnet() {
        Message message = IPSubnetMask.isValidMaskForAddress(this.address.getAddress(), this.mask.getAddress());
        if (message == null) {
            this.validsubnet = true;
            this.pool.setSubnetDefinition(this.address, this.mask);
        } else {
            this.pool.invalidateSubnetDefinition();
            this.validsubnet = false;
        }
        return message;
    }

    public String getSubnetMask() {
        return this.mask.getMask();
    }

    public IPSubnetMask getMaskObject() {
        return this.mask;
    }

    public boolean isValidSubnet() {
        return this.validsubnet;
    }

    public Message setPoolRange(String string) {
        if (this.validsubnet) {
            return this.pool.setAddressRange(string);
        }
        return new Message(ERROR_NO_SUBNET_DEFINITION);
    }

    public String getPoolRange() {
        return this.pool.getAddressRange();
    }

    public final AddressRange getPoolRangeObject() {
        return this.pool;
    }

    public boolean isPoolRangeValid() {
        return this.pool.isValidRange();
    }

    public Message setPoolRangeStart(String string) {
        if (this.validsubnet) {
            return this.pool.setAddressRangeStart(string);
        }
        return new Message(ERROR_NO_SUBNET_DEFINITION);
    }

    public String getPoolRangeStart() {
        return this.pool.getAddressRangeStart();
    }

    public Message setPoolRangeEnd(String string) {
        if (this.validsubnet) {
            return this.pool.setAddressRangeEnd(string);
        }
        return new Message(ERROR_NO_SUBNET_DEFINITION);
    }

    public String getPoolRangeEnd() {
        return this.pool.getAddressRangeEnd();
    }

    public Message validatePool() {
        if (this.validsubnet) {
            return this.pool.validateAddressRange();
        }
        return new Message(ERROR_NO_SUBNET_DEFINITION);
    }

    public Message validateExcludedAddress(IPAddress iPAddress) {
        return this.validateAddressIsInPool(iPAddress);
    }

    public Message validateAddressIsInSubnet(IPAddress iPAddress) {
        if (this.validsubnet) {
            return this.checkMembership(iPAddress);
        }
        return new Message(ERROR_SUBNET_NOT_VALID);
    }

    public Message validateAddressIsInPool(IPAddress iPAddress) {
        if (this.pool.isValidRange()) {
            return this.pool.isInTheRange(iPAddress);
        }
        return new Message(ERROR_RANGE_NOT_DEFINED);
    }

    public String getDDNSServer() {
        return this.primaryDDNSServer.get();
    }

    public Message setDDNSServer(String string) {
        return this.primaryDDNSServer.set(string);
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem instanceof Global || configItem instanceof SubnetGroup;
    }

    String getTypeSpecificScheme() {
        return "DHCP Pool";
    }

    public String getName() {
        String string = this.getAlias();
        if (!string.equals("")) {
            return String.valueOf(this.getItemType()) + " " + string;
        }
        return String.valueOf(this.getItemType()) + " " + this.getAddress();
    }

    public Enumeration getOneLineDescription() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(String.valueOf(this.getItemType()) + " " + this.getAlias());
        vector.addElement(String.valueOf(TEXT_SUBNET_ADDR) + " " + this.getAddress());
        vector.addElement(String.valueOf(TEXT_SUBNET_MASK) + " " + this.getSubnetMask());
        if (this.getPoolRange() != null) {
            vector.addElement(String.valueOf(TEXT_RANGE) + " " + this.getPoolRange());
            vector.addElement(String.valueOf(this.pool.getSize()) + " " + TEXT_ADDRESSES);
        }
        return vector.elements();
    }

    public String getItemType() {
        return TEXT_NAME_SUBNET;
    }

    public Object itemClone() {
        Subnetwork subnetwork = (Subnetwork)super.itemClone();
        subnetwork.pool = (AddressRange)this.pool.clone();
        subnetwork.primaryDDNSServer = (DomainOrAddress)this.primaryDDNSServer.clone();
        return subnetwork;
    }

    private Message checkMembership(IPAddress iPAddress) {
        if (this.validsubnet) {
            int n = iPAddress.getIntegerAddress();
            int n2 = this.address.getIntegerAddress();
            int n3 = this.mask.getIntegerAddress();
            if ((n & n3) != n2) {
                return new Message(ERROR_ADDRESS_NOT_IN_SUBNET);
            }
            return null;
        }
        return new Message(ERROR_SUBNET_NOT_VALID);
    }

    public Message validateAllExcludedAddresses() {
        Enumeration enumeration = this.getExcludedAddresses();
        while (enumeration.hasMoreElements()) {
            IPAddress iPAddress = (IPAddress)enumeration.nextElement();
            Message message = this.validateExcludedAddress(iPAddress);
            if (message == null) continue;
            return message;
        }
        return null;
    }

    public Message validate() {
        Message message = new Message();
        Enumeration enumeration = this.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.DHCPClass", false);
        while (enumeration.hasMoreElements()) {
            message.concat(((DHCPClass)enumeration.nextElement()).validate());
        }
        if (message.isEmpty()) {
            return null;
        }
        return message;
    }

    public void parseUnlistedClientSupport(String string, String string2) {
        this.unlistedClient.parseValue(string, string2);
    }

    public int getUnlistedClientSupportType() {
        return this.unlistedClient.getUnlistedClientSupportType();
    }

    public void setUnlistedClientSupportType(int n) {
        this.unlistedClient.setUnlistedClientSupportType(n);
    }

    public boolean isUnlistedInherited() {
        return this.unlistedClient.isInherited();
    }

    public void setUnlistedInherited(boolean bl) {
        this.unlistedClient.setInherited(bl);
    }

    public int getInheritedClientSupportType(ConfigItem configItem) {
        return this.getServerParameters(configItem).getUnlistedClientSupportType();
    }

    public String getInheritedClientSupportLocation(ConfigItem configItem) {
        return new String(InheritedUnlistedClientPanel.TEXT_DHCP_SERVER);
    }

    protected void writeScopedItems(Stack stack, StringBuffer stringBuffer) {
        if (!this.isUnlistedInherited()) {
            stringBuffer.append("\n" + stack.peek() + this.unlistedClient.toString());
        }
        super.writeScopedItems(stack, stringBuffer);
    }

    public ServerParameters getServerParameters(ConfigItem configItem) {
        ConfigItem configItem2 = null;
        ServerParameters serverParameters = null;
        configItem2 = configItem != null ? configItem : this.getParent();
        while (configItem2 != null) {
            if (configItem2 instanceof Configuration) {
                serverParameters = ((Configuration)configItem2).getServerParameters();
                break;
            }
            configItem2 = configItem2.getParent();
        }
        return serverParameters;
    }
}

