/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.text.MessageFormat;

public class TimeInterval {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    public static final String ERROR_NOT_AN_INTEGER = DHCPServerGUI.getResourceString("ERROR_NOT_AN_INTEGER");
    public static final String ERROR_INTEGER_OVERFLOW = DHCPServerGUI.getResourceString("ERROR_INTEGER_OVERFLOW");
    public static final String ERROR_OUT_OF_RANGE = DHCPServerGUI.getResourceString("ERROR_OUT_OF_RANGE");
    public static final String ERROR_INVALID_UNIT_TYPE = DHCPServerGUI.getResourceString("ERROR_INVALID_UNIT_TYPE");
    public static final String INFINITY = "-1";
    public static final int INT_INFINITY = -1;
    public static final String SECONDS = DHCPServerGUI.getResourceString("TEXT_SECONDS");
    public static final String MINUTES = DHCPServerGUI.getResourceString("TEXT_MINUTES");
    public static final String HOURS = DHCPServerGUI.getResourceString("TEXT_HOURS");
    public static final String DAYS = DHCPServerGUI.getResourceString("TEXT_DAYS");
    public static final String MONTHS = DHCPServerGUI.getResourceString("TEXT_MONTHS");
    public static final String YEARS = DHCPServerGUI.getResourceString("TEXT_YEARS");
    private static final String ENGLISH_SECONDS = "Seconds";
    private static final String ENGLISH_MINUTES = "Minutes";
    private static final String ENGLISH_HOURS = "Hours";
    private static final String ENGLISH_DAYS = "Days";
    private static final String ENGLISH_MONTHS = "Months";
    private static final String ENGLISH_YEARS = "Years";
    private int years;
    private int months;
    private int days;
    private int hours;
    private int minutes;
    private int seconds;
    private static final int[] CONVERTER = new int[]{12, 30, 24, 60, 60};
    private static final String MAX_INT_YEARS = "69";
    private static final String MAX_INT_MONTHS = "9999220";
    private static final String MAX_INT_DAYS = "12899814";
    private static final String MAX_INT_HOURS = "12526987";
    private static final String MAX_INT_MINUTES = "35791394";
    private static final int INT_YEARS = 69;
    private static final int INT_MONTHS = 9999220;
    private static final int INT_DAYS = 12899814;
    private static final int INT_HOURS = 12526987;
    private static final int INT_MINUTES = 0x2222222;
    private int minimumValueInSeconds;
    private int maximumValueInSeconds;
    int minVal;
    String minUnits;
    int maxVal;
    String maxUnits;
    private int defaultVal;
    private String defaultUnits;
    private boolean useDefault = false;
    private int nonNormalizedValue;
    private String nonNormalizedUnits;
    private boolean hasValue;

    public TimeInterval() {
    }

    public TimeInterval(int n, String string, int n2, String string2) {
        this();
        this.minimumValueInSeconds = TimeInterval.getTotalSecondsFromUnits(n, string);
        this.maximumValueInSeconds = TimeInterval.getTotalSecondsFromUnits(n2, string2);
        this.minVal = n;
        this.minUnits = string;
        this.maxVal = n2;
        this.maxUnits = string2;
        this.hasValue = false;
    }

    public Message setTimeInterval(String string) {
        Message message = TimeInterval.isValidInteger(string);
        if (message != null) {
            return message;
        }
        this.timeFromSeconds(Integer.parseInt(string));
        return null;
    }

    public static Message isValidInteger(String string) {
        if (TcpipValidation.IsLessThanMaxIntegerValue((String)string)) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                Object[] objectArray = new Object[]{string};
                return new Message(MessageFormat.format(ERROR_NOT_AN_INTEGER, objectArray));
            }
        } else {
            Object[] objectArray = new Object[]{new Integer(Integer.MAX_VALUE)};
            return new Message(MessageFormat.format(ERROR_INTEGER_OVERFLOW, objectArray));
        }
        return null;
    }

    public Message setDefault(int n, String string) {
        Message message = null;
        message = this.setTimeIntervalNonNormalized(Integer.toString(n), string);
        if (message == null) {
            this.defaultVal = n;
            this.defaultUnits = string;
            this.useDefault = true;
        }
        return message;
    }

    public Message setTimeIntervalNonNormalized(String string, String string2) {
        if ((string = string.trim()) == null || string.length() == 0) {
            if (this.useDefault) {
                return this.setTimeIntervalNonNormalized(Integer.toString(this.defaultVal), this.defaultUnits);
            }
            this.hasValue = false;
            return null;
        }
        Message message = TimeInterval.isValidInteger(string);
        if (message != null) {
            return message;
        }
        int n = Integer.parseInt(string);
        if (n != -1 && (message = TimeInterval.validateUnits(string2 = string2.trim())) != null) {
            return message;
        }
        int n2 = TimeInterval.getTotalSecondsFromUnits(n, string2);
        if (n2 >= this.minimumValueInSeconds && n2 <= this.maximumValueInSeconds) {
            this.hasValue = true;
            this.nonNormalizedValue = n;
            if (this.nonNormalizedValue != -1) {
                this.nonNormalizedUnits = string2;
            }
        } else {
            String string3;
            String string4;
            String string5;
            String string6;
            if (this.maxVal == -1) {
                string6 = Integer.toString(Integer.MAX_VALUE);
                string5 = YEARS;
            } else {
                string6 = Integer.toString(this.maxVal);
                string5 = this.maxUnits;
            }
            if (string2.equals(YEARS)) {
                if (this.maxVal > 69 || this.maxVal == -1) {
                    string6 = MAX_INT_YEARS;
                }
            } else if (string2.equals(MONTHS)) {
                if (this.maxVal > 9999220 || this.maxVal == -1) {
                    string6 = MAX_INT_MONTHS;
                }
                string5 = string2;
            } else if (string2.equals(DAYS)) {
                if (this.maxVal > 12899814 || this.maxVal == -1) {
                    string6 = MAX_INT_DAYS;
                }
                string5 = string2;
            } else if (string2.equals(HOURS)) {
                if (this.maxVal > 12526987 || this.maxVal == -1) {
                    string6 = MAX_INT_HOURS;
                }
                string5 = string2;
            } else if (string2.equals(MINUTES)) {
                if (this.maxVal > 0x2222222 || this.maxVal == -1) {
                    string6 = MAX_INT_MINUTES;
                }
                string5 = string2;
            } else if (string2.equals(SECONDS)) {
                string5 = this.maxUnits != null ? this.maxUnits : string2;
            }
            if (n == -1) {
                string4 = Integer.toString(Integer.MAX_VALUE);
                string3 = YEARS;
            } else {
                string4 = string;
                string3 = string2;
            }
            Object[] objectArray = new Object[]{string4, string3, Integer.toString(this.minVal), this.minUnits, string6, string5};
            return new Message(MessageFormat.format(ERROR_OUT_OF_RANGE, objectArray));
        }
        return null;
    }

    private static final Message validateUnits(String string) {
        if (string.equals(SECONDS) || string.equals(MINUTES) || string.equals(HOURS) || string.equals(DAYS) || string.equals(MONTHS) || string.equals(YEARS)) {
            return null;
        }
        Object[] objectArray = new Object[]{string};
        return new Message(MessageFormat.format(ERROR_INVALID_UNIT_TYPE, objectArray));
    }

    public String getNonNormalizedValue() {
        if (!this.hasValue) {
            return null;
        }
        return Integer.toString(this.nonNormalizedValue);
    }

    public String getNonNormalizedUnits() {
        if (!this.hasValue || this.nonNormalizedValue == -1) {
            return "";
        }
        return this.nonNormalizedUnits;
    }

    public Message setTimeInterval(int[] nArray) {
        this.years = nArray[0];
        this.months = nArray[1];
        this.days = nArray[2];
        this.hours = nArray[3];
        this.minutes = nArray[4];
        this.seconds = nArray[5];
        return null;
    }

    private void timeFromSeconds(int n) {
        int n2 = n;
        this.years = n2 / 31104000;
        this.months = (n2 -= this.years * 31104000) / 2592000;
        this.days = (n2 -= this.months * 2592000) / 86400;
        this.hours = (n2 -= this.days * 86400) / 3600;
        this.minutes = (n2 -= this.hours * 3600) / 60;
        this.seconds = n2 - this.minutes * 60;
    }

    public int[] getTimeInterval() {
        int[] nArray = new int[]{this.years, this.months, this.days, this.hours, this.minutes, this.seconds};
        return nArray;
    }

    public int getTotalSeconds() {
        return TimeInterval.getTotalSecondsFromArray(this.getTimeInterval());
    }

    private static int getTotalSecondsFromArray(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2;
            while (n3 < CONVERTER.length) {
                int n4 = n2;
                nArray[n4] = nArray[n4] * CONVERTER[n3];
                ++n3;
            }
            n += nArray[n2];
            ++n2;
        }
        return n;
    }

    private static final int getTotalSecondsFromUnits(int n, String string) {
        if (n == -1) {
            return Integer.MAX_VALUE;
        }
        int[] nArray = new int[6];
        if (string.equals(YEARS)) {
            nArray[0] = n;
        } else if (string.equals(MONTHS)) {
            nArray[1] = n;
        } else if (string.equals(DAYS)) {
            nArray[2] = n;
        } else if (string.equals(HOURS)) {
            nArray[3] = n;
        } else if (string.equals(MINUTES)) {
            nArray[4] = n;
        } else if (string.equals(SECONDS)) {
            nArray[5] = n;
        } else {
            throw new ShouldNotOccurException();
        }
        return TimeInterval.getTotalSecondsFromArray(nArray);
    }

    protected static final String englishToNlsUnits(String string) {
        if (TimeInterval.unitMatches(string, ENGLISH_SECONDS)) {
            return SECONDS;
        }
        if (TimeInterval.unitMatches(string, ENGLISH_MINUTES)) {
            return MINUTES;
        }
        if (TimeInterval.unitMatches(string, ENGLISH_HOURS)) {
            return HOURS;
        }
        if (TimeInterval.unitMatches(string, ENGLISH_DAYS)) {
            return DAYS;
        }
        if (TimeInterval.unitMatches(string, ENGLISH_MONTHS)) {
            return MONTHS;
        }
        if (TimeInterval.unitMatches(string, ENGLISH_YEARS)) {
            return YEARS;
        }
        return null;
    }

    private static final boolean unitMatches(String string, String string2) {
        return string.equalsIgnoreCase(string2) || (String.valueOf(string) + "s").equalsIgnoreCase(string2);
    }

    public static final String unitsToEnglish(String string) {
        if (string == SECONDS) {
            return ENGLISH_SECONDS;
        }
        if (string == MINUTES) {
            return ENGLISH_MINUTES;
        }
        if (string == HOURS) {
            return ENGLISH_HOURS;
        }
        if (string == DAYS) {
            return ENGLISH_DAYS;
        }
        if (string == MONTHS) {
            return ENGLISH_MONTHS;
        }
        if (string == YEARS) {
            return ENGLISH_YEARS;
        }
        return null;
    }
}

