/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.io.DHCPFile;
import COM.ibm.raleigh.dhcpsgui.io.DHCPLocalFile;
import COM.ibm.raleigh.dhcpsgui.io.DHCPRemoteFile;
import COM.ibm.raleigh.dhcpsgui.io.IOUser;
import COM.ibm.raleigh.dhcpsgui.io.NetworkHandler;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;

class UserDefinedOptionsSkeletonFile {
    private DHCPFile file;
    private String filename;
    private String line;
    private static final String PREFIX = "<OPT";
    private static final String SEPARATOR = ">";

    protected UserDefinedOptionsSkeletonFile(String string, boolean bl, NetworkHandler networkHandler) {
        this.filename = string;
        if (bl) {
            this.file = new DHCPRemoteFile(networkHandler);
            return;
        }
        this.file = new DHCPLocalFile();
    }

    protected UserDefinedOptionsSkeletonFile(String string, DHCPFile dHCPFile, NetworkHandler networkHandler) {
        this.filename = string;
        this.file = dHCPFile;
    }

    protected boolean openForRead() {
        if (this.file.exists(this.filename)) {
            if (this.file.open(this.filename, "Read")) {
                Object object = this.file.readLine();
                if (object instanceof String) {
                    this.line = (String)object;
                }
                return true;
            }
            throw new ShouldNotOccurException(String.valueOf(this.filename) + " exists but cannot be opened for READ" + " " + IOUser.TEXT_MESSAGE_READ_FILE_CANNOT_BE_OPENED);
        }
        return false;
    }

    protected void close() {
        this.file.close();
    }

    protected boolean openForWrite() {
        if (!this.file.create(this.filename, "Write")) {
            throw new ShouldNotOccurException(String.valueOf(this.filename) + " cannot be created");
        }
        if (!this.file.open(this.filename, "Write")) {
            throw new ShouldNotOccurException(String.valueOf(this.filename) + " exists but cannot be opened for WRITE" + " " + IOUser.TEXT_MESSAGE_READ_FILE_CANNOT_BE_OPENED);
        }
        return true;
    }

    protected void writeAttribute(String string, String string2) {
        this.file.writeLine(PREFIX + string + SEPARATOR + string2);
    }

    protected String readAttribute() {
        CharSequence charSequence;
        String string = null;
        if (this.line != null) {
            charSequence = new StringBuffer(this.line);
            Object object = this.file.readLine();
            this.line = object instanceof String ? (String)object : null;
            while (this.line != null && !this.line.startsWith(PREFIX)) {
                ((StringBuffer)charSequence).append("\n");
                ((StringBuffer)charSequence).append(this.line);
            }
            string = ((StringBuffer)charSequence).toString();
        }
        if (string != null) {
            int n = string.indexOf(SEPARATOR);
            charSequence = n != -1 ? string.substring(n + 1) : "";
            return charSequence;
        }
        return null;
    }
}

