/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.HexString;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.Parsing;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class Vendor
extends ConfigItem {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    public static final String TEXT_VENDOR = DHCPServerGUI.getResourceString("TEXT_VENDOR");
    public static final String ERROR_DUPLICATE_NAME = DHCPServerGUI.getResourceString("ERROR_DUPLICATE_NAME");
    public static final String ERROR_VENDOR_NAME_INCORRECT = DHCPServerGUI.getResourceString("ERROR_VENDOR_NAME_INCORRECT");
    public static final String ERROR_KEYWORD_NOT_VALID = DHCPServerGUI.getResourceString("ERROR_KEYWORD_NOT_VALID");
    public static final String KEYWORD_VENDOR = "vendor";
    private String localName = "";
    private boolean encapsulatedFormat = true;
    private HexString hexstring = new HexString();

    public static Object parse(ConfigItem configItem, String string) {
        String string2;
        String string3;
        Vendor vendor = new Vendor();
        StringTokenizer stringTokenizer = new StringTokenizer(string = String.valueOf(string.trim()) + " ", " ");
        if (stringTokenizer.countTokens() == 0) {
            return new Message(ERROR_VENDOR_NAME_INCORRECT);
        }
        if (string.charAt(0) == '\"') {
            string3 = Parsing.getAllBetween(string, "\"", "\"");
            string2 = Parsing.getAllAfter(string, String.valueOf(string3) + "\"");
        } else {
            string3 = stringTokenizer.nextToken();
            string2 = Parsing.getAllAfter(string, string3);
        }
        Message message = vendor.setName(string3);
        if (message != null) {
            return message;
        }
        if (Vendor.getADuplicateVendor(configItem, vendor) != null) {
            Object[] objectArray = new Object[]{KEYWORD_VENDOR};
            return new Message(MessageFormat.format(ERROR_DUPLICATE_NAME, objectArray));
        }
        if (string2 != null && string2.trim().length() != 0) {
            message = vendor.setHexStringAndValidate(string2, true);
            if (message != null) {
                return message;
            }
            vendor.setEncapsulatedFormat(false);
        } else {
            vendor.setEncapsulatedFormat(true);
        }
        if (vendor.commit(configItem)) {
            return vendor;
        }
        return new Message(ConfigItem.ERROR_WRONG_SCOPE);
    }

    public Message setName(String string) {
        if (string == null || string.trim().length() < 1 || string.trim().length() > 255) {
            return new Message(ERROR_VENDOR_NAME_INCORRECT);
        }
        String string2 = string.trim();
        int n = 0;
        int n2 = string2.length();
        if (string2.charAt(0) == '\"') {
            ++n;
        }
        if (string2.charAt(n2 - 1) == '\"') {
            --n2;
        }
        this.localName = string.substring(n, n2);
        return null;
    }

    public String getVendorName() {
        return this.localName;
    }

    public Vendor getADuplicateVendor(ConfigItem configItem) {
        return Vendor.getADuplicateVendor(configItem, this);
    }

    private static Vendor getADuplicateVendor(ConfigItem configItem, Vendor vendor) {
        Enumeration enumeration = configItem.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.Vendor", false);
        while (enumeration.hasMoreElements()) {
            Vendor vendor2 = (Vendor)enumeration.nextElement();
            if (vendor2 == vendor || !vendor.getVendorName().equalsIgnoreCase(vendor2.getVendorName())) continue;
            return vendor2;
        }
        return null;
    }

    public void setEncapsulatedFormat(boolean bl) {
        this.encapsulatedFormat = bl;
    }

    public boolean isEncapsulatedFormat() {
        return this.encapsulatedFormat;
    }

    public Message setHexStringAndValidate(String string, boolean bl) {
        return this.hexstring.setHexStringAndValidate(string, bl);
    }

    public String getHexString() {
        return this.hexstring.getHexString();
    }

    public String getName() {
        return String.valueOf(this.getItemType()) + " " + this.localName;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        ServerParameters serverParameters = Configuration.currentConfiguration.getServerParameters();
        if (serverParameters.getServerType().getValue().equalsIgnoreCase("dhcp") && this.localName.equalsIgnoreCase("PXEClient")) {
            stringBuffer.append('#');
        }
        if (this.localName.trim().indexOf(" ") > 0) {
            stringBuffer.append("vendor \"" + this.localName + "\"");
        } else {
            stringBuffer.append("vendor " + this.localName);
        }
        if (!this.encapsulatedFormat) {
            stringBuffer.append(" hex\"" + this.getHexString() + "\"");
        }
        return stringBuffer.toString();
    }

    protected void writeScopedItems(Stack stack, StringBuffer stringBuffer) {
        if (this.encapsulatedFormat) {
            super.writeScopedItems(stack, stringBuffer);
        }
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem instanceof Global;
    }

    protected String getTypeSpecificScheme() {
        return "DHCP Vendor";
    }

    public Enumeration getOneLineDescription() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.getName());
        return vector.elements();
    }

    public String getItemType() {
        return TEXT_VENDOR;
    }

    public Object clone() {
        Vendor vendor = (Vendor)super.clone();
        vendor.hexstring = (HexString)this.hexstring.clone();
        return vendor;
    }
}

