/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.biz;

import COM.ibm.raleigh.dhcpsgui.biz.CommonOption;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Vendor;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.util.Enumeration;
import java.util.Vector;

public class VendorOption
extends CommonOption {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_VENDOR_OPTION = DHCPServerGUI.getResourceString("TEXT_VENDOR_OPTION");
    private static final String ERROR_VENDOR_TAG_MISSING = DHCPServerGUI.getResourceString("ERROR_VENDOR_TAG_MISSING");
    private static final String ERROR_VENDOR_VALUE_MISSING = DHCPServerGUI.getResourceString("ERROR_VENDOR_VALUE_MISSING");
    private static final String ERROR_VENDOR_VALUE_TOO_LONG = DHCPServerGUI.getResourceString("ERROR_VENDOR_VALUE_TOO_LONG");
    Vector schemeVector = new Vector();

    public VendorOption() {
        this.schemeVector.addElement("DHCP Vendor Options");
    }

    public Message setTag(String string, ConfigItem configItem) {
        if (string == null || string.length() == 0) {
            return new Message(ERROR_VENDOR_TAG_MISSING);
        }
        String string2 = string.trim();
        Message message = CommonOption.isValidTag(string2);
        if (message == null) {
            this.tag = string2;
        }
        return message;
    }

    public static Object parse(ConfigItem configItem, String string) {
        return CommonOption.commonParse(new VendorOption(), configItem, string);
    }

    public String toString() {
        if (this.tag == null) {
            return "";
        }
        if (this.hexformat) {
            String string = this.hexstring.toString();
            if (string != null) {
                return "option " + this.getTag() + " " + string;
            }
        } else if (this.value != null) {
            if (this.value.trim().indexOf(" ") > 0) {
                return "option " + this.getTag() + " \"" + this.getValue() + "\"";
            }
            return "option " + this.getTag() + " " + this.getValue();
        }
        return "";
    }

    public String getName() {
        return String.valueOf(this.getItemType()) + " " + this.tag;
    }

    public String getItemType() {
        return TEXT_VENDOR_OPTION;
    }

    public boolean parentTypeIsValid(ConfigItem configItem) {
        return configItem instanceof Vendor;
    }

    public Vector getNodeScheme() {
        return this.schemeVector;
    }

    public String getTypeSpecificScheme() {
        return "DHCP Vendor Options";
    }

    public boolean meetsCriteria(ConfigItem configItem) {
        return configItem instanceof VendorOption;
    }

    public Enumeration getOneLineDescription() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(String.valueOf(this.getItemType()) + " " + this.getTag());
        if (this.hexformat) {
            vector.addElement("  Value=" + this.hexstring.toString());
        } else {
            vector.addElement("  Value=" + this.getValue());
        }
        return vector.elements();
    }

    public Object clone() {
        VendorOption vendorOption = (VendorOption)super.clone();
        return vendorOption;
    }
}

