/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.io;

import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.BINLServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.Client;
import COM.ibm.raleigh.dhcpsgui.biz.Comment;
import COM.ibm.raleigh.dhcpsgui.biz.CommonClient;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.LSA1Group;
import COM.ibm.raleigh.dhcpsgui.biz.LSA2Group;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Option;
import COM.ibm.raleigh.dhcpsgui.io.DHCPConfigFileManager;
import COM.ibm.raleigh.dhcpsgui.io.DHCPFile;
import COM.ibm.raleigh.dhcpsgui.io.ErrorReporter;
import COM.ibm.raleigh.dhcpsgui.io.IOUser;
import COM.ibm.raleigh.dhcpsgui.io.ShowAllErrors;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.awt.Frame;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class BINLTreeBuilder
implements ErrorReporter {
    public static final String s = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String ERROR_CFG_FILE_ERRORS = DHCPServerGUI.getResourceString("ERROR_CFG_FILE_ERRORS");
    private static final String ERROR_BOILERPLATE = DHCPServerGUI.getResourceString("ERROR_BOILERPLATE");
    private static final String ERROR_RECOVERY_QUIT = DHCPServerGUI.getResourceString("ERROR_RECOVERY_QUIT");
    private static final String ERROR_RECOVERY_DELETE_LINE = DHCPServerGUI.getResourceString("ERROR_RECOVERY_DELETE_LINE");
    private static final String ERROR_NOT_SCOPE = DHCPServerGUI.getResourceString("ERROR_NOT_SCOPE");
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    private static BINLTreeBuilder currentTreeBuilder = null;
    private static DHCPFile remoteFile = null;
    private Vector recoveryActions = new Vector();
    private IOUser user;
    private boolean resume = false;
    private boolean wildCard = false;
    private int lineNumber;
    private int linesDeleted;
    private String line;
    private String lastLine;
    Vector allTheErrors;
    Vector allTheWarnings;
    private Stack parentChain = new Stack();
    private ConfigItem lastObject;
    private BINLServerParameters serverParent;
    private ConfigItem globalParent;
    private ConfigItem commentParent;
    private ConfigItem commentHome = this.globalParent;
    private boolean keywordComment = false;
    private Comment tempComment;
    private ErrorReporter caller;

    public BINLTreeBuilder(DHCPFile dHCPFile) {
        remoteFile = dHCPFile;
        this.user = DHCPConfigFileManager.getManagerInstance();
    }

    public static BINLTreeBuilder getTreeBuilder(DHCPFile dHCPFile) {
        if (dHCPFile == null || dHCPFile != remoteFile) {
            currentTreeBuilder = new BINLTreeBuilder(dHCPFile);
        }
        BINLTreeBuilder.currentTreeBuilder.resume = false;
        return currentTreeBuilder;
    }

    public boolean resumeConfigTreeBuild() {
        this.resume = true;
        return this.doTreeBuild(this.serverParent, this.globalParent);
    }

    public boolean wereErrorsInFile() {
        return this.linesDeleted > 0;
    }

    public boolean buildConfigTree(BINLServerParameters bINLServerParameters, ConfigItem configItem) {
        this.allTheErrors = new Vector();
        this.allTheWarnings = new Vector();
        boolean bl = this.doTreeBuild(bINLServerParameters, configItem);
        while (!bl) {
            bl = this.resumeConfigTreeBuild();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private boolean doTreeBuild(BINLServerParameters var1_1, ConfigItem var2_2) {
        var5_3 = null;
        var6_4 = -1;
        this.globalParent = var2_2;
        this.serverParent = var1_1;
        if (!this.resume) {
            this.lineNumber = 0;
            this.linesDeleted = 0;
            this.tempComment = null;
            this.parentChain = new Stack<E>();
            this.parentChain.push(var2_2);
        }
        while ((this.line = this.getNextLine(BINLTreeBuilder.remoteFile)) != null) {
            block46: {
                block47: {
                    block45: {
                        this.line = this.line.trim();
                        while (this.line.length() > 0 && (var6_4 = this.line.lastIndexOf(92)) == this.line.length() - 1 && (var5_3 = this.getNextLine(BINLTreeBuilder.remoteFile)) != null) {
                            this.line = String.valueOf(this.line.substring(0, var6_4)) + var5_3;
                        }
                        var7_7 = new StringTokenizer(this.line, "\n \r\t");
                        if (this.line.length() == 0) {
                            if (this.tempComment == null) continue;
                            if (this.commentParent != null) {
                                if (this.commentParent.getParent() != null) {
                                    this.tempComment.commit(this.commentParent.getParent());
                                }
                            } else {
                                var8_8 = (ConfigItem)this.parentChain.peek();
                                var8_8.setComment(this.tempComment);
                            }
                            this.tempComment = null;
                            continue;
                        }
                        if (this.line.indexOf("##") == 0 || this.line.indexOf("#") >= 0 && (var8_9 = this.comment())) continue;
                        var8_10 = var7_7.nextToken();
                        var9_11 = this.line.substring(var8_10.length());
                        if (this.resume) {
                            this.resume = false;
                            if (var8_10.equals("{")) {
                                if (this.eatScopedLines(var8_10)) continue;
                                break;
                            }
                        }
                        if (!var8_10.equalsIgnoreCase("lsa1nic")) break block45;
                        var3_5 = LSA1Group.parse((ConfigItem)this.parentChain.peek(), var9_11);
                        var4_6 = this.processObjectCreation(var3_5, this.line);
                        if (!var4_6) {
                            return false;
                        }
                        break block46;
                    }
                    if (!var8_10.equalsIgnoreCase("sa") && !var8_10.equalsIgnoreCase("nit")) break block47;
                    var3_5 = LSA2Group.parse((ConfigItem)this.parentChain.peek(), String.valueOf(var8_10) + var9_11);
                    var4_6 = this.processObjectCreation(var3_5, this.line);
                    if (!var4_6) {
                        return false;
                    }
                    break block46;
                }
                if (!var8_10.equals("{")) ** GOTO lbl65
                if (this.lastObject != null && (this.lastObject instanceof LSA1Group || this.lastObject instanceof LSA2Group || this.lastObject instanceof Client)) {
                    this.parentChain.push(this.lastObject);
                    if (this.tempComment != null) {
                        this.lastObject.setComment(this.tempComment);
                        this.tempComment = null;
                    }
                    this.lastObject = null;
                } else {
                    this.postError(new Message(String.valueOf(BINLTreeBuilder.ERROR_NOT_SCOPE) + this.lastLine), this.line);
                    if (!this.eatScopedLines(var8_10)) break;
                    return false;
lbl65:
                    // 1 sources

                    if (var8_10.equals("}")) {
                        if (!this.parentChain.empty()) {
                            if (this.tempComment != null) {
                                ((ConfigItem)this.parentChain.peek()).setComment(this.tempComment);
                                this.tempComment = null;
                            }
                            this.commentParent = (ConfigItem)this.parentChain.pop();
                            if (this.parentChain.empty()) {
                                this.postError(new Message("A closing brace (\"}\") without an earlier open brace (\"{\") caused the remainder of the file to be ignored"), this.line);
                                break;
                            }
                        }
                        this.lastObject = null;
                    } else if (var8_10.equalsIgnoreCase("client")) {
                        var3_5 = CommonClient.parse((ConfigItem)this.parentChain.peek(), var9_11);
                        var4_6 = this.processObjectCreation(var3_5, this.line);
                        if (!var4_6) {
                            return false;
                        }
                    } else if (var8_10.equalsIgnoreCase("pxevendor")) {
                        if (this.tempComment != null) {
                            ((ConfigItem)this.parentChain.peek()).setComment(this.tempComment);
                            this.tempComment = null;
                        }
                        this.line = this.getNextLine(BINLTreeBuilder.remoteFile);
                        this.line = this.line.trim();
                        while (!this.line.equals("}")) {
                            if (this.line.length() == 0 || this.line.equals("{")) {
                                this.line = this.getNextLine(BINLTreeBuilder.remoteFile);
                                this.line = this.line.trim();
                                continue;
                            }
                            var8_10 = "pxeoption";
                            var3_5 = this.option(this.line.substring(var8_10.length()));
                            var4_6 = this.processObjectCreation(var3_5, this.line);
                            this.line = this.getNextLine(BINLTreeBuilder.remoteFile);
                            this.line = this.line.trim();
                        }
                    } else if (var8_10.equalsIgnoreCase("tftp")) {
                        var3_5 = ((ConfigItem)this.parentChain.peek()).setTFTPServer(var9_11);
                        var4_6 = this.processObjectCreation(var3_5, this.line);
                        if (!var4_6) {
                            return false;
                        }
                    } else if (var8_10.equalsIgnoreCase("bpname")) {
                        var3_5 = ((ConfigItem)this.parentChain.peek()).setBootImage(var9_11);
                        var4_6 = this.processObjectCreation(var3_5, this.line);
                        if (!var4_6) {
                            return false;
                        }
                    } else if (var8_10.equalsIgnoreCase("servername")) {
                        var3_5 = ((ConfigItem)this.parentChain.peek()).setComputerName(var9_11);
                        var4_6 = this.processObjectCreation(var3_5, this.line);
                        if (!var4_6) {
                            return false;
                        }
                    } else if (var8_10.equalsIgnoreCase("serverdomainname")) {
                        var3_5 = ((ConfigItem)this.parentChain.peek()).setComputerDomain(var9_11);
                        var4_6 = this.processObjectCreation(var3_5, this.line);
                        if (!var4_6) {
                            return false;
                        }
                    } else {
                        this.processServerParameters(var8_10);
                    }
                }
            }
            if (this.tempComment == null) continue;
            if (this.parentChain.peek() != null) {
                ((ConfigItem)this.parentChain.peek()).setComment(this.tempComment);
            }
            this.tempComment = null;
        }
        if (!this.parentChain.empty() && this.parentChain.peek() != var2_2) {
            this.postError(new Message("End of file reached without closing brace (\"}\") being found"), "");
        }
        if (this.tempComment != null) {
            ((ConfigItem)this.parentChain.peek()).setComment(this.tempComment);
            this.tempComment = null;
        }
        if (!this.allTheErrors.isEmpty() || !this.allTheWarnings.isEmpty()) {
            var7_7 = new ShowAllErrors(new Frame(), this.allTheErrors, this.allTheWarnings);
            var8_8 = var7_7.askUserWhatToDo();
            var7_7.dispose();
            this.takeErrorAction((String)var8_8);
            this.allTheErrors = new Vector<E>();
            this.allTheWarnings = new Vector<E>();
        } else if (this.user != null) {
            this.user.updateIOStatus(null, IOUser.TEXT_MESSAGE_READY, 5);
        }
        return true;
    }

    private boolean processServerParameters(String string) {
        boolean bl = false;
        Message message = this.serverParent.isKeyword(string);
        if (message != null) {
            this.postError(message, this.line);
            bl = false;
        } else if (!(this.parentChain.peek() instanceof BINLGlobal)) {
            this.postError(new Message(ConfigItem.ERROR_WRONG_SCOPE), this.line);
            bl = false;
        } else {
            Message message2 = this.serverParent.setParameter(this.line);
            boolean bl2 = this.processObjectCreation(message2, this.line);
            if (!bl2) {
                bl = false;
            }
        }
        return bl;
    }

    private boolean eatScopedLines(String string) {
        Stack<String> stack = new Stack<String>();
        stack.push(string);
        while ((this.line = this.getNextLine(remoteFile)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.line, "\n \r\t");
            if (!stringTokenizer.hasMoreTokens()) continue;
            string = stringTokenizer.nextToken();
            if (string.equals("{")) {
                stack.push(string);
                continue;
            }
            if (!string.equals("}")) continue;
            stack.pop();
            if (!stack.empty()) continue;
            return true;
        }
        return false;
    }

    private boolean comment() {
        int n = this.line.trim().indexOf(35);
        if (n == 0) {
            if (this.line.equals("#@@@WILD@@@")) {
                this.wildCard = true;
                return true;
            }
            if (this.tempComment != null) {
                this.tempComment.addLine(this.line);
            } else {
                this.tempComment = new Comment(this.line);
            }
            return true;
        }
        if (n > 0) {
            if (this.tempComment != null) {
                this.tempComment.addLine(this.line);
            } else {
                this.tempComment = new Comment(this.line);
            }
            this.line = this.line.substring(0, n);
            return false;
        }
        return false;
    }

    private Object option(String string) {
        if (this.parentChain.empty()) {
            throw new ShouldNotOccurException("TreeBuilder parsing error -- no scope for adding an option.  Stack empty");
        }
        return Option.parse((ConfigItem)this.parentChain.peek(), string);
    }

    public void takeErrorAction(String string) {
        if (string.equals(ERROR_RECOVERY_QUIT)) {
            this.user.updateIOStatus(null, IOUser.TEXT_MESSAGE_QUIT, 7);
            remoteFile.close();
            return;
        }
        ++this.linesDeleted;
        Object[] objectArray = new Object[]{new Integer(this.linesDeleted)};
        this.user.updateIOStatus(null, MessageFormat.format(IOUser.TEXT_MESSAGE_DELETE_LINE, objectArray), 6);
    }

    private boolean processObjectCreation(Object object, String string) {
        this.lastObject = null;
        if (object == null) {
            if (this.tempComment != null) {
                ((ConfigItem)this.parentChain.peek()).setComment(this.tempComment);
                this.tempComment = null;
            }
            return true;
        }
        if (object instanceof ConfigItem) {
            this.lastObject = (ConfigItem)object;
            this.commentParent = null;
            if (this.lastObject.hasMessages()) {
                Enumeration enumeration = this.lastObject.getMessages();
                while (enumeration.hasMoreElements()) {
                    this.postWarning((Message)enumeration.nextElement(), string);
                }
                this.lastObject.clearMessages();
            }
            if (this.tempComment != null) {
                this.lastObject.setComment(this.tempComment);
                this.tempComment = null;
            }
            return true;
        }
        if (object instanceof Message) {
            if (((Message)object).checkErrors()) {
                this.postError((Message)object, string);
            }
            if (((Message)object).checkWarnings()) {
                Enumeration enumeration = ((Message)object).extractWarnings();
                while (enumeration.hasMoreElements()) {
                    this.postWarning((String)enumeration.nextElement(), string);
                }
                ((Message)object).clearWarnings();
            }
            if (this.tempComment != null) {
                this.tempComment = null;
            }
            return false;
        }
        return false;
    }

    private void postError(Message message, String string) {
        Object[] objectArray = new Object[]{new Integer(this.lineNumber), string, message.getText()};
        this.allTheErrors.addElement(MessageFormat.format(DHCPServerGUI.getResourceString("TEXT_LineNumber_DISPLAY_ERROR"), objectArray));
    }

    private void postWarning(Message message, String string) {
        Object[] objectArray = new Object[]{new Integer(this.lineNumber), string, message.getText()};
        this.allTheWarnings.addElement(MessageFormat.format(DHCPServerGUI.getResourceString("TEXT_LineNumber_DISPLAY_WARNING"), objectArray));
    }

    private void postWarning(String string, String string2) {
        Object[] objectArray = new Object[]{new Integer(this.lineNumber), string2, string};
        this.allTheWarnings.addElement(MessageFormat.format(DHCPServerGUI.getResourceString("TEXT_LineNumber_DISPLAY_WARNING"), objectArray));
    }

    private String getNextLine(DHCPFile dHCPFile) {
        this.lastLine = this.line;
        Object object = dHCPFile.readLine();
        if (object instanceof Boolean) {
            return null;
        }
        ++this.lineNumber;
        return (String)object;
    }
}

