/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.io;

import COM.ibm.raleigh.dhcpsgui.biz.Client;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.ExcludedClient;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.SubnetValidator;
import COM.ibm.raleigh.dhcpsgui.io.BINLSampleFile;
import COM.ibm.raleigh.dhcpsgui.io.BusyWaitFrame;
import COM.ibm.raleigh.dhcpsgui.io.DHCPCommandServer;
import COM.ibm.raleigh.dhcpsgui.io.DHCPFile;
import COM.ibm.raleigh.dhcpsgui.io.DHCPParameterSet;
import COM.ibm.raleigh.dhcpsgui.io.DHCPRemoteFile;
import COM.ibm.raleigh.dhcpsgui.io.DHCPSampleFile;
import COM.ibm.raleigh.dhcpsgui.io.ErrorFrame;
import COM.ibm.raleigh.dhcpsgui.io.ErrorReporter;
import COM.ibm.raleigh.dhcpsgui.io.FileDialogResults;
import COM.ibm.raleigh.dhcpsgui.io.FileOpenDialog;
import COM.ibm.raleigh.dhcpsgui.io.IOUser;
import COM.ibm.raleigh.dhcpsgui.io.NetworkHandler;
import COM.ibm.raleigh.dhcpsgui.view.BINLServerGUI;
import COM.ibm.raleigh.dhcpsgui.view.DHCPNcodServerGUIApplet;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.awt.Component;
import java.awt.Frame;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;

public class DHCPConfigFileManager
implements IOUser,
ErrorReporter,
FileDialogResults {
    public static final String s = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String TEXT_ACTION_CANCEL_CFM = DHCPServerGUI.getResourceString("TEXT_ACTION_CANCEL_CFM");
    private static final String TEXT_ACTION_CORRECT = DHCPServerGUI.getResourceString("TEXT_ACTION_CORRECT");
    private static final String TEXT_TITLE_ERROR_FRAME = DHCPServerGUI.getResourceString("TEXT_TITLE_ERROR_FRAME");
    private static final String ATTN_NOT_ETC_INSTRUCTIONS = DHCPServerGUI.getResourceString("ATTN_NOT_ETC_INSTRUCTIONS");
    private static final String ATTN_NOT_ETC_OTHER_DATA = DHCPServerGUI.getResourceString("ATTN_NOT_ETC_OTHER_DATA");
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    private static final String TEXT_TITLE_ERROR_FRAME_BINL = DHCPServerGUI.getResourceString("TEXT_TITLE_ERROR_FRAME_BINL");
    private static final String ATTN_NOT_ETC_INSTRUCTIONS_BINL = DHCPServerGUI.getResourceString("ATTN_NOT_ETC_INSTRUCTIONS_BINL");
    private static final String ATTN_NOT_ETC_OTHER_DATA_BINL = DHCPServerGUI.getResourceString("ATTN_NOT_ETC_OTHER_DATA_BINL");
    private static final String NO_ADDRESS_DEFINED_ANYWHERE = DHCPServerGUI.getResourceString("NO_ADDRESS_DEFINED_ANYWHERE");
    private static final String DEFAULT_FILE_EXTENSION = ".cfg";
    private static final String TEXT_LABEL_NEW_CONFIGURATION = DHCPServerGUI.getResourceString("TEXT_LABEL_NEW_CONFIGURATION");
    private static ErrorFrame validErrorFrame = null;
    private static DHCPConfigFileManager thisConfigFileManager = null;
    public static final String defaultDHCPfname = "dhcpsd.cfg";
    public static final String defaultBINLfname = "binlsd.cfg";
    String fname;
    DHCPFile realFile;
    boolean fileOpen = false;
    String serverType;
    Frame caller;
    IOUser user;
    ConfigItem resumeRoot;
    Configuration root;
    String directoryName;
    boolean local = true;
    FileOpenDialog fdin;
    FileOpenDialog fdout;
    public static String theFileSeparator;
    String theLongETCdirectoryName;

    public DHCPConfigFileManager(Frame frame, DHCPFile dHCPFile, IOUser iOUser, String string) {
        this.realFile = dHCPFile;
        thisConfigFileManager = this;
        theFileSeparator = Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER) ? BINLServerGUI.theFileSeparator : DHCPServerGUI.theFileSeparator;
        this.directoryName = string != null && string.trim().length() > 0 ? string : ".." + theFileSeparator + "etc";
        if (dHCPFile instanceof DHCPRemoteFile) {
            this.local = false;
        }
        this.user = iOUser;
        this.caller = frame;
        this.serverType = Configuration.currentConfiguration.getItemType();
    }

    public void initialize() {
        validErrorFrame = ErrorFrame.getValidationErrorFrame(this.caller);
        Vector<String> vector = new Vector<String>();
        vector.addElement(TEXT_ACTION_CANCEL_CFM);
        vector.addElement(TEXT_ACTION_CORRECT);
        if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
            validErrorFrame.initialize(TEXT_TITLE_ERROR_FRAME_BINL, " ", vector, this);
            return;
        }
        validErrorFrame.initialize(TEXT_TITLE_ERROR_FRAME, " ", vector, this);
    }

    public void takeErrorAction(String string) {
        if (string.equals(TEXT_ACTION_CORRECT)) {
            ((Component)validErrorFrame).setVisible(false);
            validErrorFrame.dispose();
            this.caller.requestFocus();
            this.user.updateIOStatus(null, IOUser.TEXT_MESSAGE_FIX_PROBLEMS, 12);
            return;
        }
        if (string.equals(TEXT_ACTION_CANCEL_CFM)) {
            ((Component)validErrorFrame).setVisible(false);
            validErrorFrame.dispose();
            this.caller.requestFocus();
            this.user.updateIOStatus(null, IOUser.TEXT_MESSAGE_CONFIGURATION_LOST, 14);
        }
    }

    public static DHCPConfigFileManager getManagerInstance() {
        return thisConfigFileManager;
    }

    public String getFileName() {
        return this.fname;
    }

    public void readConfig(Configuration configuration, String string) {
        this.readConfig(configuration, string, null);
    }

    public void readConfig(Configuration configuration, String string, String string2) {
        if (configuration == null) {
            throw new ShouldNotOccurException("DHCPConfigFileManager readConfig() called with null configuration");
        }
        this.root = configuration;
        if (this.fileOpen) {
            this.realFile.close();
        }
        if (string2 == null) {
            this.fdin = new FileOpenDialog(this.caller, string, this.realFile, (FileDialogResults)this);
            this.fdin.setVisible(true);
            return;
        }
        this.fileOpenDialogOutputFileName(string2);
    }

    public boolean readSample(Configuration configuration) {
        if (configuration == null) {
            throw new ShouldNotOccurException("DHCPConfigFileManager readConfig() called with null configuration");
        }
        this.root = configuration;
        if (this.fileOpen) {
            this.realFile.close();
        }
        this.fname = "Sample.cfg";
        DHCPFile dHCPFile = Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER) ? new BINLSampleFile() : new DHCPSampleFile();
        this.fileOpen = false;
        return this.root.initializeItem(dHCPFile);
    }

    public void cleanup() {
        if (this.fileOpen) {
            this.realFile.close();
        }
    }

    public void saveConfig(Configuration configuration, String string, String string2) {
        if (this.fileOpen) {
            this.realFile.close();
        }
        this.fname = string;
        if (this.fname == null) {
            this.fdout = new FileOpenDialog(this.caller, string2, 0, (FileDialogResults)this);
            if (this.serverType.equalsIgnoreCase(TEXT_BINL_SERVER)) {
                this.fname = defaultBINLfname;
                this.fdout.setFileName(String.valueOf(this.directoryName) + theFileSeparator + defaultBINLfname);
            } else {
                this.fname = defaultDHCPfname;
                this.fdout.setFileName(String.valueOf(this.directoryName) + theFileSeparator + defaultDHCPfname);
            }
            this.fdout.setVisible(true);
            return;
        }
        if (this.fname.equalsIgnoreCase("TEXT_LABEL_NEW_CONFIGURATION")) {
            this.fdout = new FileOpenDialog(this.caller, string2, 0, (FileDialogResults)this);
            if (this.serverType.equalsIgnoreCase(TEXT_BINL_SERVER)) {
                this.fname = defaultBINLfname;
                this.fdout.setFileName(String.valueOf(this.directoryName) + theFileSeparator + defaultBINLfname);
            } else {
                this.fname = defaultDHCPfname;
                this.fdout.setFileName(String.valueOf(this.directoryName) + theFileSeparator + defaultDHCPfname);
            }
            this.fdout.setVisible(true);
            return;
        }
        this.fileSaveDialogOutputFileName(this.fname);
    }

    public void updateIOStatus(String string, String string2, int n) {
        if (n == 1) {
            this.user.updateIOStatus(null, IOUser.TEXT_MESSAGE_SAVE_CANCELLED, 1);
            return;
        }
        if (n == 4) {
            this.fileOpen = false;
            this.realFile.close();
            this.fname = null;
            this.user.updateIOStatus(null, string2, n);
            return;
        }
        if (n == 5) {
            this.realFile.close();
            this.fileOpen = false;
            if (!(this.realFile instanceof DHCPParameterSet)) {
                this.writeToFile(this.root, this.getBackupFileName(this.fname), this.user);
            }
            this.user.updateIOStatus(this.fname, string2, n);
            return;
        }
        if (n == 7) {
            this.realFile.close();
            this.fileOpen = false;
            this.fname = null;
            this.user.updateIOStatus(null, string2, n);
            return;
        }
        if (n == 6) {
            this.user.updateIOStatus(null, string2, n);
        }
    }

    public String getDefaultDirectory() {
        return this.directoryName;
    }

    public boolean thereWereErrorsInFile() {
        return this.root.wereErrorsInFile();
    }

    private boolean writeToFile(ConfigItem configItem, String string, IOUser iOUser) {
        if (configItem == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        String string2 = this.serverType.equalsIgnoreCase(TEXT_BINL_SERVER) ? "binlback" : "dhcpback";
        try {
            if (this.realFile.connect()) {
                this.realFile.create(string, "Write");
                this.realFile.open(string, "Write");
                this.fileOpen = true;
                configItem.saveToConfigFile(this.realFile);
                if (!this.serverType.equalsIgnoreCase(TEXT_BINL_SERVER) && string.indexOf(string2) == -1) {
                    if (this.local) {
                        this.doKeyGeneration(DHCPServerGUI.getConnectionToServer());
                    } else {
                        this.doKeyGeneration(DHCPRemoteFile.theDataSocket);
                    }
                }
                this.realFile.close();
                this.fileOpen = false;
            } else {
                this.realFile.close();
                this.fileOpen = false;
            }
            return true;
        }
        catch (Exception exception) {
            if (configItem == null) {
                throw new ShouldNotOccurException("DHCPConfigFileMgr writeToFile(): No Configuration to write out");
            }
            if (iOUser != null) {
                if (string == null) {
                    iOUser.updateIOStatus(null, IOUser.TEXT_MESSAGE_READ_CANCELLED, 4);
                } else {
                    iOUser.updateIOStatus(null, String.valueOf(IOUser.TEXT_MESSAGE_SAVE_FAILED) + string, 1);
                }
            }
            return false;
        }
    }

    public void doKeyGeneration(NetworkHandler networkHandler) {
        DHCPCommandServer dHCPCommandServer;
        String string;
        Enumeration enumeration = this.root.getServerParameters().getDDNSKeySupport().getARecKeyInformation();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            dHCPCommandServer = new DHCPCommandServer(8, string);
            System.out.println("new command " + dHCPCommandServer);
            if (!networkHandler.sendToServer(dHCPCommandServer.toString())) continue;
            networkHandler.receiveFromServer();
        }
        Enumeration enumeration2 = this.root.getServerParameters().getDDNSKeySupport().getPtrRecKeyInformation();
        while (enumeration2.hasMoreElements()) {
            string = (String)enumeration2.nextElement();
            dHCPCommandServer = new DHCPCommandServer(9, string);
            if (!networkHandler.sendToServer(dHCPCommandServer.toString())) continue;
            networkHandler.receiveFromServer();
        }
    }

    private String getFileName(String string) {
        if (string != null && string.indexOf(".") == -1) {
            string = String.valueOf(string) + DEFAULT_FILE_EXTENSION;
        }
        return string;
    }

    private String getBackupFileName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string.substring(string.lastIndexOf(theFileSeparator) + 1);
        String string3 = this.serverType.equalsIgnoreCase(TEXT_BINL_SERVER) ? "binlback" : "dhcpback";
        string2 = String.valueOf(this.getDefaultDirectory()) + theFileSeparator + string3 + theFileSeparator + string2;
        return string2;
    }

    private boolean validateClientStatements(Configuration configuration) {
        Message message;
        Enumeration enumeration = configuration.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.Client", true);
        boolean bl = true;
        while (enumeration.hasMoreElements()) {
            Client client = (Client)enumeration.nextElement();
            message = client.validateIDAndType(client.getParent());
            if (message == null) continue;
            validErrorFrame.show(this, message);
            bl = false;
            break;
        }
        enumeration = configuration.getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.ExcludedClient", true);
        while (enumeration.hasMoreElements()) {
            ExcludedClient excludedClient = (ExcludedClient)enumeration.nextElement();
            message = excludedClient.validateIDAndType(excludedClient.getParent());
            if (message == null) continue;
            validErrorFrame.show(this, message);
            bl = false;
            break;
        }
        return bl;
    }

    private String unqualifyFileName(String string) {
        if (string != null) {
            int n = string.lastIndexOf(theFileSeparator);
            if (n >= 0 && n < string.length()) {
                return string.substring(n + 1);
            }
            return string;
        }
        return null;
    }

    public void fileSaveDialogOutputFileName(String string) {
        Object object;
        Message message;
        Object object2;
        int n;
        this.fname = string;
        Object[] objectArray = new Object[]{this.fname};
        this.user.updateIOStatus(this.fname, MessageFormat.format(IOUser.TEXT_MESSAGE_SAVE_REMOTELY, objectArray), 3);
        int n2 = this.fname.lastIndexOf(theFileSeparator);
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = this.fname.substring(n2).indexOf(".")) == -1) {
            this.fname = String.valueOf(this.fname) + DEFAULT_FILE_EXTENSION;
        }
        String string2 = "";
        if (n2 > 0) {
            string2 = this.fname.substring(0, n2);
        }
        String string3 = String.valueOf(string2) + theFileSeparator;
        if (!Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER) && !this.root.getGlobal().checkAnAddressIsDefined()) {
            object2 = ErrorFrame.getValidationWarningFrame(this.caller);
            message = new Message(NO_ADDRESS_DEFINED_ANYWHERE);
            ((ErrorFrame)object2).show(message);
        }
        new SubnetValidator();
        if (!this.validateClientStatements(this.root)) {
            return;
        }
        object2 = this.root.validate();
        if (object2 != null) {
            ErrorFrame errorFrame = ErrorFrame.getValidationWarningFrame(this.caller);
            errorFrame.show((Message)object2);
            return;
        }
        if (!string2.equalsIgnoreCase(this.directoryName) && !string3.equalsIgnoreCase(this.directoryName)) {
            if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
                message = new Message(ATTN_NOT_ETC_INSTRUCTIONS_BINL);
                message.setOtherData(ATTN_NOT_ETC_OTHER_DATA_BINL);
            } else {
                message = new Message(ATTN_NOT_ETC_INSTRUCTIONS);
                message.setOtherData(ATTN_NOT_ETC_OTHER_DATA);
            }
            object = ErrorFrame.getFileWarningFrame(this.caller);
            ((ErrorFrame)object).show(message);
        }
        object = new Object[]{this.fname};
        this.user.updateIOStatus(this.fname, MessageFormat.format(IOUser.TEXT_MESSAGE_SAVED_TO, (Object[])object), 3);
        this.writeToFile(this.root, this.fname, this.user);
        this.user.updateIOStatus(this.fname, MessageFormat.format(IOUser.TEXT_MESSAGE_SAVE_COMPLETE, (Object[])object), 2);
    }

    public void fileSaveDialogCanceled() {
        this.fname = null;
        this.user.updateIOStatus(this.fname, IOUser.TEXT_MESSAGE_SAVE_CANCELLED, 1);
    }

    public void fileOpenDialogCanceled() {
        this.fname = null;
        this.user.updateIOStatus(null, IOUser.TEXT_MESSAGE_READ_CANCELLED, 4);
    }

    public void fileOpenDialogOutputFileName(String string) {
        this.fname = this.getFileName(string);
        BusyWaitFrame busyWaitFrame = null;
        if (!this.local) {
            busyWaitFrame = new BusyWaitFrame();
            ((Component)busyWaitFrame).setSize(400, 100);
            ((Component)busyWaitFrame).setVisible(true);
        }
        if (this.realFile.connect()) {
            if (this.realFile.exists(this.fname)) {
                Object[] objectArray = new Object[]{this.fname};
                this.user.updateIOStatus(this.fname, MessageFormat.format(IOUser.TEXT_MESSAGE_LOADING_NEW, objectArray), 0);
                if (!this.realFile.open(this.fname, "Read")) {
                    this.user.updateIOStatus(this.fname, IOUser.TEXT_MESSAGE_READ_FILE_CANNOT_BE_OPENED, 7);
                    if (busyWaitFrame != null) {
                        busyWaitFrame.dispose();
                    }
                }
                this.fileOpen = true;
                if (this.root.initializeItem(this.realFile)) {
                    this.realFile.close();
                    this.fileOpen = false;
                    if (busyWaitFrame != null) {
                        busyWaitFrame.dispose();
                    }
                    if (!(this.realFile instanceof DHCPParameterSet)) {
                        this.writeToFile(this.root, this.getBackupFileName(this.fname), this.user);
                    }
                } else if (busyWaitFrame != null) {
                    busyWaitFrame.dispose();
                }
            } else {
                Object[] objectArray = new Object[]{this.fname};
                this.user.updateIOStatus(this.fname, MessageFormat.format(IOUser.TEXT_MESSAGE_FILE_NOT_THERE, objectArray), 10);
                this.fname = TEXT_LABEL_NEW_CONFIGURATION;
                if (busyWaitFrame != null) {
                    busyWaitFrame.dispose();
                }
            }
        } else {
            this.user.updateIOStatus(null, IOUser.TEXT_MESSAGE_NO_CONNECT_TO_SERVER, 0);
            if (busyWaitFrame != null) {
                busyWaitFrame.dispose();
            }
        }
        if (DHCPNcodServerGUIApplet.APPLETCATIONFLAG) {
            if (this.serverType.equalsIgnoreCase(TEXT_BINL_SERVER)) {
                BINLServerGUI.SERVERGUI.appletcationFileOpen(this.fname);
                return;
            }
            DHCPServerGUI.SERVERGUI.appletcationFileOpen(this.fname);
        }
    }
}

