/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.io;

import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.io.DHCPNetworkStringParser;
import COM.ibm.raleigh.dhcpsgui.io.DHCPQuestion;
import COM.ibm.raleigh.dhcpsgui.io.NetworkHandler;
import COM.ibm.raleigh.dhcpsgui.view.BINLServerGUI;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.applet.Applet;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;

public class DHCPSocketNetworkHandler
implements NetworkHandler {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final String URL_DELIMITER = "/";
    private final int MAX_RETRIES = 10;
    private static final String TEXT_BINL_SERVER = DHCPServerGUI.getResourceString("TEXT_BINL_SERVER");
    DataOutputStream toTheNet;
    DataInputStream fromTheNet;
    Socket theSocketItself;
    InetAddress[] inetAddrs;

    public DHCPSocketNetworkHandler(Applet applet, int n, String string) {
        if (applet != null) {
            URL uRL = applet.getCodeBase();
            this.inetAddrs = null;
            try {
                this.inetAddrs = InetAddress.getAllByName(uRL.getHost());
                try {
                    this.theSocketItself = new Socket(this.inetAddrs[0], n);
                    this.toTheNet = new DataOutputStream(this.theSocketItself.getOutputStream());
                    this.fromTheNet = new DataInputStream(new BufferedInputStream(this.theSocketItself.getInputStream()));
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println(">>>> Couldn't get hostnames for connection to server");
                return;
            }
        }
        InetAddress inetAddress = null;
        this.inetAddrs = null;
        if (string == null) {
            try {
                InetAddress inetAddress2 = InetAddress.getLocalHost();
                String string2 = inetAddress2.getHostAddress();
                inetAddress = InetAddress.getByName(string2);
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println("NetworkHandler, localHost threw an UnknownHostException");
            }
        }
        try {
            if (inetAddress != null && string == null) {
                this.inetAddrs = InetAddress.getAllByName(inetAddress.getHostName());
            } else if (string != null) {
                this.inetAddrs = InetAddress.getAllByName(string);
            }
            if (this.inetAddrs != null) {
                int n2 = 0;
                while (n2 < 10) {
                    try {
                        this.theSocketItself = new Socket(this.inetAddrs[0], n);
                        this.toTheNet = new DataOutputStream(this.theSocketItself.getOutputStream());
                        this.fromTheNet = new DataInputStream(new BufferedInputStream(this.theSocketItself.getInputStream()));
                        return;
                    }
                    catch (IOException iOException) {
                        ++n2;
                    }
                }
                return;
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("Couldn't get hostnames for the server");
            return;
        }
    }

    public DHCPSocketNetworkHandler(int n, String string) {
        InetAddress inetAddress = null;
        this.inetAddrs = null;
        try {
            InetAddress inetAddress2 = InetAddress.getLocalHost();
            String string2 = inetAddress2.getHostAddress();
            inetAddress = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println("NetworkHandler, localHost threw an UnknownHostException");
        }
        try {
            if (inetAddress != null && string == null) {
                this.inetAddrs = InetAddress.getAllByName(inetAddress.getHostName());
            } else if (string != null) {
                this.inetAddrs = InetAddress.getAllByName(string);
            }
            if (this.inetAddrs != null) {
                int n2 = 0;
                while (n2 < 10) {
                    try {
                        this.theSocketItself = new Socket(this.inetAddrs[0], n);
                        this.toTheNet = new DataOutputStream(this.theSocketItself.getOutputStream());
                        this.fromTheNet = new DataInputStream(new BufferedInputStream(this.theSocketItself.getInputStream()));
                        return;
                    }
                    catch (IOException iOException) {
                        ++n2;
                    }
                }
                return;
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println(">>>> Couldn't get hostnames for the server");
        }
    }

    public String getDefaultDirectory() {
        DHCPQuestion dHCPQuestion;
        String string = null;
        if (this.theSocketItself != null && this.sendToServer((dHCPQuestion = new DHCPQuestion(2)).toString())) {
            DHCPNetworkStringParser dHCPNetworkStringParser = this.receiveFromServer();
            string = dHCPQuestion.getReturnedString(dHCPNetworkStringParser.getParsed());
        }
        if (string == null) {
            if (Configuration.currentConfiguration.getItemType().equalsIgnoreCase(TEXT_BINL_SERVER)) {
                return ".." + BINLServerGUI.theFileSeparator + "etc";
            }
            return ".." + DHCPServerGUI.theFileSeparator + "etc";
        }
        return string;
    }

    public String getFileSeparator() {
        DHCPQuestion dHCPQuestion;
        String string = null;
        if (this.theSocketItself != null && this.sendToServer((dHCPQuestion = new DHCPQuestion(3)).toString())) {
            DHCPNetworkStringParser dHCPNetworkStringParser = this.receiveFromServer();
            string = dHCPQuestion.getReturnedString(dHCPNetworkStringParser.getParsed());
        }
        if (string == null) {
            return File.separator;
        }
        return string;
    }

    public boolean socketCreated() {
        return this.theSocketItself != null;
    }

    public Socket getSocket() {
        return this.theSocketItself;
    }

    public boolean sendToServer(String string) {
        try {
            this.toTheNet.writeUTF(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public DHCPNetworkStringParser receiveFromServer() {
        try {
            String string = this.fromTheNet.readUTF();
            DHCPNetworkStringParser dHCPNetworkStringParser = new DHCPNetworkStringParser(string);
            return dHCPNetworkStringParser;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String receiveFromServer(boolean bl) {
        try {
            String string = this.fromTheNet.readUTF();
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void closeStreams() {
        try {
            if (this.toTheNet != null) {
                this.toTheNet.close();
                this.toTheNet = null;
            }
            if (this.fromTheNet != null) {
                this.fromTheNet.close();
                this.fromTheNet = null;
            }
            if (this.theSocketItself != null) {
                this.theSocketItself.close();
                this.theSocketItself = null;
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public boolean setSocketTimeout(int n) {
        if (this.theSocketItself != null) {
            try {
                this.theSocketItself.setSoTimeout(n);
                return true;
            }
            catch (SocketException socketException) {
                return false;
            }
        }
        return false;
    }

    public int getSocketTimeout() {
        if (this.theSocketItself != null) {
            try {
                return this.theSocketItself.getSoTimeout();
            }
            catch (SocketException socketException) {
                return 0;
            }
        }
        return 0;
    }
}

