/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.CommonClient;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.ExcludedClient;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.TextFieldWithTab;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class BINLExcludedClientPanel
extends NotebookPanel
implements KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_CLIENTNAME = DHCPServerGUI.getResourceString("TEXT_CLIENTNAME");
    private static final String TEXT_ID = DHCPServerGUI.getResourceString("TEXT_ID");
    private static final String TEXT_TYPE = DHCPServerGUI.getResourceString("TEXT_TYPE");
    private static final String TEXT_ID_AND_TYPE = DHCPServerGUI.getResourceString("TEXT_ID_AND_TYPE");
    private static final String TEXT_SCOPE = DHCPServerGUI.getResourceString("TEXT_SCOPE");
    private static final String TEXT_COMMENT = DHCPServerGUI.getResourceString("TEXT_COMMENT");
    private static final String TEXT_BINL_EXCLUDED_CLIENT_LABEL = DHCPServerGUI.getResourceString("TEXT_BINL_EXCLUDED_CLIENT_LABEL");
    private ExcludedClient client = null;
    private NotebookFrame parentFrame = null;
    private ConfigItem parent;
    private BINLGlobal global;
    private TextFieldWithTab name;
    private TextFieldWithTab clientID;
    private Choice scope;
    private Choice hwtype;
    private TextArea comment;
    private boolean existingClient;
    private WrappedTextPanel infoLabel;
    private Panel excludedPanel;
    private Font theTextFont;
    private Font theTitleFont;
    private Label nameLabel;
    private Label idLabel;
    private Label typeLabel;
    private Label scopeLabel;
    private Label commentLabel;
    private GridBagLayout gridBag = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.client = (ExcludedClient)configItem;
        this.parentFrame = notebookFrame;
        this.parent = this.parentFrame.getItemParent();
        this.global = this.parentFrame.getBINLGlobal();
        this.remove(this.scope);
        this.scope = null;
        this.comment.setText("");
        if (this.parentFrame.isNewItem()) {
            this.existingClient = false;
            return;
        }
        this.existingClient = true;
    }

    public void populatePanel() {
        if (this.client.getAlias() != null) {
            ((TextComponent)this.name).setText(this.client.getAlias());
        } else {
            ((TextComponent)this.name).setText("");
        }
        if (this.client.getIdValue() != null) {
            ((TextComponent)this.clientID).setText(this.client.getIdValue());
        } else {
            ((TextComponent)this.clientID).setText("");
        }
        this.hwtype.select(this.client.getIdType());
        this.scope = new Choice();
        if (this.populateScopeChoice(this.scope, this.global, this.client, this.parent, this.existingClient)) {
            this.parentFrame.setItemParent(this.parent);
        }
        this.constraints.gridx = 2;
        this.constraints.gridy = 3;
        this.constraints.gridwidth = 0;
        this.constraints.anchor = 18;
        this.constraints.fill = 0;
        this.gridBag.setConstraints(this.scope, this.constraints);
        String string = this.client.getComment();
        if (string != null) {
            this.comment.setText(string);
        }
    }

    public boolean saveState() {
        if (this.existingClient) {
            this.parentFrame.setItemParent(this.parent);
        } else {
            this.parentFrame.setItemParent(this.getScopeParent());
        }
        this.parent = this.parentFrame.getItemParent();
        Message message = this.client.setAlias(this.name.getText());
        if (message != null) {
            message.setLocation(TEXT_CLIENTNAME);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.client.setIdValue(this.clientID.getText());
        if (message != null) {
            message.setLocation(TEXT_ID);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.client.setIdTypeUsingIndex(this.hwtype.getSelectedIndex());
        if (message != null) {
            message.setLocation(TEXT_TYPE);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.client.validateIDAndType(this.parent);
        if (message != null) {
            message.setLocation(TEXT_ID_AND_TYPE);
            this.parentFrame.displayError(message);
            return false;
        }
        this.client.setComment(this.comment.getText());
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        this.theTextFont = font;
        this.theTitleFont = font2;
        this.initComponents();
        this.addComponentsToGrid();
    }

    public void initComponents() {
        this.name = new TextFieldWithTab(17);
        this.clientID = new TextFieldWithTab(17);
        this.comment = new TextArea("", 5, 60);
        this.comment.addKeyListener(this);
        this.hwtype = new Choice();
        this.scope = new Choice();
        this.nameLabel = new Label(TEXT_CLIENTNAME);
        this.idLabel = new Label(TEXT_ID);
        this.typeLabel = new Label(TEXT_TYPE);
        this.scopeLabel = new Label(TEXT_SCOPE);
        this.commentLabel = new Label(TEXT_COMMENT);
        this.infoLabel = new WrappedTextPanel(TEXT_BINL_EXCLUDED_CLIENT_LABEL, 110);
        this.excludedPanel = new Panel();
    }

    public void addComponentsToGrid() {
        ((Component)this).setFont(this.theTextFont);
        this.setLayout(this.gridBag);
        this.infoLabel.getNumDividedTextLines();
        String[] stringArray = CommonClient.getTypeList();
        int n = 0;
        while (n < stringArray.length) {
            this.hwtype.addItem(stringArray[n]);
            ++n;
        }
        this.excludedPanel.setLayout(this.gridBag);
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constrain(this.nameLabel, this.gridBag, this.constraints, 0, 0, 1, 1);
        this.excludedPanel.add(this.nameLabel);
        this.constrain(this.name, this.gridBag, this.constraints, 2, 0, 0, 1);
        this.excludedPanel.add(this.name);
        this.constrain(this.typeLabel, this.gridBag, this.constraints, 0, 1, 1, 1);
        this.excludedPanel.add(this.typeLabel);
        this.constrain(this.hwtype, this.gridBag, this.constraints, 2, 1, 0, 1);
        this.excludedPanel.add(this.hwtype);
        this.constrain(this.idLabel, this.gridBag, this.constraints, 0, 2, 1, 1);
        this.excludedPanel.add(this.idLabel);
        this.constrain(this.clientID, this.gridBag, this.constraints, 2, 2, 0, 1);
        this.excludedPanel.add(this.clientID);
        this.constrain(this.commentLabel, this.gridBag, this.constraints, 0, 3, 1, 1);
        this.excludedPanel.add(this.commentLabel);
        this.constraints.fill = 2;
        this.constrain(this.comment, this.gridBag, this.constraints, -1, 3, 0, 1);
        this.excludedPanel.add(this.comment);
        this.constraints.fill = 2;
        this.constraints.anchor = 18;
        this.constraints.ipady = 40;
        this.constraints.insets = new Insets(10, 10, 0, 0);
        this.constrain(this.excludedPanel, this.gridBag, this.constraints, 0, 0, 1, 1);
        this.add(this.excludedPanel);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 9 && object instanceof TextArea) {
            this.transferFocus();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

