/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.LSA1Group;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Option;
import COM.ibm.raleigh.dhcpsgui.biz.OptionSkeleton;
import COM.ibm.raleigh.dhcpsgui.biz.OptionValidator;
import COM.ibm.raleigh.dhcpsgui.biz.PXEOptionSkeletonManager;
import COM.ibm.raleigh.dhcpsgui.notebook.AddrListPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.AddrPairListPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.BootMenuListPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.BootServersListPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.BorderPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.DefineOptionFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.IntegerListPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.NoValuePanel;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.OneValuePanel;
import COM.ibm.raleigh.dhcpsgui.notebook.OptionInputPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.PXEDiscoveryControlPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.StatusPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.TimeEntryPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.TimeOutPromptPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.WrappedTextArea;
import COM.ibm.raleigh.dhcpsgui.view.BINLServerGUI;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class BINLOptionsPanel
extends NotebookPanel
implements Observer,
ItemListener,
ActionListener,
KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_OPTION_INSTRUCTIONS1 = DHCPServerGUI.getResourceString("TEXT_OPTION_INSTRUCTIONS");
    private static final String TEXT_OPTION_INSTRUCTIONS2 = DHCPServerGUI.getResourceString("TEXT_OPTION_INSTRUCTIONS_2");
    private static final String TEXT_USED = DHCPServerGUI.getResourceString("TEXT_USED");
    private static final String TEXT_ALPHA = DHCPServerGUI.getResourceString("TEXT_ALPHA");
    private static final String TEXT_BYTAG = DHCPServerGUI.getResourceString("TEXT_BYTAG");
    private static final String TEXT_BUTTON_DELETE_OPTION = DHCPServerGUI.getResourceString("TEXT_BUTTON_DELETE_OPTION");
    private static final String TEXT_BUTTON_NEW = DHCPServerGUI.getResourceString("TEXT_BUTTON_NEW");
    private static final String TEXT_BUTTON_EDIT = DHCPServerGUI.getResourceString("TEXT_BUTTON_EDIT");
    private static final String TEXT_BUTTON_DELETE = DHCPServerGUI.getResourceString("TEXT_BUTTON_DELETE");
    private static final String TEXT_LABEL_OPTION_DESCRIPTION = DHCPServerGUI.getResourceString("TEXT_LABEL_OPTION_DESCRIPTION");
    private static final String TEXT_LABEL_OPTIONS_FOR = DHCPServerGUI.getResourceString("TEXT_LABEL_OPTIONS_FOR");
    private static final String TEXT_LABEL_DEFINE_OPTIONS = DHCPServerGUI.getResourceString("TEXT_LABEL_DEFINE_OPTIONS");
    private static final String TEXT_LABEL_AVAILABLE_OPTIONS = DHCPServerGUI.getResourceString("TEXT_LABEL_AVAILABLE_OPTIONS");
    private static final String TEXT_LABEL_INHERITED_FROM = DHCPServerGUI.getResourceString("TEXT_LABEL_INHERITED_FROM");
    private static final String TEXT_LABEL_NOT_DEFINED = DHCPServerGUI.getResourceString("TEXT_LABEL_NOT_DEFINED");
    private static final String TEXT_LABEL_DEFINED_LOCALLY = DHCPServerGUI.getResourceString("TEXT_LABEL_DEFINED_LOCALLY");
    private static final String TEXT_UNNAMED = DHCPServerGUI.getResourceString("TEXT_UNNAMED");
    private static final String TEXT_LABEL_OPTION = DHCPServerGUI.getResourceString("TEXT_LABEL_OPTION");
    private static final String TEXT_LABEL_OPTION_SHORT = DHCPServerGUI.getResourceString("TEXT_LABEL_OPTION_SHORT");
    private static final String TEXT_LABEL_FOR_DEFINING = DHCPServerGUI.getResourceString("TEXT_LABEL_FOR_DEFINING");
    protected static final String TEXT_LOCATION_FOR_OPTION = DHCPServerGUI.getResourceString("TEXT_LOCATION_FOR_OPTION");
    private static final String TEXT_LIST_ITEM_USED_HERE = DHCPServerGUI.getResourceString("TEXT_LIST_ITEM_USED_HERE");
    private static final String TEXT_LIST_ITEM_USED_ELSEWHERE = DHCPServerGUI.getResourceString("TEXT_LIST_ITEM_USED_ELSEWHERE");
    private static final String TEXT_LIST_ITEM_UNUSED = DHCPServerGUI.getResourceString("TEXT_LIST_ITEM_UNUSED");
    private static final String ERROR_MODIFY_IN_USE = DHCPServerGUI.getResourceString("ERROR_MODIFY_IN_USE");
    private static final String ERROR_DELETE_IN_USE = DHCPServerGUI.getResourceString("ERROR_DELETE_IN_USE");
    private static final String TEXT_BOX_LABEL_ENTER_DATA = DHCPServerGUI.getResourceString("TEXT_BOX_LABEL_ENTER_DATA");
    private static final String TEXT_LABEL_VALUE = DHCPServerGUI.getResourceString("TEXT_LABEL_VALUE");
    private static final String TEXT_LABEL_STRING = DHCPServerGUI.getResourceString("TEXT_LABEL_STRING");
    private static final String BLANK = "blank panel";
    private static final String LABEL_BLANK = "";
    private NotebookFrame callingNotebook;
    private ConfigItem curItem;
    private ConfigItem potentialParent;
    private ConfigItem optionParent;
    private String currentOrder = TEXT_USED;
    private Vector currentVector;
    private OptionSkeleton selectedOskel;
    private Option realOption;
    boolean explicitOption;
    private Hashtable newlyCreatedOptions;
    private Vector usedElsewhere;
    private Vector usedHere;
    private TextArea instructions;
    private Font textFont;
    private Font titleFont;
    private Button buttonNew;
    private Button buttonEdit;
    private Button buttonDelete;
    private Button buttonDeleteOption;
    private Choice sortChoice;
    private List availableOptions;
    private int selectedIndex;
    private Vector labelIndices = new Vector();
    private Panel rightTopPanel;
    private BorderPanel valueBox;
    private OptionInputPanel currentInputPanel;
    private Label currentOptionSpec = new Label("");
    private Label currentOptionLocation;
    private CardLayout cLayout;
    private WrappedTextArea description;
    private Panel valueSpecs;
    private Label ins1;
    private Label ins2;
    private Label availableOptionsLabel;
    private Label descriptionLabel;
    private Vector panelNames = new Vector();
    private Vector panelInstances = new Vector();
    private boolean panelLaidOut = false;
    private boolean closingNotebook = false;
    private BINLGlobal savedGlobal;
    private static BINLOptionsPanel currentPanel = null;

    public BINLOptionsPanel() {
        this.currentVector = new Vector();
        PXEOptionSkeletonManager.setObserver(this);
    }

    public static BINLOptionsPanel getOptionsPanel() {
        if (currentPanel == null) {
            currentPanel = new BINLOptionsPanel();
        }
        return currentPanel;
    }

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.selectedOskel = null;
        this.callingNotebook = notebookFrame;
        this.newlyCreatedOptions = new Hashtable();
        this.usedElsewhere = new Vector();
        this.usedHere = new Vector();
        this.potentialParent = this.callingNotebook.getItemParent();
        this.curItem = configItem;
        this.currentVector.removeAllElements();
        this.localPopulatePanel();
        PXEOptionSkeletonManager.backupSkeletons();
    }

    public void layoutPanel(Font font, Font font2) {
        String string;
        Object[] objectArray;
        if (this.panelLaidOut) {
            return;
        }
        this.panelLaidOut = true;
        ((Component)this).setFont(font);
        this.textFont = font;
        this.titleFont = font2;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.setLayout(gridBagLayout2);
        if (this.curItem != null) {
            objectArray = new Object[]{this.curItem.getName()};
            string = MessageFormat.format(TEXT_LABEL_OPTIONS_FOR, objectArray);
        } else {
            string = TEXT_LABEL_DEFINE_OPTIONS;
        }
        objectArray = new Label(string, 1);
        objectArray.setFont(font2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipady = -4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        this.ins1 = new Label(TEXT_OPTION_INSTRUCTIONS1);
        gridBagLayout2.setConstraints(this.ins1, gridBagConstraints);
        this.add(this.ins1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        this.ins2 = new Label(TEXT_OPTION_INSTRUCTIONS2);
        gridBagLayout2.setConstraints(this.ins2, gridBagConstraints);
        this.add(this.ins2);
        this.availableOptionsLabel = new Label(TEXT_LABEL_AVAILABLE_OPTIONS, 1);
        this.availableOptionsLabel.setFont(font2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout2.setConstraints(this.availableOptionsLabel, gridBagConstraints);
        this.add(this.availableOptionsLabel);
        this.sortChoice = new Choice();
        this.sortChoice.addItemListener(this);
        this.sortChoice.addItem(TEXT_USED);
        this.sortChoice.addItem(TEXT_ALPHA);
        this.sortChoice.addItem(TEXT_BYTAG);
        this.sortChoice.select(TEXT_USED);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout2.setConstraints(this.sortChoice, gridBagConstraints);
        this.add(this.sortChoice);
        this.availableOptions = new List(18, false);
        this.availableOptions.addItemListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 150;
        gridBagConstraints.ipady = -250;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagLayout2.setConstraints(this.availableOptions, gridBagConstraints);
        this.add(this.availableOptions);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        this.buttonNew = new Button(TEXT_BUTTON_NEW);
        this.buttonNew.setBackground(Color.lightGray);
        this.buttonNew.addActionListener(this);
        this.buttonNew.addKeyListener(this);
        panel.add(this.buttonNew);
        this.buttonEdit = new Button(TEXT_BUTTON_EDIT);
        this.buttonEdit.setBackground(Color.lightGray);
        this.buttonEdit.addActionListener(this);
        this.buttonEdit.addKeyListener(this);
        panel.add(this.buttonEdit);
        this.buttonDelete = new Button(TEXT_BUTTON_DELETE);
        this.buttonDelete.setBackground(Color.lightGray);
        this.buttonDelete.addActionListener(this);
        this.buttonDelete.addKeyListener(this);
        panel.add(this.buttonDelete);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout2.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        this.valueBox = new BorderPanel(TEXT_BOX_LABEL_ENTER_DATA);
        this.valueBox.setTextFont(font2);
        this.valueBox.setLayout(gridBagLayout);
        this.valueBox.setThickness(1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.currentOptionSpec, gridBagConstraints);
        this.valueBox.add(this.currentOptionSpec);
        this.currentOptionLocation = new Label(LABEL_BLANK);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.currentOptionLocation, gridBagConstraints);
        this.valueBox.add(this.currentOptionLocation);
        this.addInputPanels();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.valueSpecs, gridBagConstraints);
        this.valueBox.add(this.valueSpecs);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.ipady = -10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 2;
        gridBagLayout2.setConstraints(this.valueBox, gridBagConstraints);
        this.add(this.valueBox);
        this.descriptionLabel = new Label(TEXT_LABEL_OPTION_DESCRIPTION, 1);
        this.descriptionLabel.setFont(font2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout2.setConstraints(this.descriptionLabel, gridBagConstraints);
        this.add(this.descriptionLabel);
        this.description = new WrappedTextArea(" ", 3, 40, font);
        this.description.setEditable(false);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout2.setConstraints(this.description, gridBagConstraints);
        this.add(this.description);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        this.buttonDeleteOption = new Button(TEXT_BUTTON_DELETE_OPTION);
        this.buttonDeleteOption.setBackground(Color.lightGray);
        this.buttonDeleteOption.addActionListener(this);
        this.buttonDeleteOption.addKeyListener(this);
        panel2.add(this.buttonDeleteOption);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout2.setConstraints(panel2, gridBagConstraints);
        this.add(panel2);
    }

    public void setEnabled(boolean bl) {
        this.availableOptions.setEnabled(bl);
        this.ins1.setEnabled(bl);
        this.ins2.setEnabled(bl);
        this.availableOptionsLabel.setEnabled(bl);
        this.sortChoice.setEnabled(bl);
        this.buttonNew.setEnabled(bl);
        this.valueBox.setEnabled(bl);
        this.descriptionLabel.setEnabled(bl);
        this.description.setEnabled(bl);
        if (!bl) {
            this.valueBox.setColor(Color.gray);
            return;
        }
        this.valueBox.setColor(Color.black);
    }

    private void localPopulatePanel() {
        this.blankSelectedOption();
        BINLGlobal bINLGlobal = Configuration.currentConfiguration.getBINLGlobal();
        if (this.savedGlobal != bINLGlobal) {
            PXEOptionSkeletonManager.sortUsed();
            this.savedGlobal = bINLGlobal;
        }
        this.changeOrder(this.currentOrder);
        if (BINLServerGUI.SERVERGUI.getNodeSelected() instanceof LSA1Group || BINLServerGUI.SERVERGUI.getNodeSelected().getParent() instanceof LSA1Group) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    private void addInputPanels() {
        this.cLayout = new CardLayout();
        this.valueSpecs = new Panel();
        this.valueSpecs.setLayout(this.cLayout);
        this.addOnePanel("String", new OneValuePanel());
        this.addOnePanel("IP address", new OneValuePanel());
        this.addOnePanel("Broadcast IP address", new OneValuePanel());
        this.addOnePanel("Integer", new OneValuePanel());
        this.addOnePanel("Mask in either Integer or IP address format", new OneValuePanel());
        this.addOnePanel("Boolean", new StatusPanel());
        this.addOnePanel("Choice", new StatusPanel());
        this.valueSpecs.add(BLANK, new Panel());
        this.addOnePanel("Time", new TimeEntryPanel(6, 2));
        this.addOnePanel("IP addresses", new AddrListPanel());
        this.addOnePanel("Integer list", new IntegerListPanel());
        this.addOnePanel("IP address pairs", new AddrPairListPanel());
        this.addOnePanel("IP address pairs with mask", new AddrPairListPanel());
        this.addOnePanel("Multicast IP address", new OneValuePanel());
        this.addOnePanel("Discovery Control", new PXEDiscoveryControlPanel());
        this.addOnePanel("Boot Servers", new BootServersListPanel());
        this.addOnePanel("Boot Menu", new BootMenuListPanel());
        this.addOnePanel("Menu Prompt", new TimeOutPromptPanel());
        NoValuePanel noValuePanel = new NoValuePanel();
        ((Component)noValuePanel).setFont(this.textFont);
        this.addOnePanel("Disabled field", noValuePanel);
        this.cLayout.show(this.valueSpecs, BLANK);
    }

    private void addOnePanel(String string, OptionInputPanel optionInputPanel) {
        this.valueSpecs.add(string, (Panel)((Object)optionInputPanel));
        this.panelNames.addElement(string);
        this.panelInstances.addElement(optionInputPanel);
    }

    private void changeInputPanel(OptionSkeleton optionSkeleton) {
        String string = optionSkeleton.getDatatype();
        int n = this.panelNames.indexOf(string);
        if (n < 0) {
            throw new ShouldNotOccurException("ArchOps changeInputPanel, panel name not recognized: <" + string + ">");
        }
        this.currentInputPanel = (OptionInputPanel)this.panelInstances.elementAt(n);
        this.currentInputPanel.setFormat(optionSkeleton, this.titleFont);
        NotebookPanel.setFocus((Panel)((Object)this.currentInputPanel));
        if (string.equals("Disabled field")) {
            this.currentOptionLocation.setText(LABEL_BLANK);
        }
        this.currentInputPanel.setCaller(this.callingNotebook);
        this.cLayout.show(this.valueSpecs, string);
        this.validate();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.availableOptions) {
            this.processSelectedAvailableOption();
            return;
        }
        if (itemEvent.getSource() == this.sortChoice) {
            Choice choice = (Choice)itemEvent.getSource();
            String string = choice.getSelectedItem();
            this.changeOrder(string);
            this.validate();
        }
    }

    private void processSelectedAvailableOption() {
        boolean bl = this.changeSelectedOption();
        if (bl) {
            this.selectedIndex = this.availableOptions.getSelectedIndex();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    private void blankSelectedOption() {
        if (this.currentInputPanel != null) {
            this.currentInputPanel.resetFields();
        }
        this.currentOptionSpec.setText(LABEL_BLANK);
        this.currentOptionLocation.setText(LABEL_BLANK);
        this.cLayout.show(this.valueSpecs, BLANK);
        this.description.setText(" ");
        this.buttonDeleteOption.setEnabled(false);
        this.buttonEdit.setEnabled(false);
        this.buttonDelete.setEnabled(false);
        this.currentInputPanel = null;
    }

    public void selectOption(Option option) {
        String[] stringArray = this.availableOptions.getItems();
        if (stringArray != null && stringArray.length > 0) {
            String string = this.buildOptionDescription(option.getTag(), option.getBriefDescription());
            int n = 0;
            while (n < stringArray.length) {
                if (string.trim().compareTo(stringArray[n].trim()) == 0) {
                    this.availableOptions.select(n);
                    this.processSelectedAvailableOption();
                    return;
                }
                ++n;
            }
        }
    }

    private String buildOptionDescription(String string, String string2) {
        String string3 = " ";
        if (string.length() == 1) {
            string3 = "     ";
        } else if (string.length() == 2) {
            string3 = "   ";
        }
        String string4 = String.valueOf(string3) + string + "  " + string2;
        return string4;
    }

    private boolean changeSelectedOption() {
        String string;
        String string2;
        if (this.currentInputPanel != null && !this.saveEnteredData()) {
            this.availableOptions.select(this.selectedIndex);
            return false;
        }
        int n = this.availableOptions.getSelectedIndex();
        if (!this.currentOrder.equals(TEXT_USED)) {
            this.selectedOskel = (OptionSkeleton)this.currentVector.elementAt(n);
        } else {
            string2 = this.availableOptions.getSelectedItem();
            if (string2 == TEXT_LIST_ITEM_USED_HERE || string2 == TEXT_LIST_ITEM_USED_ELSEWHERE || string2 == TEXT_LIST_ITEM_UNUSED) {
                this.blankSelectedOption();
                return true;
            }
            int n2 = 0;
            n2 = n <= this.usedHere.size() ? 1 : 2;
            int n3 = n - n2;
            if (n3 >= 0) {
                this.selectedOskel = (OptionSkeleton)this.currentVector.elementAt(n3);
            }
        }
        this.displayPrecis(this.selectedOskel);
        string2 = this.selectedOskel.getTag();
        Object[] objectArray = new Object[]{string2, this.selectedOskel.getBriefDescription()};
        this.currentOptionSpec.setText(MessageFormat.format(TEXT_LABEL_OPTION, objectArray));
        this.optionParent = null;
        this.realOption = (Option)this.newlyCreatedOptions.get(string2);
        if (this.realOption != null) {
            this.optionParent = this.curItem;
            this.explicitOption = true;
        } else {
            this.realOption = this.curItem.getOption(string2);
            if (this.realOption != null) {
                this.optionParent = this.realOption.getParent();
                this.explicitOption = this.optionParent == this.curItem;
            } else {
                this.realOption = this.potentialParent.getOption(string2);
                if (this.realOption != null && this.realOption.getParent() != null) {
                    this.optionParent = this.realOption.getParent();
                }
                this.explicitOption = false;
            }
        }
        if (this.optionParent != null) {
            if (this.optionParent == this.curItem) {
                if (this.curItem.getParent() != null) {
                    Object[] objectArray2 = new Object[]{this.curItem.getName()};
                    string = MessageFormat.format(TEXT_LABEL_DEFINED_LOCALLY, objectArray2);
                } else {
                    Object[] objectArray3 = new Object[]{TEXT_UNNAMED};
                    string = MessageFormat.format(TEXT_LABEL_DEFINED_LOCALLY, objectArray3);
                }
            } else {
                Object[] objectArray4 = new Object[]{this.optionParent.getName()};
                string = MessageFormat.format(TEXT_LABEL_INHERITED_FROM, objectArray4);
            }
        } else {
            string = TEXT_LABEL_NOT_DEFINED;
        }
        this.currentOptionLocation.setText(string);
        this.changeInputPanel(this.selectedOskel);
        if (this.realOption != null) {
            this.currentInputPanel.populate(this.realOption.getValue());
        } else if (this.currentInputPanel != null) {
            this.currentInputPanel.resetFields();
        }
        this.validate();
        this.buttonDeleteOption.setEnabled(this.realOption != null && this.explicitOption);
        this.buttonEdit.setEnabled(!this.selectedOskel.isRFC_architected());
        this.buttonDelete.setEnabled(!this.selectedOskel.isRFC_architected());
        return true;
    }

    public boolean saveState() {
        this.closingNotebook = true;
        if (this.curItem == null) {
            return false;
        }
        if (this.currentInputPanel != null && !this.saveEnteredData()) {
            this.closingNotebook = false;
            return false;
        }
        Enumeration enumeration = this.newlyCreatedOptions.elements();
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            PXEOptionSkeletonManager.setOptionSkeletonUsed(option.getTag());
            option.commit(this.curItem);
        }
        this.currentInputPanel = null;
        this.closingNotebook = false;
        return true;
    }

    private boolean saveEnteredData() {
        Message message;
        if (this.selectedOskel == null || this.currentInputPanel == null) {
            return true;
        }
        String string = this.selectedOskel.getTag();
        String string2 = this.currentInputPanel.getUserInput();
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string2 == null || string2.length() == 0) {
            return this.deleteOption();
        }
        Object object = OptionValidator.validateOption(string, string2, this.optionParent);
        if (object != null) {
            if (object instanceof Message) {
                Message message2 = (Message)object;
                message2.setLocation(String.valueOf(TEXT_LOCATION_FOR_OPTION) + string);
                this.callingNotebook.displayError(message2);
                return false;
            }
            if (object instanceof String && ((String)object).equals("Delete option")) {
                return this.deleteOption();
            }
        }
        if (this.realOption != null && string2.equals(this.realOption.getValue())) {
            return true;
        }
        if (this.realOption == null || this.realOption.getParent() != null && this.realOption.getParent() != this.curItem) {
            this.realOption = new Option();
            message = this.realOption.setTag(string, this.realOption.getParent());
            if (message == null && (message = this.realOption.setValue(string2, this.realOption.getParent())) == null) {
                this.newlyCreatedOptions.put(string, this.realOption);
            }
        } else {
            message = this.realOption.setValue(string2, this.realOption.getParent());
            if (message == null) {
                this.callingNotebook.somethingChanged();
            }
        }
        if (message != null) {
            Object[] objectArray = new Object[]{string, this.selectedOskel.getBriefDescription()};
            message.setOtherData(MessageFormat.format(TEXT_LABEL_OPTION, objectArray));
            this.callingNotebook.displayError(message);
            return false;
        }
        this.currentInputPanel.resetFields();
        return true;
    }

    private boolean deleteOption() {
        if (this.realOption != null && this.explicitOption) {
            this.newlyCreatedOptions.remove(this.realOption.getTag());
            ConfigItem configItem = this.realOption.getParent();
            if (configItem != null) {
                configItem.deleteChild(this.realOption);
            }
        }
        return true;
    }

    private void displayPrecis(OptionSkeleton optionSkeleton) {
        if (optionSkeleton == null) {
            return;
        }
        String string = optionSkeleton.getLongDescription();
        this.description.setText(string);
        if (this.description.getPeer() != null) {
            this.description.setCaretPosition(0);
        }
    }

    private void changeOrder(String string) {
        this.changeOrder(string, this.selectedOskel);
    }

    private void changeOrder(String string, OptionSkeleton optionSkeleton) {
        Vector<OptionSkeleton> vector = new Vector<OptionSkeleton>();
        if (string.equals(this.currentOrder) && this.currentVector.size() > 0) {
            return;
        }
        this.currentVector.removeAllElements();
        this.availableOptions.setVisible(false);
        this.availableOptions.removeItemListener(this);
        this.availableOptions.removeAll();
        this.availableOptions.addItemListener(this);
        if (string.equals(TEXT_USED)) {
            this.createUsedVectors();
            this.availableOptions.addItem(TEXT_LIST_ITEM_USED_HERE);
            this.buildOptionList(this.usedHere.elements(), optionSkeleton);
            Enumeration enumeration = PXEOptionSkeletonManager.getUnusedOptionSkeletons();
            while (enumeration.hasMoreElements()) {
                OptionSkeleton optionSkeleton2 = (OptionSkeleton)enumeration.nextElement();
                int n = Integer.parseInt(optionSkeleton2.getTag());
                if (n >= 6 && n <= 10) continue;
                vector.addElement(optionSkeleton2);
            }
            Enumeration enumeration2 = vector.elements();
            this.availableOptions.addItem(TEXT_LIST_ITEM_UNUSED);
            this.buildOptionList(enumeration2, optionSkeleton);
        } else if (string.equals(TEXT_BYTAG)) {
            Enumeration enumeration = PXEOptionSkeletonManager.getOptionSkeletonsByTag();
            this.buildOptionList(enumeration, optionSkeleton);
        } else {
            Enumeration enumeration = PXEOptionSkeletonManager.getOptionSkeletonsByAlphabet();
            this.buildOptionList(enumeration, optionSkeleton);
        }
        this.availableOptions.setVisible(true);
        this.currentOrder = string;
    }

    /*
     * Unable to fully structure code
     */
    private void createUsedVectors() {
        this.usedHere.removeAllElements();
        this.usedElsewhere.removeAllElements();
        var1_1 = PXEOptionSkeletonManager.getUsedOptionSkeletons();
        if (this.curItem != null) ** GOTO lbl15
        while (var1_1.hasMoreElements()) {
            this.usedElsewhere.addElement(var1_1.nextElement());
        }
        return;
lbl-1000:
        // 1 sources

        {
            var2_2 = (OptionSkeleton)var1_1.nextElement();
            var3_3 = this.curItem.getOption(var2_2.getTag());
            if (var3_3 != null) {
                this.usedHere.addElement(var2_2);
                continue;
            }
            this.usedElsewhere.addElement(var2_2);
lbl15:
            // 3 sources

            ** while (var1_1.hasMoreElements())
        }
lbl16:
        // 1 sources

    }

    private void buildOptionList(Enumeration enumeration, OptionSkeleton optionSkeleton) {
        while (enumeration.hasMoreElements()) {
            OptionSkeleton optionSkeleton2 = (OptionSkeleton)enumeration.nextElement();
            String string = this.buildOptionDescription(optionSkeleton2.getTag(), optionSkeleton2.getBriefDescription());
            this.availableOptions.addItem(string);
            if (optionSkeleton == optionSkeleton2) {
                this.availableOptions.select(this.availableOptions.getItemCount() - 1);
            }
            this.currentVector.addElement(optionSkeleton2);
        }
    }

    public void update(Observable observable, Object object) {
        if (!this.closingNotebook) {
            this.currentVector.removeAllElements();
            this.blankSelectedOption();
            this.changeOrder(this.currentOrder, (OptionSkeleton)observable);
            this.processSelectedAvailableOption();
        }
    }

    private void handleButton(Button button) {
        if (button == this.buttonDeleteOption) {
            this.deleteOption();
            if (this.realOption != null) {
                PXEOptionSkeletonManager.sortUsed();
                this.currentVector.removeAllElements();
                this.changeOrder(this.currentOrder);
                this.callingNotebook.somethingChanged();
            }
            this.currentInputPanel.resetFields();
            return;
        }
        if (button == this.buttonNew) {
            this.saveEnteredData();
            DefineOptionFrame defineOptionFrame = new DefineOptionFrame(this.callingNotebook, this.textFont, this.titleFont);
            defineOptionFrame.setVisible(true);
            return;
        }
        if (button == this.buttonEdit) {
            if (this.selectedOskel != null) {
                String string = this.selectedOskel.getTag();
                if (this.optionDefined(string)) {
                    Message message = new Message(ERROR_MODIFY_IN_USE);
                    Object[] objectArray = new Object[]{string, this.selectedOskel.getBriefDescription()};
                    message.setOtherData(MessageFormat.format(TEXT_LABEL_OPTION, objectArray));
                    this.callingNotebook.displayError(message);
                    return;
                }
                DefineOptionFrame defineOptionFrame = new DefineOptionFrame(this.callingNotebook, this.selectedOskel, this.textFont, this.titleFont);
                defineOptionFrame.setVisible(true);
                return;
            }
        } else if (button == this.buttonDelete) {
            if (this.selectedOskel == null) {
                return;
            }
            String string = this.selectedOskel.getTag();
            if (this.optionDefined(string)) {
                Message message = new Message(ERROR_DELETE_IN_USE);
                Object[] objectArray = new Object[]{string, this.selectedOskel.getBriefDescription()};
                message.setOtherData(MessageFormat.format(TEXT_LABEL_OPTION, objectArray));
                this.callingNotebook.displayError(message);
                return;
            }
            PXEOptionSkeletonManager.deleteOptionSkeleton(this.selectedOskel);
            this.currentVector.removeAllElements();
            this.blankSelectedOption();
            this.changeOrder(this.currentOrder);
        }
    }

    private boolean optionDefined(String string) {
        return Configuration.currentConfiguration.getWhetherOptionUsed(string) || this.newlyCreatedOptions.containsKey(string);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

