/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.ddnssgui.common.TcpipLocale;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.OptionSkeleton;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.OptionInputPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;

public class BootMenuListPanel
extends Panel
implements OptionInputPanel,
ActionListener,
KeyListener,
ItemListener {
    static final String copyright = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_REQUIRED_FIELDS = DHCPServerGUI.getResourceString("ERROR_REQUIRED_FIELDS");
    private static final String TEXT_BUTTON_ADD = DHCPServerGUI.getResourceString("TEXT_BUTTON_ADD");
    private static final String TEXT_BUTTON_REMOVE = DHCPServerGUI.getResourceString("TEXT_BUTTON_REMOVE");
    private OptionSkeleton skeleton;
    Label bootMenuListLabel;
    Label serverType;
    Label description;
    Choice newServerType;
    TextField newDescription;
    Button buttonAdd;
    Button buttonRemove;
    List bootMenuList;
    int selectedIndex = -1;
    String dataType;
    NotebookFrame callingNotebook;
    private static TcpipLocale thisLocale = DHCPServerGUI.getDHCPLocale();
    private static ResourceBundle thisBundle;
    private static final String bundleName = "COM.ibm.raleigh.dhcpsgui.resource.PXEOptionResources";

    private static String getResourceString(String string) {
        if (thisBundle == null && (thisBundle = ResourceBundle.getBundle(bundleName, TcpipLocale.getLocale())) == null) {
            throw new ShouldNotOccurException("The resource bundle for this locale cannot be found");
        }
        try {
            return thisBundle.getString(string);
        }
        catch (Exception exception) {
            System.err.println("OpSkel - getResourceString() for string " + string + " -- exception is <" + exception + ">");
            throw new ShouldNotOccurException();
        }
    }

    public BootMenuListPanel() {
        this.layoutPanel();
    }

    public void populate(String string) {
        this.resetFields();
        String string2 = "";
        String string3 = "";
        int n = 0;
        string = string.trim();
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        while (n2 > 0) {
            n = string.indexOf(" ");
            if (n < 0) break;
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
            string = string.trim();
            n3 = 0;
            while (string.charAt(n3) == '\"') {
                if (string.length() == ++n3) break;
            }
            string3 = string.substring(n3);
            n = (string3 = string3.trim()).indexOf("\"");
            if (n < 0) break;
            string3 = string3.substring(n);
            n4 = 0;
            while (string3.charAt(n4) == '\"') {
                if (string3.length() == ++n4) break;
            }
            if (n3 != n4) break;
            string3 = string.substring(1, n3 - 1 + n + n4);
            if (string2.length() > 0 && string3.length() > 0) {
                this.bootMenuList.addItem(String.valueOf(string2) + " " + string3);
            }
            string = string.substring(n + n3 + n4);
            string = string.trim();
            n2 = string.length();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.bootMenuList) {
            this.selectedIndex = this.bootMenuList.getSelectedIndex();
        }
    }

    public String getUserInput() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.bootMenuList.getItemCount();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            String string = this.bootMenuList.getItem(n3);
            if (string.length() > 0) {
                n2 = string.indexOf(" ");
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2);
                string3 = string3.trim();
                if (string2.length() > 0 && string3.length() > 0) {
                    stringBuffer.append(String.valueOf(string2) + " " + "\"" + string3 + "\"" + " ");
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public void resetFields() {
        this.bootMenuList.removeAll();
        this.newServerType.select(0);
        ((TextComponent)this.newDescription).setText("");
    }

    public void setFormat(OptionSkeleton optionSkeleton, Font font) {
        this.skeleton = optionSkeleton;
        this.dataType = optionSkeleton.getDatatype();
        Enumeration enumeration = optionSkeleton.getLabelSet();
        if (enumeration.hasMoreElements()) {
            this.serverType.setText((String)enumeration.nextElement());
        }
        if (enumeration.hasMoreElements()) {
            this.description.setText((String)enumeration.nextElement());
        }
    }

    public void setCaller(NotebookFrame notebookFrame) {
        this.callingNotebook = notebookFrame;
    }

    private void layoutPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.serverType = new Label(BootMenuListPanel.getResourceString("OPT8LL1"));
        this.add(this.serverType, gridBagLayout, gridBagConstraints, 0, 0, 1, 1);
        this.description = new Label(BootMenuListPanel.getResourceString("OPT8LL2"));
        this.add(this.description, gridBagLayout, gridBagConstraints, 1, 0, 0, 1);
        this.newServerType = new Choice();
        int n = 1;
        while (n < 11) {
            int n2 = n - 1;
            if (n == 10) {
                n = 65535;
                this.newServerType.add("(" + n + ")" + BootMenuListPanel.getResourceString("OPT8L" + n));
            } else {
                this.newServerType.add("(" + n2 + ")" + BootMenuListPanel.getResourceString("OPT8L" + n));
            }
            ++n;
        }
        this.add(this.newServerType, gridBagLayout, gridBagConstraints, 0, 1, 1, 1);
        this.newDescription = new TextField("Description");
        this.add(this.newDescription, gridBagLayout, gridBagConstraints, 1, 1, 0, 1);
        this.buttonAdd = new Button(TEXT_BUTTON_ADD);
        this.buttonAdd.setBackground(Color.lightGray);
        this.buttonAdd.addActionListener(this);
        this.buttonAdd.addKeyListener(this);
        gridBagConstraints.anchor = 15;
        this.add(this.buttonAdd, gridBagLayout, gridBagConstraints, 0, 2, 0, 1);
        gridBagConstraints.anchor = 17;
        this.bootMenuListLabel = new Label();
        gridBagConstraints.anchor = 17;
        this.add(this.bootMenuListLabel, gridBagLayout, gridBagConstraints, 0, 3, 0, 1);
        this.bootMenuList = new List(3, false);
        this.bootMenuList.addItemListener(this);
        gridBagConstraints.fill = 2;
        this.add(this.bootMenuList, gridBagLayout, gridBagConstraints, 0, 4, 0, 2);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.buttonRemove = new Button(TEXT_BUTTON_REMOVE);
        this.buttonRemove.setBackground(Color.lightGray);
        this.buttonRemove.addActionListener(this);
        this.buttonRemove.addKeyListener(this);
        this.add(this.buttonRemove, gridBagLayout, gridBagConstraints, 0, 6, 0, 0);
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void handleButton(Button button) {
        if (button == this.buttonAdd) {
            int n = this.newServerType.getSelectedIndex();
            String string = this.newDescription.getText();
            int n2 = string.trim().length();
            if (n2 == 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(BootMenuListPanel.getResourceString("OPT9L2"));
                Object[] objectArray = new Object[]{stringBuffer.toString()};
                Message message = new Message(MessageFormat.format(ERROR_REQUIRED_FIELDS, objectArray));
                this.callingNotebook.displayError(message);
                return;
            }
            if (n == 9) {
                n = 65535;
            }
            this.bootMenuList.addItem(String.valueOf(n) + " " + string);
            this.newServerType.select(0);
            ((TextComponent)this.newDescription).setText("");
            return;
        }
        if (button == this.buttonRemove && this.bootMenuList != null && this.selectedIndex >= 0) {
            this.bootMenuList.delItem(this.selectedIndex);
            this.selectedIndex = -1;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

