/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.Client;
import COM.ibm.raleigh.dhcpsgui.biz.CommonClient;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.notebook.IPAddressField;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.TextFieldWithTab;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public class ClientInfoPanel
extends NotebookPanel
implements ItemListener,
KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_CLIENTNAME = DHCPServerGUI.getResourceString("TEXT_CLIENTNAME");
    private static final String TEXT_ID = DHCPServerGUI.getResourceString("TEXT_ID");
    private static final String TEXT_TYPE = DHCPServerGUI.getResourceString("TEXT_TYPE");
    private static final String TEXT_ID_AND_TYPE = DHCPServerGUI.getResourceString("TEXT_ID_AND_TYPE");
    private static final String TEXT_SCOPE = DHCPServerGUI.getResourceString("TEXT_SCOPE");
    private static final String TEXT_ADDRESS = DHCPServerGUI.getResourceString("TEXT_ADDRESS");
    private static final String TEXT_ASSIGN_ANY = DHCPServerGUI.getResourceString("TEXT_ASSIGN_ANY");
    private static final String TEXT_ASSIGN_ADDR = DHCPServerGUI.getResourceString("TEXT_ASSIGN_ADDR");
    private TextFieldWithTab name;
    private TextFieldWithTab clientID;
    private Choice hwtype;
    private Choice scope;
    private IPAddressField address;
    private Checkbox anyRadiobutton;
    private Checkbox assignRadiobutton;
    private CheckboxGroup radiobuttons;
    private ConfigItem parent = null;
    private Client client = null;
    private NotebookFrame parentFrame = null;
    private Vector scopeObjects;
    private boolean existingClient;
    private Global global;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints gbc = new GridBagConstraints();

    public ClientInfoPanel() {
        this.scopeObjects = new Vector();
    }

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.client = (Client)configItem;
        this.parentFrame = notebookFrame;
        this.parent = this.parentFrame.getItemParent();
        this.global = this.parentFrame.getGlobal();
        this.remove(this.scope);
        this.scope = null;
        if (this.parentFrame.isNewItem()) {
            this.existingClient = false;
            return;
        }
        this.existingClient = true;
    }

    public void populatePanel() {
        if (this.client.getAlias() != null) {
            ((TextComponent)this.name).setText(this.client.getAlias());
        } else {
            ((TextComponent)this.name).setText("");
        }
        if (this.client.getIdValue() != null) {
            ((TextComponent)this.clientID).setText(this.client.getIdValue());
        } else {
            ((TextComponent)this.clientID).setText("");
        }
        this.hwtype.select(this.client.getIdType());
        String string = this.client.getAddress();
        if (string == null) {
            this.address.setText("");
            this.radiobuttons.setSelectedCheckbox(this.anyRadiobutton);
            this.address.setEditable(false);
        } else if (string.equals("ANY")) {
            this.address.setText("");
            this.radiobuttons.setSelectedCheckbox(this.anyRadiobutton);
            this.address.setEditable(false);
        } else {
            this.radiobuttons.setSelectedCheckbox(this.assignRadiobutton);
            this.address.setEditable(true);
            this.address.setText(string);
        }
        this.scope = new Choice();
        if (this.populateScopeChoice(this.scope, this.global, this.client, this.parent, this.existingClient)) {
            this.parentFrame.setItemParent(this.parent);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox) {
            this.handleCheckbox((Checkbox)object);
        }
    }

    public boolean saveState() {
        if (this.existingClient) {
            this.parentFrame.setItemParent(this.parent);
        } else {
            this.parentFrame.setItemParent(this.getScopeParent());
        }
        this.parent = this.parentFrame.getItemParent();
        Message message = this.client.setAlias(this.name.getText());
        if (message != null) {
            message.setLocation(TEXT_CLIENTNAME);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.client.setIdValue(this.clientID.getText());
        if (message != null) {
            message.setLocation(TEXT_ID);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.client.setIdTypeUsingIndex(this.hwtype.getSelectedIndex());
        if (message != null) {
            message.setLocation(TEXT_TYPE);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.client.validateIDAndType(this.parent);
        if (message != null) {
            message.setLocation(TEXT_ID_AND_TYPE);
            this.parentFrame.displayError(message);
            return false;
        }
        if (this.radiobuttons.getSelectedCheckbox() == this.anyRadiobutton) {
            message = this.client.setAddress("ANY");
            if (message != null) {
                message.setLocation(TEXT_ASSIGN_ANY);
                this.parentFrame.displayError(message);
                return false;
            }
        } else {
            message = this.client.setAddress(this.address.getText());
            if (message == null) {
                message = this.client.validateAddress(this.parent);
            }
            if (message != null) {
                message.setLocation(TEXT_ASSIGN_ADDR);
                this.parentFrame.displayError(message);
                return false;
            }
        }
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        ((Component)this).setFont(font);
        this.setLayout(this.gbl);
        Label label = new Label(TEXT_CLIENTNAME);
        Label label2 = new Label(TEXT_ID);
        Label label3 = new Label(TEXT_TYPE);
        new Label(TEXT_SCOPE);
        Label label4 = new Label(TEXT_ADDRESS);
        this.name = new TextFieldWithTab(15);
        this.clientID = new TextFieldWithTab(15);
        this.address = new IPAddressField();
        this.hwtype = new Choice();
        this.scope = new Choice();
        String[] stringArray = CommonClient.getTypeList();
        int n = 0;
        while (n < stringArray.length) {
            this.hwtype.addItem(stringArray[n]);
            ++n;
        }
        this.radiobuttons = new CheckboxGroup();
        this.anyRadiobutton = new Checkbox(TEXT_ASSIGN_ANY, this.radiobuttons, true);
        this.anyRadiobutton.setBackground(Color.lightGray);
        this.anyRadiobutton.addItemListener(this);
        this.anyRadiobutton.addKeyListener(this);
        this.assignRadiobutton = new Checkbox(TEXT_ASSIGN_ADDR, this.radiobuttons, false);
        this.assignRadiobutton.addItemListener(this);
        this.assignRadiobutton.addKeyListener(this);
        this.assignRadiobutton.setBackground(Color.lightGray);
        this.gbc.fill = 0;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.anchor = 12;
        this.gbl.setConstraints(label, this.gbc);
        this.add(label);
        this.gbc.gridx = 2;
        this.gbc.gridwidth = 0;
        this.gbc.anchor = 18;
        this.gbl.setConstraints(this.name, this.gbc);
        this.add(this.name);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.anchor = 12;
        this.gbl.setConstraints(label3, this.gbc);
        this.add(label3);
        this.gbc.gridx = 2;
        this.gbc.gridwidth = 0;
        this.gbc.anchor = 18;
        this.gbl.setConstraints(this.hwtype, this.gbc);
        this.add(this.hwtype);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.anchor = 12;
        this.gbl.setConstraints(label2, this.gbc);
        this.add(label2);
        this.gbc.gridx = 2;
        this.gbc.gridwidth = 0;
        this.gbc.anchor = 18;
        this.gbl.setConstraints(this.clientID, this.gbc);
        this.add(this.clientID);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.anchor = 12;
        this.gbc.fill = 0;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.gbl.setConstraints(label4, this.gbc);
        this.add(label4);
        this.gbc.gridx = 2;
        this.gbc.gridwidth = 0;
        this.gbc.anchor = 18;
        this.gbl.setConstraints(this.anyRadiobutton, this.gbc);
        this.add(this.anyRadiobutton);
        this.gbc.gridx = 2;
        this.gbc.gridy = 4;
        this.gbc.gridwidth = 1;
        this.gbl.setConstraints(this.assignRadiobutton, this.gbc);
        this.add(this.assignRadiobutton);
        this.gbc.gridx = -1;
        this.gbc.gridwidth = 0;
        this.gbc.anchor = 12;
        this.gbl.setConstraints(this.address, this.gbc);
        this.add(this.address);
    }

    private void handleCheckbox(Checkbox checkbox) {
        if (checkbox == this.anyRadiobutton) {
            this.address.setEditable(false);
            return;
        }
        if (checkbox == this.assignRadiobutton) {
            this.address.setEditable(true);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Checkbox) {
            Checkbox checkbox;
            checkbox.setState(!(checkbox = (Checkbox)object).getState());
            this.handleCheckbox(checkbox);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

