/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItemWithExcludedAddresses;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.notebook.IPAddressField;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;

public class ExcludedAddrPanel
extends NotebookPanel
implements ActionListener,
KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_EXCLUDED_ADDRESS_RANGE = DHCPServerGUI.getResourceString("TEXT_EXCLUDED_ADDRESS_RANGE");
    private static final String TEXT_EXCLUDED_ADDRESS = DHCPServerGUI.getResourceString("TEXT_EXCLUDED_ADDRESS");
    private static final String TEXT_FROM = DHCPServerGUI.getResourceString("TEXT_FROM");
    private static final String TEXT_ENTER_IP_ADDRESS = DHCPServerGUI.getResourceString("TEXT_ENTER_IP_ADDRESS");
    private static final String TEXT_TO = DHCPServerGUI.getResourceString("TEXT_TO");
    private static final String TEXT_EXCLUSION_LIST = DHCPServerGUI.getResourceString("TEXT_EXCLUSION_LIST");
    private static final String TEXT_ADD = DHCPServerGUI.getResourceString("TEXT_BUTTON_ADD");
    private static final String TEXT_REMOVE = DHCPServerGUI.getResourceString("TEXT_BUTTON_REMOVE");
    private Button buttonAdd;
    private Button buttonRemove;
    private List exclusionList;
    private IPAddressField excludeFrom;
    private IPAddressField excludeTo;
    private Label excludeFromLabel;
    private Label excludeToLabel;
    private ConfigItemWithExcludedAddresses item;
    private NotebookFrame parentFrame;
    private NotebookPanel info;
    private boolean validsubnet = false;

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.item = (ConfigItemWithExcludedAddresses)configItem;
        this.parentFrame = notebookFrame;
        this.enableRange();
    }

    public void populatePanel() {
        this.refreshList();
    }

    public void setInfoPanel(NotebookPanel notebookPanel) {
        this.info = notebookPanel;
    }

    public void disableRange() {
        this.excludeFrom.setEditable(true);
        this.excludeFromLabel.setText(TEXT_ENTER_IP_ADDRESS);
        this.excludeToLabel.setVisible(false);
        this.excludeTo.setVisible(false);
    }

    private void enableRange() {
        this.excludeFrom.setEditable(true);
        this.excludeFromLabel.setText(TEXT_FROM);
        this.excludeToLabel.setVisible(true);
        this.excludeTo.setVisible(true);
        this.excludeTo.setEditable(true);
    }

    private void refreshList() {
        this.excludeFrom.setText("");
        this.excludeTo.setText("");
        this.exclusionList.removeAll();
        Enumeration enumeration = this.item.getExcludedAddresses();
        while (enumeration.hasMoreElements()) {
            this.exclusionList.addItem(enumeration.nextElement().toString());
        }
    }

    public boolean saveState() {
        Message message;
        this.processAddButton();
        if (this.item instanceof Subnetwork && (message = ((Subnetwork)this.item).validateAllExcludedAddresses()) != null) {
            message.setLocation(TEXT_EXCLUSION_LIST);
            this.parentFrame.displayError(message);
            return false;
        }
        return true;
    }

    public void processAddButton() {
        this.parentFrame.somethingChanged();
        if (this.excludeTo.isEditable()) {
            if (this.info != null && !(this.validsubnet = this.info.saveState())) {
                return;
            }
        } else {
            if (!this.excludeFrom.getText().equals("")) {
                Message message = this.item.addExcludedAddress(this.excludeFrom.getText());
                if (message != null) {
                    message.setLocation(TEXT_EXCLUDED_ADDRESS);
                    this.parentFrame.displayError(message);
                }
                this.refreshList();
            }
            return;
        }
        if (!this.excludeFrom.getText().equals("") && this.excludeTo.getText().equals(this.excludeFrom.getText())) {
            Message message = this.item.addExcludedAddress(this.excludeFrom.getText());
            if (message != null) {
                message.setLocation(TEXT_EXCLUDED_ADDRESS);
                this.parentFrame.displayError(message);
            }
            this.refreshList();
            return;
        }
        if (!this.excludeFrom.getText().equals("") && !this.excludeTo.getText().equals("")) {
            Message message = this.item.addExcludedAddresses(this.excludeFrom.getText(), this.excludeTo.getText());
            if (message != null) {
                message.setLocation(TEXT_EXCLUDED_ADDRESS_RANGE);
                this.parentFrame.displayError(message);
            }
            this.refreshList();
            return;
        }
        if (!this.excludeFrom.getText().equals("") && this.excludeTo.getText().equals("")) {
            Message message = this.item.addExcludedAddress(this.excludeFrom.getText());
            if (message != null) {
                message.setLocation(TEXT_EXCLUDED_ADDRESS);
                this.parentFrame.displayError(message);
            }
            this.refreshList();
            return;
        }
        if (this.excludeFrom.getText().equals("") && !this.excludeTo.getText().equals("")) {
            Message message = this.item.addExcludedAddress(this.excludeTo.getText());
            if (message != null) {
                message.setLocation(TEXT_EXCLUDED_ADDRESS);
                this.parentFrame.displayError(message);
            }
            this.refreshList();
        }
    }

    public void layoutPanel(Font font, Font font2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.excludeFromLabel = new Label(TEXT_FROM);
        this.excludeToLabel = new Label(TEXT_TO);
        Label label = new Label(TEXT_EXCLUSION_LIST);
        this.excludeFrom = new IPAddressField();
        this.excludeTo = new IPAddressField();
        this.buttonAdd = new Button(TEXT_ADD);
        this.buttonAdd.setBackground(Color.lightGray);
        this.buttonRemove = new Button(TEXT_REMOVE);
        this.buttonRemove.setBackground(Color.lightGray);
        this.exclusionList = new List(3, false);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(this.excludeFromLabel, gridBagConstraints);
        this.add(this.excludeFromLabel);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.excludeFrom, gridBagConstraints);
        this.add(this.excludeFrom);
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(this.excludeToLabel, gridBagConstraints);
        this.add(this.excludeToLabel);
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.excludeTo, gridBagConstraints);
        this.add(this.excludeTo);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.buttonAdd, gridBagConstraints);
        this.buttonAdd.addActionListener(this);
        this.buttonAdd.addKeyListener(this);
        this.add(this.buttonAdd);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.exclusionList, gridBagConstraints);
        this.add(this.exclusionList);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.buttonRemove, gridBagConstraints);
        this.buttonRemove.addActionListener(this);
        this.buttonRemove.addKeyListener(this);
        this.add(this.buttonRemove);
    }

    private void handleButton(Button button) {
        if (button == this.buttonAdd) {
            this.processAddButton();
            return;
        }
        if (button == this.buttonRemove && this.exclusionList.getSelectedIndex() != -1) {
            this.parentFrame.somethingChanged();
            this.item.deleteExcludedAddress(this.exclusionList.getSelectedItem());
            this.refreshList();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

