/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.CommonClient;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.ExcludedClient;
import COM.ibm.raleigh.dhcpsgui.biz.Global;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.TextFieldWithTab;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class ExcludedClientDefinitionPanel
extends NotebookPanel
implements KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_CLIENTNAME = DHCPServerGUI.getResourceString("TEXT_CLIENTNAME");
    private static final String TEXT_ID = DHCPServerGUI.getResourceString("TEXT_ID");
    private static final String TEXT_TYPE = DHCPServerGUI.getResourceString("TEXT_TYPE");
    private static final String TEXT_ID_AND_TYPE = DHCPServerGUI.getResourceString("TEXT_ID_AND_TYPE");
    private static final String TEXT_SCOPE = DHCPServerGUI.getResourceString("TEXT_SCOPE");
    private static final String TEXT_COMMENT = DHCPServerGUI.getResourceString("TEXT_COMMENT");
    private ExcludedClient client = null;
    private NotebookFrame parentFrame = null;
    private ConfigItem parent;
    private Global global;
    private TextFieldWithTab name;
    private TextFieldWithTab clientID;
    private Choice scope;
    private Choice hwtype;
    private TextArea comment;
    private boolean existingClient;
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints gbc = new GridBagConstraints();

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.client = (ExcludedClient)configItem;
        this.parentFrame = notebookFrame;
        this.parent = this.parentFrame.getItemParent();
        this.global = this.parentFrame.getGlobal();
        this.remove(this.scope);
        this.scope = null;
        this.comment.setText("");
        if (this.parentFrame.isNewItem()) {
            this.existingClient = false;
            return;
        }
        this.existingClient = true;
    }

    public void populatePanel() {
        if (this.client.getAlias() != null) {
            ((TextComponent)this.name).setText(this.client.getAlias());
        } else {
            ((TextComponent)this.name).setText("");
        }
        if (this.client.getIdValue() != null) {
            ((TextComponent)this.clientID).setText(this.client.getIdValue());
        } else {
            ((TextComponent)this.clientID).setText("");
        }
        this.hwtype.select(this.client.getIdType());
        this.scope = new Choice();
        if (this.populateScopeChoice(this.scope, this.global, this.client, this.parent, this.existingClient)) {
            this.parentFrame.setItemParent(this.parent);
        }
        this.gbc.gridx = 2;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 0;
        this.gbc.anchor = 18;
        this.gbc.fill = 0;
        this.gbl.setConstraints(this.scope, this.gbc);
        String string = this.client.getComment();
        if (string != null) {
            this.comment.setText(string);
        }
    }

    public boolean saveState() {
        if (this.existingClient) {
            this.parentFrame.setItemParent(this.parent);
        } else {
            this.parentFrame.setItemParent(this.getScopeParent());
        }
        this.parent = this.parentFrame.getItemParent();
        Message message = this.client.setAlias(this.name.getText());
        if (message != null) {
            message.setLocation(TEXT_CLIENTNAME);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.client.setIdValue(this.clientID.getText());
        if (message != null) {
            message.setLocation(TEXT_ID);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.client.setIdTypeUsingIndex(this.hwtype.getSelectedIndex());
        if (message != null) {
            message.setLocation(TEXT_TYPE);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.client.validateIDAndType(this.parent);
        if (message != null) {
            message.setLocation(TEXT_ID_AND_TYPE);
            this.parentFrame.displayError(message);
            return false;
        }
        this.client.setComment(this.comment.getText());
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        ((Component)this).setFont(font);
        this.setLayout(this.gbl);
        this.name = new TextFieldWithTab(15);
        this.clientID = new TextFieldWithTab(15);
        this.comment = new TextArea("", 3, 60);
        this.comment.addKeyListener(this);
        this.hwtype = new Choice();
        this.scope = new Choice();
        String[] stringArray = CommonClient.getTypeList();
        int n = 0;
        while (n < stringArray.length) {
            this.hwtype.addItem(stringArray[n]);
            ++n;
        }
        Label label = new Label(TEXT_CLIENTNAME);
        Label label2 = new Label(TEXT_ID);
        Label label3 = new Label(TEXT_TYPE);
        Label label4 = new Label(TEXT_SCOPE);
        Label label5 = new Label(TEXT_COMMENT);
        this.gbc.fill = 0;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.anchor = 12;
        this.gbl.setConstraints(label, this.gbc);
        this.add(label);
        this.gbc.gridx = 2;
        this.gbc.gridwidth = 0;
        this.gbc.anchor = 18;
        this.gbl.setConstraints(this.name, this.gbc);
        this.add(this.name);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.anchor = 12;
        this.gbl.setConstraints(label3, this.gbc);
        this.add(label3);
        this.gbc.gridx = 2;
        this.gbc.gridwidth = 0;
        this.gbc.anchor = 18;
        this.gbl.setConstraints(this.hwtype, this.gbc);
        this.add(this.hwtype);
        this.gbc.gridx = 0;
        this.gbc.gridy = 2;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.anchor = 12;
        this.gbl.setConstraints(label2, this.gbc);
        this.add(label2);
        this.gbc.gridx = 2;
        this.gbc.gridwidth = 0;
        this.gbc.anchor = 18;
        this.gbl.setConstraints(this.clientID, this.gbc);
        this.add(this.clientID);
        this.gbc.gridx = 0;
        this.gbc.gridy = 3;
        this.gbc.gridwidth = 1;
        this.gbc.gridheight = 1;
        this.gbc.anchor = 12;
        this.gbl.setConstraints(label4, this.gbc);
        this.gbc.gridx = 2;
        this.gbc.gridwidth = 0;
        this.gbc.anchor = 18;
        this.gbl.setConstraints(this.scope, this.gbc);
        this.gbc.gridx = 0;
        this.gbc.gridy = 4;
        this.gbc.gridwidth = 1;
        this.gbc.anchor = 12;
        this.gbl.setConstraints(label5, this.gbc);
        this.add(label5);
        this.gbc.gridx = -1;
        this.gbc.gridwidth = 0;
        this.gbc.anchor = 18;
        this.gbc.fill = 2;
        this.gbl.setConstraints(this.comment, this.gbc);
        this.add(this.comment);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 9 && object instanceof TextArea) {
            this.transferFocus();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

