/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.OptionValidator;
import COM.ibm.raleigh.dhcpsgui.notebook.ArchOptionsPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.ItemListPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.IntegerSorter;
import java.awt.List;
import java.awt.TextField;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class IntegerListPanel
extends ItemListPanel {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_LABEL_ADD_INTEGER = DHCPServerGUI.getResourceString("TEXT_LABEL_ADD_MTU_SIZE");
    private static final String TEXT_LABEL_INTEGER_LIST = DHCPServerGUI.getResourceString("TEXT_LABEL_MTU_LIST");
    private TextField newIntegerItem = new TextField(20);
    private String currentText = "";
    private String tag = "";

    public IntegerListPanel() {
        super(TEXT_LABEL_ADD_INTEGER, TEXT_LABEL_INTEGER_LIST);
        super.layoutPanel();
    }

    protected TextField getEntryField() {
        return this.newIntegerItem;
    }

    public void populate(String string) {
        super.populate(string);
        this.currentText = string;
        this.itemList.removeAll();
        if (string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        IntegerSorter integerSorter = new IntegerSorter(vector.elements());
        Enumeration enumeration = integerSorter.elements();
        while (enumeration.hasMoreElements()) {
            this.itemList.addItem((String)enumeration.nextElement());
        }
    }

    protected boolean addItemToList(String string, List list) {
        Message message = (Message)OptionValidator.validateOption(this.oSkel.getTag(), string, null);
        if (message != null) {
            message.setLocation(String.valueOf(ArchOptionsPanel.TEXT_LOCATION_FOR_OPTION) + this.tag);
            this.callingNotebook.displayError(message);
            return false;
        }
        this.currentText = String.valueOf(this.currentText) + " " + string;
        if (string.length() == 0) {
            return true;
        }
        list.removeAll();
        StringTokenizer stringTokenizer = new StringTokenizer(this.currentText.trim(), " ");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        IntegerSorter integerSorter = new IntegerSorter(vector.elements());
        Enumeration enumeration = integerSorter.elements();
        while (enumeration.hasMoreElements()) {
            list.addItem((String)enumeration.nextElement());
        }
        return true;
    }

    public void resetFields() {
        super.resetFields();
        this.currentText = "";
    }

    protected void removeItemFromList(int n, List list) {
        list.delItem(this.selectedIndex);
        this.currentText = super.getUserInput();
    }
}

