/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.OptionSkeleton;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.OptionInputPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.StringTokenizer;

public abstract class ItemListPanel
extends Panel
implements OptionInputPanel,
ActionListener,
KeyListener,
ItemListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_BUTTON_ADD = DHCPServerGUI.getResourceString("TEXT_BUTTON_ADD");
    private static final String TEXT_BUTTON_REMOVE = DHCPServerGUI.getResourceString("TEXT_BUTTON_REMOVE");
    private static final String TEXT_LIST = DHCPServerGUI.getResourceString("TEXT_LIST");
    private String addLabelText;
    private String listLabelText;
    private Label itemListLabel;
    private Label itemLabel;
    private Button buttonAdd;
    private Button buttonRemove;
    protected List itemList;
    private TextField newItem;
    int selectedIndex = -1;
    protected OptionSkeleton oSkel;
    String dataType = "";
    protected NotebookFrame callingNotebook;

    public ItemListPanel(String string, String string2) {
        this.addLabelText = string;
        this.listLabelText = string2;
    }

    protected abstract TextField getEntryField();

    protected boolean addItemToList(String string, List list) {
        list.addItem(string);
        return true;
    }

    public void populate(String string) {
        this.resetFields();
        if (string.length() == 0) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            this.itemList.addItem(stringTokenizer.nextToken());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.selectedIndex = this.itemList.getSelectedIndex();
    }

    public String getUserInput() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.newItem.getText();
        int n = this.itemList.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(String.valueOf(this.itemList.getItem(n2)) + " ");
            ++n2;
        }
        if (string.trim().length() > 0) {
            stringBuffer.append(string.trim());
        }
        return stringBuffer.toString();
    }

    public void resetFields() {
        this.itemList.removeItemListener(this);
        this.itemList.removeAll();
        ((TextComponent)this.newItem).setText("");
        this.itemList.addItemListener(this);
    }

    public void setFormat(OptionSkeleton optionSkeleton, Font font) {
        this.oSkel = optionSkeleton;
        this.dataType = optionSkeleton.getDatatype();
    }

    protected void removeItemFromList(int n, List list) {
        list.delItem(n);
    }

    public void setCaller(NotebookFrame notebookFrame) {
        this.callingNotebook = notebookFrame;
    }

    protected void layoutPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.itemLabel = new Label(this.addLabelText);
        this.newItem = this.getEntryField();
        this.itemListLabel = new Label(this.listLabelText);
        this.itemList = new List(3, false);
        this.itemList.addItemListener(this);
        this.buttonAdd = new Button(TEXT_BUTTON_ADD);
        this.buttonAdd.setBackground(Color.lightGray);
        this.buttonRemove = new Button(TEXT_BUTTON_REMOVE);
        this.buttonRemove.setBackground(Color.lightGray);
        this.buttonAdd.addActionListener(this);
        this.buttonAdd.addKeyListener(this);
        this.buttonRemove.addActionListener(this);
        this.buttonRemove.addKeyListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.itemLabel, gridBagConstraints);
        this.add(this.itemLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.newItem, gridBagConstraints);
        this.add(this.newItem);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.buttonAdd, gridBagConstraints);
        this.add(this.buttonAdd);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.itemListLabel, gridBagConstraints);
        this.add(this.itemListLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.itemList, gridBagConstraints);
        this.add(this.itemList);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.buttonRemove, gridBagConstraints);
        this.add(this.buttonRemove);
    }

    private void handleButton(Button button) {
        if (button == this.buttonAdd) {
            String string = this.newItem.getText();
            boolean bl = this.addItemToList(string, this.itemList);
            if (bl) {
                ((TextComponent)this.newItem).setText("");
                return;
            }
        } else if (button == this.buttonRemove && this.itemList != null && this.selectedIndex >= 0) {
            this.removeItemFromList(this.selectedIndex, this.itemList);
            this.selectedIndex = -1;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

