/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.ddnssgui.common.WrappedTextPanel;
import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.LSA1Group;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.NetworkInterfaceType;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public class LSA1GroupDefinitionPanel
extends NotebookPanel
implements KeyListener,
ItemListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_LSA1_GROUPNAME_LABEL = DHCPServerGUI.getResourceString("TEXT_LSA1_GROUPNAME_LABEL");
    private static final String TEXT_LSA1_GROUPNAME_BOX_LABEL = DHCPServerGUI.getResourceString("TEXT_LSA1_GROUPNAME_BOX_LABEL");
    private static final String TEXT_NETWORK_INTERFACE_LABEL = DHCPServerGUI.getResourceString("TEXT_NETWORK_INTERFACE_LABEL");
    private static final String TEXT_COMMENT = DHCPServerGUI.getResourceString("TEXT_COMMENT");
    private static final String TEXT_DUPLICATE_LSA1GROUP = DHCPServerGUI.getResourceString("TEXT_DUPLICATE_LSA1GROUP");
    private NotebookFrame parentFrame;
    private NotebookPanel info;
    private WrappedTextPanel infoPanel;
    private TextField LSA1GroupNameField;
    private Label LSA1GroupNameLabel;
    private Panel LSA1GroupNamePanel;
    private Choice NITChoice;
    private Label NITLabel;
    private Font theTextFont;
    private Font theTitleFont;
    private TextArea comment;
    private Label commentLabel;
    private LSA1Group lsa1Group = null;
    private NetworkInterfaceType nitType = new NetworkInterfaceType();
    private String nic = String.valueOf(1);
    private BINLGlobal glob;

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.parentFrame = notebookFrame;
        this.lsa1Group = (LSA1Group)configItem;
        this.comment.setText("");
        this.glob = this.parentFrame.getBINLGlobal();
    }

    public void populatePanel() {
        String string;
        if (this.lsa1Group.getAlias() != null) {
            ((TextComponent)this.LSA1GroupNameField).setText(this.lsa1Group.getAlias());
        } else {
            ((TextComponent)this.LSA1GroupNameField).setText("");
        }
        if (this.lsa1Group.getNic() != null) {
            this.NITChoice.select(this.lsa1Group.getNicAsInt() - 1);
        }
        if ((string = this.lsa1Group.getComment()) != null) {
            this.comment.setText(string);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n = ((Choice)itemEvent.getItemSelectable()).getSelectedIndex();
        this.nic = String.valueOf(n + 1);
    }

    public boolean saveState() {
        Message message = this.lsa1Group.setAlias(this.LSA1GroupNameField.getText());
        if (message != null) {
            message.setLocation(TEXT_LSA1_GROUPNAME_LABEL);
            this.parentFrame.displayError(message);
            return false;
        }
        LSA1Group lSA1Group = this.lsa1Group.getADuplicateLSA1Group(this.glob, this.nic);
        if (lSA1Group != null) {
            message = new Message(TEXT_DUPLICATE_LSA1GROUP);
            message.setLocation(TEXT_NETWORK_INTERFACE_LABEL);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.lsa1Group.setNic(this.nic);
        if (message != null) {
            message.setLocation(TEXT_LSA1_GROUPNAME_LABEL);
            this.parentFrame.displayError(message);
            return false;
        }
        this.lsa1Group.setComment(this.comment.getText());
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        this.theTextFont = font;
        this.theTitleFont = font2;
        this.initComponents();
        this.addComponentsToGrid();
    }

    private void initComponents() {
        this.infoPanel = new WrappedTextPanel(TEXT_LSA1_GROUPNAME_BOX_LABEL);
        this.LSA1GroupNameField = new TextField(25);
        this.LSA1GroupNameLabel = new Label(TEXT_LSA1_GROUPNAME_LABEL);
        this.LSA1GroupNamePanel = new Panel();
        this.NITChoice = new Choice();
        this.NITLabel = new Label(TEXT_NETWORK_INTERFACE_LABEL);
        this.comment = new TextArea("", 5, 60);
        this.commentLabel = new Label(TEXT_COMMENT);
        this.comment.addKeyListener(this);
        this.NITChoice.addItemListener(this);
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = this.infoPanel.getNumDividedTextLines();
        this.setLayout(gridBagLayout);
        ((Component)this).setFont(this.theTextFont);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.LSA1GroupNamePanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        this.constrain(this.LSA1GroupNameLabel, gridBagLayout, gridBagConstraints, 0, n, 1, 1);
        this.LSA1GroupNamePanel.add(this.LSA1GroupNameLabel);
        this.constrain(this.LSA1GroupNameField, gridBagLayout, gridBagConstraints, 1, n, 1, 1);
        this.LSA1GroupNamePanel.add(this.LSA1GroupNameField);
        this.constrain(this.NITLabel, gridBagLayout, gridBagConstraints, 0, 1 + n, 1, 1);
        this.LSA1GroupNamePanel.add(this.NITLabel);
        this.constrain(this.NITChoice, gridBagLayout, gridBagConstraints, 1, 1 + n, 1, 1);
        this.LSA1GroupNamePanel.add(this.NITChoice);
        gridBagConstraints.anchor = 17;
        this.constrain(this.commentLabel, gridBagLayout, gridBagConstraints, 0, 2 + n, 1, 1);
        this.LSA1GroupNamePanel.add(this.commentLabel);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.constrain(this.comment, gridBagLayout, gridBagConstraints, -1, 2 + n, 0, 1);
        this.LSA1GroupNamePanel.add(this.comment);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.ipady = 40;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.constrain(this.LSA1GroupNamePanel, gridBagLayout, gridBagConstraints, 0, 0, 1, 1);
        this.add(this.LSA1GroupNamePanel);
        Vector vector = this.nitType.getAllNITTypes();
        int n2 = 0;
        while (n2 < NetworkInterfaceType.numberOfNITTypes) {
            String string = n2 < 9 ? "(  " + (n2 + 1) + ")  " : "(" + (n2 + 1) + ")  ";
            this.NITChoice.addItem(String.valueOf(string) + (String)vector.elementAt(n2));
            ++n2;
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 9 && object instanceof TextArea) {
            this.transferFocus();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }
}

