/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Lease;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Option;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.TimeInterval;
import COM.ibm.raleigh.dhcpsgui.notebook.LeaseEntryPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class LeaseAndCommentPanel
extends NotebookPanel
implements ItemListener,
KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_COMMENT_LABEL = DHCPServerGUI.getResourceString("TEXT_COMMENT_LABEL");
    private static final String TEXT_FINITE_LABEL = DHCPServerGUI.getResourceString("TEXT_FINITE_LABEL");
    private static final String TEXT_DEFAULT_LABEL = DHCPServerGUI.getResourceString("TEXT_DEFAULT_LABEL");
    private static final String TEXT_INFINITE_LABEL = DHCPServerGUI.getResourceString("TEXT_INFINITE_LABEL");
    private static final String TEXT_LOCATION_FINITE_LABEL = DHCPServerGUI.getResourceString("TEXT_LOCATION_FINITE_LABEL");
    private static final String TEXT_LOCATION_DEFAULT_LABEL = DHCPServerGUI.getResourceString("TEXT_LOCATION_DEFAULT_LABEL");
    private static final String TEXT_LOCATION_INFINITE_LABEL = DHCPServerGUI.getResourceString("TEXT_LOCATION_INFINITE_LABEL");
    private static final String TEXT_NO_DEFAULT_LABEL = DHCPServerGUI.getResourceString("TEXT_NO_DEFAULT_LABEL");
    private static final String TEXT_INFINITE_DEFAULT_LABEL = DHCPServerGUI.getResourceString("TEXT_INFINITE_DEFAULT_LABEL");
    private static final String TEXT_YEARS = DHCPServerGUI.getResourceString("TEXT_YEARS");
    private static final String TEXT_MONTHS = DHCPServerGUI.getResourceString("TEXT_MONTHS");
    private static final String TEXT_DAYS = DHCPServerGUI.getResourceString("TEXT_DAYS");
    private static final String TEXT_HOURS = DHCPServerGUI.getResourceString("TEXT_HOURS");
    private static final String TEXT_MINUTES = DHCPServerGUI.getResourceString("TEXT_MINUTES");
    private static final String TEXT_SECONDS = DHCPServerGUI.getResourceString("TEXT_SECONDS");
    private static final String TEXT_YEAR = DHCPServerGUI.getResourceString("TEXT_YEAR");
    private static final String TEXT_MONTH = DHCPServerGUI.getResourceString("TEXT_MONTH");
    private static final String TEXT_DAY = DHCPServerGUI.getResourceString("TEXT_DAY");
    private static final String TEXT_HOUR = DHCPServerGUI.getResourceString("TEXT_HOUR");
    private static final String TEXT_MINUTE = DHCPServerGUI.getResourceString("TEXT_MINUTE");
    private static final String TEXT_SECOND = DHCPServerGUI.getResourceString("TEXT_SECOND");
    private LeaseEntryPanel leaseEntryPanel;
    private TextArea comment;
    private CheckboxGroup leaseGroup;
    private Checkbox finitebox;
    private Checkbox defaultbox;
    private Checkbox infinitebox;
    private Label leaseDefaultLabel;
    private ConfigItem item = null;
    private NotebookFrame parentFrame = null;
    boolean noComment = false;

    public LeaseAndCommentPanel() {
    }

    public LeaseAndCommentPanel(boolean bl) {
        this();
        this.noComment = bl;
    }

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.item = configItem;
        this.parentFrame = notebookFrame;
        this.leaseDefaultLabel.setText("");
        this.leaseEntryPanel.resetFields();
        if (!this.noComment) {
            this.comment.setText("");
        }
    }

    public void populatePanel() {
        this.populateDefault();
        this.populateLocal();
        if (this.noComment) {
            return;
        }
        String string = this.item.getComment();
        if (string != null) {
            this.comment.setText(string);
        }
    }

    private void populateDefault() {
        Option option = this.parentFrame.getItemParent().getOption("51");
        if (option == null) {
            ServerParameters serverParameters = this.parentFrame.getRoot().getServerParameters();
            Lease lease = serverParameters.getLease();
            String string = lease.getLeaseTimeDefault();
            if (string == null) {
                this.leaseDefaultLabel.setText(TEXT_NO_DEFAULT_LABEL);
            } else if (string.equals("-1")) {
                this.leaseDefaultLabel.setText(TEXT_INFINITE_DEFAULT_LABEL);
            } else {
                this.leaseDefaultLabel.setText(String.valueOf(string) + " " + lease.getLeaseTimeDefaultUnits());
            }
        } else {
            String string = option.getValue().trim();
            if (string.equals("-1")) {
                this.leaseDefaultLabel.setText(TEXT_INFINITE_DEFAULT_LABEL);
            } else {
                TimeInterval timeInterval = new TimeInterval();
                int[] nArray = new int[6];
                String[] stringArray = new String[]{TEXT_YEARS, TEXT_MONTHS, TEXT_DAYS, TEXT_HOURS, TEXT_MINUTES, TEXT_SECONDS};
                String[] stringArray2 = new String[]{TEXT_YEAR, TEXT_MONTH, TEXT_DAY, TEXT_HOUR, TEXT_MINUTE, TEXT_SECOND};
                StringBuffer stringBuffer = new StringBuffer();
                timeInterval.setTimeInterval(string);
                nArray = timeInterval.getTimeInterval();
                int n = 0;
                while (n < 6) {
                    if (nArray[n] == 1) {
                        stringBuffer.append(" " + nArray[n] + " " + stringArray2[n]);
                    }
                    if (nArray[n] > 1) {
                        stringBuffer.append(" " + nArray[n] + " " + stringArray[n]);
                    }
                    ++n;
                }
                this.leaseDefaultLabel.setText(String.valueOf(stringBuffer.toString()) + " " + "(" + string + " " + TEXT_SECONDS + ")");
            }
        }
        this.leaseGroup.setSelectedCheckbox(this.defaultbox);
        this.leaseEntryPanel.disableFields();
    }

    public void populateLocal() {
        Option option = this.item.getExplicitOption("51");
        if (option != null) {
            String string = option.getValue();
            if (Integer.parseInt(string) == -1) {
                this.leaseGroup.setSelectedCheckbox(this.infinitebox);
                this.leaseEntryPanel.disableFields();
                return;
            }
            this.leaseEntryPanel.enableFields();
            this.leaseEntryPanel.populate(option.getValue());
            this.leaseGroup.setSelectedCheckbox(this.finitebox);
        }
    }

    private void handleCheckbox(Checkbox checkbox) {
        if (checkbox == this.finitebox) {
            this.leaseEntryPanel.enableFields();
            return;
        }
        if (checkbox == this.defaultbox || checkbox == this.infinitebox) {
            this.leaseEntryPanel.resetFields();
            this.leaseEntryPanel.disableFields();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object instanceof Checkbox) {
            this.handleCheckbox((Checkbox)object);
        }
    }

    public boolean saveState() {
        if (this.leaseGroup.getSelectedCheckbox() == this.infinitebox) {
            Message message = this.item.setLeaseInterval("-1");
            if (message != null) {
                message.setLocation(TEXT_LOCATION_INFINITE_LABEL);
                this.parentFrame.displayError(message);
                return false;
            }
        } else if (this.leaseGroup.getSelectedCheckbox() == this.finitebox) {
            String string = this.leaseEntryPanel.getUserInput();
            Message message = this.item.setLeaseInterval(string);
            if (message != null) {
                message.setLocation(TEXT_LOCATION_FINITE_LABEL);
                this.parentFrame.displayError(message);
                return false;
            }
        } else {
            Message message = this.item.setLeaseInterval(null);
            if (message != null) {
                message.setLocation(TEXT_LOCATION_FINITE_LABEL);
                this.parentFrame.displayError(message);
                return false;
            }
        }
        if (!this.noComment) {
            this.item.setComment(this.comment.getText());
        }
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        Label label = new Label();
        Label label2 = new Label(String.valueOf(TEXT_COMMENT_LABEL) + " ");
        this.leaseDefaultLabel = new Label(TEXT_NO_DEFAULT_LABEL);
        this.leaseEntryPanel = new LeaseEntryPanel();
        this.leaseGroup = new CheckboxGroup();
        this.defaultbox = new Checkbox(String.valueOf(TEXT_DEFAULT_LABEL) + " ", this.leaseGroup, true);
        this.defaultbox.setBackground(Color.lightGray);
        this.defaultbox.addItemListener(this);
        this.defaultbox.addKeyListener(this);
        this.finitebox = new Checkbox(String.valueOf(TEXT_FINITE_LABEL) + " ", this.leaseGroup, false);
        this.finitebox.setBackground(Color.lightGray);
        this.finitebox.addItemListener(this);
        this.finitebox.addKeyListener(this);
        this.infinitebox = new Checkbox(String.valueOf(TEXT_INFINITE_LABEL) + " ", this.leaseGroup, false);
        this.infinitebox.setBackground(Color.lightGray);
        this.infinitebox.addItemListener(this);
        this.infinitebox.addKeyListener(this);
        Panel panel = new Panel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        panel.setLayout(gridBagLayout2);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 18;
        gridBagLayout2.setConstraints(this.defaultbox, gridBagConstraints);
        panel.add(this.defaultbox);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout2.setConstraints(this.leaseDefaultLabel, gridBagConstraints);
        panel.add(this.leaseDefaultLabel);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 16;
        gridBagLayout2.setConstraints(this.finitebox, gridBagConstraints);
        panel.add(this.finitebox);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout2.setConstraints(this.leaseEntryPanel, gridBagConstraints);
        panel.add(this.leaseEntryPanel);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout2.setConstraints(this.infinitebox, gridBagConstraints);
        panel.add(this.infinitebox);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(panel, gridBagConstraints);
        this.add(panel);
        if (this.noComment) {
            return;
        }
        this.comment = new TextArea("", 2, 65);
        this.comment.addKeyListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.add(label2);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.comment, gridBagConstraints);
        this.add(this.comment);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10) {
            if (object instanceof Checkbox) {
                Checkbox checkbox;
                checkbox.setState(!(checkbox = (Checkbox)object).getState());
                this.handleCheckbox(checkbox);
                return;
            }
        } else if (keyEvent.getKeyCode() == 9 && object instanceof TextArea) {
            TextArea textArea = (TextArea)object;
            textArea.transferFocus();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

