/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Lease;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.notebook.LeaseParm;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.PingTime;
import COM.ibm.raleigh.dhcpsgui.notebook.SubPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.Vector;

public class LeasePanel
extends NotebookPanel {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    static final String LEASE_TIME_DEFAULT = DHCPServerGUI.getResourceString("TEXT_LEASE_TIME_DEFAULT");
    static final String LEASE_EXPIRE_INTERVAL = DHCPServerGUI.getResourceString("TEXT_LEASE_EXPIRE_INTERVAL");
    static final String STATISTIC_SNAPSHOT_INTERVAL = String.valueOf(DHCPServerGUI.getResourceString("TEXT_STATISTIC_SNAPSHOT_INTERVAL_A")) + DHCPServerGUI.getResourceString("TEXT_STATISTIC_SNAPSHOT_INTERVAL_B");
    static final String LEASE_RESERVED_TIME = DHCPServerGUI.getResourceString("TEXT_LEASE_RESERVED_TIME");
    static final String IP_ADDRESS_EXPIRE = String.valueOf(DHCPServerGUI.getResourceString("TEXT_IP_ADDRESS_EXPIRE_A")) + DHCPServerGUI.getResourceString("TEXT_IP_ADDRESS_EXPIRE_B");
    static final String PING_TIME = String.valueOf(DHCPServerGUI.getResourceString("TEXT_PING_TIME_A")) + DHCPServerGUI.getResourceString("TEXT_PING_TIME_B");
    static final String NEVER_EXPIRE = DHCPServerGUI.getResourceString("TEXT_NEVER_EXPIRE");
    static final String HOLD_INDEFINITELY = DHCPServerGUI.getResourceString("TEXT_HOLD_INDEFINITELY");
    private Vector subPanels = new Vector(6);
    private Lease lease;
    private LeaseParm leaseTimeDefault = new LeaseParm(LEASE_TIME_DEFAULT, NEVER_EXPIRE, true);
    private LeaseParm leaseExpireInterval = new LeaseParm(LEASE_EXPIRE_INTERVAL, null, true);
    private LeaseParm statisticSnapshotInterval = new LeaseParm(STATISTIC_SNAPSHOT_INTERVAL, null, false);
    private LeaseParm reservedTime = new LeaseParm(LEASE_RESERVED_TIME, HOLD_INDEFINITELY, true);
    private LeaseParm usedIpAddressExpireInterval = new LeaseParm(IP_ADDRESS_EXPIRE, HOLD_INDEFINITELY, true);
    private PingTime pingTime = new PingTime(PING_TIME);
    private NotebookFrame callingNotebook;

    public LeasePanel() {
        this.subPanels.addElement(this.leaseTimeDefault);
        this.subPanels.addElement(this.leaseExpireInterval);
        this.subPanels.addElement(this.statisticSnapshotInterval);
        this.subPanels.addElement(this.reservedTime);
        this.subPanels.addElement(this.usedIpAddressExpireInterval);
        this.subPanels.addElement(this.pingTime);
    }

    public void layoutPanel(Font font, Font font2) {
        ((Component)this).setFont(font);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        Enumeration enumeration = this.subPanels.elements();
        while (enumeration.hasMoreElements()) {
            SubPanel subPanel = (SubPanel)enumeration.nextElement();
            subPanel.layoutPanel(font, font2);
            NotebookPanel.add(this, (Component)((Object)subPanel), gridBagLayout, gridBagConstraints, -1, -1, 0, 1);
        }
    }

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.lease = ((ServerParameters)configItem).getLease();
        this.callingNotebook = notebookFrame;
    }

    public void populatePanel() {
        this.leaseTimeDefault.populate(this.lease.getLeaseTimeDefault(), this.lease.getLeaseTimeDefaultUnits());
        this.leaseExpireInterval.populate(this.lease.getLeaseExpireInterval(), this.lease.getLeaseExpireIntervalUnits());
        this.statisticSnapshotInterval.populate(this.lease.getStatisticSnapshotInterval(), null);
        this.reservedTime.populate(this.lease.getReservedTime(), this.lease.getReservedTimeUnits());
        this.usedIpAddressExpireInterval.populate(this.lease.getUsedIpAddressExpireInterval(), this.lease.getUsedIpAddressExpireIntervalUnits());
        this.pingTime.populate(this.lease.getPingTime());
    }

    public boolean saveState() {
        Enumeration enumeration = this.subPanels.elements();
        while (enumeration.hasMoreElements()) {
            SubPanel subPanel = (SubPanel)enumeration.nextElement();
            Message message = subPanel.updateField(this.lease);
            if (message == null) continue;
            this.callingNotebook.displayError(message);
            return false;
        }
        return true;
    }
}

