/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.BINLServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.LogFile;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.notebook.BINLServerParametersNotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;

class LogParmPanel
extends NotebookPanel {
    static final String LABEL_MAX_LOG_FILES = DHCPServerGUI.getResourceString("TEXT_LABEL_MAX_LOG_FILES");
    static final String LABEL_MAX_LOG_SIZE = DHCPServerGUI.getResourceString("TEXT_LABEL_MAX_LOG_SIZE");
    static final String LABEL_LOG_NAME = DHCPServerGUI.getResourceString("TEXT_LABEL_LOG_FILE_NAME");
    private LogFile log;
    private NotebookFrame callingNotebook;
    private TextField logFileName;
    private TextField numLogFiles;
    private TextField logFileSize;

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.log = notebookFrame instanceof BINLServerParametersNotebookFrame ? ((BINLServerParameters)configItem).getLogFile() : ((ServerParameters)configItem).getLogFile();
        this.callingNotebook = notebookFrame;
    }

    public void layoutPanel(Font font, Font font2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Component)this).setFont(font);
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 12;
        this.add(new Label(LABEL_MAX_LOG_FILES), gridBagLayout, gridBagConstraints, 0, 0, -1, 1);
        gridBagConstraints.anchor = 18;
        this.numLogFiles = new TextField(12);
        this.add(this.numLogFiles, gridBagLayout, gridBagConstraints, -1, 0, 0, 1);
        gridBagConstraints.anchor = 12;
        this.add(new Label(LABEL_MAX_LOG_SIZE), gridBagLayout, gridBagConstraints, 0, 1, -1, 1);
        this.logFileSize = new TextField(12);
        gridBagConstraints.anchor = 18;
        this.add(this.logFileSize, gridBagLayout, gridBagConstraints, -1, 1, 0, 1);
        gridBagConstraints.anchor = 12;
        this.add(new Label(LABEL_LOG_NAME), gridBagLayout, gridBagConstraints, 0, 2, -1, -1);
        gridBagConstraints.fill = 2;
        this.logFileName = new TextField(40);
        gridBagConstraints.anchor = 18;
        this.add(this.logFileName, gridBagLayout, gridBagConstraints, -1, 2, 2, 0);
    }

    public void populatePanel() {
        ((TextComponent)this.logFileName).setText(this.log.getLogFileName());
        ((TextComponent)this.numLogFiles).setText(this.log.getNumLogFiles());
        ((TextComponent)this.logFileSize).setText(this.log.getLogFileSize());
    }

    public boolean saveState() {
        Message message = this.updateMsg(this.log.setLogFileName(this.logFileName.getText()), LABEL_LOG_NAME);
        if (message == null) {
            message = this.updateMsg(this.log.setNumLogFiles(this.numLogFiles.getText()), LABEL_MAX_LOG_FILES);
        }
        if (message == null) {
            message = this.updateMsg(this.log.setLogFileSize(this.logFileSize.getText()), LABEL_MAX_LOG_SIZE);
        }
        if (message == null) {
            message = this.log.isLogStateValid();
        }
        if (message != null) {
            this.callingNotebook.displayError(message);
            return false;
        }
        return true;
    }

    private Message updateMsg(Message message, String string) {
        if (message != null) {
            message.setLocation(string);
        }
        return message;
    }

    LogParmPanel() {
    }
}

