/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.ddnssgui.common.TcpipLocale;
import COM.ibm.raleigh.dhcpsgui.biz.OptionSkeleton;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.OptionInputPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class PXEDiscoveryControlPanel
extends Panel
implements OptionInputPanel,
ItemListener {
    Checkbox disableBcast;
    Checkbox disableMcast;
    Checkbox useOnlyListedServers;
    Checkbox useDhcpOfferBootFile;
    boolean disableBcastState;
    boolean disableMcastState;
    boolean useOnlyListedServersState;
    boolean useDhcpOfferBootFileState;
    private OptionSkeleton skeleton;
    static final String copyright = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    String dataType;
    NotebookFrame callingNotebook;
    private static TcpipLocale thisLocale = DHCPServerGUI.getDHCPLocale();
    private static ResourceBundle thisBundle;
    private static final String bundleName = "COM.ibm.raleigh.dhcpsgui.resource.PXEOptionResources";

    private static String getResourceString(String string) {
        if (thisBundle == null && (thisBundle = ResourceBundle.getBundle(bundleName, TcpipLocale.getLocale())) == null) {
            throw new ShouldNotOccurException("The resource bundle for this locale cannot be found");
        }
        try {
            return thisBundle.getString(string);
        }
        catch (Exception exception) {
            System.err.println("OpSkel - getResourceString() for string " + string + " -- exception is <" + exception + ">");
            throw new ShouldNotOccurException();
        }
    }

    public PXEDiscoveryControlPanel() {
        this.layoutPanel();
    }

    public void populate(String string) {
        this.resetFields();
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (string2.equals("DISABLE_BCAST")) {
                    this.disableBcast.setState(true);
                }
                if (string2.equals("DISABLE_MCAST")) {
                    this.disableMcast.setState(true);
                }
                if (string2.equals("USE_ONLY_LISTED_SERVERS")) {
                    this.useOnlyListedServers.setState(true);
                }
                if (!string2.equals("USE_DHCPOFFER_BOOTFILE")) continue;
                this.useDhcpOfferBootFile.setState(true);
            }
        }
    }

    public String getUserInput() {
        this.disableBcastState = this.disableBcast.getState();
        this.disableMcastState = this.disableMcast.getState();
        this.useOnlyListedServersState = this.useOnlyListedServers.getState();
        this.useDhcpOfferBootFileState = this.useDhcpOfferBootFile.getState();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.disableBcastState) {
            stringBuffer.append("DISABLE_BCAST ");
        }
        if (this.disableMcastState) {
            stringBuffer.append("DISABLE_MCAST ");
        }
        if (this.useOnlyListedServersState) {
            stringBuffer.append("USE_ONLY_LISTED_SERVERS ");
        }
        if (this.useDhcpOfferBootFileState) {
            stringBuffer.append("USE_DHCPOFFER_BOOTFILE");
        }
        return stringBuffer.toString();
    }

    public void resetFields() {
        this.disableBcast.setState(false);
        this.disableMcast.setState(false);
        this.useOnlyListedServers.setState(false);
        this.useDhcpOfferBootFile.setState(false);
    }

    public void setFormat(OptionSkeleton optionSkeleton, Font font) {
    }

    public void setCaller(NotebookFrame notebookFrame) {
        this.callingNotebook = notebookFrame;
    }

    private void layoutPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.disableBcast = new Checkbox(PXEDiscoveryControlPanel.getResourceString("OPT6L1"));
        this.disableMcast = new Checkbox(PXEDiscoveryControlPanel.getResourceString("OPT6L2"));
        this.useOnlyListedServers = new Checkbox(PXEDiscoveryControlPanel.getResourceString("OPT6L3"));
        this.useDhcpOfferBootFile = new Checkbox(PXEDiscoveryControlPanel.getResourceString("OPT6L4"));
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 100.0;
        gridBagConstraints.weighty = 100.0;
        this.add(this.disableBcast, gridBagLayout, gridBagConstraints, 0, 1, 1, 1);
        this.add(this.disableMcast, gridBagLayout, gridBagConstraints, 0, 2, 1, 1);
        this.add(this.useOnlyListedServers, gridBagLayout, gridBagConstraints, 0, 3, 1, 1);
        this.add(this.useDhcpOfferBootFile, gridBagLayout, gridBagConstraints, 0, 4, 1, 1);
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
    }
}

