/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.DDNSKeySupport;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.util.Enumeration;

class PtrPoolsPanel
extends NotebookPanel {
    private DDNSKeySupport ddnsInfo;
    private List subnetList;

    PtrPoolsPanel() {
    }

    public void layoutPanel(Font font, Font font2) {
        ((Component)this).setFont(font);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add(new Label(DHCPServerGUI.getResourceString("TEXT_KEYS_WILL_BE_CREATED")), gridBagLayout, gridBagConstraints, 1, 0, 0, 1);
        gridBagConstraints.fill = 0;
        String string = String.valueOf(DHCPServerGUI.getResourceString("TEXT_NAME_SUBNET")) + "             " + DHCPServerGUI.getResourceString("TEXT_DDNS_SERVER");
        this.add(new Label(string), gridBagLayout, gridBagConstraints, 1, 1, 1, 1);
        gridBagConstraints.fill = 1;
        this.subnetList = new List(3, false);
        this.add(this.subnetList, gridBagLayout, gridBagConstraints, 1, 2, 1, 1);
        gridBagConstraints.fill = 0;
    }

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.ddnsInfo = ((ServerParameters)configItem).getDDNSKeySupport();
        super.initializePanel(configItem, notebookFrame);
        this.subnetList.removeAll();
    }

    public void populatePanel() {
        Configuration configuration = this.callingNotebook.getRoot();
        Enumeration enumeration = configuration.getGlobal().getConfigItems("COM.ibm.raleigh.dhcpsgui.biz.Subnetwork", true);
        while (enumeration.hasMoreElements()) {
            String string;
            Subnetwork subnetwork = (Subnetwork)enumeration.nextElement();
            String string2 = subnetwork.getAlias();
            if (string2.equals("")) {
                string2 = subnetwork.getAddress();
            }
            if ((string = subnetwork.getDDNSServer()) == null) {
                string = DHCPServerGUI.getResourceString("TEXT_UNDEFINED");
            }
            this.subnetList.addItem(String.valueOf(string2) + "    " + string);
        }
    }

    public boolean saveState() {
        return true;
    }
}

