/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.ServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.ServerType;
import COM.ibm.raleigh.dhcpsgui.notebook.BorderPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.ImageServerPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.PXEOptionsPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class ServerTypePanel
extends NotebookPanel
implements ItemListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_PXE_GROUP_LABEL = DHCPServerGUI.getResourceString("TEXT_PXE_GROUP_LABEL");
    private static final String TEXT_PXE_DISABLE_LABEL = DHCPServerGUI.getResourceString("TEXT_PXE_DISABLE_LABEL");
    private static final String TEXT_PXE_ENABLE_WITHDHCP_LABEL = DHCPServerGUI.getResourceString("TEXT_PXE_ENABLE_WITHDHCP_LABEL");
    private static final String TEXT_PXE_ENABLE_NODHCP_LABEL = DHCPServerGUI.getResourceString("TEXT_PXE_ENABLE_NODHCP_LABEL");
    private NotebookFrame parentFrame;
    private NotebookPanel info;
    private String serverType;
    private ServerParameters cfgItem;
    private Checkbox pxeEnableWithDhcp;
    private Checkbox pxeEnableNoDhcp;
    private Checkbox pxeDisable;
    private CheckboxGroup pxeCheckBoxGroup;
    private BorderPanel pxeGroupPanel;
    private Font theTextFont;
    private Font theTitleFont;
    private ImageServerPanel imageServerPanel;
    private PXEOptionsPanel pxeOptionsPanel;

    public ServerTypePanel() {
    }

    public ServerTypePanel(ImageServerPanel imageServerPanel, PXEOptionsPanel pXEOptionsPanel) {
        this.imageServerPanel = imageServerPanel;
        this.pxeOptionsPanel = pXEOptionsPanel;
    }

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.setCfgItem((ServerParameters)configItem);
        this.setParentFrame(notebookFrame);
    }

    public void setCfgItem(ServerParameters serverParameters) {
        this.cfgItem = serverParameters;
    }

    public ConfigItem getCfgItem() {
        return this.cfgItem;
    }

    public void setParentFrame(NotebookFrame notebookFrame) {
        this.parentFrame = notebookFrame;
    }

    public NotebookFrame getParentFrame() {
        return this.parentFrame;
    }

    public void setServerType(String string) {
        this.serverType = string;
    }

    public String getServerType() {
        return this.serverType;
    }

    public boolean saveState() {
        ServerType serverType = this.cfgItem.getServerType();
        serverType.setValue(this.getServerType());
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        this.theTextFont = font;
        this.theTitleFont = font2;
        this.initComponents();
        this.addComponentsToGrid();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setServerType(this.getStates(itemEvent));
        this.setStates(this.getServerType());
    }

    public String getStates(ItemEvent itemEvent) {
        String string = null;
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.pxeEnableWithDhcp) {
            string = "pxedhcp";
        } else if (itemSelectable == this.pxeEnableNoDhcp) {
            string = "pxeproxy";
        } else if (itemSelectable == this.pxeDisable) {
            string = "dhcp";
        }
        return string;
    }

    public void setStates(String string) {
        if (string == "dhcp" || this.serverType == null) {
            this.pxeEnableWithDhcp.setState(false);
            this.pxeEnableNoDhcp.setState(false);
            this.pxeDisable.setState(true);
            if (this.imageServerPanel != null) {
                this.imageServerPanel.setEnabled(false);
            }
            if (this.pxeOptionsPanel != null) {
                this.pxeOptionsPanel.setEnabled(false);
                return;
            }
        } else if (string == "pxeproxy") {
            this.pxeEnableNoDhcp.setState(true);
            this.pxeDisable.setState(false);
            if (this.imageServerPanel != null) {
                this.imageServerPanel.setEnabled(true);
            }
            if (this.pxeOptionsPanel != null) {
                this.pxeOptionsPanel.setEnabled(true);
                return;
            }
        } else if (string == "pxedhcp") {
            this.pxeEnableWithDhcp.setState(true);
            this.pxeDisable.setState(false);
            if (this.imageServerPanel != null) {
                this.imageServerPanel.setEnabled(true);
            }
            if (this.pxeOptionsPanel != null) {
                this.pxeOptionsPanel.setEnabled(true);
            }
        }
    }

    public void populatePanel() {
        this.pxeDisable.setState(false);
        this.pxeEnableWithDhcp.setState(false);
        this.pxeEnableNoDhcp.setState(false);
        this.setServerType(this.cfgItem.getServerType().getValue());
        this.setStates(this.getServerType());
    }

    private void initComponents() {
        this.pxeGroupPanel = new BorderPanel(TEXT_PXE_GROUP_LABEL);
        this.pxeCheckBoxGroup = new CheckboxGroup();
        this.pxeEnableWithDhcp = new Checkbox(TEXT_PXE_ENABLE_WITHDHCP_LABEL, false, this.pxeCheckBoxGroup);
        this.add(this.pxeEnableWithDhcp);
        this.pxeEnableWithDhcp.addItemListener(this);
        this.pxeEnableNoDhcp = new Checkbox(TEXT_PXE_ENABLE_NODHCP_LABEL, false, this.pxeCheckBoxGroup);
        this.add(this.pxeEnableNoDhcp);
        this.pxeEnableNoDhcp.addItemListener(this);
        this.pxeDisable = new Checkbox(TEXT_PXE_DISABLE_LABEL, false, this.pxeCheckBoxGroup);
        this.add(this.pxeDisable);
        this.pxeDisable.addItemListener(this);
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        ((Component)this).setFont(this.theTextFont);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pxeGroupPanel.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.constrain(this.pxeEnableWithDhcp, gridBagLayout, gridBagConstraints, 0, 1, 1, 1);
        this.add(this.pxeEnableWithDhcp);
        this.constrain(this.pxeEnableNoDhcp, gridBagLayout, gridBagConstraints, 0, 2, 1, 1);
        this.add(this.pxeEnableNoDhcp);
        this.constrain(this.pxeDisable, gridBagLayout, gridBagConstraints, 0, 3, 0, 0);
        this.add(this.pxeDisable);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }
}

