/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.notebook.BorderPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.ExcludedAddrPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.LeaseAndCommentPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.SubnetInfoPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class SubnetDefinitionPanel
extends NotebookPanel {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_SUBNET_BOX1TITLE = DHCPServerGUI.getResourceString("TEXT_SUBNET_BOX1TITLE");
    private static final String TEXT_SUBNET_BOX2TITLE = DHCPServerGUI.getResourceString("TEXT_SUBNET_BOX2TITLE");
    private static final String TEXT_TITLE_LEASE_AND_COMMENT = DHCPServerGUI.getResourceString("TEXT_TITLE_LEASE_AND_COMMENT");
    private Font myTextFont;
    private Font myTitleFont;
    private BorderPanel leaseBox;
    private BorderPanel sninfoBox;
    private BorderPanel excludedBox;
    private boolean layoutCalled = false;
    private boolean firstTime = true;
    SubnetInfoPanel sninfo = new SubnetInfoPanel();
    ExcludedAddrPanel excluded = new ExcludedAddrPanel();
    LeaseAndCommentPanel lease = new LeaseAndCommentPanel();
    Subnetwork sn = null;
    NotebookFrame parentFrame = null;

    public SubnetDefinitionPanel() {
        this.sninfo.setExcludedPanel(this.excluded);
        this.excluded.setInfoPanel(this.sninfo);
    }

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.sn = (Subnetwork)configItem;
        this.parentFrame = notebookFrame;
        this.sninfo.initializePanel(this.sn, this.parentFrame);
        this.excluded.initializePanel(this.sn, this.parentFrame);
        this.lease.initializePanel(this.sn, this.parentFrame);
        this.myTextFont = this.parentFrame.getTextFont();
        this.myTitleFont = this.parentFrame.getTitleFont();
    }

    public void populatePanel() {
        if (!this.firstTime) {
            this.removeAndRebuildPanels();
        }
        this.sninfo.populatePanel();
        this.excluded.populatePanel();
        this.lease.populatePanel();
        if (!this.firstTime) {
            this.layoutPanel(this.myTextFont, this.myTitleFont);
        }
        this.firstTime = false;
    }

    private void removeAndRebuildPanels() {
        this.remove(this.sninfoBox);
        this.remove(this.excludedBox);
        this.remove(this.leaseBox);
        this.sninfoBox = null;
        this.excludedBox = null;
        this.leaseBox = null;
        this.remove(this.lease);
        this.remove(this.sninfo);
        this.remove(this.excluded);
        this.lease = null;
        this.sninfo = null;
        this.excluded = null;
        this.lease = new LeaseAndCommentPanel();
        this.sninfo = new SubnetInfoPanel();
        this.excluded = new ExcludedAddrPanel();
        this.sninfo.setExcludedPanel(this.excluded);
        this.excluded.setInfoPanel(this.sninfo);
        this.sninfo.layoutPanel(this.myTextFont, this.myTitleFont);
        this.excluded.layoutPanel(this.myTextFont, this.myTitleFont);
        this.lease.layoutPanel(this.myTextFont, this.myTitleFont);
        this.sninfo.initializePanel(this.sn, this.parentFrame);
        this.excluded.initializePanel(this.sn, this.parentFrame);
        this.lease.initializePanel(this.sn, this.parentFrame);
    }

    public boolean saveState() {
        if (this.sninfo.saveState() && this.excluded.saveState() && this.lease.saveState()) {
            this.parentFrame.setItemParent(this.parentFrame.getGlobal());
            return true;
        }
        return false;
    }

    public void layoutPanel(Font font, Font font2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Component)this).setFont(font);
        this.setLayout(gridBagLayout);
        int n = 0;
        if (!this.layoutCalled) {
            this.sninfo.layoutPanel(font, font2);
        }
        this.sninfoBox = new BorderPanel(TEXT_SUBNET_BOX1TITLE);
        this.sninfoBox.setTextFont(font2);
        this.sninfoBox.setGap(n);
        this.sninfoBox.add(this.sninfo);
        this.sninfoBox.setThickness(1);
        if (!this.layoutCalled) {
            this.excluded.layoutPanel(font, font2);
        }
        this.excludedBox = new BorderPanel(TEXT_SUBNET_BOX2TITLE);
        this.excludedBox.setTextFont(font2);
        this.excludedBox.setGap(n);
        this.excludedBox.add(this.excluded);
        this.excludedBox.setThickness(2);
        if (!this.layoutCalled) {
            this.lease.layoutPanel(font, font2);
        }
        this.leaseBox = new BorderPanel(TEXT_TITLE_LEASE_AND_COMMENT);
        this.leaseBox.setTextFont(font2);
        this.leaseBox.setGap(n);
        this.leaseBox.add(this.lease);
        this.leaseBox.setThickness(1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(this.sninfoBox, gridBagConstraints);
        this.add(this.sninfoBox);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.excludedBox, gridBagConstraints);
        this.add(this.excludedBox);
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.leaseBox, gridBagConstraints);
        this.add(this.leaseBox);
        this.layoutCalled = true;
    }
}

