/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Subnetwork;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.text.MessageFormat;

public class SubnetInfoPanel
extends NotebookPanel {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_SUBNET_NAME = DHCPServerGUI.getResourceString("TEXT_SUBNET_NAME");
    private static final String TEXT_SUBNET_ADDR = DHCPServerGUI.getResourceString("TEXT_SUBNET_ADDR");
    private static final String TEXT_SUBNET_MASK = DHCPServerGUI.getResourceString("TEXT_SUBNET_MASK");
    private static final String TEXT_RANGE = DHCPServerGUI.getResourceString("TEXT_RANGE");
    private static final String TEXT_FROM = DHCPServerGUI.getResourceString("TEXT_FROM");
    private static final String TEXT_TO = DHCPServerGUI.getResourceString("TEXT_TO");
    private static final String ERROR_GENERATED_SUBNET_MASK = DHCPServerGUI.getResourceString("ERROR_GENERATED_SUBNET_MASK");
    private static final String TEXT_INVALID_CHAR = DHCPServerGUI.getResourceString("TEXT_INVALID_CHAR");
    private TextField name = new TextField(16);
    private TextField address = new TextField(16);
    private TextField mask = new TextField(16);
    private TextField poolstart = new TextField(16);
    private TextField poolend = new TextField(16);
    private boolean validsubnet;
    private boolean validrange;
    private Subnetwork sn = null;
    private NotebookFrame parentFrame = null;
    private NotebookPanel excluded = null;

    public void initializePanel(ConfigItem configItem, NotebookFrame notebookFrame) {
        this.sn = (Subnetwork)configItem;
        this.parentFrame = notebookFrame;
        if (!this.sn.isValidSubnet()) {
            this.validsubnet = false;
            this.validrange = false;
            return;
        }
        this.validsubnet = true;
        if (this.sn.isPoolRangeValid()) {
            this.validrange = true;
        }
    }

    public void populatePanel() {
        if (this.sn.getAlias() != null) {
            ((TextComponent)this.name).setText(this.sn.getAlias());
        } else {
            ((TextComponent)this.name).setText("");
        }
        if (this.sn.getAddress() != null) {
            ((TextComponent)this.address).setText(this.sn.getAddress());
        } else {
            ((TextComponent)this.address).setText("");
        }
        if (this.sn.getSubnetMask() != null) {
            ((TextComponent)this.mask).setText(this.sn.getSubnetMask());
        } else {
            ((TextComponent)this.mask).setText("");
        }
        if (this.sn.getPoolRangeStart() != null) {
            ((TextComponent)this.poolstart).setText(this.sn.getPoolRangeStart());
        } else {
            ((TextComponent)this.poolstart).setText("");
        }
        if (this.sn.getPoolRangeEnd() != null) {
            ((TextComponent)this.poolend).setText(this.sn.getPoolRangeEnd());
            return;
        }
        ((TextComponent)this.poolend).setText("");
    }

    public void setExcludedPanel(NotebookPanel notebookPanel) {
        this.excluded = notebookPanel;
    }

    public boolean saveState() {
        Message message = this.sn.setAlias(this.name.getText());
        if (message != null) {
            message.setLocation(String.valueOf(TEXT_SUBNET_NAME) + " ");
            this.parentFrame.displayError(message);
            return false;
        }
        if (this.name.getText().indexOf("#") != -1) {
            System.out.println("error with alias");
            Object[] objectArray = new Object[]{TEXT_SUBNET_NAME, "#"};
            this.parentFrame.displayError(new Message(MessageFormat.format(TEXT_INVALID_CHAR, objectArray)));
            return false;
        }
        if (!this.validateSubnet()) {
            return false;
        }
        return this.validateRange();
    }

    public boolean validateSubnet() {
        this.parentFrame.somethingChanged();
        this.validsubnet = false;
        Message message = this.sn.setAddress(this.address.getText());
        if (message != null) {
            message.setLocation(TEXT_SUBNET_ADDR);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.sn.setSubnetMask(this.mask.getText());
        if (message != null) {
            if (message.getText().equals(ERROR_GENERATED_SUBNET_MASK)) {
                ((TextComponent)this.address).setText(this.sn.getAddress());
                ((TextComponent)this.mask).setText(this.sn.getSubnetMask());
            }
            message.setLocation(TEXT_SUBNET_MASK);
            this.parentFrame.displayError(message);
            return false;
        }
        message = this.sn.validateSubnet();
        if (message != null) {
            message.setLocation(TEXT_SUBNET_MASK);
            this.parentFrame.displayError(message);
            return false;
        }
        this.validsubnet = true;
        return true;
    }

    public boolean validateRange() {
        this.parentFrame.somethingChanged();
        Message message = this.sn.setPoolRangeStart(this.poolstart.getText());
        if (message != null) {
            message.setLocation(TEXT_FROM);
            this.parentFrame.displayError(message);
            this.validrange = false;
            return false;
        }
        message = this.sn.setPoolRangeEnd(this.poolend.getText());
        if (message != null) {
            message.setLocation(TEXT_TO);
            this.parentFrame.displayError(message);
            this.validrange = false;
            return false;
        }
        message = this.sn.validatePool();
        if (message != null) {
            message.setLocation(TEXT_RANGE);
            this.parentFrame.displayError(message);
            this.validrange = false;
            return false;
        }
        this.validrange = true;
        return true;
    }

    public void layoutPanel(Font font, Font font2) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ((Component)this).setFont(font);
        this.setLayout(gridBagLayout);
        Label label = new Label(TEXT_SUBNET_NAME);
        Label label2 = new Label(TEXT_SUBNET_ADDR);
        Label label3 = new Label(TEXT_SUBNET_MASK);
        Label label4 = new Label(String.valueOf(TEXT_RANGE) + " ");
        Label label5 = new Label(String.valueOf(TEXT_FROM) + " ");
        Label label6 = new Label(String.valueOf(TEXT_TO) + " ");
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.name, gridBagConstraints);
        this.add(this.name);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.add(label2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.address, gridBagConstraints);
        this.add(this.address);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(label3, gridBagConstraints);
        this.add(label3);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.mask, gridBagConstraints);
        this.add(this.mask);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(label4, gridBagConstraints);
        this.add(label4);
        gridBagConstraints.gridx = -1;
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(label5, gridBagConstraints);
        this.add(label5);
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.poolstart, gridBagConstraints);
        this.add(this.poolstart);
        gridBagConstraints.anchor = 12;
        gridBagLayout.setConstraints(label6, gridBagConstraints);
        this.add(label6);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagLayout.setConstraints(this.poolend, gridBagConstraints);
        this.add(this.poolend);
    }
}

