/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.awtExt.SpinButton;
import COM.ibm.raleigh.dhcpsgui.biz.OptionSkeleton;
import COM.ibm.raleigh.dhcpsgui.biz.TimeInterval;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.OptionInputPanel;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class TimeEntryPanel
extends Panel
implements OptionInputPanel,
KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    static final String TEXT_LABEL_TIME_ENTRY = DHCPServerGUI.getResourceString("TEXT_LABEL_TIME_ENTRY");
    static final String TEXT_CHECKBOX_LABEL_INFINITE = DHCPServerGUI.getResourceString("TEXT_CHECKBOX_LABEL_INFINITE");
    static final String TEXT_CHECKBOX_LABEL_DEFAULT = DHCPServerGUI.getResourceString("TEXT_CHECKBOX_LABEL_DEFAULT");
    static final String TEXT_CHECKBOX_LABEL_ENTER_TIME = DHCPServerGUI.getResourceString("TEXT_CHECKBOX_LABEL_ENTER_TIME");
    static final String TEXT_YEARS = DHCPServerGUI.getResourceString("TEXT_YEARS");
    static final String TEXT_MONTHS = DHCPServerGUI.getResourceString("TEXT_MONTHS");
    static final String TEXT_DAYS = DHCPServerGUI.getResourceString("TEXT_DAYS");
    static final String TEXT_HOURS = DHCPServerGUI.getResourceString("TEXT_HOURS");
    static final String TEXT_MINUTES = DHCPServerGUI.getResourceString("TEXT_MINUTES");
    static final String TEXT_SECONDS = DHCPServerGUI.getResourceString("TEXT_SECONDS");
    Label timeEntryLabel;
    CheckboxGroup timeChoices;
    Checkbox infiniteTime;
    Checkbox defaultTime;
    Checkbox enterTime;
    SpinButton inputYears;
    SpinButton inputMonths;
    SpinButton inputDays;
    SpinButton inputHours;
    SpinButton inputMinutes;
    SpinButton inputSeconds;
    int numberOfRows;
    int numberOfFields;
    TimeInterval timeValue = new TimeInterval();
    private Panel parent;
    boolean askInfinite;
    boolean askDefault;

    public TimeEntryPanel(int n, int n2, boolean bl, boolean bl2) {
        this.numberOfRows = n2;
        this.numberOfFields = n;
        this.askInfinite = bl;
        this.askDefault = bl2;
        this.layoutPanel();
    }

    public TimeEntryPanel(int n, int n2) {
        this(n, n2, false, false);
    }

    public TimeEntryPanel() {
        this(6, 1, false, false);
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        int n = 1;
        if (this.askDefault) {
            ++n;
        }
        if (this.askInfinite) {
            ++n;
        }
        panel.setLayout(new GridLayout(1, n));
        if (n > 1) {
            this.timeChoices = new CheckboxGroup();
            if (this.askInfinite) {
                this.infiniteTime = new Checkbox(TEXT_CHECKBOX_LABEL_INFINITE, this.timeChoices, false);
                this.infiniteTime.addKeyListener(this);
                panel.add(this.infiniteTime);
            }
            if (this.askDefault) {
                this.defaultTime = new Checkbox(TEXT_CHECKBOX_LABEL_DEFAULT, this.timeChoices, false);
                this.defaultTime.addKeyListener(this);
                panel.add(this.defaultTime);
            }
            this.enterTime = new Checkbox(TEXT_CHECKBOX_LABEL_ENTER_TIME, this.timeChoices, false);
            this.enterTime.addKeyListener(this);
            panel.add(this.enterTime);
        } else {
            this.timeEntryLabel = new Label(TEXT_LABEL_TIME_ENTRY);
            panel.add(this.timeEntryLabel);
        }
        this.add("North", panel);
        Panel panel2 = new Panel();
        int n2 = this.numberOfFields / this.numberOfRows;
        int n3 = this.numberOfRows * 2;
        int n4 = 0;
        panel2.setLayout(new GridLayout(n3, n2));
        Label label = new Label(TEXT_HOURS);
        Label label2 = new Label(TEXT_MINUTES);
        Label label3 = new Label(TEXT_SECONDS);
        this.inputHours = new SpinButton(2, false);
        this.inputHours.setRange(0, 23);
        this.inputMinutes = new SpinButton(2, false);
        this.inputMinutes.setRange(0, 59);
        this.inputSeconds = new SpinButton(2, false);
        this.inputSeconds.setRange(0, 59);
        if (this.numberOfFields > 3) {
            this.inputYears = new SpinButton(2, false);
            this.inputYears.setRange(0, 10);
            this.inputMonths = new SpinButton(2, false);
            this.inputMonths.setRange(0, 11);
            this.inputDays = new SpinButton(2, false);
            this.inputDays.setRange(0, 30);
        }
        if (this.numberOfFields > 3) {
            Label label4 = new Label(TEXT_YEARS);
            Label label5 = new Label(TEXT_MONTHS);
            Label label6 = new Label(TEXT_DAYS);
            panel2.add(label4);
            panel2.add(label5);
            panel2.add(label6);
            n4 += 3;
            if (this.numberOfRows == 2) {
                panel2.add(this.inputYears);
                panel2.add(this.inputMonths);
                panel2.add(this.inputDays);
                n4 += 3;
            }
        }
        panel2.add(label);
        panel2.add(label2);
        panel2.add(label3);
        n4 += 3;
        if (this.numberOfFields > 3 && n3 == 2) {
            panel2.add(this.inputYears);
            panel2.add(this.inputMonths);
            panel2.add(this.inputDays);
            n4 += 3;
        }
        panel2.add(this.inputHours);
        panel2.add(this.inputMinutes);
        panel2.add(this.inputSeconds);
        n4 += 3;
        this.add("Center", panel2);
    }

    public void populate(String string) {
        int[] nArray = new int[6];
        if (string.length() > 0) {
            this.timeValue = new TimeInterval();
            this.timeValue.setTimeInterval(string);
            nArray = this.timeValue.getTimeInterval();
        }
        this.inputHours.setValue(nArray[3]);
        this.inputMinutes.setValue(nArray[4]);
        this.inputSeconds.setValue(nArray[5]);
        if (this.numberOfFields == 6) {
            this.inputYears.setValue(nArray[0]);
            this.inputMonths.setValue(nArray[1]);
            this.inputDays.setValue(nArray[2]);
        }
        this.validate();
    }

    public String getUserInput() {
        int[] nArray = new int[6];
        nArray[3] = this.inputHours.intValue();
        nArray[4] = this.inputMinutes.intValue();
        nArray[5] = this.inputSeconds.intValue();
        if (this.numberOfFields == 6) {
            nArray[0] = this.inputYears.intValue();
            nArray[1] = this.inputMonths.intValue();
            nArray[2] = this.inputDays.intValue();
        }
        this.timeValue.setTimeInterval(nArray);
        String string = Integer.toString(this.timeValue.getTotalSeconds());
        return string;
    }

    public void resetFields() {
        this.inputHours.setValue(0);
        this.inputMinutes.setValue(0);
        this.inputSeconds.setValue(0);
        if (this.numberOfFields == 6) {
            this.inputYears.setValue(0);
            this.inputMonths.setValue(0);
            this.inputDays.setValue(0);
        }
        this.timeEntryLabel.setText(TEXT_LABEL_TIME_ENTRY);
    }

    public void setFormat(OptionSkeleton optionSkeleton, Font font) {
        if (optionSkeleton != null) {
            this.timeEntryLabel.setText(TEXT_LABEL_TIME_ENTRY);
        }
    }

    public void setCaller(NotebookFrame notebookFrame) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Checkbox) {
            Checkbox checkbox;
            checkbox.setState(!(checkbox = (Checkbox)object).getState());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

