/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.Vendor;
import COM.ibm.raleigh.dhcpsgui.biz.VendorOption;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.WrappedTextArea;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.Choice;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;

public class VendorInputPanel
extends Panel {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String TEXT_VENDOR_LABEL_ADD_TAG = DHCPServerGUI.getResourceString("TEXT_VENDOR_LABEL_ADD_TAG");
    private static final String TEXT_LOCATION_VENDOR_TAG = DHCPServerGUI.getResourceString("TEXT_LOCATION_VENDOR_TAG");
    private static final String TEXT_LOCATION_VENDOR_VALUE = DHCPServerGUI.getResourceString("TEXT_LOCATION_VENDOR_VALUE");
    private static final String TEXT_BUTTON_LABEL_TEXT = DHCPServerGUI.getResourceString("TEXT_BUTTON_LABEL_TEXT");
    private static final String TEXT_BUTTON_LABEL_HEX = DHCPServerGUI.getResourceString("TEXT_BUTTON_LABEL_HEX");
    private static final String TEXT_VALUE_TYPE = DHCPServerGUI.getResourceString("TEXT_VALUE_TYPE");
    Label addTagLabel;
    Label addValueLabel;
    TextField inputTag;
    WrappedTextArea inputValue;
    Message errorMsg;
    Choice format;
    private boolean encapsulatedFormat = true;
    private NotebookFrame parentFrame;

    public VendorInputPanel(NotebookFrame notebookFrame) {
        this.parentFrame = notebookFrame;
        this.layoutPanel();
        this.encapsulatedFormat = true;
    }

    public void populate(VendorOption vendorOption) {
        if (vendorOption == null) {
            ((TextComponent)this.inputTag).setText("");
            this.inputValue.setText("");
            return;
        }
        ((TextComponent)this.inputTag).setText(vendorOption.getTag());
        this.inputValue.setText(vendorOption.getValue());
    }

    public void populate(Vendor vendor) {
        String string = vendor.getHexString();
        if (string == null) {
            this.inputValue.setText("");
            return;
        }
        this.inputValue.setText(string);
    }

    public Object getUserInput(Vendor vendor) {
        String string = this.inputTag.getText();
        String string2 = this.inputValue.getText();
        if (!(string != null && string.trim().length() != 0 || string2 != null && string2.trim().length() != 0)) {
            return null;
        }
        string = string.trim();
        string2 = string2.trim();
        if (this.inputTag.isEnabled()) {
            VendorOption vendorOption = new VendorOption();
            Vendor vendor2 = new Vendor();
            Message message = vendorOption.setTag(string, vendor2);
            if (message != null) {
                message.setLocation(TEXT_LOCATION_VENDOR_TAG);
                this.parentFrame.displayError(message);
                return null;
            }
            message = this.format.getSelectedItem().equals(TEXT_BUTTON_LABEL_TEXT) ? vendorOption.setValue(string2, false, null) : vendorOption.setValue(string2, true, null);
            if (message != null) {
                message.setLocation(TEXT_LOCATION_VENDOR_VALUE);
                this.parentFrame.displayError(message);
                return null;
            }
            this.resetFields();
            return vendorOption;
        }
        Message message = vendor.setHexStringAndValidate(string2, false);
        if (message != null) {
            message.setLocation(TEXT_LOCATION_VENDOR_VALUE);
            this.parentFrame.displayError(message);
            return null;
        }
        this.resetFields();
        return vendor.getHexString();
    }

    public final void resetFields() {
        ((TextComponent)this.inputTag).setText(" ");
        this.inputValue.setText(" ");
    }

    public void setFormat(String string, String string2, Font font) {
    }

    public void setDataType(String string) {
    }

    public void populate(String string) {
    }

    private void layoutPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.addTagLabel = new Label(TEXT_VENDOR_LABEL_ADD_TAG);
        this.addValueLabel = new Label(TEXT_VALUE_TYPE);
        this.inputTag = new TextField(5);
        this.inputValue = new WrappedTextArea(" ", 6, 35, this.parentFrame.getTextFont());
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        this.format = new Choice();
        this.format.addItem(TEXT_BUTTON_LABEL_TEXT);
        this.format.addItem(TEXT_BUTTON_LABEL_HEX);
        panel.add(this.addValueLabel);
        panel.add(this.format);
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(this.addTagLabel, gridBagConstraints);
        this.add(this.addTagLabel);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        ++gridBagConstraints.gridy;
        this.add((Component)this.inputTag, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ++gridBagConstraints.gridy;
        this.add((Component)panel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.inputValue, gridBagConstraints);
    }
}

