/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.notebook;

import COM.ibm.raleigh.ddnssgui.common.TcpipLocale;
import java.awt.Font;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.BreakIterator;
import java.util.Locale;
import java.util.Vector;

public class WrappedTextArea
extends TextArea
implements KeyListener {
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private int cols;
    private String tempText;
    private Locale theCurrentLocale;
    private Font fontToUse;

    public WrappedTextArea(String string, int n, int n2, Font font) {
        super(string, n, n2);
        this.tempText = string;
        this.cols = n2;
        this.theCurrentLocale = TcpipLocale.getLocale();
        this.fontToUse = font;
        this.insertLineBreaks();
        this.addKeyListener(this);
    }

    public void insertLineBreaks() {
        if (this.isDoubleByteLocale()) {
            this.splitDoubleByteString(this.tempText);
            return;
        }
        this.splitSingleByteString();
    }

    public void splitSingleByteString() {
        int n = this.tempText.length();
        int n2 = 0;
        this.cols = super.getColumns();
        while (n > this.cols) {
            String string = this.tempText.substring(1, this.cols);
            int n3 = string.lastIndexOf(" ");
            if (n3 < 0) break;
            super.insert("\n", n2 += n3 + 1);
            ++n2;
            this.tempText = this.tempText.substring(n3 + 1);
            n = this.tempText.length();
        }
    }

    public void setText(String string) {
        super.setText(string);
        this.tempText = string;
        this.insertLineBreaks();
    }

    public String getText() {
        this.tempText = super.getText();
        String string = this.tempText.replace('\n', ' ');
        return string;
    }

    public String getNewlineText() {
        this.tempText = super.getText();
        return this.tempText;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        keyEvent.getSource();
        if (keyEvent.getKeyCode() == 9) {
            this.transferFocus();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    /*
     * Unable to fully structure code
     */
    private void splitDoubleByteString(String var1_1) {
        var2_2 = this.getFontMetrics(this.fontToUse);
        var3_3 = this.cols * var2_2.getMaxAdvance();
        var10_4 = null;
        var15_5 = new Vector<String>();
        var4_6 = 0;
        while (true) {
            if ((var5_7 = var1_1.indexOf(10, var4_6)) < 0) break;
            var15_5.addElement(var1_1.substring(var4_6, var5_7));
            var4_6 = var5_7 + 1;
        }
        var15_5.addElement(var1_1.substring(var4_6));
        var5_7 = var15_5.size();
        var4_6 = 0;
        while (var4_6 < var5_7) {
            block10: {
                block11: {
                    block9: {
                        var11_12 = (String)var15_5.elementAt(var4_6);
                        var9_11 = var11_12.toCharArray();
                        var8_10 = var2_2.charsWidth(var9_11, 0, var9_11.length);
                        if (var8_10 <= var3_3) break block10;
                        if (var10_4 == null) {
                            var10_4 = BreakIterator.getLineInstance(this.theCurrentLocale);
                        }
                        var10_4.setText(var11_12);
                        var6_8 = var9_11.length * var3_3 / var8_10;
                        var7_9 = var10_4.following(var6_8);
                        if (var7_9 == -1) {
                            var7_9 = var10_4.last();
                        }
                        if (var7_9 == -1) break block10;
                        var6_8 = var7_9;
                        var14_15 = false;
                        while ((var8_10 = var2_2.charsWidth(var9_11, 0, var7_9)) > var3_3) {
                            var14_15 = true;
                            var7_9 = var10_4.previous();
                            if (var7_9 != -1 && var7_9 != 0) {
                                var6_8 = var7_9;
                                continue;
                            }
                            break block9;
                        }
                        break block9;
lbl37:
                        // 1 sources

                        while ((var7_9 = var10_4.next()) != -1 && var2_2.charsWidth(var9_11, 0, var7_9) <= var3_3) {
                            var6_8 = var7_9;
                            break block9;
                        }
                        break block11;
                    }
                    if (!var14_15) ** GOTO lbl37
                }
                var12_13 = var11_12.substring(0, var6_8);
                var13_14 = var11_12.substring(var6_8);
                var15_5.setElementAt(var12_13, var4_6);
                var15_5.insertElementAt(var13_14, var4_6 + 1);
                ++var5_7;
            }
            ++var4_6;
        }
        if (!var15_5.isEmpty()) {
            var16_16 = var15_5.elements();
            var17_17 = new StringBuffer();
            while (var16_16.hasMoreElements()) {
                var17_17.append(String.valueOf((String)var16_16.nextElement()) + "\n");
            }
            super.setText(var17_17.toString());
        }
    }

    private boolean isDoubleByteLocale() {
        String string = this.theCurrentLocale.getLanguage();
        String string2 = this.theCurrentLocale.getCountry();
        String string3 = String.valueOf(string) + "_" + string2;
        return string3.equals("ja_JP") || string3.equals("ko_KR") || string3.equals("zh_TW") || string3.equals("zh_CN");
    }
}

