/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.view;

import COM.ibm.raleigh.ddnssgui.client.SimplePanel;
import COM.ibm.raleigh.ddnssgui.common.PasswordUser;
import COM.ibm.raleigh.ddnssgui.common.PromptForPassword;
import COM.ibm.raleigh.ddnssgui.common.TcpipLocale;
import COM.ibm.raleigh.dhcpsgui.biz.BINLGlobal;
import COM.ibm.raleigh.dhcpsgui.biz.BINLServerParameters;
import COM.ibm.raleigh.dhcpsgui.biz.Client;
import COM.ibm.raleigh.dhcpsgui.biz.Comment;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.biz.Configuration;
import COM.ibm.raleigh.dhcpsgui.biz.ExcludedClient;
import COM.ibm.raleigh.dhcpsgui.biz.LSA1Group;
import COM.ibm.raleigh.dhcpsgui.biz.LSA2Group;
import COM.ibm.raleigh.dhcpsgui.biz.Option;
import COM.ibm.raleigh.dhcpsgui.biz.PXEOptionSkeletonManager;
import COM.ibm.raleigh.dhcpsgui.biz.SubnetValidator;
import COM.ibm.raleigh.dhcpsgui.io.DHCPConfigFileManager;
import COM.ibm.raleigh.dhcpsgui.io.DHCPFile;
import COM.ibm.raleigh.dhcpsgui.io.DHCPLocalFile;
import COM.ibm.raleigh.dhcpsgui.io.DHCPNcodNetworkHandler;
import COM.ibm.raleigh.dhcpsgui.io.DHCPParameterSet;
import COM.ibm.raleigh.dhcpsgui.io.DHCPRemoteFile;
import COM.ibm.raleigh.dhcpsgui.io.DHCPSocketNetworkHandler;
import COM.ibm.raleigh.dhcpsgui.io.IOUser;
import COM.ibm.raleigh.dhcpsgui.io.NetworkHandler;
import COM.ibm.raleigh.dhcpsgui.io.PromptForSave;
import COM.ibm.raleigh.dhcpsgui.notebook.BINLExcludedClientNotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.BINLGlobalNotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.BINLServerParametersNotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.BorderPanel;
import COM.ibm.raleigh.dhcpsgui.notebook.CommentNotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.LSA1GroupNotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.LSA2ClientNotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.LSA2GroupNotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrame;
import COM.ibm.raleigh.dhcpsgui.notebook.NotebookFrameWithOptionsPanel;
import COM.ibm.raleigh.dhcpsgui.view.AboutBINLFrame;
import COM.ibm.raleigh.dhcpsgui.view.BINLNcodServerGUIApplet;
import COM.ibm.raleigh.dhcpsgui.view.BINLServerGUIForFrame;
import COM.ibm.raleigh.dhcpsgui.view.Banner;
import COM.ibm.raleigh.dhcpsgui.view.BlankPanel;
import COM.ibm.raleigh.dhcpsgui.view.ClientView;
import COM.ibm.raleigh.dhcpsgui.view.CrossRefView;
import COM.ibm.raleigh.dhcpsgui.view.DHCPNcodServerGUIApplet;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUILayoutManager;
import COM.ibm.raleigh.dhcpsgui.view.FileView;
import COM.ibm.raleigh.dhcpsgui.view.FindSpecFrameBINL;
import COM.ibm.raleigh.dhcpsgui.view.HelpFrame;
import COM.ibm.raleigh.dhcpsgui.view.HierarchicalView;
import COM.ibm.raleigh.dhcpsgui.view.InfoFrame;
import COM.ibm.raleigh.dhcpsgui.view.LSA1GroupView;
import COM.ibm.raleigh.dhcpsgui.view.LSA2GroupView;
import COM.ibm.raleigh.dhcpsgui.view.MsgFrame;
import COM.ibm.raleigh.dhcpsgui.view.NcodDHCPServerGUILayoutManager;
import COM.ibm.raleigh.dhcpsgui.view.NotebookUser;
import COM.ibm.raleigh.dhcpsgui.view.OptionView;
import COM.ibm.raleigh.dhcpsgui.view.OptionsForItemView;
import COM.ibm.raleigh.dhcpsgui.view.SearchView;
import COM.ibm.raleigh.dhcpsgui.view.View;
import COM.ibm.raleigh.dhcpsgui.view.ViewIcons;
import COM.ibm.raleigh.dhcpsgui.view.ViewSchemes;
import COM.ibm.raleigh.dhcpsgui.view.ViewUser;
import COM.ibm.raleigh.utilExt.ShouldNotOccurException;
import com.ibm.eNetwork.onDemand.config.agents.BaseDetails;
import com.ibm.eNetwork.onDemand.config.node.Node;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Panel;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.MissingResourceException;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public abstract class BINLServerGUI
extends Panel
implements ViewUser,
NotebookUser,
IOUser,
Observer,
PasswordUser {
    private static final String cStmt1 = "Licensed Materials - Property of IBM \n IBM TCP/IP for OS/2 \n (c) Copyright IBM Corp 1998. All rights reserved.\n";
    private static final String cStmt2 = "US Government Users Restricted Rights - Use, Duplication or\n disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static TcpipLocale thisLocale = new TcpipLocale("");
    private static ResourceBundle thisBundle;
    private static final String bundleName = "COM.ibm.raleigh.dhcpsgui.resource.DHCPResources";
    private static final String TEXT_BINL_GUI_TITLE;
    private static final String TEXT_LABEL_ADDRESS_UNKNOWN;
    private static final String TEXT_LABEL_LEFT_PANEL;
    private static final String TEXT_LABEL_SAMPLE;
    private static final String TEXT_LABEL_NEW_CONFIGURATION;
    private static final String TEXT_TITLE_OPEN_FILE;
    private static final String TEXT_TITLE_SAVE_AS;
    private static final String TEXT_TITLE_SAVE_FOR_NEW;
    private static final String TEXT_TITLE_SAVE;
    private static final String TEXT_TITLE_SAVE_AT_CLOSE;
    private static final String TEXT_TITLE_CLIPBOARD_BINL;
    private static final String ERROR_MESSAGE_NOTEBOOK_ALREADY_OPEN;
    private static final String ERROR_MESSAGE_NO_NOTEBOOK_FOR_OPTION;
    private static final String ERROR_MESSAGE_VALIDATION_ERRORS;
    private static final String TEXT_MESSAGE_LOADING_NOTEBOOK_;
    private static final String TEXT_MESSAGE_NOTHING_TO_SAVE;
    private static final String TEXT_MESSAGE_APPLET_STARTED_BINL;
    private static final String TEXT_MESSAGE_LOADING_SAMPLE;
    private static final String TEXT_MESSAGE_STARTING_NEW;
    private static final String TEXT_MESSAGE_HAS_BEEN_DELETED;
    private static final String TEXT_MESSAGE_CLOSE_NOTEBOOK;
    private static final String TEXT_BINL_SERVER;
    private static final String TEXT_INFO_TITLE_BINL;
    private static final String EMPTY_STRING = "";
    public static final String URL_DELIMITER = "/";
    InfoFrame clipBoard = new InfoFrame(TEXT_TITLE_CLIPBOARD_BINL);
    Configuration configuration;
    SubnetValidator subValidate;
    ViewSchemes vSchemes;
    ViewIcons vIcons;
    private SimplePanel MainTextPanel;
    private BorderPanel mainBorder;
    private BlankPanel rightBlankPanel;
    Banner latestBanner;
    HierarchicalView hView;
    ClientView clView;
    OptionView oView;
    LSA1GroupView lsa1View;
    LSA2GroupView lsa2View;
    SearchView srchView;
    OptionsForItemView ofiView;
    CrossRefView xrefView;
    View currentView;
    View currentRightView;
    boolean firstTime = true;
    boolean thruInit = false;
    FindSpecFrameBINL findSpec;
    FileView fView;
    ConfigItem nodeSelected;
    ConfigItem rightViewNodeSelected;
    DHCPConfigFileManager dFileMgr;
    DHCPFile dFile;
    int ioActionChosen;
    static final int NONECHOSEN = 0;
    static final int EXITCHOSEN = 1;
    static final int CLOSECHOSEN = 2;
    static final int OPENCHOSEN = 3;
    static final int NEWCHOSEN = 4;
    static final int SAMPLECHOSEN = 5;
    String[] serverHostName;
    String[] serverIPaddress;
    String currentFileName;
    ConfigItem itemToBeMoved;
    boolean cutCase = false;
    ConfigItem deletedItem;
    ConfigItem deletedItemParent;
    ConfigItem deletedItemSibling;
    boolean somethingChanged = false;
    private boolean notebookOpen = false;
    BINLServerParametersNotebookFrame spNotebook;
    BINLGlobalNotebookFrame gNotebook;
    CommentNotebookFrame comNotebook;
    BINLExcludedClientNotebookFrame exclNotebook;
    LSA1GroupNotebookFrame lsa1Notebook;
    LSA2GroupNotebookFrame lsa2Notebook;
    LSA2ClientNotebookFrame lsa2ClientNotebook;
    Applet myApplet;
    AppletContext myAppletContext;
    HelpFrame helpFrame;
    String helpInstructions;
    private static NetworkHandler dataOut;
    public static String theFileSeparator;
    Option currentOption;
    boolean rightOptionNodeChosen = false;
    public static BINLServerGUI SERVERGUI;

    BINLServerGUI(String string) {
        this.serverHostName = new String[1];
        this.serverHostName[0] = string;
        this.setBackground(Color.lightGray);
        this.initFrame(string);
        SERVERGUI = this;
    }

    public BINLServerGUI(AppletContext appletContext, Applet applet) {
        this.myApplet = applet;
        this.myAppletContext = appletContext;
        thisLocale = new TcpipLocale(this.myApplet.getParameter("TCPJAVALOCALE"));
        this.myApplet.showStatus(TEXT_MESSAGE_APPLET_STARTED_BINL);
        URL uRL = this.myApplet.getCodeBase();
        this.serverHostName = new String[1];
        this.serverHostName[0] = uRL.getHost();
        this.initFrame(null);
        SERVERGUI = this;
    }

    public BINLServerGUI(AppletContext appletContext, Applet applet, String string) {
        this.myApplet = applet;
        this.myAppletContext = appletContext;
        thisLocale = new TcpipLocale(this.myApplet.getParameter("TCPJAVALOCALE"));
        this.myApplet.showStatus(TEXT_MESSAGE_APPLET_STARTED_BINL);
        this.myApplet.getCodeBase();
        this.serverHostName = new String[1];
        this.serverHostName[0] = string;
        this.initFrame(string);
        SERVERGUI = this;
    }

    public static String getResourceString(String string) {
        if (thisBundle == null) {
            thisBundle = ResourceBundle.getBundle(bundleName, TcpipLocale.getLocale());
        }
        if (thisBundle == null) {
            throw new ShouldNotOccurException("The resource bundle for this locale cannot be found");
        }
        try {
            return thisBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("getResourceString() for string " + missingResourceException.getKey() + " -- exception is <" + missingResourceException + ">");
            throw new ShouldNotOccurException();
        }
    }

    public static TcpipLocale getDHCPLocale() {
        return thisLocale;
    }

    public void init() {
        if (this instanceof BINLServerGUIForFrame) {
            dataOut = new DHCPSocketNetworkHandler(this.myApplet, 7466, this.serverHostName[0]);
            if (dataOut != null && ((DHCPSocketNetworkHandler)dataOut).socketCreated()) {
                ((DHCPSocketNetworkHandler)dataOut).setSocketTimeout(30000);
                new PromptForPassword((PasswordUser)this, BINLServerGUI.getResourceString("TEXT_PROMPT_FOR_PASSWORD"), TEXT_BINL_GUI_TITLE, BINLServerGUI.getResourceString("TEXT_BUTTON_OK"), BINLServerGUI.getResourceString("TEXT_BUTTON_CANCEL"), ((DHCPSocketNetworkHandler)dataOut).getSocket());
                return;
            }
            new MsgFrame(this.getFrame(), BINLServerGUI.getResourceString("ERROR_CONTACTING_SERVER"), true);
            this.handleExit();
            return;
        }
        dataOut = new DHCPNcodNetworkHandler(this.serverHostName[0], this.myApplet);
        this.passwordValidationSucceeded();
    }

    public void passwordValidationSucceeded() {
        if (dataOut != null && dataOut instanceof DHCPSocketNetworkHandler) {
            ((DHCPSocketNetworkHandler)dataOut).setSocketTimeout(0);
        }
        theFileSeparator = dataOut.getFileSeparator();
        this.completeInitFrame();
        if (this.serverHostName[0] != null) {
            if (this instanceof BINLServerGUIForFrame) {
                this.dFile = new DHCPRemoteFile(dataOut);
                PXEOptionSkeletonManager.initialize(dataOut, dataOut.getDefaultDirectory(), true, TEXT_BINL_SERVER);
            } else {
                Node node = BaseDetails.getNode((Applet)this.myApplet);
                this.dFile = (DHCPFile)node.performOperation(103, null);
                PXEOptionSkeletonManager.initialize(dataOut, dataOut.getDefaultDirectory(), ((DHCPParameterSet)this.dFile).getPXEOptionFile());
            }
        } else {
            DHCPLocalFile dHCPLocalFile = new DHCPLocalFile();
            this.dFile = dHCPLocalFile;
            PXEOptionSkeletonManager.initialize(dataOut, dataOut.getDefaultDirectory(), false, TEXT_BINL_SERVER);
        }
        this.dFileMgr = new DHCPConfigFileManager(this.getFrame(), this.dFile, this, dataOut.getDefaultDirectory());
        this.dFileMgr.initialize();
        this.initializeViews();
        this.updateMenu();
        this.openConfiguration(String.valueOf(this.dFileMgr.getDefaultDirectory()) + theFileSeparator + "binlsd.cfg");
        this.thruInit = true;
        this.setVisible(true);
        if (dataOut.getDefaultDirectory().equals("NO_ETC_VALUE")) {
            new MsgFrame(this.getFrame(), BINLServerGUI.getResourceString("ERROR_NO_ETC_VALUE"));
        }
    }

    public void passwordValidationFailed() {
        new MsgFrame(this.getFrame(), BINLServerGUI.getResourceString("TEXT_INVALID_PASSWORD"));
        this.init();
    }

    public void passwordValidationCancelled() {
        this.handleExit();
    }

    public static NetworkHandler getConnectionToServer() {
        return dataOut;
    }

    private void createViews() {
        this.findSpec = new FindSpecFrameBINL(this);
        this.hView = new HierarchicalView(this.configuration, this);
        this.hView.loadView(this.configuration);
        this.clView = new ClientView(this.configuration, this);
        this.lsa1View = new LSA1GroupView(this.configuration, this);
        this.lsa2View = new LSA2GroupView(this.configuration, this);
        this.oView = new OptionView(this.configuration, this);
        this.srchView = new SearchView(this.configuration, this);
        this.xrefView = new CrossRefView(this.configuration, this);
        this.ofiView = new OptionsForItemView(this.configuration, this);
        this.rightViewNodeSelected = null;
    }

    public void initializeViews() {
        this.nodeSelected = this.configuration.getBINLGlobal();
        this.hView.initializeView();
        this.changeLeftView(this.hView);
        this.rightViewNodeSelected = null;
        this.setNodeSelected(this.configuration.getBINLGlobal(), this.hView);
        this.latestBanner.refresh(this.nodeSelected);
        this.clView.initializeView();
        this.lsa1View.initializeView();
        this.lsa2View.initializeView();
        this.oView.initializeView();
        if (this.firstTime) {
            this.firstTime = false;
            return;
        }
        System.gc();
    }

    private void askToCloseNotebook(String string) {
        InfoFrame infoFrame = new InfoFrame(true, TEXT_INFO_TITLE_BINL);
        infoFrame.setText(string);
        infoFrame.setVisible(true);
    }

    public void doFileNew() {
        if (this.notebookOpen) {
            this.askToCloseNotebook(TEXT_MESSAGE_CLOSE_NOTEBOOK);
            return;
        }
        if (this.somethingChanged) {
            this.saveBeforeContinuing(4, TEXT_TITLE_SAVE_FOR_NEW);
            return;
        }
        this.dFileMgr.cleanup();
        this.startNewConfiguration();
    }

    private void saveBeforeContinuing(int n, String string) {
        PromptForSave promptForSave = new PromptForSave(this.getFrame(), TEXT_BINL_GUI_TITLE);
        int n2 = promptForSave.getUserResponse();
        if (n2 == 1) {
            if (this.currentFileName != null) {
                this.saveIfAsked(n, string, this.currentFileName);
                return;
            }
            this.saveIfAsked(n, string, null);
            return;
        }
        if (n2 == 2) {
            if (n == 4) {
                this.dFileMgr.cleanup();
                this.startNewConfiguration();
                return;
            }
            if (n == 3) {
                this.openConfiguration();
                return;
            }
            if (n == 5) {
                this.loadSample();
                return;
            }
            if (n == 1) {
                this.exitAction();
            }
        }
    }

    public void doFileOpen() {
        if (this.notebookOpen) {
            this.askToCloseNotebook(TEXT_MESSAGE_CLOSE_NOTEBOOK);
            return;
        }
        this.latestBanner.refresh();
        if (this.somethingChanged) {
            this.saveBeforeContinuing(3, TEXT_TITLE_SAVE_FOR_NEW);
            return;
        }
        this.openConfiguration();
    }

    public void doLoadSample() {
        if (this.notebookOpen) {
            this.askToCloseNotebook(TEXT_MESSAGE_CLOSE_NOTEBOOK);
            return;
        }
        if (this.somethingChanged) {
            this.saveBeforeContinuing(5, TEXT_TITLE_SAVE_FOR_NEW);
            return;
        }
        this.loadSample();
    }

    public void doFileSaveAs() {
        if (this.notebookOpen) {
            this.askToCloseNotebook(TEXT_MESSAGE_CLOSE_NOTEBOOK);
            return;
        }
        this.saveIfAsked(0, TEXT_TITLE_SAVE_AS, null);
    }

    public void doFileSave() {
        if (this.notebookOpen) {
            this.askToCloseNotebook(TEXT_MESSAGE_CLOSE_NOTEBOOK);
            return;
        }
        if (this.somethingChanged) {
            this.saveIfAsked(0, null, this.currentFileName);
            return;
        }
        this.latestBanner.refresh(TEXT_MESSAGE_NOTHING_TO_SAVE);
    }

    public void doDelete() {
        this.deletedItem = this.nodeSelected;
        this.deletedItemParent = this.nodeSelected.getParent();
        this.deletedItemParent.deleteChild(this.nodeSelected);
        this.somethingChanged = true;
        this.latestBanner.refresh(String.valueOf(this.deletedItem.getName()) + ": " + TEXT_MESSAGE_HAS_BEEN_DELETED);
        this.currentView.refresh(true, false);
    }

    public void doCopyItem() {
        boolean bl = false;
        this.cutCase = false;
        this.currentView.unselect();
        if (this.itemToBeMoved != null) {
            bl = true;
            this.itemToBeMoved.markCutState(false);
        }
        this.itemToBeMoved = (ConfigItem)this.nodeSelected.itemClone();
        if (bl) {
            this.currentView.refresh(true, false);
        }
        this.nodeSelected = null;
        this.updateMenu();
    }

    public void doCopyTree() {
        boolean bl = false;
        this.cutCase = false;
        this.currentView.unselect();
        if (this.itemToBeMoved != null) {
            bl = true;
            this.itemToBeMoved.markCutState(false);
        }
        this.itemToBeMoved = (ConfigItem)this.nodeSelected.clone();
        if (bl) {
            this.currentView.refresh(true);
        }
        this.nodeSelected = null;
        this.updateMenu();
    }

    public void doCut() {
        this.cutCase = true;
        this.currentView.unselect();
        if (this.itemToBeMoved != null) {
            this.itemToBeMoved.markCutState(false);
        }
        this.itemToBeMoved = this.nodeSelected;
        this.itemToBeMoved.markCutState(true);
        this.currentView.refresh(true, false);
        this.nodeSelected = null;
        this.updateMenu();
    }

    public void doPasteAfter() {
        if (this.cutCase) {
            this.itemToBeMoved.getParent().deleteChild(this.itemToBeMoved);
        }
        ConfigItem configItem = this.nodeSelected.getParent();
        this.itemToBeMoved.commitAt(configItem, this.nodeSelected);
        if (this.cutCase) {
            this.itemToBeMoved.markCutState(false);
            this.itemToBeMoved = null;
            this.cutCase = false;
        } else {
            this.itemToBeMoved = (ConfigItem)this.itemToBeMoved.clone();
        }
        this.somethingChanged = true;
        this.currentView.refresh(true, false);
    }

    public void doPasteIn() {
        if (this.nodeSelected == this.itemToBeMoved.getParent()) {
            if (this.cutCase) {
                this.itemToBeMoved.markCutState(false);
                this.itemToBeMoved = null;
                this.cutCase = false;
            }
        } else {
            if (this.cutCase) {
                this.itemToBeMoved.getParent().deleteChild(this.itemToBeMoved);
            }
            this.itemToBeMoved.commit(this.nodeSelected);
            if (this.cutCase) {
                this.itemToBeMoved.markCutState(false);
                this.itemToBeMoved = null;
                this.cutCase = false;
            } else {
                this.itemToBeMoved = (ConfigItem)this.itemToBeMoved.clone();
            }
        }
        this.somethingChanged = true;
        this.currentView.refresh(true, false);
    }

    public void displayHelp(String string) {
        this.latestBanner.refresh(this.helpInstructions);
        this.helpFrame.showHelp(string);
        this.latestBanner.refresh(EMPTY_STRING);
    }

    public void expandAll() {
        if (this.currentView == this.hView) {
            this.hView.expandAll();
            this.hView.refresh();
        }
    }

    public void showAboutBox() {
        AboutBINLFrame aboutBINLFrame = new AboutBINLFrame();
        aboutBINLFrame.setVisible(true);
    }

    public void collapseAll() {
        if (this.currentView == this.hView) {
            this.hView.collapseAll();
            this.hView.refresh();
        }
    }

    public void viewClipboard() {
        this.clipBoard.setItem(this.itemToBeMoved);
        this.clipBoard.setVisible(true);
    }

    public void viewEntireFile() {
        this.fView = new FileView(this.configuration);
        this.fView.setVisible(true);
    }

    public void viewScopedFile() {
        this.fView = new FileView(this.nodeSelected);
        this.fView.setVisible(true);
    }

    public void viewItemInFile() {
        this.fView = new FileView(this.nodeSelected, 1);
        this.fView.setVisible(true);
    }

    private void changeLeftView(View view) {
        DHCPServerGUILayoutManager dHCPServerGUILayoutManager = (DHCPServerGUILayoutManager)this.getLayout();
        if (this.currentView != null) {
            this.remove((Component)((Object)this.currentView));
        }
        dHCPServerGUILayoutManager.removeMainTree();
        this.add((Component)((Object)view));
        dHCPServerGUILayoutManager.addMainTree((Component)((Object)view));
        this.currentView = view;
        this.invalidate();
        this.validate();
    }

    private void changeRightView(View view) {
        DHCPServerGUILayoutManager dHCPServerGUILayoutManager = (DHCPServerGUILayoutManager)this.getLayout();
        if (this.currentRightView != null) {
            this.remove((Component)((Object)this.currentRightView));
        }
        if (this.rightBlankPanel.isShowing()) {
            this.remove(this.rightBlankPanel);
        }
        this.rightBlankPanel.setShowing(false);
        dHCPServerGUILayoutManager.removeOptionTree();
        this.add((Component)((Object)view));
        dHCPServerGUILayoutManager.addOptionTree((Component)((Object)view));
        this.currentRightView = view;
        this.invalidate();
        this.validate();
    }

    public void viewOptions() {
        this.currentView.unselect();
        if (this.currentRightView != null) {
            this.currentRightView.unselect();
        }
        this.resetRightView();
        this.latestBanner.refresh();
        this.oView.refresh(true);
        this.changeLeftView(this.oView);
        if (this.nodeSelected != null && this.nodeSelected instanceof Option) {
            ConfigItem configItem = this.oView.selectOptionNumber((Option)this.nodeSelected);
            if (configItem != null) {
                this.nodeSelected = configItem;
            }
            this.xrefView.setCurrentItem(this.nodeSelected);
            this.xrefView.initializeView();
            this.changeRightView(this.xrefView);
            this.latestBanner.refresh(this.nodeSelected);
            return;
        }
        this.oView.selectRoot();
        this.resetRightView();
        this.latestBanner.refresh();
    }

    public void viewLSA1Groups() {
        this.switchView(this.lsa1View, this.nodeSelected instanceof LSA1Group);
    }

    public void viewLSA2Groups() {
        this.switchView(this.lsa2View, this.nodeSelected instanceof LSA2Group);
    }

    public void viewClients() {
        this.switchView(this.clView, this.nodeSelected instanceof Client);
    }

    public void viewMain() {
        this.switchView(this.hView, this.nodeSelected != null);
    }

    private void switchView(View view, boolean bl) {
        view.refresh();
        view.requestFocus();
        if (bl) {
            this.changeRightView(this.ofiView);
        } else {
            this.resetRightView(EMPTY_STRING);
            this.latestBanner.refresh();
        }
        this.changeLeftView(view);
        if (!bl) {
            view.selectRoot();
        }
    }

    private void exitAction() {
        this.dFileMgr.cleanup();
        PXEOptionSkeletonManager.terminate();
        if (dataOut != null && dataOut instanceof DHCPSocketNetworkHandler) {
            ((DHCPSocketNetworkHandler)dataOut).closeStreams();
            dataOut = null;
        }
        this.handleExit();
    }

    private boolean informNotebookIsUp() {
        if (this.notebookOpen) {
            this.latestBanner.refresh(ERROR_MESSAGE_NOTEBOOK_ALREADY_OPEN);
            this.askToCloseNotebook(ERROR_MESSAGE_NOTEBOOK_ALREADY_OPEN);
            return true;
        }
        this.notebookOpen = true;
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void modifySelectedItem() {
        ConfigItem configItem = null;
        ConfigItem configItem2 = null;
        NotebookFrame notebookFrame = null;
        if (this.informNotebookIsUp()) {
            return;
        }
        if (this.nodeSelected.getCutState()) {
            return;
        }
        this.currentOption = null;
        this.rightOptionNodeChosen = false;
        this.latestBanner.refresh(TEXT_MESSAGE_LOADING_NOTEBOOK_);
        if (this.nodeSelected instanceof Option) {
            if (!(this.currentRightView instanceof OptionsForItemView)) {
                this.latestBanner.refresh(ERROR_MESSAGE_NO_NOTEBOOK_FOR_OPTION);
                this.notebookOpen = false;
                return;
            }
            this.currentOption = (Option)this.nodeSelected;
            this.nodeSelected = this.nodeSelected.getParent();
            this.rightOptionNodeChosen = true;
        } else if (this.nodeSelected instanceof BINLServerParameters) {
            if (!(this.currentRightView instanceof OptionsForItemView)) {
                this.notebookOpen = false;
                this.latestBanner.refresh(EMPTY_STRING);
                return;
            }
            if (this.spNotebook == null) {
                this.spNotebook = new BINLServerParametersNotebookFrame();
            }
            notebookFrame = this.spNotebook;
            this.rightOptionNodeChosen = true;
        }
        configItem = this.nodeSelected;
        configItem2 = !this.rightOptionNodeChosen ? this.nodeSelected.getParent() : this.nodeSelected;
        if (this.nodeSelected instanceof Configuration) {
            if (this.spNotebook == null) {
                this.spNotebook = new BINLServerParametersNotebookFrame();
            }
            notebookFrame = this.spNotebook;
            configItem = ((Configuration)this.nodeSelected).getBINLServerParameters();
        } else if (this.nodeSelected instanceof BINLGlobal) {
            if (this.gNotebook == null) {
                this.gNotebook = new BINLGlobalNotebookFrame();
            }
            notebookFrame = this.gNotebook;
        } else if (this.nodeSelected instanceof LSA1Group) {
            if (this.lsa1Notebook == null) {
                this.lsa1Notebook = new LSA1GroupNotebookFrame();
            }
            notebookFrame = this.lsa1Notebook;
        } else if (this.nodeSelected instanceof LSA2Group) {
            if (this.lsa2Notebook == null) {
                this.lsa2Notebook = new LSA2GroupNotebookFrame();
            }
            notebookFrame = this.lsa2Notebook;
        } else if (this.nodeSelected instanceof Client) {
            if (this.lsa2ClientNotebook == null) {
                this.lsa2ClientNotebook = new LSA2ClientNotebookFrame();
            }
            notebookFrame = this.lsa2ClientNotebook;
        } else if (this.nodeSelected instanceof Comment) {
            if (this.comNotebook == null) {
                this.comNotebook = new CommentNotebookFrame();
            }
            notebookFrame = this.comNotebook;
        } else if (this.nodeSelected instanceof ExcludedClient) {
            if (this.exclNotebook == null) {
                this.exclNotebook = new BINLExcludedClientNotebookFrame();
            }
            notebookFrame = this.exclNotebook;
        }
        notebookFrame.initializeNotebook(configItem2, configItem, this.configuration, this.configuration.getBINLGlobal(), (NotebookUser)this, false);
        ((Component)notebookFrame).setVisible(true);
        if (!this.rightOptionNodeChosen) {
            notebookFrame.open();
        }
        if (this.rightOptionNodeChosen && notebookFrame instanceof NotebookFrameWithOptionsPanel) {
            if (notebookFrame instanceof LSA2ClientNotebookFrame || notebookFrame instanceof LSA2GroupNotebookFrame || notebookFrame instanceof BINLGlobalNotebookFrame) {
                ((NotebookFrameWithOptionsPanel)notebookFrame).selectTab(1);
                return;
            }
            ((NotebookFrameWithOptionsPanel)notebookFrame).selectOptionsTab(this.currentOption);
        }
    }

    public void addLSA1Group() {
        ConfigItem configItem = null;
        if (this.informNotebookIsUp()) {
            return;
        }
        this.latestBanner.refresh(TEXT_MESSAGE_LOADING_NOTEBOOK_);
        configItem = this.nodeSelected == null ? this.configuration.getBINLGlobal() : this.nodeSelected;
        if (this.lsa1Notebook == null) {
            this.lsa1Notebook = new LSA1GroupNotebookFrame();
        }
        this.lsa1Notebook.initializeNotebook(configItem, (ConfigItem)new LSA1Group(), this.configuration, this.configuration.getBINLGlobal(), (NotebookUser)this, true);
        ((Component)this.lsa1Notebook).setVisible(true);
        this.lsa1Notebook.open();
    }

    public void addLSA2Client() {
        ConfigItem configItem = null;
        if (this.informNotebookIsUp()) {
            return;
        }
        this.latestBanner.refresh(TEXT_MESSAGE_LOADING_NOTEBOOK_);
        configItem = this.nodeSelected == null ? this.configuration.getBINLGlobal() : this.nodeSelected;
        if (this.lsa2ClientNotebook == null) {
            this.lsa2ClientNotebook = new LSA2ClientNotebookFrame();
        }
        this.lsa2ClientNotebook.initializeNotebook(configItem, (ConfigItem)new Client(), this.configuration, this.configuration.getBINLGlobal(), (NotebookUser)this, true);
        this.lsa2ClientNotebook.setVisible(true);
        this.lsa2ClientNotebook.open();
    }

    public void addLSA2Group() {
        ConfigItem configItem = null;
        if (this.informNotebookIsUp()) {
            return;
        }
        this.latestBanner.refresh(TEXT_MESSAGE_LOADING_NOTEBOOK_);
        configItem = this.nodeSelected == null ? this.configuration.getBINLGlobal() : this.nodeSelected;
        if (this.lsa2Notebook == null) {
            this.lsa2Notebook = new LSA2GroupNotebookFrame();
        }
        this.lsa2Notebook.initializeNotebook(configItem, (ConfigItem)new LSA2Group(), this.configuration, this.configuration.getBINLGlobal(), (NotebookUser)this, true);
        this.lsa2Notebook.setVisible(true);
        this.lsa2Notebook.open();
    }

    public void addComment() {
        ConfigItem configItem = null;
        if (this.informNotebookIsUp()) {
            return;
        }
        this.latestBanner.refresh(TEXT_MESSAGE_LOADING_NOTEBOOK_);
        configItem = this.nodeSelected == null ? this.configuration.getBINLGlobal() : this.nodeSelected;
        if (this.comNotebook == null) {
            this.comNotebook = new CommentNotebookFrame();
        }
        this.comNotebook.initializeNotebook(configItem, (ConfigItem)new Comment(), this.configuration, this.configuration.getBINLGlobal(), (NotebookUser)this, true);
        ((Component)this.comNotebook).setVisible(true);
        this.comNotebook.open();
    }

    public void addExcludedClient() {
        ConfigItem configItem = null;
        if (this.informNotebookIsUp()) {
            return;
        }
        this.latestBanner.refresh(TEXT_MESSAGE_LOADING_NOTEBOOK_);
        configItem = this.nodeSelected == null ? this.configuration.getBINLGlobal() : this.nodeSelected;
        if (this.exclNotebook == null) {
            this.exclNotebook = new BINLExcludedClientNotebookFrame();
        }
        this.exclNotebook.initializeNotebook(configItem, (ConfigItem)new ExcludedClient(), this.configuration, this.configuration.getBINLGlobal(), (NotebookUser)this, true);
        ((Component)this.exclNotebook).setVisible(true);
        this.exclNotebook.open();
    }

    public void closeNotebook(Frame frame, boolean bl) {
        if (this.rightOptionNodeChosen && this.currentOption != null) {
            this.nodeSelected = this.currentOption;
            this.rightViewNodeSelected = null;
        }
        if (bl) {
            this.somethingChanged = true;
            this.setNodeSelected(this.nodeSelected, this.hView);
            this.currentView.refresh(true);
        }
        ((Component)frame).setVisible(false);
        this.notebookOpen = false;
        this.latestBanner.refresh(this.nodeSelected);
        if (this.rightOptionNodeChosen) {
            this.currentRightView.refresh(true);
        }
        this.rightOptionNodeChosen = false;
    }

    public void closeNotebook(Frame frame, ConfigItem configItem) {
        if (this.rightOptionNodeChosen && this.currentOption != null) {
            this.nodeSelected = this.currentOption;
            this.rightViewNodeSelected = null;
        }
        if (configItem == null) {
            throw new ShouldNotOccurException("DHCPTop closeNotebook() called with null ConfigItem");
        }
        this.nodeSelected.replaceItem(configItem);
        this.currentView.refresh(true);
        this.setNodeSelected(configItem, this.hView);
        this.closeNotebook(frame, false);
        if (this.rightOptionNodeChosen) {
            this.currentRightView.refresh(true);
        }
        this.rightOptionNodeChosen = false;
    }

    public void appletcationFileOpen(String string) {
        Node node = BaseDetails.getNode((Applet)this.myApplet);
        this.dFile = (DHCPFile)node.performOperation(103, null);
        PXEOptionSkeletonManager.initialize(dataOut, dataOut.getDefaultDirectory(), ((DHCPParameterSet)this.dFile).getPXEOptionFile());
        this.configuration.initializeItem(this.dFile);
        this.MainTextPanel.setText(string);
        this.initializeViews();
    }

    private void startNewConfiguration() {
        this.somethingChanged = false;
        this.latestBanner.refresh(TEXT_MESSAGE_STARTING_NEW);
        this.configuration.initializeItem();
        this.MainTextPanel.setText(String.valueOf(TEXT_LABEL_LEFT_PANEL) + TEXT_LABEL_NEW_CONFIGURATION);
        this.initializeViews();
    }

    private void resetLeftView() {
        DHCPServerGUILayoutManager dHCPServerGUILayoutManager = (DHCPServerGUILayoutManager)this.getLayout();
        if (this.currentView != null) {
            this.remove((Component)((Object)this.currentView));
        }
        dHCPServerGUILayoutManager.removeMainTree();
        this.MainTextPanel.setText(EMPTY_STRING);
        this.currentView = null;
        this.invalidate();
        this.validate();
    }

    private void resetRightView() {
        DHCPServerGUILayoutManager dHCPServerGUILayoutManager = (DHCPServerGUILayoutManager)this.getLayout();
        if (this.currentRightView != null) {
            this.remove((Component)((Object)this.currentRightView));
        }
        if (this.rightBlankPanel.isShowing()) {
            this.remove(this.rightBlankPanel);
        }
        dHCPServerGUILayoutManager.removeOptionTree();
        this.add(this.rightBlankPanel);
        dHCPServerGUILayoutManager.addOptionTree(this.rightBlankPanel);
        this.rightBlankPanel.setShowing(true);
        this.currentRightView = null;
        this.invalidate();
        this.validate();
    }

    private void resetRightView(String string) {
        this.resetRightView();
    }

    private void loadSample() {
        this.somethingChanged = false;
        this.resetLeftView();
        this.resetRightView();
        this.latestBanner.refresh(TEXT_MESSAGE_LOADING_SAMPLE);
        this.dFileMgr.readSample(this.configuration);
        this.currentFileName = null;
        this.MainTextPanel.setText(String.valueOf(TEXT_LABEL_LEFT_PANEL) + TEXT_LABEL_SAMPLE);
        this.initializeViews();
    }

    private void openConfiguration() {
        this.openConfiguration(null);
    }

    private void openConfiguration(String string) {
        this.somethingChanged = false;
        this.resetLeftView();
        this.resetRightView();
        this.currentFileName = null;
        this.dFileMgr.readConfig(this.configuration, TEXT_TITLE_OPEN_FILE, string);
        this.currentFileName = this.dFileMgr.getFileName();
        if (this.currentFileName != null) {
            if (this instanceof BINLServerGUIForFrame) {
                this.MainTextPanel.setText(String.valueOf(TEXT_LABEL_LEFT_PANEL) + this.currentFileName);
            } else {
                this.MainTextPanel.setText(this.currentFileName);
            }
            this.initializeViews();
            this.somethingChanged = this.dFileMgr.thereWereErrorsInFile();
            return;
        }
        this.changeLeftView(this.hView);
        this.setNodeSelected(this.configuration.getBINLGlobal(), this.hView);
    }

    public void updateIOStatus(String string, String string2, int n) {
        if (n == 5) {
            this.latestBanner.refresh(string2);
            this.currentFileName = string;
            this.MainTextPanel.setText(String.valueOf(TEXT_LABEL_LEFT_PANEL) + string);
            this.nodeSelected = null;
            this.initializeViews();
            return;
        }
        if (n == 6 || n == 3 || n == 12 || n == 0) {
            this.latestBanner.refresh(string2);
            return;
        }
        if (n == 4) {
            this.rightViewNodeSelected = null;
            this.changeLeftView(this.hView);
            this.latestBanner.refresh(string2);
            this.setNodeSelected(this.configuration.getBINLGlobal(), this.hView);
            return;
        }
        if (n == 7) {
            this.rightViewNodeSelected = null;
            this.changeLeftView(this.hView);
            this.latestBanner.refresh(string2);
            this.dFileMgr.cleanup();
            this.startNewConfiguration();
            this.setNodeSelected(this.configuration.getBINLGlobal(), this.hView);
            return;
        }
        if (n == 10) {
            this.rightViewNodeSelected = null;
            this.changeLeftView(this.hView);
            this.latestBanner.refresh(string2);
            if (this.thruInit) {
                InfoFrame infoFrame = new InfoFrame(true, TEXT_INFO_TITLE_BINL);
                infoFrame.setText(string2);
                infoFrame.setVisible(true);
            }
            this.setNodeSelected(this.configuration.getBINLGlobal(), this.hView);
            return;
        }
        if (n == 9) {
            this.exitAction();
            return;
        }
        if (n == 2 || n == 1) {
            if (this.ioActionChosen == 4) {
                this.ioActionChosen = 0;
                this.startNewConfiguration();
                return;
            }
            if (this.ioActionChosen == 3) {
                this.ioActionChosen = 0;
                this.latestBanner.refresh(string2);
                this.openConfiguration();
                return;
            }
            if (this.ioActionChosen == 5) {
                this.ioActionChosen = 0;
                this.latestBanner.refresh(string2);
                this.loadSample();
                return;
            }
            if (this.ioActionChosen == 1) {
                this.ioActionChosen = 0;
                this.continueSaving();
                this.somethingChanged = false;
                this.exitAction();
                return;
            }
            if (this.ioActionChosen == 0) {
                this.latestBanner.refresh(string2);
                this.currentFileName = string;
                if (string != null && n == 2) {
                    this.somethingChanged = false;
                    this.MainTextPanel.setText(String.valueOf(TEXT_LABEL_LEFT_PANEL) + string);
                    this.continueSaving();
                    return;
                }
            }
        } else if (n == 14) {
            this.latestBanner.refresh(string2);
            this.startNewConfiguration();
        }
    }

    public void displaySearchResults(String string, String string2, boolean bl) {
        this.findSpec.setVisible(false);
        if (string == null) {
            return;
        }
        this.srchView.initializeView(string, string2, bl);
        this.changeLeftView(this.srchView);
        this.resetRightView();
        this.latestBanner.refresh();
    }

    public void setNodeSelected(ConfigItem configItem, View view) {
        if (this.rightViewNodeSelected == configItem) {
            this.nodeSelected = configItem;
            if (this.currentRightView != null) {
                this.currentRightView.refresh(true);
                return;
            }
            this.latestBanner.refresh(this.nodeSelected);
            return;
        }
        if (this.currentView instanceof OptionView) {
            if (configItem instanceof Option) {
                this.xrefView.setCurrentItem(configItem);
                this.xrefView.initializeView();
                this.changeRightView(this.xrefView);
            } else {
                this.nodeSelected = configItem;
            }
        } else if (configItem instanceof Option) {
            if (this.currentView != this.srchView) {
                this.currentView.unselect();
                this.nodeSelected = configItem;
                this.currentView.refresh(true);
                if (!(view instanceof OptionsForItemView)) {
                    this.rightViewNodeSelected = null;
                }
            } else {
                this.nodeSelected = configItem;
            }
        } else if (!(configItem instanceof Comment || configItem instanceof Configuration || configItem instanceof LSA1Group || configItem instanceof ExcludedClient)) {
            this.ofiView.setCurrentItem(configItem);
            this.ofiView.initializeView();
            this.changeRightView(this.ofiView);
            if (this.currentRightView != null) {
                this.currentRightView.unselect();
            }
            this.nodeSelected = configItem;
            this.rightViewNodeSelected = configItem;
        } else {
            this.rightViewNodeSelected = null;
            this.nodeSelected = configItem;
            if (configItem != this.configuration) {
                this.resetRightView(this.nodeSelected.getName());
            } else if (view != this.hView) {
                this.currentView.unselect();
            }
        }
        this.updateMenu();
        this.latestBanner.refresh(configItem);
    }

    public abstract void updateMenu();

    public void doubleClickOn(ConfigItem configItem, View view) {
        if (this.nodeSelected != configItem) {
            this.setNodeSelected(configItem, view);
        }
        if (configItem.getCutState()) {
            return;
        }
        this.modifySelectedItem();
    }

    private void saveIfAsked(int n, String string, String string2) {
        this.ioActionChosen = n;
        this.dFileMgr.saveConfig(this.configuration, string2, string);
    }

    public void continueSaving() {
        if (!(this instanceof BINLServerGUIForFrame)) {
            Node node = BaseDetails.getNode((Applet)this.myApplet);
            PXEOptionSkeletonManager.terminate();
            if (DHCPNcodServerGUIApplet.APPLETCATIONFLAG) {
                node.performOperation(401, (Object)this.currentFileName);
                return;
            }
            node.performOperation(104, (Object)this.dFile);
        }
    }

    public ConfigItem getNodeSelected() {
        return this.nodeSelected;
    }

    public void update(Observable observable, Object object) {
        if (object == null) {
            return;
        }
        Observable observable2 = (Observable)object;
        observable2.addObserver(this);
        if (!(observable2 instanceof Option)) {
            observable2.addObserver(this.hView);
            observable2.addObserver(this.lsa1View);
            observable2.addObserver(this.clView);
            return;
        }
        if (observable2 instanceof Option) {
            observable2.addObserver(this.oView);
        }
    }

    private void deriveAppletData(String string) {
        if (string == null) {
            URL uRL = this.myApplet.getCodeBase();
            InetAddress[] inetAddressArray = null;
            try {
                inetAddressArray = InetAddress.getAllByName(uRL.getHost());
                this.serverHostName = new String[inetAddressArray.length];
                this.serverIPaddress = new String[inetAddressArray.length];
                StringTokenizer stringTokenizer = null;
                int n = 0;
                while (n < inetAddressArray.length) {
                    this.serverHostName[n] = inetAddressArray[n].getHostName();
                    stringTokenizer = new StringTokenizer(inetAddressArray[n].toString(), URL_DELIMITER);
                    stringTokenizer.nextToken();
                    this.serverIPaddress[n] = stringTokenizer.nextToken();
                    ++n;
                }
                return;
            }
            catch (UnknownHostException unknownHostException) {
                throw new ShouldNotOccurException("DHCP TOP:  deriveAppletData() -- UnknownHostException");
            }
        }
    }

    public void exitApp() {
        if (this.notebookOpen) {
            this.askToCloseNotebook(TEXT_MESSAGE_CLOSE_NOTEBOOK);
            return;
        }
        if (this.somethingChanged) {
            this.saveBeforeContinuing(1, TEXT_TITLE_SAVE_AT_CLOSE);
            return;
        }
        this.exitAction();
    }

    private void initFrame(String string) {
        this.helpFrame = new HelpFrame(this.myApplet);
        this.helpInstructions = this.helpFrame.getInstructions();
        if (this.myApplet != null) {
            String string2 = " ";
            this.deriveAppletData(string);
            if (this.serverHostName != null && this.serverIPaddress != null) {
                string2 = this.serverHostName[0];
                string2 = String.valueOf(string2) + " (";
                string2 = String.valueOf(string2) + this.serverIPaddress[0];
                string2 = String.valueOf(string2) + ")";
            }
            this.MainTextPanel = new SimplePanel(String.valueOf(TEXT_LABEL_LEFT_PANEL) + string2);
            this.MainTextPanel.setFont(12);
            this.mainBorder = new BorderPanel(Color.black, 1);
            this.mainBorder.setBackground(Color.lightGray);
        } else if (this.serverHostName[0] == null) {
            this.MainTextPanel = new SimplePanel(String.valueOf(TEXT_LABEL_LEFT_PANEL) + TEXT_LABEL_ADDRESS_UNKNOWN);
            this.mainBorder = new BorderPanel(Color.black, 1);
            this.mainBorder.setBackground(Color.lightGray);
        } else {
            this.MainTextPanel = new SimplePanel(String.valueOf(TEXT_LABEL_LEFT_PANEL) + this.serverHostName[0]);
            this.mainBorder = new BorderPanel(Color.black, 1);
            this.mainBorder.setBackground(Color.lightGray);
        }
        this.rightBlankPanel = new BlankPanel();
    }

    private void completeInitFrame() {
        this.vIcons = new ViewIcons(this, this.myApplet);
        this.vIcons.loadIcons();
        this.vSchemes = new ViewSchemes(this.vIcons);
        this.vSchemes.loadSchemes();
        this.configuration = new Configuration(TEXT_BINL_SERVER);
        this.subValidate = new SubnetValidator();
        this.latestBanner = new Banner();
        this.createViews();
        DHCPServerGUILayoutManager dHCPServerGUILayoutManager = this instanceof BINLServerGUIForFrame ? new DHCPServerGUILayoutManager(this.latestBanner, (Component)this.MainTextPanel, this.mainBorder) : new NcodDHCPServerGUILayoutManager(this, this.latestBanner, (Component)this.MainTextPanel, this.mainBorder);
        this.setLayout(dHCPServerGUILayoutManager);
        this.add(this.latestBanner);
        this.add((Component)this.MainTextPanel);
        this.add(this.mainBorder);
        this.configuration.addObserver(this);
        this.configuration.initializeItem();
        this.invalidate();
        this.validate();
    }

    private void handleExit() {
        if (BINLNcodServerGUIApplet.APPLETCATIONFLAG) {
            System.exit(0);
            return;
        }
        if (this.myApplet != null) {
            this.myApplet.stop();
            return;
        }
        System.exit(0);
    }

    public Frame getFrame() {
        return new Frame();
    }

    static {
        TEXT_BINL_GUI_TITLE = BINLServerGUI.getResourceString("TEXT_BINL_GUI_TITLE");
        TEXT_LABEL_ADDRESS_UNKNOWN = BINLServerGUI.getResourceString("TEXT_LABEL_ADDRESS_UNKNOWN");
        TEXT_LABEL_LEFT_PANEL = BINLServerGUI.getResourceString("TEXT_LABEL_LEFT_PANEL");
        TEXT_LABEL_SAMPLE = BINLServerGUI.getResourceString("TEXT_LABEL_SAMPLE");
        TEXT_LABEL_NEW_CONFIGURATION = BINLServerGUI.getResourceString("TEXT_LABEL_NEW_CONFIGURATION");
        TEXT_TITLE_OPEN_FILE = BINLServerGUI.getResourceString("TEXT_TITLE_OPEN_FILE");
        TEXT_TITLE_SAVE_AS = BINLServerGUI.getResourceString("TEXT_TITLE_SAVE_AS");
        TEXT_TITLE_SAVE_FOR_NEW = BINLServerGUI.getResourceString("TEXT_TITLE_SAVE_FOR_NEW");
        TEXT_TITLE_SAVE = BINLServerGUI.getResourceString("TEXT_TITLE_SAVE");
        TEXT_TITLE_SAVE_AT_CLOSE = BINLServerGUI.getResourceString("TEXT_TITLE_SAVE_AT_CLOSE");
        TEXT_TITLE_CLIPBOARD_BINL = BINLServerGUI.getResourceString("TEXT_TITLE_CLIPBOARD_BINL");
        ERROR_MESSAGE_NOTEBOOK_ALREADY_OPEN = BINLServerGUI.getResourceString("ERROR_MESSAGE_NOTEBOOK_ALREADY_OPEN");
        ERROR_MESSAGE_NO_NOTEBOOK_FOR_OPTION = BINLServerGUI.getResourceString("ERROR_MESSAGE_NO_NOTEBOOK_FOR_OPTION");
        ERROR_MESSAGE_VALIDATION_ERRORS = BINLServerGUI.getResourceString("ERROR_MESSAGE_VALIDATION_ERRORS");
        TEXT_MESSAGE_LOADING_NOTEBOOK_ = BINLServerGUI.getResourceString("TEXT_MESSAGE_LOADING_NOTEBOOK");
        TEXT_MESSAGE_NOTHING_TO_SAVE = BINLServerGUI.getResourceString("TEXT_MESSAGE_NOTHING_TO_SAVE");
        TEXT_MESSAGE_APPLET_STARTED_BINL = BINLServerGUI.getResourceString("TEXT_MESSAGE_APPLET_STARTED_BINL");
        TEXT_MESSAGE_LOADING_SAMPLE = BINLServerGUI.getResourceString("TEXT_MESSAGE_LOADING_SAMPLE");
        TEXT_MESSAGE_STARTING_NEW = BINLServerGUI.getResourceString("TEXT_MESSAGE_STARTING_NEW");
        TEXT_MESSAGE_HAS_BEEN_DELETED = BINLServerGUI.getResourceString("TEXT_MESSAGE_HAS_BEEN_DELETED");
        TEXT_MESSAGE_CLOSE_NOTEBOOK = BINLServerGUI.getResourceString("TEXT_MESSAGE_CLOSE_NOTEBOOK");
        TEXT_BINL_SERVER = BINLServerGUI.getResourceString("TEXT_BINL_SERVER");
        TEXT_INFO_TITLE_BINL = BINLServerGUI.getResourceString("TEXT_INFO_TITLE_BINL");
    }
}

